/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.estore.operator.dataimport;

import com.tydic.pesapp.estore.operator.ability.OpeInsertPayInvoiceInfoBusiService;
import com.tydic.pesapp.estore.operator.ability.bo.OpeFscBaseRspBo;
import com.tydic.pesapp.estore.operator.ability.bo.OpeFscFileAppBO;
import com.tydic.pesapp.estore.operator.ability.bo.OpeInsertPayInvoiceInfoReqBO;
import com.tydic.pesapp.estore.operator.ability.bo.OpeInsertPayInvoiceInfoRspBO;
import com.tydic.pesapp.estore.operator.ability.bo.OpePayInvoiceInfoBO;
import com.tydic.pesapp.estore.operator.util.FscExcelUtils;
import com.tydic.pesapp.estore.operator.util.OperatorFscExcelUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class OpeFscImportInvoiceInfoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpeFscImportInvoiceInfoService.class);
    private static final Integer NUMBER_OF_SHEETS = 2;
    @Autowired
    private OpeInsertPayInvoiceInfoBusiService insertPayInvoiceInfoBusiService;

    public OpeFscBaseRspBo importData(OpeFscFileAppBO opeFscFileAppBO) {
        return this.uploadExcel(opeFscFileAppBO);
    }

    private OpeFscBaseRspBo uploadExcel(OpeFscFileAppBO opeFscFileAppBO) {
        OpeFscBaseRspBo rspInfo = new OpeFscBaseRspBo();
        try {
            Workbook wb = FscExcelUtils.createWorkbook(opeFscFileAppBO);
            LOGGER.debug("\u83b7\u53d6Excel sheet\u9875\u7684\u6570\u91cf" + wb.getNumberOfSheets());
            if (wb.getNumberOfSheets() != NUMBER_OF_SHEETS.intValue()) {
                rspInfo.setRespCode("18000");
                rspInfo.setRespDesc("\u6570\u636eExcel\u6587\u4ef6" + opeFscFileAppBO.getFileName() + "\u672a\u5305\u542b\u9884\u671f\u76842\u4e2asheet\u9875");
                return rspInfo;
            }
            HashMap<String, List<OpePayInvoiceInfoBO>> resultMap = new HashMap<String, List<OpePayInvoiceInfoBO>>(16);
            LinkedList<OpePayInvoiceInfoBO> payInvoiceInfoBOList = new LinkedList<OpePayInvoiceInfoBO>();
            Sheet sheet = wb.getSheetAt(1);
            for (int rowNum = 1; rowNum <= sheet.getLastRowNum(); ++rowNum) {
                List<OpePayInvoiceInfoBO> infoBoList;
                BigDecimal taxAmt;
                BigDecimal notTaxAmt;
                BigDecimal amt;
                Row row = sheet.getRow(rowNum);
                LOGGER.debug("\u6821\u9a8cExcel\u4e2d\u6570\u636e\u662f\u5426\u4e3a\u7a7a");
                String validateData = this.validateDataEmpty(row, rowNum);
                if (StringUtils.hasText((String)validateData)) {
                    rspInfo.setRespCode("18000");
                    rspInfo.setRespDesc(validateData);
                    return rspInfo;
                }
                LOGGER.debug("\u5c06Excel\u4e2d\u7684\u6570\u636e\u548c\u5f00\u7968\u901a\u77e5\u8868\u7684\u6570\u636e\u6dfb\u52a0\u5230list");
                OpePayInvoiceInfoBO insertBO = new OpePayInvoiceInfoBO();
                String value = OperatorFscExcelUtils.getValue(row.getCell(1));
                if ("\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968".equals(value)) {
                    insertBO.setInvoiceType(Integer.valueOf(2));
                } else if ("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968".equals(value)) {
                    insertBO.setInvoiceType(Integer.valueOf(1));
                } else {
                    rspInfo.setRespCode("18000");
                    rspInfo.setRespDesc("\u53d1\u7968\u7c7b\u578b\u4e0d\u6b63\u786e");
                    return rspInfo;
                }
                try {
                    amt = new BigDecimal(OperatorFscExcelUtils.getValue(row.getCell(5)));
                }
                catch (Exception e) {
                    rspInfo.setRespCode("18000");
                    rspInfo.setRespDesc("\u7b2c" + (rowNum + 1) + "\u884c\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u6b63\u786e!");
                    return rspInfo;
                }
                try {
                    notTaxAmt = new BigDecimal(OperatorFscExcelUtils.getValue(row.getCell(6)));
                }
                catch (Exception e) {
                    rspInfo.setRespCode("18000");
                    rspInfo.setRespDesc("\u7b2c" + (rowNum + 1) + "\u884c\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0d\u6b63\u786e!");
                    return rspInfo;
                }
                try {
                    taxAmt = new BigDecimal(OperatorFscExcelUtils.getValue(row.getCell(7)));
                }
                catch (Exception e) {
                    rspInfo.setRespCode("18000");
                    rspInfo.setRespDesc("\u7b2c" + (rowNum + 1) + "\u884c\u7a0e\u989d\u4e0d\u6b63\u786e!");
                    return rspInfo;
                }
                insertBO.setAmt(amt);
                insertBO.setNotTaxAmt(notTaxAmt);
                insertBO.setTaxAmt(taxAmt);
                LOGGER.debug("\u6821\u9a8c\u91d1\u989d(\u4e0d\u542b\u7a0e)+\u7a0e\u989d=\u4ef7\u7a0e\u5408\u8ba1");
                if (amt.compareTo(notTaxAmt.add(taxAmt)) != 0) {
                    rspInfo.setRespCode("18000");
                    rspInfo.setRespDesc("\u7b2c" + (rowNum + 1) + "\u884c\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u7b49\u4e8e\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0e\u7a0e\u989d\u4e4b\u548c!");
                    return rspInfo;
                }
                insertBO.setInvoiceCode(OperatorFscExcelUtils.getValue(row.getCell(2)));
                insertBO.setInvoiceNo(OperatorFscExcelUtils.getValue(row.getCell(3)));
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    sdf.setLenient(false);
                    Date parse = sdf.parse(OperatorFscExcelUtils.getValue(row.getCell(4)));
                    insertBO.setInvoiceDate(parse);
                }
                catch (Exception e) {
                    rspInfo.setRespCode("18000");
                    rspInfo.setRespDesc("\u7b2c" + (rowNum + 1) + "\u884c\u65e5\u671f\u683c\u5f0f\u9519\u8bef!");
                    return rspInfo;
                }
                insertBO.setNotificationNo(OperatorFscExcelUtils.getValue(row.getCell(0)));
                if (!resultMap.containsKey(OperatorFscExcelUtils.getValue(row.getCell(0)))) {
                    infoBoList = new LinkedList<OpePayInvoiceInfoBO>();
                    infoBoList.add(insertBO);
                    resultMap.put(OperatorFscExcelUtils.getValue(row.getCell(0)), infoBoList);
                } else {
                    infoBoList = (List)resultMap.get(OperatorFscExcelUtils.getValue(row.getCell(0)));
                    for (OpePayInvoiceInfoBO payInvoiceInfoBO : infoBoList) {
                        if (!payInvoiceInfoBO.getInvoiceNo().equals(OperatorFscExcelUtils.getValue(row.getCell(3)))) continue;
                        rspInfo.setRespCode("18000");
                        rspInfo.setRespDesc("\u7b2c" + (rowNum + 1) + "\u884c\u53d1\u7968\u53f7\u7801\u91cd\u590d!");
                        return rspInfo;
                    }
                    infoBoList.add(insertBO);
                }
                payInvoiceInfoBOList.add(insertBO);
            }
            OpeInsertPayInvoiceInfoReqBO insertPayInvoiceInfoReqBO = new OpeInsertPayInvoiceInfoReqBO();
            insertPayInvoiceInfoReqBO.setListReqBO(payInvoiceInfoBOList);
            OpeInsertPayInvoiceInfoRspBO insert = this.insertPayInvoiceInfoBusiService.insert(insertPayInvoiceInfoReqBO);
            if (insert == null || !"0000".equals(insert.getRespCode())) {
                rspInfo.setRespCode("18000");
                if (null != insert && StringUtils.hasText((String)insert.getRespDesc())) {
                    rspInfo.setRespDesc(insert.getRespDesc());
                } else {
                    rspInfo.setRespDesc("\u5931\u8d25");
                }
                return rspInfo;
            }
            if (null == rspInfo.getRespCode()) {
                rspInfo.setRespCode("0000");
                rspInfo.setRespDesc("\u5bfc\u5165\u6210\u529f");
            }
            return rspInfo;
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            rspInfo.setRespCode("18000");
            rspInfo.setRespDesc("\u5bfc\u5165\u5931\u8d25");
            return rspInfo;
        }
    }

    private String validateDataEmpty(Row row, int rowNum) {
        if (row == null) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)OperatorFscExcelUtils.getValue(row.getCell(0)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u5f00\u7968\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)OperatorFscExcelUtils.getValue(row.getCell(1)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)OperatorFscExcelUtils.getValue(row.getCell(2)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)OperatorFscExcelUtils.getValue(row.getCell(3)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)OperatorFscExcelUtils.getValue(row.getCell(4)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)OperatorFscExcelUtils.getValue(row.getCell(5)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)OperatorFscExcelUtils.getValue(row.getCell(6)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)OperatorFscExcelUtils.getValue(row.getCell(7)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        return null;
    }
}

