/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.mall.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.ability.api.UccFreightQryAbilityService;
import com.tydic.commodity.bo.ability.UccFreightQryAbilityReqBO;
import com.tydic.commodity.bo.ability.UccFreightQryAbilityRspBO;
import com.tydic.commodity.bo.busi.SkuNumBO_busi;
import com.tydic.commodity.bo.busi.UccFreightQryBusiReqBO;
import com.tydic.order.extend.ability.saleorder.PebExtThirdSupplierCreateOrderAbilityService;
import com.tydic.order.extend.bo.saleorder.PebExtThirdSupplierCreateOrderReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtThirdSupplierCreateOrderRspBO;
import com.tydic.pesapp.mall.ability.PesappMallCreateOrderService;
import com.tydic.pesapp.mall.ability.bo.PesappMallCreateOrderReqBO;
import com.tydic.pesapp.mall.ability.bo.PesappMallCreateOrderRspBO;
import com.tydic.pesapp.mall.ability.bo.PesappMallCreateOrderThirdSupplierSkuInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PesappMallCreateOrderServiceImpl
implements PesappMallCreateOrderService {
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UOC_GROUP_TEST")
    private PebExtThirdSupplierCreateOrderAbilityService pebExtThirdSupplierCreateOrderAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UCC_GROUP_TEST")
    private UccFreightQryAbilityService uccFreightQryAbilityService;

    public PesappMallCreateOrderRspBO createOrder(PesappMallCreateOrderReqBO reqBO) {
        this.checkFreight(reqBO);
        PebExtThirdSupplierCreateOrderReqBO orderReqBO = (PebExtThirdSupplierCreateOrderReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), PebExtThirdSupplierCreateOrderReqBO.class);
        PebExtThirdSupplierCreateOrderRspBO orderRspBO = this.pebExtThirdSupplierCreateOrderAbilityService.dealPebExtThirdSupplierCreateOrder(orderReqBO);
        if ("0000".equals(orderRspBO.getRespCode())) {
            return (PesappMallCreateOrderRspBO)JSON.parseObject((String)JSON.toJSONString((Object)orderRspBO), PesappMallCreateOrderRspBO.class);
        }
        throw new ZTBusinessException(orderRspBO.getRespDesc());
    }

    private void checkFreight(PesappMallCreateOrderReqBO reqBO) {
        UccFreightQryAbilityReqBO qryBusiReqBO = new UccFreightQryAbilityReqBO();
        ArrayList freightList = new ArrayList();
        reqBO.getSaleOrderItemList().stream().collect(Collectors.groupingBy(PesappMallCreateOrderThirdSupplierSkuInfoBO::getGoodsSupplierId)).forEach((k, v) -> {
            UccFreightQryBusiReqBO uccFreightQryBusiReqBO = new UccFreightQryBusiReqBO();
            uccFreightQryBusiReqBO.setSupplierShopId(Long.valueOf(k));
            ArrayList skuNumBO = new ArrayList();
            v.forEach(item -> {
                SkuNumBO_busi sku = new SkuNumBO_busi();
                sku.setNum(Long.valueOf(item.getPurchaseCount().longValue()));
                sku.setSkuId(Long.valueOf(item.getSkuId()));
                skuNumBO.add(sku);
            });
            uccFreightQryBusiReqBO.setSku(skuNumBO);
            uccFreightQryBusiReqBO.setCity(Long.valueOf(reqBO.getAddressInfo().getReceiverCityId()));
            uccFreightQryBusiReqBO.setCounty(Long.valueOf(reqBO.getAddressInfo().getReceiverCountyId()));
            uccFreightQryBusiReqBO.setPaymentType(reqBO.getPayType());
            uccFreightQryBusiReqBO.setProvince(Long.valueOf(reqBO.getAddressInfo().getReceiverProvinceId()));
            if (StringUtils.isNotBlank((CharSequence)reqBO.getAddressInfo().getReceiverTownId())) {
                uccFreightQryBusiReqBO.setTown(Long.valueOf(reqBO.getAddressInfo().getReceiverTownId()));
            } else {
                uccFreightQryBusiReqBO.setTown(Long.valueOf(0L));
            }
            freightList.add(uccFreightQryBusiReqBO);
        });
        qryBusiReqBO.setFreightList(freightList);
        UccFreightQryAbilityRspBO uccFreightQryAbilityRspBO = this.uccFreightQryAbilityService.qryFreightAbility(qryBusiReqBO);
        if ("0000".equals(uccFreightQryAbilityRspBO.getRespCode())) {
            if (uccFreightQryAbilityRspBO.getTotalFreight() != null && uccFreightQryAbilityRspBO.getTotalFreight().compareTo(BigDecimal.ZERO) > 0) {
                throw new ZTBusinessException("\u5f53\u524d\u6240\u9009\u62e9\u7535\u5546\u5546\u54c1\u6709\u8fd0\u8d39\u4ea7\u751f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u907f\u514d\u8fd0\u8d39!");
            }
        } else {
            throw new ZTBusinessException(uccFreightQryAbilityRspBO.getRespDesc());
        }
    }
}

