/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.ssc.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.pesapp.ssc.ability.DingdangCreateProjectOaApprovalService;
import com.tydic.pesapp.ssc.ability.bo.DingdangCreateProjectOaApprovalReqBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangCreateProjectOaApprovalRspBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangOaParamBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangRequestRecordsBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangWorkflowBaseInfoBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangWorkflowMainTableInfoBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangWorkflowRequestTableFieldsBO;
import com.tydic.pesapp.ssc.ability.utils.DingdangSscHttpUtil;
import com.tydic.ssc.ability.SscDicDictionaryAbilityService;
import com.tydic.ssc.ability.SscQryInfoForOaCreateProjectAbilityService;
import com.tydic.ssc.ability.bo.SscDicDictionaryAbilityReqBO;
import com.tydic.ssc.ability.bo.SscDicDictionaryAbilityRspBO;
import com.tydic.ssc.ability.bo.SscQryInfoForOaCreateProjectAbilityReqBO;
import com.tydic.ssc.ability.bo.SscQryInfoForOaCreateProjectAbilityRspBO;
import com.tydic.ssc.common.SscDicDictionaryBO;
import com.tydic.ssc.common.SscProjectAttachBO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DingdangCreateProjectOaApprovalServiceImpl
implements DingdangCreateProjectOaApprovalService {
    private static final Logger log = LoggerFactory.getLogger(DingdangCreateProjectOaApprovalServiceImpl.class);
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="SSC_GROUP_TEST")
    private SscQryInfoForOaCreateProjectAbilityService sscQryInfoForOaCreateProjectAbilityService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="SSC_GROUP_TEST")
    private SscDicDictionaryAbilityService sscDicDictionaryAbilityService;
    @Value(value="${oa.url:}")
    private String oaUrl;

    public DingdangCreateProjectOaApprovalRspBO dealCreateProjectOaApproval(DingdangCreateProjectOaApprovalReqBO reqBO) {
        DingdangCreateProjectOaApprovalRspBO rsp = new DingdangCreateProjectOaApprovalRspBO();
        if (null == reqBO.getProjectId()) {
            throw new ZTBusinessException("\u9879\u76ee\u521b\u5efaOA\u5ba1\u6279\u63d0\u4ea4\u5165\u53c2\u3010projectId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSnapshot())) {
            throw new ZTBusinessException("\u9879\u76ee\u521b\u5efaOA\u5ba1\u6279\u63d0\u4ea4\u5165\u53c2\u3010snapshot\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DingdangOaParamBO jsonParam = this.initParam(reqBO);
        rsp.setRequestParam(JSON.toJSONString((Object)jsonParam));
        try {
            log.debug("oaUrl:" + this.oaUrl);
            log.debug("jsonParam:" + JSON.toJSONString((Object)jsonParam));
            String returnCode = DingdangSscHttpUtil.sendPost(this.oaUrl, JSON.toJSONString((Object)jsonParam));
            log.debug("returnCode:" + returnCode);
            Map resultMap = (Map)JSON.parse((String)returnCode);
            rsp.setRequestId((String)resultMap.get("requestId"));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ZTBusinessException(e.getMessage());
        }
        return rsp;
    }

    private DingdangOaParamBO initParam(DingdangCreateProjectOaApprovalReqBO reqBO) {
        SscDicDictionaryBO dicInfo = this.getSysDicInfo();
        SscQryInfoForOaCreateProjectAbilityRspBO projectInfo = this.getProjectInfo(reqBO);
        DingdangOaParamBO jsonParam = this.setValue(dicInfo, projectInfo, reqBO.getSnapshot());
        return jsonParam;
    }

    private DingdangOaParamBO setValue(SscDicDictionaryBO dicInfo, SscQryInfoForOaCreateProjectAbilityRspBO projectInfo, String snapshot) {
        DingdangOaParamBO jsonParam = new DingdangOaParamBO();
        Map valueMap = (Map)JSON.parse((String)dicInfo.getTitle());
        jsonParam.setCreatorId((String)valueMap.get("creatorId"));
        jsonParam.setRequestLevel("0");
        jsonParam.setRequestName(projectInfo.getSscProjectBO().getProjectName());
        DingdangWorkflowBaseInfoBO workflowBaseInfo = new DingdangWorkflowBaseInfoBO();
        workflowBaseInfo.setWorkflowId(dicInfo.getCode());
        jsonParam.setWorkflowBaseInfo(workflowBaseInfo);
        DingdangWorkflowMainTableInfoBO workflowMainTableInfo = new DingdangWorkflowMainTableInfoBO();
        ArrayList<DingdangRequestRecordsBO> requestRecords = new ArrayList<DingdangRequestRecordsBO>();
        DingdangRequestRecordsBO dingdangRequestRecordsBO = new DingdangRequestRecordsBO();
        ArrayList<DingdangWorkflowRequestTableFieldsBO> workflowRequestTableFields = new ArrayList<DingdangWorkflowRequestTableFieldsBO>();
        DingdangWorkflowRequestTableFieldsBO dingdangWorkflowRequestTableFieldsBO1 = new DingdangWorkflowRequestTableFieldsBO();
        dingdangWorkflowRequestTableFieldsBO1.setEdit(Boolean.valueOf(true));
        dingdangWorkflowRequestTableFieldsBO1.setFieldName("sqbh");
        dingdangWorkflowRequestTableFieldsBO1.setFieldValue(projectInfo.getSscProjectBO().getProjectNo());
        dingdangWorkflowRequestTableFieldsBO1.setView(Boolean.valueOf(true));
        workflowRequestTableFields.add(dingdangWorkflowRequestTableFieldsBO1);
        DingdangWorkflowRequestTableFieldsBO dingdangWorkflowRequestTableFieldsBO2 = new DingdangWorkflowRequestTableFieldsBO();
        dingdangWorkflowRequestTableFieldsBO2.setEdit(Boolean.valueOf(true));
        dingdangWorkflowRequestTableFieldsBO2.setFieldName("sqr");
        dingdangWorkflowRequestTableFieldsBO2.setFieldValue((String)valueMap.get("creatorId"));
        dingdangWorkflowRequestTableFieldsBO2.setView(Boolean.valueOf(true));
        workflowRequestTableFields.add(dingdangWorkflowRequestTableFieldsBO2);
        DingdangWorkflowRequestTableFieldsBO dingdangWorkflowRequestTableFieldsBO3 = new DingdangWorkflowRequestTableFieldsBO();
        dingdangWorkflowRequestTableFieldsBO3.setEdit(Boolean.valueOf(true));
        dingdangWorkflowRequestTableFieldsBO3.setFieldName("sqrq");
        dingdangWorkflowRequestTableFieldsBO3.setFieldValue(DateUtils.dateToStr((Date)new Date()));
        dingdangWorkflowRequestTableFieldsBO3.setView(Boolean.valueOf(true));
        workflowRequestTableFields.add(dingdangWorkflowRequestTableFieldsBO3);
        DingdangWorkflowRequestTableFieldsBO dingdangWorkflowRequestTableFieldsBO4 = new DingdangWorkflowRequestTableFieldsBO();
        dingdangWorkflowRequestTableFieldsBO4.setEdit(Boolean.valueOf(true));
        dingdangWorkflowRequestTableFieldsBO4.setFieldName("projectId");
        dingdangWorkflowRequestTableFieldsBO4.setFieldValue(projectInfo.getSscProjectBO().getProjectId().toString());
        dingdangWorkflowRequestTableFieldsBO4.setView(Boolean.valueOf(true));
        workflowRequestTableFields.add(dingdangWorkflowRequestTableFieldsBO4);
        DingdangWorkflowRequestTableFieldsBO dingdangWorkflowRequestTableFieldsBO5 = new DingdangWorkflowRequestTableFieldsBO();
        dingdangWorkflowRequestTableFieldsBO5.setEdit(Boolean.valueOf(true));
        dingdangWorkflowRequestTableFieldsBO5.setFieldName("scfj");
        String scfjStr = this.getAttach(projectInfo.getSscProjectAttachBOs(), snapshot);
        dingdangWorkflowRequestTableFieldsBO5.setFieldValue(scfjStr);
        dingdangWorkflowRequestTableFieldsBO5.setView(Boolean.valueOf(true));
        workflowRequestTableFields.add(dingdangWorkflowRequestTableFieldsBO5);
        dingdangRequestRecordsBO.setWorkflowRequestTableFields(workflowRequestTableFields);
        requestRecords.add(dingdangRequestRecordsBO);
        workflowMainTableInfo.setRequestRecords(requestRecords);
        jsonParam.setWorkflowMainTableInfo(workflowMainTableInfo);
        return jsonParam;
    }

    private String getAttach(List<SscProjectAttachBO> sscProjectAttachBOs, String snapshot) {
        StringBuffer scfjStr = new StringBuffer(snapshot);
        if (!CollectionUtils.isEmpty(sscProjectAttachBOs)) {
            for (SscProjectAttachBO bo : sscProjectAttachBOs) {
                scfjStr.append(",");
                scfjStr.append(bo.getProjectAttachAddress());
            }
        }
        return scfjStr.toString();
    }

    private SscDicDictionaryBO getSysDicInfo() {
        SscDicDictionaryAbilityReqBO sscDicDictionaryAbilityReqBO = new SscDicDictionaryAbilityReqBO();
        sscDicDictionaryAbilityReqBO.setPCode("CREATE_OA_APPROVAL");
        sscDicDictionaryAbilityReqBO.setDescrip("1");
        log.debug("\u5b57\u5178\u67e5\u8be2\u5165\u53c2" + JSON.toJSONString((Object)sscDicDictionaryAbilityReqBO));
        SscDicDictionaryAbilityRspBO sscDicDictionaryAbilityRspBO = this.sscDicDictionaryAbilityService.queryDictBOBySysCodeAndPcodeNoRedis(sscDicDictionaryAbilityReqBO);
        log.debug("\u5b57\u5178\u67e5\u8be2\u51fa\u53c2" + JSON.toJSONString((Object)sscDicDictionaryAbilityRspBO));
        if (CollectionUtils.isEmpty((Collection)sscDicDictionaryAbilityRspBO.getRows())) {
            throw new ZTBusinessException("\u67e5\u8be2\u5b57\u5178\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        return (SscDicDictionaryBO)sscDicDictionaryAbilityRspBO.getRows().get(0);
    }

    private SscQryInfoForOaCreateProjectAbilityRspBO getProjectInfo(DingdangCreateProjectOaApprovalReqBO reqBO) {
        SscQryInfoForOaCreateProjectAbilityReqBO sscQryInfoForOaCreateProjectAbilityReqBO = new SscQryInfoForOaCreateProjectAbilityReqBO();
        sscQryInfoForOaCreateProjectAbilityReqBO.setProjectId(reqBO.getProjectId());
        log.debug("\u8c03\u7528\u9879\u76ee\u521b\u5efaOA\u5ba1\u6279\u6240\u9700\u4fe1\u606f\u67e5\u8be2API\u5165\u53c2\uff1a" + JSON.toJSONString((Object)sscQryInfoForOaCreateProjectAbilityReqBO));
        SscQryInfoForOaCreateProjectAbilityRspBO sscQryInfoForOaCreateProjectAbilityRspBO = this.sscQryInfoForOaCreateProjectAbilityService.qryInfoForOaCreateProject(sscQryInfoForOaCreateProjectAbilityReqBO);
        log.debug("\u8c03\u7528\u9879\u76ee\u521b\u5efaOA\u5ba1\u6279\u6240\u9700\u4fe1\u606f\u67e5\u8be2API\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)sscQryInfoForOaCreateProjectAbilityRspBO));
        if (!"0000".equals(sscQryInfoForOaCreateProjectAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException(sscQryInfoForOaCreateProjectAbilityRspBO.getRespDesc());
        }
        return sscQryInfoForOaCreateProjectAbilityRspBO;
    }
}

