/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.ssc.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.pesapp.ssc.ability.DingdangSelectSupplierOaApprovalService;
import com.tydic.pesapp.ssc.ability.bo.DingdangOaParamBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangRequestRecordsBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangSelectSupplierOaApprovalReqBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangSelectSupplierOaApprovalRspBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangWorkflowBaseInfoBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangWorkflowMainTableInfoBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangWorkflowRequestTableFieldsBO;
import com.tydic.pesapp.ssc.ability.utils.DingdangSscHttpUtil;
import com.tydic.ssc.ability.SscDicDictionaryAbilityService;
import com.tydic.ssc.ability.SscQryInfoForOaSelectSupplierAbilityService;
import com.tydic.ssc.ability.bo.SscDicDictionaryAbilityReqBO;
import com.tydic.ssc.ability.bo.SscDicDictionaryAbilityRspBO;
import com.tydic.ssc.ability.bo.SscQryInfoForOaSelectSupplierAbilityReqBO;
import com.tydic.ssc.ability.bo.SscQryInfoForOaSelectSupplierAbilityRspBO;
import com.tydic.ssc.common.SscDicDictionaryBO;
import com.tydic.ssc.common.SscProjectTempAttachBO;
import com.tydic.ssc.common.SscSupplierProjectBO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DingdangSelectSupplierOaApprovalServiceImpl
implements DingdangSelectSupplierOaApprovalService {
    private static final Logger log = LoggerFactory.getLogger(DingdangSelectSupplierOaApprovalServiceImpl.class);
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="SSC_GROUP_TEST")
    private SscQryInfoForOaSelectSupplierAbilityService sscQryInfoForOaSelectSupplierAbilityService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="SSC_GROUP_TEST")
    private SscDicDictionaryAbilityService sscDicDictionaryAbilityService;
    @Value(value="${oa.url:}")
    private String oaUrl;

    public DingdangSelectSupplierOaApprovalRspBO dealSelectSupplierOaApproval(DingdangSelectSupplierOaApprovalReqBO reqBO) {
        DingdangSelectSupplierOaApprovalRspBO rsp = new DingdangSelectSupplierOaApprovalRspBO();
        if (null == reqBO.getProjectId()) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u5165\u56f4OA\u5ba1\u6279\u63d0\u4ea4\u5165\u53c2\u3010projectId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSnapshot())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u5165\u56f4OA\u5ba1\u6279\u63d0\u4ea4\u5165\u53c2\u3010snapshot\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DingdangOaParamBO jsonParam = this.initParam(reqBO);
        rsp.setRequestParam(JSON.toJSONString((Object)jsonParam));
        try {
            log.debug("oaUrl:" + this.oaUrl);
            log.debug("jsonParam:" + JSON.toJSONString((Object)jsonParam));
            String returnCode = DingdangSscHttpUtil.sendPost(this.oaUrl, JSON.toJSONString((Object)jsonParam));
            log.debug("returnCode:" + returnCode);
            Map resultMap = (Map)JSON.parse((String)returnCode);
            rsp.setRequestId((String)resultMap.get("requestId"));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ZTBusinessException(e.getMessage());
        }
        return rsp;
    }

    private DingdangOaParamBO initParam(DingdangSelectSupplierOaApprovalReqBO reqBO) {
        SscDicDictionaryBO dicInfo = this.getSysDicInfo();
        SscQryInfoForOaSelectSupplierAbilityRspBO projectAndSupplierInfo = this.getProjectAndSupplierInfo(reqBO);
        DingdangOaParamBO jsonParam = this.setValue(dicInfo, projectAndSupplierInfo, reqBO.getSnapshot());
        return jsonParam;
    }

    private DingdangOaParamBO setValue(SscDicDictionaryBO dicInfo, SscQryInfoForOaSelectSupplierAbilityRspBO projectAndSupplierInfo, String snapshot) {
        DingdangOaParamBO jsonParam = new DingdangOaParamBO();
        Map valueMap = (Map)JSON.parse((String)dicInfo.getTitle());
        jsonParam.setCreatorId((String)valueMap.get("creatorId"));
        jsonParam.setRequestLevel("0");
        jsonParam.setRequestName(projectAndSupplierInfo.getSscProjectBO().getProjectName());
        DingdangWorkflowBaseInfoBO workflowBaseInfo = new DingdangWorkflowBaseInfoBO();
        workflowBaseInfo.setWorkflowId(dicInfo.getCode());
        jsonParam.setWorkflowBaseInfo(workflowBaseInfo);
        DingdangWorkflowMainTableInfoBO workflowMainTableInfo = new DingdangWorkflowMainTableInfoBO();
        ArrayList<DingdangRequestRecordsBO> requestRecords = new ArrayList<DingdangRequestRecordsBO>();
        DingdangRequestRecordsBO dingdangRequestRecordsBO = new DingdangRequestRecordsBO();
        ArrayList<DingdangWorkflowRequestTableFieldsBO> workflowRequestTableFields = new ArrayList<DingdangWorkflowRequestTableFieldsBO>();
        DingdangWorkflowRequestTableFieldsBO dingdangWorkflowRequestTableFieldsBO1 = new DingdangWorkflowRequestTableFieldsBO();
        dingdangWorkflowRequestTableFieldsBO1.setEdit(Boolean.valueOf(true));
        dingdangWorkflowRequestTableFieldsBO1.setFieldName("sqbh");
        dingdangWorkflowRequestTableFieldsBO1.setFieldValue(projectAndSupplierInfo.getSscProjectBO().getProjectNo());
        dingdangWorkflowRequestTableFieldsBO1.setView(Boolean.valueOf(true));
        workflowRequestTableFields.add(dingdangWorkflowRequestTableFieldsBO1);
        DingdangWorkflowRequestTableFieldsBO dingdangWorkflowRequestTableFieldsBO2 = new DingdangWorkflowRequestTableFieldsBO();
        dingdangWorkflowRequestTableFieldsBO2.setEdit(Boolean.valueOf(true));
        dingdangWorkflowRequestTableFieldsBO2.setFieldName("sqr");
        dingdangWorkflowRequestTableFieldsBO2.setFieldValue((String)valueMap.get("creatorId"));
        dingdangWorkflowRequestTableFieldsBO2.setView(Boolean.valueOf(true));
        workflowRequestTableFields.add(dingdangWorkflowRequestTableFieldsBO2);
        DingdangWorkflowRequestTableFieldsBO dingdangWorkflowRequestTableFieldsBO3 = new DingdangWorkflowRequestTableFieldsBO();
        dingdangWorkflowRequestTableFieldsBO3.setEdit(Boolean.valueOf(true));
        dingdangWorkflowRequestTableFieldsBO3.setFieldName("sqrq");
        dingdangWorkflowRequestTableFieldsBO3.setFieldValue(DateUtils.dateToStr((Date)new Date()));
        dingdangWorkflowRequestTableFieldsBO3.setView(Boolean.valueOf(true));
        workflowRequestTableFields.add(dingdangWorkflowRequestTableFieldsBO3);
        DingdangWorkflowRequestTableFieldsBO dingdangWorkflowRequestTableFieldsBO4 = new DingdangWorkflowRequestTableFieldsBO();
        dingdangWorkflowRequestTableFieldsBO4.setEdit(Boolean.valueOf(true));
        dingdangWorkflowRequestTableFieldsBO4.setFieldName("projectId");
        dingdangWorkflowRequestTableFieldsBO4.setFieldValue(projectAndSupplierInfo.getSscProjectBO().getProjectId().toString());
        dingdangWorkflowRequestTableFieldsBO4.setView(Boolean.valueOf(true));
        workflowRequestTableFields.add(dingdangWorkflowRequestTableFieldsBO4);
        DingdangWorkflowRequestTableFieldsBO dingdangWorkflowRequestTableFieldsBO5 = new DingdangWorkflowRequestTableFieldsBO();
        dingdangWorkflowRequestTableFieldsBO5.setEdit(Boolean.valueOf(true));
        dingdangWorkflowRequestTableFieldsBO5.setFieldName("scfj");
        String scfjStr = this.getAttach(projectAndSupplierInfo.getSscProjectTempAttachBOs(), snapshot);
        dingdangWorkflowRequestTableFieldsBO5.setFieldValue(scfjStr);
        dingdangWorkflowRequestTableFieldsBO5.setView(Boolean.valueOf(true));
        workflowRequestTableFields.add(dingdangWorkflowRequestTableFieldsBO5);
        DingdangWorkflowRequestTableFieldsBO dingdangWorkflowRequestTableFieldsBO6 = new DingdangWorkflowRequestTableFieldsBO();
        dingdangWorkflowRequestTableFieldsBO6.setEdit(Boolean.valueOf(true));
        dingdangWorkflowRequestTableFieldsBO6.setFieldName("gysmc");
        String supplierNameStr = this.getSupplierName(projectAndSupplierInfo.getSscSupplierProjectBOs());
        dingdangWorkflowRequestTableFieldsBO6.setFieldValue(supplierNameStr);
        dingdangWorkflowRequestTableFieldsBO6.setView(Boolean.valueOf(true));
        workflowRequestTableFields.add(dingdangWorkflowRequestTableFieldsBO6);
        dingdangRequestRecordsBO.setWorkflowRequestTableFields(workflowRequestTableFields);
        requestRecords.add(dingdangRequestRecordsBO);
        workflowMainTableInfo.setRequestRecords(requestRecords);
        jsonParam.setWorkflowMainTableInfo(workflowMainTableInfo);
        return jsonParam;
    }

    private String getSupplierName(List<SscSupplierProjectBO> sscSupplierProjectBOs) {
        StringBuffer supplierNameBuffer = new StringBuffer();
        if (!CollectionUtils.isEmpty(sscSupplierProjectBOs)) {
            for (SscSupplierProjectBO bo : sscSupplierProjectBOs) {
                supplierNameBuffer.append(bo.getSupplierName());
                supplierNameBuffer.append(",");
            }
        }
        String supplierNameStr = "";
        if (supplierNameBuffer.length() > 0) {
            supplierNameStr = supplierNameBuffer.deleteCharAt(supplierNameBuffer.length() - 1).toString();
        }
        return supplierNameStr;
    }

    private String getAttach(List<SscProjectTempAttachBO> sscProjectTempAttachBOs, String snapshot) {
        StringBuffer scfjStr = new StringBuffer(snapshot);
        if (!CollectionUtils.isEmpty(sscProjectTempAttachBOs)) {
            for (SscProjectTempAttachBO bo : sscProjectTempAttachBOs) {
                scfjStr.append(",");
                scfjStr.append(bo.getProjectAttachAddress());
            }
        }
        return scfjStr.toString();
    }

    private SscQryInfoForOaSelectSupplierAbilityRspBO getProjectAndSupplierInfo(DingdangSelectSupplierOaApprovalReqBO reqBO) {
        SscQryInfoForOaSelectSupplierAbilityReqBO sscQryInfoForOaSelectSupplierAbilityReqBO = new SscQryInfoForOaSelectSupplierAbilityReqBO();
        sscQryInfoForOaSelectSupplierAbilityReqBO.setProjectId(reqBO.getProjectId());
        log.debug("\u8c03\u7528\u4f9b\u5e94\u5546\u9009\u62e9\u5165\u56f4OA\u5ba1\u6279\u6240\u9700\u4fe1\u606f\u67e5\u8be2API\u5165\u53c2\uff1a" + JSON.toJSONString((Object)sscQryInfoForOaSelectSupplierAbilityReqBO));
        SscQryInfoForOaSelectSupplierAbilityRspBO sscQryInfoForOaSelectSupplierAbilityRspBO = this.sscQryInfoForOaSelectSupplierAbilityService.qryInfoForOaSelectSupplier(sscQryInfoForOaSelectSupplierAbilityReqBO);
        log.debug("\u8c03\u7528\u4f9b\u5e94\u5546\u9009\u62e9\u5165\u56f4OA\u5ba1\u6279\u6240\u9700\u4fe1\u606f\u67e5\u8be2API\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)sscQryInfoForOaSelectSupplierAbilityRspBO));
        if (!"0000".equals(sscQryInfoForOaSelectSupplierAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException(sscQryInfoForOaSelectSupplierAbilityRspBO.getRespDesc());
        }
        return sscQryInfoForOaSelectSupplierAbilityRspBO;
    }

    private SscDicDictionaryBO getSysDicInfo() {
        SscDicDictionaryAbilityReqBO sscDicDictionaryAbilityReqBO = new SscDicDictionaryAbilityReqBO();
        sscDicDictionaryAbilityReqBO.setPCode("CREATE_OA_APPROVAL");
        sscDicDictionaryAbilityReqBO.setDescrip("2");
        log.debug("\u5b57\u5178\u67e5\u8be2\u5165\u53c2" + JSON.toJSONString((Object)sscDicDictionaryAbilityReqBO));
        SscDicDictionaryAbilityRspBO sscDicDictionaryAbilityRspBO = this.sscDicDictionaryAbilityService.queryDictBOBySysCodeAndPcodeNoRedis(sscDicDictionaryAbilityReqBO);
        log.debug("\u5b57\u5178\u67e5\u8be2\u51fa\u53c2" + JSON.toJSONString((Object)sscDicDictionaryAbilityRspBO));
        if (CollectionUtils.isEmpty((Collection)sscDicDictionaryAbilityRspBO.getRows())) {
            throw new ZTBusinessException("\u67e5\u8be2\u5b57\u5178\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        return (SscDicDictionaryBO)sscDicDictionaryAbilityRspBO.getRows().get(0);
    }
}

