/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.ssc.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.pesapp.ssc.ability.DingdangSscBiddingDetailComplexExcelService;
import com.tydic.pesapp.ssc.ability.bo.DingdangSscPriceComparisonItemInfoBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangSscSupplierInfoBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangSscSupplierPriceComparisonItemBO;
import com.tydic.pesapp.ssc.ability.bo.ExcelMaterialDataBO;
import com.tydic.pesapp.ssc.ability.bo.ExcelPubInputReqBO;
import com.tydic.pesapp.ssc.ability.bo.ExcelPubOutputRspBO;
import com.tydic.pesapp.ssc.ability.bo.ExcelSupplierBiddingDetailBO;
import com.tydic.pesapp.ssc.ability.bo.ExcelSupplierBiddingInfoBO;
import com.tydic.pesapp.ssc.ability.utils.ExcelFormatUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DingdangSscBiddingDetailComplexExcelServiceImpl
implements DingdangSscBiddingDetailComplexExcelService {
    private static final Logger log = LoggerFactory.getLogger(DingdangSscBiddingDetailComplexExcelServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    private static final String path = "pesapp-common";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;

    private void encapInputReq(ExcelPubInputReqBO excelPubInputReqBO) {
        if (!CollectionUtils.isEmpty((Collection)excelPubInputReqBO.getPriceComparisonItemInfoBOList())) {
            List emdBOList = excelPubInputReqBO.getPriceComparisonItemInfoBOList().stream().map(e -> {
                ExcelMaterialDataBO excelMaterialDataBO = new ExcelMaterialDataBO();
                BeanUtils.copyProperties((Object)e, (Object)excelMaterialDataBO);
                excelMaterialDataBO.setSpecModel(e.getSpec() + "_" + e.getModel());
                if (!StringUtils.isEmpty((Object)e.getHistoryUnitPrice())) {
                    excelMaterialDataBO.setHistoryUnitPrice(new BigDecimal(e.getHistoryUnitPrice()).setScale(2, 1));
                } else {
                    excelMaterialDataBO.setHistoryUnitPrice(new BigDecimal(0).setScale(2, 1));
                }
                if (!StringUtils.isEmpty((Object)e.getPurchaseNumber())) {
                    excelMaterialDataBO.setPurchaseNumber(new BigDecimal(e.getPurchaseNumber()).setScale(2, 1));
                } else {
                    excelMaterialDataBO.setPurchaseNumber(new BigDecimal(0).setScale(2, 1));
                }
                return excelMaterialDataBO;
            }).collect(Collectors.toList());
            excelPubInputReqBO.setEmdBOList(emdBOList);
            HashMap<String, ExcelSupplierBiddingDetailBO> detailFirstBOMap = new HashMap<String, ExcelSupplierBiddingDetailBO>();
            HashMap<String, ExcelSupplierBiddingDetailBO> detailLastBOMap = new HashMap<String, ExcelSupplierBiddingDetailBO>();
            for (DingdangSscPriceComparisonItemInfoBO priceComparisonItemInfoBO : excelPubInputReqBO.getPriceComparisonItemInfoBOList()) {
                if (CollectionUtils.isEmpty((Collection)priceComparisonItemInfoBO.getSupplierPriceComparisonItemList())) continue;
                for (DingdangSscSupplierPriceComparisonItemBO itemBO : priceComparisonItemInfoBO.getSupplierPriceComparisonItemList()) {
                    ExcelSupplierBiddingDetailBO supplierDetailFirstBO = new ExcelSupplierBiddingDetailBO();
                    supplierDetailFirstBO.setSupplierId(itemBO.getSupplierId());
                    supplierDetailFirstBO.setSupplierName(itemBO.getSupplierName());
                    supplierDetailFirstBO.setMaterialId(priceComparisonItemInfoBO.getMaterialId());
                    supplierDetailFirstBO.setMaterialName(priceComparisonItemInfoBO.getMaterialName());
                    supplierDetailFirstBO.setBrandName(itemBO.getBrandNameHis());
                    supplierDetailFirstBO.setTaxRate(itemBO.getTaxRateHis());
                    supplierDetailFirstBO.setTaxUnitPrice(itemBO.getTaxUnitPriceHis());
                    supplierDetailFirstBO.setSupplierRemark(itemBO.getSupplierRemarkHis());
                    supplierDetailFirstBO.setQualityPeriod(itemBO.getQualityPeriodHis());
                    supplierDetailFirstBO.setDeliveryPeriod(itemBO.getDeliveryPeriodHis());
                    detailFirstBOMap.put(itemBO.getSupplierId() + "_" + priceComparisonItemInfoBO.getMaterialId(), supplierDetailFirstBO);
                    ExcelSupplierBiddingDetailBO supplierDetailLastBO = new ExcelSupplierBiddingDetailBO();
                    BeanUtils.copyProperties((Object)itemBO, (Object)supplierDetailLastBO);
                    supplierDetailLastBO.setMaterialId(priceComparisonItemInfoBO.getMaterialId());
                    supplierDetailLastBO.setMaterialName(priceComparisonItemInfoBO.getMaterialName());
                    detailLastBOMap.put(itemBO.getSupplierId() + "_" + priceComparisonItemInfoBO.getMaterialId(), supplierDetailLastBO);
                }
            }
            excelPubInputReqBO.setDetailFirstBOMap(detailFirstBOMap);
            excelPubInputReqBO.setDetailLastBOMap(detailLastBOMap);
        }
        if (!CollectionUtils.isEmpty((Collection)excelPubInputReqBO.getSupplierHeaderBOList())) {
            HashMap<String, ExcelSupplierBiddingInfoBO> biddingInfoFirstBOMap = new HashMap<String, ExcelSupplierBiddingInfoBO>();
            HashMap<String, ExcelSupplierBiddingInfoBO> biddingInfoLastBOMap = new HashMap<String, ExcelSupplierBiddingInfoBO>();
            for (DingdangSscSupplierInfoBO sscSupplierInfoBO : excelPubInputReqBO.getSupplierHeaderBOList()) {
                ExcelSupplierBiddingInfoBO supplierInfoFirstBO = new ExcelSupplierBiddingInfoBO();
                supplierInfoFirstBO.setSupplierId(sscSupplierInfoBO.getSupplierId());
                supplierInfoFirstBO.setSupplierName(sscSupplierInfoBO.getSupplierName());
                supplierInfoFirstBO.setTotalFee(sscSupplierInfoBO.getHisTotalQuotationPrice());
                supplierInfoFirstBO.setTotalFeeRankings(sscSupplierInfoBO.getHisTotalFeeRankings());
                supplierInfoFirstBO.setSettleMethodName(sscSupplierInfoBO.getTradeModeShow());
                supplierInfoFirstBO.setPayTypeName(sscSupplierInfoBO.getPayModeShow());
                supplierInfoFirstBO.setIsAffordShippingName("\u662f");
                supplierInfoFirstBO.setCurrencyTypeName("\u4eba\u6c11\u5e01");
                biddingInfoFirstBOMap.put(sscSupplierInfoBO.getSupplierId() + "", supplierInfoFirstBO);
                ExcelSupplierBiddingInfoBO supplierInfoLastBO = new ExcelSupplierBiddingInfoBO();
                supplierInfoLastBO.setSupplierId(sscSupplierInfoBO.getSupplierId());
                supplierInfoLastBO.setSupplierName(sscSupplierInfoBO.getSupplierName());
                supplierInfoLastBO.setTotalFee(sscSupplierInfoBO.getTotalQuotationPrice());
                supplierInfoLastBO.setTotalFeeRankings(sscSupplierInfoBO.getTotalFeeRankings());
                supplierInfoLastBO.setSettleMethodName(sscSupplierInfoBO.getTradeModeShow());
                supplierInfoLastBO.setPayTypeName(sscSupplierInfoBO.getPayModeShow());
                supplierInfoLastBO.setIsAffordShippingName("\u662f");
                supplierInfoLastBO.setCurrencyTypeName("\u4eba\u6c11\u5e01");
                biddingInfoLastBOMap.put(sscSupplierInfoBO.getSupplierId() + "", supplierInfoLastBO);
            }
            excelPubInputReqBO.setBiddingInfoFirstBOMap(biddingInfoFirstBOMap);
            excelPubInputReqBO.setBiddingInfoLastBOMap(biddingInfoLastBOMap);
        }
    }

    public ExcelPubOutputRspBO createBiddingDetailComplexExcel(ExcelPubInputReqBO excelPubInputReqBO) {
        log.info("createBiddingDetailComplexExcel\u5165\u53c2\u4fe1\u606f::excelPubInputReqBO.toString()=" + excelPubInputReqBO.toString());
        ExcelPubOutputRspBO excelPubOutputRspBO = new ExcelPubOutputRspBO();
        this.encapInputReq(excelPubInputReqBO);
        log.info("\u5c01\u88c5\u540e\u7684\u5165\u53c2\u4fe1\u606f-encapInputReq::excelPubInputReqBO.toString()=" + excelPubInputReqBO.toString());
        try {
            String fileUrl;
            int i;
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFCellStyle alignStyle = (XSSFCellStyle)ExcelFormatUtil.contentStyle((Workbook)wb);
            XSSFCellStyle headerStyle = (XSSFCellStyle)ExcelFormatUtil.headStyle((Workbook)wb);
            XSSFCellStyle titleStyle = (XSSFCellStyle)ExcelFormatUtil.titleStyle((Workbook)wb, HSSFColor.HSSFColorPredefined.WHITE.getIndex(), (short)10);
            Sheet sheet = wb.createSheet("\u6bd4\u4ef7\u660e\u7ec6");
            int rowCount = 0;
            int cellCount = 0;
            int materialRowCnt = 1;
            String[] headerFronds = new String[]{"\u7269\u6599\u7f16\u7801", "\u7269\u6599\u540d\u79f0", "\u89c4\u683c\u578b\u53f7", "\u8ba1\u91cf\u5355\u4f4d", "\u6570\u91cf", "\u4f7f\u7528\u5355\u4f4d", "\u9700\u65b9\u5907\u6ce8", "\u5386\u53f2\u4ef7\u683c", "\u62a5\u4ef7\u4fe1\u606f"};
            Row ztRow = sheet.createRow(0);
            log.info("rowCount=" + (rowCount += materialRowCnt));
            for (int i2 = 0; i2 < headerFronds.length; ++i2) {
                Cell ztCell = ztRow.createCell(i2);
                ztCell.setCellValue(headerFronds[i2]);
                ztCell.setCellStyle((CellStyle)headerStyle);
                CellRangeAddress regionZt = new CellRangeAddress(0, 1, i2, i2);
                sheet.addMergedRegion(regionZt);
                sheet.setColumnWidth(i2, headerFronds[i2].getBytes().length * 2 * 256);
                ExcelFormatUtil.setRegionBorder(BorderStyle.THIN, regionZt, sheet);
                ++cellCount;
            }
            log.info("cellCount=" + cellCount);
            int priceRowCnt = 5;
            log.info("excelPubInputReqBO.getEmdBOList()=" + excelPubInputReqBO.getEmdBOList());
            int tempCnt = 0;
            String[] headerMiddles = new String[]{"\u62a5\u4ef7", "\u4ea4\u8d27\u5468\u671f(\u5929)", "\u54c1\u724c", "\u8d28\u4fdd\u671f", "\u4f9b\u65b9\u5907\u6ce8", "\u7a0e\u7387"};
            int tempRowCnt = materialRowCnt;
            for (ExcelMaterialDataBO materialDataBO : excelPubInputReqBO.getEmdBOList()) {
                log.info("emdBOList.size()::tempRowCnt=" + tempRowCnt);
                for (int i3 = 0; i3 < headerMiddles.length; ++i3) {
                    log.info("headerMiddles::tempRowCnt+1=" + (tempRowCnt + 1));
                    log.info("headerMiddles::headerFronds.length-1=" + (headerFronds.length - 1));
                    log.info("headerMiddles::headerMiddles[i]=" + headerMiddles[i3]);
                    ExcelFormatUtil.createRowAndCell(sheet, tempRowCnt + 1, headerFronds.length - 1, (CellStyle)titleStyle, false, false, headerMiddles[i3]);
                    ++tempRowCnt;
                }
                log.info("1111::materialDataBO.toString()=" + materialDataBO.toString());
                log.info("1111::tempCnt=" + tempCnt);
                log.info("1111::rowCount=" + rowCount);
                tempCnt = rowCount + 1;
                log.info("2222::tempCnt=" + tempCnt);
                materialDataBO.setRowNum(Integer.valueOf(tempCnt));
                Field[] materialFields = materialDataBO.getClass().getDeclaredFields();
                Method[] materialMethods = materialDataBO.getClass().getDeclaredMethods();
                block5: for (int i4 = 0; i4 < materialFields.length; ++i4) {
                    log.info("materialFields[i].getName()=" + materialFields[i4].getName());
                    for (int j = 0; j < materialMethods.length; ++j) {
                        if (!materialMethods[j].getName().contains("get") || "rowNum".equals(materialFields[i4].getName()) || !("get" + materialFields[i4].getName().substring(0, 1).toUpperCase() + materialFields[i4].getName().substring(1)).equals(materialMethods[j].getName())) continue;
                        log.info("materialMethods[j].getName()=" + materialMethods[j].getName());
                        ExcelFormatUtil.createRowAndCell(sheet, tempCnt, i4, (CellStyle)alignStyle, true, false, materialMethods[j].invoke((Object)materialDataBO, new Object[0]));
                        CellRangeAddress regionZt = new CellRangeAddress(tempCnt, tempCnt + priceRowCnt, i4, i4);
                        sheet.addMergedRegion(regionZt);
                        sheet.setColumnWidth(i4, (materialMethods[j].invoke((Object)materialDataBO, new Object[0]) + "").getBytes().length * 2 * 256);
                        ExcelFormatUtil.setRegionBorder(BorderStyle.THIN, regionZt, sheet);
                        continue block5;
                    }
                }
                rowCount = tempCnt + priceRowCnt;
            }
            HashMap<String, Integer> buttomNumList = new HashMap<String, Integer>();
            String[] headerButtoms = new String[]{"\u603b\u91d1\u989d", "\u603b\u91d1\u989d\u6392\u540d", "\u7ed3\u7b97\u65b9\u5f0f", "\u4ed8\u6b3e\u65b9\u5f0f", "\u8fd0\u6742\u8d39\u7528\u627f\u62c5", "\u5e01\u79cd"};
            String[] headerKeyButtoms = new String[]{"totalFee", "totalFeeRankings", "settleMethodName", "payTypeName", "isAffordShippingName", "currencyTypeName"};
            for (i = 0; i < headerButtoms.length; ++i) {
                tempCnt = rowCount + 1;
                buttomNumList.put(headerKeyButtoms[i], tempCnt);
                ExcelFormatUtil.createRowAndCell(sheet, tempCnt, 0, (CellStyle)titleStyle, false, false, headerButtoms[i]);
                CellRangeAddress regionZt = new CellRangeAddress(tempCnt, tempCnt, 0, headerFronds.length - 1);
                sheet.addMergedRegion(regionZt);
                ExcelFormatUtil.setRegionBorder(BorderStyle.THIN, regionZt, sheet);
                ++rowCount;
            }
            for (i = 0; i < excelPubInputReqBO.getSupplierHeaderBOList().size(); ++i) {
                ExcelFormatUtil.createRowAndCell(sheet, 0, cellCount, (CellStyle)headerStyle, true, false, ((DingdangSscSupplierInfoBO)excelPubInputReqBO.getSupplierHeaderBOList().get(i)).getSupplierName());
                CellRangeAddress regionZt = new CellRangeAddress(0, 0, cellCount, cellCount + 1);
                sheet.addMergedRegion(regionZt);
                sheet.setColumnWidth(i, ((DingdangSscSupplierInfoBO)excelPubInputReqBO.getSupplierHeaderBOList().get(i)).getSupplierName().getBytes().length * 2 * 256);
                ExcelFormatUtil.setRegionBorder(BorderStyle.THIN, regionZt, sheet);
                ExcelFormatUtil.createRowAndCell(sheet, 1, cellCount, (CellStyle)titleStyle, true, false, "\u4e00\u6b21\u62a5\u4ef7");
                ExcelFormatUtil.createRowAndCell(sheet, 1, cellCount + 1, (CellStyle)titleStyle, true, false, "\u6700\u7ec8\u62a5\u4ef7");
                ((DingdangSscSupplierInfoBO)excelPubInputReqBO.getSupplierHeaderBOList().get(i)).setCellNum(Integer.valueOf(cellCount));
                cellCount += 2;
            }
            for (DingdangSscSupplierInfoBO supplierHeaderBO : excelPubInputReqBO.getSupplierHeaderBOList()) {
                Field[] firstFields = ((ExcelSupplierBiddingInfoBO)excelPubInputReqBO.getBiddingInfoFirstBOMap().get(supplierHeaderBO.getSupplierId() + "")).getClass().getDeclaredFields();
                Method[] firstMethods = ((ExcelSupplierBiddingInfoBO)excelPubInputReqBO.getBiddingInfoFirstBOMap().get(supplierHeaderBO.getSupplierId() + "")).getClass().getDeclaredMethods();
                for (int i5 = 0; i5 < firstFields.length; ++i5) {
                    log.info("firstFields[i].getName()=" + firstFields[i5].getName());
                    if (!buttomNumList.containsKey(firstFields[i5].getName())) continue;
                    log.info("buttomNumList.get(firstFields[i].getName())=" + buttomNumList.get(firstFields[i5].getName()));
                    for (int j = 0; j < firstMethods.length; ++j) {
                        log.info("firstMethods[j].getName()=" + firstMethods[j].getName());
                        if (!firstMethods[j].getName().equals("get" + firstFields[i5].getName().substring(0, 1).toUpperCase() + firstFields[i5].getName().substring(1))) continue;
                        log.info("supplierHeaderBO.getCellNum()=" + supplierHeaderBO.getCellNum());
                        log.info("(buttomNumList.get(firstFields[i].getName()))=" + buttomNumList.get(firstFields[i5].getName()));
                        ExcelFormatUtil.createRowAndCell(sheet, (Integer)buttomNumList.get(firstFields[i5].getName()), supplierHeaderBO.getCellNum(), (CellStyle)alignStyle, true, false, firstMethods[j].invoke(excelPubInputReqBO.getBiddingInfoFirstBOMap().get(supplierHeaderBO.getSupplierId() + ""), new Object[0]));
                    }
                }
                Field[] lastFields = ((ExcelSupplierBiddingInfoBO)excelPubInputReqBO.getBiddingInfoLastBOMap().get(supplierHeaderBO.getSupplierId() + "")).getClass().getDeclaredFields();
                Method[] lastMethods = ((ExcelSupplierBiddingInfoBO)excelPubInputReqBO.getBiddingInfoLastBOMap().get(supplierHeaderBO.getSupplierId() + "")).getClass().getDeclaredMethods();
                for (int i6 = 0; i6 < lastFields.length; ++i6) {
                    if (!buttomNumList.containsKey(lastFields[i6].getName())) continue;
                    for (int j = 0; j < lastMethods.length; ++j) {
                        if (!lastMethods[j].getName().equals("get" + lastFields[i6].getName().substring(0, 1).toUpperCase() + lastFields[i6].getName().substring(1))) continue;
                        ExcelFormatUtil.createRowAndCell(sheet, (Integer)buttomNumList.get(lastFields[i6].getName()), supplierHeaderBO.getCellNum() + 1, (CellStyle)alignStyle, true, false, lastMethods[j].invoke(excelPubInputReqBO.getBiddingInfoLastBOMap().get(supplierHeaderBO.getSupplierId() + ""), new Object[0]));
                    }
                }
                for (ExcelMaterialDataBO materialDataBO : excelPubInputReqBO.getEmdBOList()) {
                    log.info("materialDataBO.getRowNum()=" + materialDataBO.getRowNum());
                    log.info("supplierHeaderBO.getCellNum()=" + supplierHeaderBO.getCellNum());
                    log.info("supplierHeaderBO.getSupplierId()=" + supplierHeaderBO.getSupplierId());
                    log.info("materialDataBO.getMaterialId()=" + materialDataBO.getMaterialId());
                    int tempRowNum = materialDataBO.getRowNum();
                    int tempCellNum = supplierHeaderBO.getCellNum();
                    if (excelPubInputReqBO.getDetailFirstBOMap().containsKey(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())) {
                        ExcelFormatUtil.createRowAndCell(sheet, tempRowNum, tempCellNum, (CellStyle)alignStyle, true, false, ((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailFirstBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getTaxUnitPrice());
                        ExcelFormatUtil.createRowAndCell(sheet, tempRowNum + 1, tempCellNum, (CellStyle)alignStyle, true, false, ((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailFirstBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getDeliveryPeriod());
                        ExcelFormatUtil.createRowAndCell(sheet, tempRowNum + 2, tempCellNum, (CellStyle)alignStyle, true, false, ((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailFirstBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getBrandName());
                        ExcelFormatUtil.createRowAndCell(sheet, tempRowNum + 3, tempCellNum, (CellStyle)alignStyle, true, false, ((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailFirstBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getQualityPeriod());
                        ExcelFormatUtil.createRowAndCell(sheet, tempRowNum + 4, tempCellNum, (CellStyle)alignStyle, true, false, ((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailFirstBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getSupplierRemark());
                        ExcelFormatUtil.createRowAndCell(sheet, tempRowNum + 5, tempCellNum, (CellStyle)alignStyle, true, false, ((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailFirstBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getTaxRate());
                    } else {
                        ExcelFormatUtil.createMultRowAndCell(sheet, tempRowNum, tempCellNum, (CellStyle)alignStyle, true, false, null, 6, 0);
                    }
                    if (excelPubInputReqBO.getDetailLastBOMap().containsKey(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())) {
                        ExcelFormatUtil.createRowAndCell(sheet, tempRowNum, tempCellNum + 1, (CellStyle)alignStyle, true, false, ((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailLastBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getTaxUnitPrice());
                        ExcelFormatUtil.createRowAndCell(sheet, tempRowNum + 1, tempCellNum + 1, (CellStyle)alignStyle, true, false, ((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailLastBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getDeliveryPeriod());
                        ExcelFormatUtil.createRowAndCell(sheet, tempRowNum + 2, tempCellNum + 1, (CellStyle)alignStyle, true, false, ((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailLastBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getBrandName());
                        ExcelFormatUtil.createRowAndCell(sheet, tempRowNum + 3, tempCellNum + 1, (CellStyle)alignStyle, true, false, ((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailLastBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getQualityPeriod());
                        ExcelFormatUtil.createRowAndCell(sheet, tempRowNum + 4, tempCellNum + 1, (CellStyle)alignStyle, true, false, ((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailLastBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getSupplierRemark());
                        ExcelFormatUtil.createRowAndCell(sheet, tempRowNum + 5, tempCellNum + 1, (CellStyle)alignStyle, true, false, ((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailLastBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getTaxRate());
                        continue;
                    }
                    ExcelFormatUtil.createMultRowAndCell(sheet, tempRowNum, tempCellNum + 1, (CellStyle)alignStyle, true, false, null, 6, 0);
                }
            }
            String nowDate = DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMddHHmmss");
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            wb.write((OutputStream)os);
            byte[] data = os.toByteArray();
            os.close();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            String fileName = "BiddingDetailExcel_" + nowDate + ".xlsx";
            log.info("createBiddingDetailComplexExcel::fileName=" + fileName);
            String path = this.fileClient.uploadFileByInputStream(path, fileName, (InputStream)inputStream);
            log.info("createBiddingDetailComplexExcel::path=" + path);
            if ("OSS".equals(this.fileType)) {
                fileUrl = this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                fileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            if (!fileUrl.contains("http:")) {
                fileUrl = "http://" + fileUrl;
            }
            log.info("createBiddingDetailComplexExcel::\u751f\u6210\u590d\u6742excel\u6587\u4ef6\u5730\u5740::fileUrl=" + fileUrl);
            excelPubOutputRspBO.setExcelUrl(fileUrl);
            log.info("\u5199\u5165\u6210\u529f\uff0c\u8fd0\u884c\u7ed3\u675f\uff01");
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u590d\u6742excel\u8868\u683c\u5f02\u5e38\uff1ae=" + e);
            excelPubOutputRspBO.setRespCode("8888");
            excelPubOutputRspBO.setRespDesc("\u751f\u6210\u590d\u5236excel\u8868\u683c\u5f02\u5e38");
            return excelPubOutputRspBO;
        }
        excelPubOutputRspBO.setRespCode("0000");
        excelPubOutputRspBO.setRespDesc("\u6210\u529f");
        log.info("createBiddingDetailComplexExcel\u51fa\u53c2\u4fe1\u606f::excelPubOutputRspBO.toString()=" + excelPubOutputRspBO.toString());
        return excelPubOutputRspBO;
    }
}

