/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.ssc.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.pesapp.ssc.ability.DingdangSscQrySupQuotationScoreService;
import com.tydic.pesapp.ssc.ability.bo.DingdangSscQrySupQuotationScoreReqBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangSscQrySupQuotationScoreRspBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangSupProfessorScoreBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangSupQuotationScoreBO;
import com.tydic.ssc.ability.SscQryProfessorSupplierScoreListAbilityService;
import com.tydic.ssc.ability.SscQrySupplierQuotationListAbilityService;
import com.tydic.ssc.ability.bo.SscQryProfessorSupplierScoreListAbilityReqBO;
import com.tydic.ssc.ability.bo.SscQryProfessorSupplierScoreListAbilityRspBO;
import com.tydic.ssc.ability.bo.SscQrySupplierQuotationListAbilityReqBO;
import com.tydic.ssc.ability.bo.SscQrySupplierQuotationListAbilityRspBO;
import com.tydic.ssc.common.SscProfessorSupplierScoreBO;
import com.tydic.ssc.common.SscSupplierQuotationBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class DingdangSscQrySupQuotationScoreServiceImpl
implements DingdangSscQrySupQuotationScoreService {
    private static final Logger log = LoggerFactory.getLogger(DingdangSscQrySupQuotationScoreServiceImpl.class);
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="SSC_GROUP_TEST")
    private SscQrySupplierQuotationListAbilityService sscQrySupplierQuotationListAbilityService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="SSC_GROUP_TEST")
    private SscQryProfessorSupplierScoreListAbilityService sscQryProfessorSupplierScoreListAbilityService;

    public DingdangSscQrySupQuotationScoreRspBO qrySupQuotationScore(DingdangSscQrySupQuotationScoreReqBO reqBO) {
        DingdangSscQrySupQuotationScoreRspBO rspBO = new DingdangSscQrySupQuotationScoreRspBO();
        this.validateParams(reqBO);
        SscQrySupplierQuotationListAbilityReqBO sscQrySupplierQuotationListAbilityReqBO = new SscQrySupplierQuotationListAbilityReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)sscQrySupplierQuotationListAbilityReqBO);
        sscQrySupplierQuotationListAbilityReqBO.setQuotationRound(reqBO.getScoreRound());
        log.info("\u5165\u53c2\u5206\u9875\u4fe1\u606f\uff1a pageNo-" + sscQrySupplierQuotationListAbilityReqBO.getPageNo() + " pageSize-" + sscQrySupplierQuotationListAbilityReqBO.getPageSize() + " queryPageFlag-" + sscQrySupplierQuotationListAbilityReqBO.getQueryPageFlag());
        SscQrySupplierQuotationListAbilityRspBO sscQrySupplierQuotationListAbilityRspBO = this.sscQrySupplierQuotationListAbilityService.qrySupplierQuotationList(sscQrySupplierQuotationListAbilityReqBO);
        if (!"0000".equals(sscQrySupplierQuotationListAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException(sscQrySupplierQuotationListAbilityRspBO.getRespDesc());
        }
        log.info("\u4f9b\u5e94\u5546\u62a5\u4ef7\u8bc4\u5206\u4fe1\u606f\u5217\u8868\u67e5\u8be2API \u8c03\u7528\u6210\u529f");
        List supplierQuotationRows = sscQrySupplierQuotationListAbilityRspBO.getRows();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (supplierQuotationRows != null && supplierQuotationRows.size() != 0) {
            for (SscSupplierQuotationBO row : supplierQuotationRows) {
                ids.add(row.getSupplierId());
            }
        } else {
            log.debug("\u4f9b\u5e94\u5546\u62a5\u4ef7\u8bc4\u5206\u4fe1\u606f\u5217\u8868\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e");
            return new DingdangSscQrySupQuotationScoreRspBO();
        }
        log.info("\u67e5\u8be2\u67d0project\u5bf9\u5e94\u4f9b\u5e94\u5546\u5217\u8868Id\uff1a" + ids);
        SscQryProfessorSupplierScoreListAbilityReqBO sscQryProfessorSupplierScoreListAbilityReqBO = new SscQryProfessorSupplierScoreListAbilityReqBO();
        sscQryProfessorSupplierScoreListAbilityReqBO.setProjectId(reqBO.getProjectId());
        sscQryProfessorSupplierScoreListAbilityReqBO.setScoreRound(reqBO.getScoreRound());
        sscQryProfessorSupplierScoreListAbilityReqBO.setPageSize(Integer.valueOf(-1));
        sscQryProfessorSupplierScoreListAbilityReqBO.setPageNo(Integer.valueOf(-1));
        SscQryProfessorSupplierScoreListAbilityRspBO sscQryProfessorSupplierScoreListAbilityRspBO = this.sscQryProfessorSupplierScoreListAbilityService.qryProfessorSupplierScoreList(sscQryProfessorSupplierScoreListAbilityReqBO);
        if (!"0000".equals(sscQryProfessorSupplierScoreListAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException(sscQryProfessorSupplierScoreListAbilityRspBO.getRespDesc());
        }
        log.info("\u4e13\u5bb6\u4f9b\u5e94\u5546\u8bc4\u5206\u5217\u8868\u67e5\u8be2API \u8c03\u7528\u6210\u529f");
        List professorSupplierRows = sscQryProfessorSupplierScoreListAbilityRspBO.getRows();
        Map<Long, List<SscProfessorSupplierScoreBO>> professorSupplierCollect = new HashMap<Long, List<SscProfessorSupplierScoreBO>>();
        if (professorSupplierRows != null && professorSupplierRows.size() > 0) {
            professorSupplierCollect = professorSupplierRows.stream().collect(Collectors.groupingBy(SscProfessorSupplierScoreBO::getSupplierId));
            for (Long supplierId : professorSupplierCollect.keySet()) {
                String professorId = " ";
                for (SscProfessorSupplierScoreBO sscProfessorSupplierScoreBO : professorSupplierCollect.get(supplierId)) {
                    professorId = professorId + sscProfessorSupplierScoreBO.getProfessorId() + " ";
                }
                log.info("\u5f53\u524d\u4f9b\u5e94\u5546\uff1a" + supplierId + " \u4e13\u5bb6ids\uff1a" + professorId);
            }
        } else {
            log.info("\u4e13\u5bb6\u4f9b\u5e94\u5546\u6253\u5206\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        List<DingdangSupQuotationScoreBO> result = this.getResultOnForce(supplierQuotationRows, professorSupplierCollect, reqBO.getProfessorIds());
        rspBO.setRows(result);
        log.info("\u9879\u76ee\u4f9b\u5e94\u5546\u62a5\u4ef7\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u7684\u5206\u9875\u4fe1\u606f\uff1a pageNo-" + sscQrySupplierQuotationListAbilityRspBO.getPageNo() + " total-" + sscQrySupplierQuotationListAbilityRspBO.getTotal() + " recordsTotal" + sscQrySupplierQuotationListAbilityRspBO.getRecordsTotal());
        rspBO.setPageNo(sscQrySupplierQuotationListAbilityRspBO.getPageNo());
        rspBO.setTotal(sscQrySupplierQuotationListAbilityRspBO.getTotal());
        rspBO.setRecordsTotal(sscQrySupplierQuotationListAbilityRspBO.getRecordsTotal());
        return rspBO;
    }

    public void validateParams(DingdangSscQrySupQuotationScoreReqBO reqBO) {
        if (reqBO.getProjectId() == null) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u62a5\u4ef7\u8bc4\u5206\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u3010projectId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getScoreRound() == null) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u62a5\u4ef7\u8bc4\u5206\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u3010scoreRound\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getProfessorIds().size() == 0) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u62a5\u4ef7\u8bc4\u5206\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u3010professorIds\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public Map<Long, List<DingdangSupProfessorScoreBO>> getProfessorScoreList(List<Long> ids, SscQryProfessorSupplierScoreListAbilityRspBO rspBO) {
        ArrayList<DingdangSupProfessorScoreBO> list;
        HashMap<Long, List<DingdangSupProfessorScoreBO>> map = new HashMap<Long, List<DingdangSupProfessorScoreBO>>();
        List rows = rspBO.getRows();
        for (SscProfessorSupplierScoreBO row : rows) {
            DingdangSupProfessorScoreBO dingdangSupProfessorScoreBO = new DingdangSupProfessorScoreBO();
            dingdangSupProfessorScoreBO.setProfessorId(row.getProfessorId());
            dingdangSupProfessorScoreBO.setBusinessScore(row.getBusinessScore());
            dingdangSupProfessorScoreBO.setTechnicalScore(row.getTechnicalScore());
            dingdangSupProfessorScoreBO.setTotalScore(row.getTotalScore());
            if (map.containsKey(row.getSupplierId())) {
                ((List)map.get(row.getSupplierId())).add(dingdangSupProfessorScoreBO);
                continue;
            }
            list = new ArrayList();
            list.add(dingdangSupProfessorScoreBO);
            map.put(row.getSupplierId(), list);
        }
        Set keys = map.keySet();
        for (Long id : ids) {
            if (keys.contains(id)) continue;
            list = new ArrayList<DingdangSupProfessorScoreBO>();
            list.add(new DingdangSupProfessorScoreBO());
            map.put(id, list);
        }
        log.info("\u7ed9\u8be5\u9879\u76ee\u6240\u6709\u4f9b\u5e94\u5546\u6253\u5206\u60c5\u51b5\uff1a" + map);
        return map;
    }

    public List<Long> getAllSupplierIds(SscQrySupplierQuotationListAbilityRspBO rspBO) {
        List rows = rspBO.getRows();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (SscSupplierQuotationBO row : rows) {
            if (ids.contains(row.getSupplierId())) continue;
            ids.add(row.getSupplierId());
        }
        return ids;
    }

    public Map<Long, List<DingdangSupProfessorScoreBO>> sortProfessorScoreList(DingdangSscQrySupQuotationScoreReqBO reqBO, Map<Long, List<DingdangSupProfessorScoreBO>> reqMap) {
        HashMap<Long, List<DingdangSupProfessorScoreBO>> map = new HashMap<Long, List<DingdangSupProfessorScoreBO>>();
        List professorIds = reqBO.getProfessorIds();
        for (Long key : reqMap.keySet()) {
            ArrayList<DingdangSupProfessorScoreBO> dingdangSupProfessorScoreBOArrayList = new ArrayList<DingdangSupProfessorScoreBO>();
            for (Long professorId : professorIds) {
                DingdangSupProfessorScoreBO score = new DingdangSupProfessorScoreBO();
                for (DingdangSupProfessorScoreBO scoreBO : reqMap.get(key)) {
                    if (scoreBO.getProfessorId() == null) {
                        scoreBO.setProfessorId(Long.valueOf(-1L));
                    }
                    if (!professorId.equals(scoreBO.getProfessorId())) continue;
                    score = scoreBO;
                    dingdangSupProfessorScoreBOArrayList.add(score);
                }
                if (score.getProfessorId() == null) {
                    score.setProfessorId(professorId);
                    dingdangSupProfessorScoreBOArrayList.add(score);
                }
                if (score.getProfessorId() != -1L) continue;
                score.setProfessorId(professorId);
                dingdangSupProfessorScoreBOArrayList.add(score);
            }
            map.put(key, dingdangSupProfessorScoreBOArrayList);
        }
        return map;
    }

    public String getTotalScore(List<DingdangSupProfessorScoreBO> list) {
        double totalScore = 0.0;
        double a = 0.0;
        double b = 0.0;
        if (list != null && list.size() > 0) {
            for (DingdangSupProfessorScoreBO scoreBO : list) {
                if (scoreBO.getBusinessScore() == null) {
                    a = 0.0;
                }
                if (scoreBO.getTechnicalScore() == null) {
                    b = 0.0;
                }
                if (scoreBO.getBusinessScore() != null) {
                    a = scoreBO.getBusinessScore().doubleValue();
                }
                if (scoreBO.getTechnicalScore() != null) {
                    b = scoreBO.getTechnicalScore().doubleValue();
                }
                totalScore = totalScore + a + b;
            }
        }
        return String.valueOf(totalScore);
    }

    public List<DingdangSupQuotationScoreBO> getDingdangSupQuotationScoreBO(SscQrySupplierQuotationListAbilityRspBO rspBO, Map<Long, List<DingdangSupProfessorScoreBO>> map) {
        ArrayList<DingdangSupQuotationScoreBO> list = new ArrayList<DingdangSupQuotationScoreBO>();
        List rows = rspBO.getRows();
        for (SscSupplierQuotationBO row : rows) {
            DingdangSupQuotationScoreBO dingdangSupQuotationScoreBO = new DingdangSupQuotationScoreBO();
            dingdangSupQuotationScoreBO.setSupplierName(row.getSupplierName());
            dingdangSupQuotationScoreBO.setSupplierId(row.getSupplierId());
            dingdangSupQuotationScoreBO.setQuotationIp(row.getQuotationIp());
            dingdangSupQuotationScoreBO.setDingdangSupProfessorScoreBOs(map.get(row.getSupplierId()));
            dingdangSupQuotationScoreBO.setSignInIp(row.getSignInIp());
            dingdangSupQuotationScoreBO.setProfessorScoreTotal(this.getTotalScore(map.get(row.getSupplierId())));
            list.add(dingdangSupQuotationScoreBO);
        }
        return list;
    }

    public List<DingdangSupQuotationScoreBO> getResultOnForce(List<SscSupplierQuotationBO> supplierQuotationRows, Map<Long, List<SscProfessorSupplierScoreBO>> professorSupplierCollect, List<Long> professorIds) {
        HashSet<Long> supplierIds = new HashSet<Long>();
        for (SscSupplierQuotationBO sscSupplierQuotationBO : supplierQuotationRows) {
            supplierIds.add(sscSupplierQuotationBO.getSupplierId());
        }
        log.info("\u4f9b\u5e94\u5546id\u96c6\u5408\uff1a" + supplierIds);
        HashMap map = new HashMap();
        for (Long supplierId : supplierIds) {
            map.put(supplierId, new ArrayList());
            for (Long professorId : professorIds) {
                boolean flag = false;
                if (professorSupplierCollect.get(supplierId) != null && professorSupplierCollect.get(supplierId).size() > 0) {
                    for (SscProfessorSupplierScoreBO sscProfessorSupplierScoreBO : professorSupplierCollect.get(supplierId)) {
                        if (!sscProfessorSupplierScoreBO.getProfessorId().equals(professorId) || !sscProfessorSupplierScoreBO.getSupplierId().equals(supplierId)) continue;
                        DingdangSupProfessorScoreBO score = new DingdangSupProfessorScoreBO();
                        score.setTotalScore(sscProfessorSupplierScoreBO.getTotalScore());
                        score.setProfessorId(professorId);
                        score.setProfessorName(sscProfessorSupplierScoreBO.getProfessorName());
                        score.setTechnicalScore(sscProfessorSupplierScoreBO.getTechnicalScore());
                        score.setBusinessScore(sscProfessorSupplierScoreBO.getBusinessScore());
                        ((List)map.get(supplierId)).add(score);
                        flag = true;
                        break;
                    }
                }
                if (flag) continue;
                DingdangSupProfessorScoreBO score = new DingdangSupProfessorScoreBO();
                score.setProfessorId(professorId);
                score.setProfessorName("-1");
                ((List)map.get(supplierId)).add(score);
            }
        }
        ArrayList<DingdangSupQuotationScoreBO> arrayList = new ArrayList<DingdangSupQuotationScoreBO>();
        for (SscSupplierQuotationBO supplierQuotationRow : supplierQuotationRows) {
            DingdangSupQuotationScoreBO dingdangSupQuotationScoreBO = new DingdangSupQuotationScoreBO();
            dingdangSupQuotationScoreBO.setSupplierName(supplierQuotationRow.getSupplierName());
            dingdangSupQuotationScoreBO.setSupplierId(supplierQuotationRow.getSupplierId());
            dingdangSupQuotationScoreBO.setQuotationIp(supplierQuotationRow.getQuotationIp());
            dingdangSupQuotationScoreBO.setSignInIp(supplierQuotationRow.getSignInIp());
            dingdangSupQuotationScoreBO.setDingdangSupProfessorScoreBOs((List)map.get(supplierQuotationRow.getSupplierId()));
            dingdangSupQuotationScoreBO.setProfessorScoreTotal(this.getTotalScore((List)map.get(supplierQuotationRow.getSupplierId())));
            arrayList.add(dingdangSupQuotationScoreBO);
        }
        return arrayList;
    }
}

