/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.ssc.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.pesapp.ssc.ability.DingdangSscQueryPriceComparisonItemListService;
import com.tydic.pesapp.ssc.ability.bo.DingdangSscPriceComparisonItemInfoBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangSscQueryPriceComparisonItemListReqBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangSscQueryPriceComparisonItemListRspBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangSscSupplierPriceComparisonItemBO;
import com.tydic.ssc.ability.SscQryProjectDetailQuotationHisListAbilityService;
import com.tydic.ssc.ability.SscQryProjectDetailQuotationListAbilityService;
import com.tydic.ssc.ability.SscQryProjectMaxScoreRoundAbilityService;
import com.tydic.ssc.ability.bo.SscQryProjectDetailQuotationHisListAbilityReqBO;
import com.tydic.ssc.ability.bo.SscQryProjectDetailQuotationHisListAbilityRspBO;
import com.tydic.ssc.ability.bo.SscQryProjectDetailQuotationListAbilityReqBO;
import com.tydic.ssc.ability.bo.SscQryProjectDetailQuotationListAbilityRspBO;
import com.tydic.ssc.ability.bo.SscQryProjectMaxScoreRoundAbilityReqBO;
import com.tydic.ssc.ability.bo.SscQryProjectMaxScoreRoundAbilityRspBO;
import com.tydic.ssc.common.SscProjectDetailQuotationBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DingdangSscQueryPriceComparisonItemListServiceImpl
implements DingdangSscQueryPriceComparisonItemListService {
    private static final Logger log = LoggerFactory.getLogger(DingdangSscQueryPriceComparisonItemListServiceImpl.class);
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="SSC_GROUP_TEST")
    private SscQryProjectDetailQuotationListAbilityService sscQryProjectDetailQuotationListAbilityService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="SSC_GROUP_TEST")
    private SscQryProjectDetailQuotationHisListAbilityService sscQryProjectDetailQuotationHisListAbilityService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="SSC_GROUP_TEST")
    private SscQryProjectMaxScoreRoundAbilityService sscQryProjectMaxScoreRoundAbilityService;

    public DingdangSscQueryPriceComparisonItemListRspBO queryPriceComparisonItemList(DingdangSscQueryPriceComparisonItemListReqBO reqBO) {
        Integer maxScoreRound = -1;
        Boolean query = false;
        List hisList = null;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        log.debug("\u5165\u53c2\u6821\u9a8c\uff1a" + reqBO);
        if (reqBO.getExpecSettleDays() != null && reqBO.getExpecSettleDays().size() != 0) {
            int size = reqBO.getExpecSettleDays().size();
            log.debug("\u9700\u8981supplierId\u4e0eexpecSettleDay\u5bf9\u5e94");
            for (int i = 0; i < size; ++i) {
                map.put((String)reqBO.getSupplierOrderList().get(i), (Integer)reqBO.getExpecSettleDays().get(i));
            }
            log.debug("supplierId\u4e0eexpecSettleDay\u5bf9\u5e94:" + map);
        }
        HashMap<String, String> mapMode = new HashMap<String, String>();
        if (reqBO.getTradeModes() != null && reqBO.getTradeModes().size() != 0) {
            int size = reqBO.getTradeModes().size();
            for (int i = 0; i < size; ++i) {
                mapMode.put((String)reqBO.getSupplierOrderList().get(i), (String)reqBO.getTradeModes().get(i));
            }
        }
        HashMap<String, String> mapModeShow = new HashMap<String, String>();
        if (reqBO.getTradeModeShows() != null && reqBO.getTradeModeShows().size() != 0) {
            int size = reqBO.getTradeModeShows().size();
            for (int i = 0; i < size; ++i) {
                mapModeShow.put((String)reqBO.getSupplierOrderList().get(i), (String)reqBO.getTradeModeShows().get(i));
            }
        }
        HashMap<String, String> mapModeStr = new HashMap<String, String>();
        if (reqBO.getTradeModeStrs() != null && reqBO.getTradeModeStrs().size() != 0) {
            int size = reqBO.getTradeModeStrs().size();
            for (int i = 0; i < size; ++i) {
                mapModeStr.put((String)reqBO.getSupplierOrderList().get(i), (String)reqBO.getTradeModeStrs().get(i));
            }
        }
        this.validateParams(reqBO);
        if (reqBO.getQueryHis() == null || !reqBO.getQueryHis().booleanValue()) {
            log.debug("\u6839\u636e\u5165\u53c2\u4e0d\u9700\u8981\u67e5\u8be2\u5386\u53f2\u62a5\u4ef7");
        } else {
            SscQryProjectMaxScoreRoundAbilityReqBO sscQryProjectMaxScoreRoundAbilityReqBO = new SscQryProjectMaxScoreRoundAbilityReqBO();
            sscQryProjectMaxScoreRoundAbilityReqBO.setProjectId(reqBO.getProjectId());
            SscQryProjectMaxScoreRoundAbilityRspBO sscQryProjectMaxScoreRoundAbilityRspBO = this.sscQryProjectMaxScoreRoundAbilityService.qryProjectMaxScoreRound(sscQryProjectMaxScoreRoundAbilityReqBO);
            if ("0000".equals(sscQryProjectMaxScoreRoundAbilityRspBO.getRespCode())) {
                maxScoreRound = sscQryProjectMaxScoreRoundAbilityRspBO.getMaxScoreRound();
                log.debug("\u6700\u5927\u62a5\u4ef7\u8f6e\u6b21\uff1a" + maxScoreRound);
            } else {
                throw new ZTBusinessException(sscQryProjectMaxScoreRoundAbilityRspBO.getRespDesc());
            }
        }
        if (maxScoreRound == null || maxScoreRound == 1 || maxScoreRound == -1) {
            log.debug("\u67e5\u8be2\u6807\u5fd7 query: " + query);
            log.debug("\u6839\u636e\u6700\u5927\u62a5\u4ef7\u8f6e\u6b21\u4e0d\u9700\u8981\u67e5\u8be2\u5386\u53f2\u62a5\u4ef7");
        } else {
            query = true;
            log.debug("\u67e5\u8be2\u6807\u5fd7 query: " + query);
            log.debug("\u9700\u8981\u67e5\u8be2\u5386\u53f2\u62a5\u4ef7");
        }
        SscQryProjectDetailQuotationListAbilityReqBO reqBO1 = new SscQryProjectDetailQuotationListAbilityReqBO();
        reqBO1.setProjectId(reqBO.getProjectId());
        reqBO1.setStageId(reqBO.getStageId());
        reqBO1.setQueryPageFlag(Boolean.valueOf(false));
        SscQryProjectDetailQuotationListAbilityRspBO rspBO = this.sscQryProjectDetailQuotationListAbilityService.qryProjectDetailQuotationList(reqBO1);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException(rspBO.getRespDesc());
        }
        if (query.booleanValue()) {
            SscQryProjectDetailQuotationHisListAbilityReqBO reqBO2 = new SscQryProjectDetailQuotationHisListAbilityReqBO();
            reqBO2.setProjectId(reqBO.getProjectId());
            reqBO2.setStageId(reqBO.getStageId());
            reqBO2.setQueryPageFlag(Boolean.valueOf(false));
            reqBO2.setQuotationRound(Integer.valueOf(1));
            SscQryProjectDetailQuotationHisListAbilityRspBO rspBO1 = this.sscQryProjectDetailQuotationHisListAbilityService.qryProjectDetailQuotationHisList(reqBO2);
            if (!"0000".equals(rspBO1.getRespCode())) {
                throw new ZTBusinessException(rspBO.getRespDesc());
            }
            hisList = rspBO1.getRows();
            log.debug("\u9879\u76ee\u660e\u7ec6\u4f9b\u5e94\u5546\u62a5\u4ef7\u5386\u53f2\u5217\u8868\u67e5\u8be2\u6210\u529f");
            log.debug("\u9879\u76ee\u660e\u7ec6\u4f9b\u5e94\u5546\u62a5\u4ef7\u5386\u53f2\u5217\u8868\u6570\u636e\u4e3a\uff1a");
            this.log(hisList);
        }
        List rows = rspBO.getRows();
        log.debug("\u9879\u76ee\u660e\u7ec6\u4f9b\u5e94\u5546\u62a5\u4ef7\u5217\u8868\u6570\u636e\u4e3a\uff1a");
        this.log(rows);
        if (rows.size() == 0) {
            ArrayList list = new ArrayList();
            DingdangSscQueryPriceComparisonItemListRspBO rspResultBO = new DingdangSscQueryPriceComparisonItemListRspBO();
            rspResultBO.setRows(list);
            return rspResultBO;
        }
        Map<String, List<DingdangSscSupplierPriceComparisonItemBO>> mapOnForceBySort = this.getProjectDetailToSupplierMapOnForceBySort(rows, hisList, reqBO.getSupplierOrderList(), map, mapMode, mapModeShow, mapModeStr);
        Map<String, DingdangSscPriceComparisonItemInfoBO> itemInfoMap = this.getItemInfoMap(rows);
        ArrayList<DingdangSscPriceComparisonItemInfoBO> list = new ArrayList<DingdangSscPriceComparisonItemInfoBO>();
        for (String key : mapOnForceBySort.keySet()) {
            DingdangSscPriceComparisonItemInfoBO itemInfoBO = itemInfoMap.get(key);
            itemInfoBO.setSupplierPriceComparisonItemList(mapOnForceBySort.get(key));
            list.add(itemInfoBO);
        }
        DingdangSscQueryPriceComparisonItemListRspBO rspResultBO = new DingdangSscQueryPriceComparisonItemListRspBO();
        rspResultBO.setRows(list);
        return rspResultBO;
    }

    public void log(List<SscProjectDetailQuotationBO> rows) {
        if (rows == null || rows.size() == 0) {
            log.debug("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return;
        }
        Map<Long, List<SscProjectDetailQuotationBO>> collect = rows.stream().collect(Collectors.groupingBy(SscProjectDetailQuotationBO::getProjectDetailId));
        for (Long projectDetailId : collect.keySet()) {
            List<SscProjectDetailQuotationBO> list = collect.get(projectDetailId);
            String supplierIds = " ";
            for (SscProjectDetailQuotationBO bo : list) {
                supplierIds = supplierIds + bo.getSupplierId() + " ";
            }
            log.debug("\u9879\u76ee\u660e\u7ec6id\uff1a" + projectDetailId + " \u4f9b\u5e94\u5546ids" + supplierIds);
        }
    }

    public void validateParams(DingdangSscQueryPriceComparisonItemListReqBO reqBO) {
        if (reqBO.getProjectId() == null) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u62a5\u4ef7\u660e\u7ec6\u5217\u8868\u67e5\u8be2API\u3010projectId\u3011\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getSupplierOrderList() == null || reqBO.getSupplierOrderList().size() == 0) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u62a5\u4ef7\u660e\u7ec6\u5217\u8868\u67e5\u8be2API\u3010supplierOrderList\u3011\u4e0d\u80fd\u4e3anull");
        }
    }

    public Map<String, DingdangSscPriceComparisonItemInfoBO> getItemInfoMap(List<SscProjectDetailQuotationBO> rows) {
        HashMap<String, DingdangSscPriceComparisonItemInfoBO> map = new HashMap<String, DingdangSscPriceComparisonItemInfoBO>();
        for (SscProjectDetailQuotationBO row : rows) {
            if (map.containsKey(String.valueOf(row.getProjectDetailId()))) continue;
            DingdangSscPriceComparisonItemInfoBO itemInfoBO = new DingdangSscPriceComparisonItemInfoBO();
            itemInfoBO.setProjectDetailId(row.getProjectDetailId());
            itemInfoBO.setMaterialId(row.getMaterialId());
            itemInfoBO.setMaterialName(row.getMaterialName());
            itemInfoBO.setMaterialLongName(row.getMaterialLongName());
            itemInfoBO.setCatalogId(row.getMaterialId());
            itemInfoBO.setCatalogName(row.getCatalogName());
            itemInfoBO.setSpec(row.getSpec());
            itemInfoBO.setModel(row.getModel());
            itemInfoBO.setPurchaseNumber(row.getPurchaseNumber());
            itemInfoBO.setMeasureId(row.getMeasureId());
            itemInfoBO.setMeasureName(row.getMeasureName());
            itemInfoBO.setBugetUnitPrice(row.getBugetUnitPrice());
            itemInfoBO.setHistoryUnitPrice(row.getHistoryUnitPrice());
            itemInfoBO.setDeliveryAdderss(row.getDeliveryAdderss());
            map.put(String.valueOf(row.getProjectDetailId()), itemInfoBO);
        }
        return map;
    }

    public Map<String, List<DingdangSscSupplierPriceComparisonItemBO>> getMaterialToSupplierMap(List<SscProjectDetailQuotationBO> rows, List<SscProjectDetailQuotationBO> hisRows) {
        HashMap<String, List<DingdangSscSupplierPriceComparisonItemBO>> map = new HashMap<String, List<DingdangSscSupplierPriceComparisonItemBO>>();
        for (SscProjectDetailQuotationBO row : rows) {
            DingdangSscSupplierPriceComparisonItemBO itemBO;
            if (map.containsKey(String.valueOf(row.getProjectDetailId()))) {
                itemBO = new DingdangSscSupplierPriceComparisonItemBO();
                itemBO.setSupplierId(row.getSupplierId());
                itemBO.setSupplierName(row.getSupplierName());
                itemBO.setQuotationDetailId(row.getQuotationDetailId());
                itemBO.setQuotationNum(row.getQuotationNum());
                if (row.getTaxUnitPrice() == null) {
                    itemBO.setTaxUnitPrice(null);
                } else {
                    itemBO.setTaxUnitPrice(new BigDecimal(row.getTaxUnitPrice()));
                }
                itemBO.setTaxRate(row.getTaxRate());
                itemBO.setPromisedDeliveryDate(row.getPromisedDeliveryDate());
                itemBO.setQualityPeriod(row.getQualityPeriod());
                itemBO.setSupplierRemark(row.getSupplierRemark());
                itemBO.setDeliveryPeriod(row.getDeliveryPeriod());
                itemBO.setBrandName(row.getBrandName());
                ((List)map.get(String.valueOf(row.getProjectDetailId()))).add(itemBO);
                continue;
            }
            itemBO = new DingdangSscSupplierPriceComparisonItemBO();
            itemBO.setSupplierId(row.getSupplierId());
            itemBO.setSupplierName(row.getSupplierName());
            itemBO.setQuotationDetailId(row.getQuotationDetailId());
            itemBO.setQuotationNum(row.getQuotationNum());
            if (row.getTaxUnitPrice() == null) {
                itemBO.setTaxUnitPrice(null);
            } else {
                itemBO.setTaxUnitPrice(new BigDecimal(row.getTaxUnitPrice()));
            }
            itemBO.setTaxRate(row.getTaxRate());
            itemBO.setPromisedDeliveryDate(row.getPromisedDeliveryDate());
            itemBO.setQualityPeriod(row.getQualityPeriod());
            itemBO.setSupplierRemark(row.getSupplierRemark());
            itemBO.setDeliveryPeriod(row.getDeliveryPeriod());
            itemBO.setBrandName(row.getBrandName());
            ArrayList<DingdangSscSupplierPriceComparisonItemBO> list = new ArrayList<DingdangSscSupplierPriceComparisonItemBO>();
            list.add(itemBO);
            map.put(String.valueOf(row.getProjectDetailId()), list);
        }
        if (hisRows == null || hisRows.size() == 0) {
            log.debug("\u4f9b\u5e94\u5546\u62a5\u4ef7\u5386\u53f2\u5217\u8868\u503c\u4e3a\u7a7a");
        } else {
            for (String projectDetailId : map.keySet()) {
                List list = (List)map.get(projectDetailId);
                for (DingdangSscSupplierPriceComparisonItemBO itemBO : list) {
                    for (SscProjectDetailQuotationBO hisRow : hisRows) {
                        if (!hisRow.getProjectDetailId().equals(Long.valueOf(projectDetailId)) || !hisRow.getSupplierId().equals(itemBO.getSupplierId())) continue;
                        log.debug("\u8fdb\u884c\u8d4b\u503c\uff1a" + projectDetailId + " " + hisRow.getSupplierId());
                        itemBO.setQuotationNumHis(hisRow.getQuotationNum());
                        if (hisRow.getTaxUnitPrice() == null) {
                            itemBO.setTaxUnitPriceHis(null);
                        } else {
                            itemBO.setTaxUnitPriceHis(new BigDecimal(hisRow.getTaxUnitPrice()));
                        }
                        itemBO.setTaxRateHis(hisRow.getTaxRate());
                        itemBO.setPromisedDeliveryDateHis(hisRow.getPromisedDeliveryDate());
                        itemBO.setQualityPeriodHis(hisRow.getQualityPeriod());
                        itemBO.setSupplierRemarkHis(hisRow.getSupplierRemark());
                        itemBO.setDeliveryPeriodHis(hisRow.getDeliveryPeriod());
                        itemBO.setBrandNameHis(hisRow.getBrandName());
                    }
                }
            }
        }
        return map;
    }

    public Map<String, List<DingdangSscSupplierPriceComparisonItemBO>> sort(Map<String, List<DingdangSscSupplierPriceComparisonItemBO>> map, Map<Long, String> supplierIdWithName, List<String> supplierOrderList) {
        HashMap<String, List<DingdangSscSupplierPriceComparisonItemBO>> mapResult = new HashMap<String, List<DingdangSscSupplierPriceComparisonItemBO>>();
        for (String key : map.keySet()) {
            ArrayList<DingdangSscSupplierPriceComparisonItemBO> list = new ArrayList<DingdangSscSupplierPriceComparisonItemBO>();
            for (String id : supplierOrderList) {
                boolean flag = false;
                for (DingdangSscSupplierPriceComparisonItemBO itemBO : map.get(key)) {
                    if (itemBO.getSupplierId() == null) {
                        itemBO.setSupplierId(Long.valueOf(-1L));
                    }
                    if (!id.equals(String.valueOf(itemBO.getSupplierId()))) continue;
                    flag = true;
                    list.add(itemBO);
                    break;
                }
                if (flag) continue;
                DingdangSscSupplierPriceComparisonItemBO itemBO = new DingdangSscSupplierPriceComparisonItemBO();
                itemBO.setSupplierId(Long.valueOf(Long.parseLong(id)));
                itemBO.setSupplierName(supplierIdWithName.get(Long.parseLong(id)));
                list.add(itemBO);
            }
            mapResult.put(key, list);
        }
        return mapResult;
    }

    public Map<Long, String> getSupplierIdWithName(List<SscProjectDetailQuotationBO> rows) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (SscProjectDetailQuotationBO row : rows) {
            if (map.containsKey(row.getSupplierId())) continue;
            map.put(row.getSupplierId(), row.getSupplierName());
        }
        return map;
    }

    public Map<String, List<DingdangSscSupplierPriceComparisonItemBO>> getProjectDetailToSupplierMapOnForceBySort(List<SscProjectDetailQuotationBO> rows, List<SscProjectDetailQuotationBO> hisRows, List<String> supplierOrderList, Map<String, Integer> daysMap, Map<String, String> modes, Map<String, String> modeShows, Map<String, String> modeStrs) {
        HashMap<String, List<DingdangSscSupplierPriceComparisonItemBO>> map = new HashMap<String, List<DingdangSscSupplierPriceComparisonItemBO>>();
        HashMap supplierMap = new HashMap();
        HashSet<Long> set = new HashSet<Long>();
        for (SscProjectDetailQuotationBO row : rows) {
            if (set.contains(row.getProjectDetailId())) continue;
            set.add(row.getProjectDetailId());
        }
        log.debug("\u6839\u636e\u9879\u76ee\u660e\u7ec6\u4f9b\u5e94\u5546\u62a5\u4ef7\u5217\u8868\u67e5\u8be2API\u67e5\u8be2\u7684projectDetailId\uff1a" + set);
        for (Long projectDetailId : set) {
            ArrayList<DingdangSscSupplierPriceComparisonItemBO> list = new ArrayList<DingdangSscSupplierPriceComparisonItemBO>();
            for (String supplierId : supplierOrderList) {
                boolean flag = false;
                for (SscProjectDetailQuotationBO row : rows) {
                    if (row.getSupplierId() == null || !row.getProjectDetailId().equals(projectDetailId) || !row.getSupplierId().equals(Long.valueOf(supplierId))) continue;
                    DingdangSscSupplierPriceComparisonItemBO bo = new DingdangSscSupplierPriceComparisonItemBO();
                    bo.setSupplierId(row.getSupplierId());
                    bo.setSupplierName(row.getSupplierName());
                    bo.setQuotationDetailId(row.getQuotationDetailId());
                    bo.setQuotationNum(row.getQuotationNum());
                    if (row.getTaxUnitPrice() == null) {
                        bo.setTaxUnitPrice(null);
                    } else {
                        bo.setTaxUnitPrice(new BigDecimal(row.getTaxUnitPrice()));
                    }
                    bo.setTaxRate(row.getTaxRate());
                    bo.setPromisedDeliveryDate(row.getPromisedDeliveryDate());
                    bo.setQualityPeriod(row.getQualityPeriod());
                    bo.setSupplierRemark(row.getSupplierRemark());
                    bo.setDeliveryPeriod(row.getDeliveryPeriod());
                    bo.setBrandName(row.getBrandName());
                    if (daysMap != null && daysMap.size() != 0) {
                        bo.setExpecSettleDay(daysMap.get(supplierId));
                    }
                    if (modes != null && modes.size() != 0) {
                        bo.setTradeMode(modes.get(supplierId));
                    }
                    if (modeShows != null && modeShows.size() != 0) {
                        bo.setTradeModeShow(modeShows.get(supplierId));
                    }
                    if (modeStrs != null && modeStrs.size() != 0) {
                        bo.setTradeModeStr(modeStrs.get(supplierId));
                    }
                    list.add(bo);
                    flag = true;
                }
                if (flag) continue;
                DingdangSscSupplierPriceComparisonItemBO itemBO = new DingdangSscSupplierPriceComparisonItemBO();
                itemBO.setSupplierId(Long.valueOf(supplierId));
                if (daysMap != null && daysMap.size() != 0) {
                    itemBO.setExpecSettleDay(daysMap.get(supplierId));
                }
                if (modes != null && modes.size() != 0) {
                    itemBO.setTradeMode(modes.get(supplierId));
                }
                if (modeShows != null && modeShows.size() != 0) {
                    itemBO.setTradeModeShow(modeShows.get(supplierId));
                }
                if (modeStrs != null && modeStrs.size() != 0) {
                    itemBO.setTradeModeStr(modeStrs.get(supplierId));
                }
                list.add(itemBO);
            }
            ArrayList<String> logList = new ArrayList<String>();
            for (DingdangSscSupplierPriceComparisonItemBO itemBO : list) {
                logList.add("supplierId: " + itemBO.getSupplierId());
            }
            map.put(String.valueOf(projectDetailId), list);
        }
        if (hisRows != null && hisRows.size() > 0) {
            for (Long projectDetailId : set) {
                for (DingdangSscSupplierPriceComparisonItemBO itemBO : (List)map.get(String.valueOf(projectDetailId))) {
                    for (SscProjectDetailQuotationBO hisRow : hisRows) {
                        if (hisRow.getSupplierId() == null || !hisRow.getProjectDetailId().equals(projectDetailId) || !hisRow.getSupplierId().equals(itemBO.getSupplierId())) continue;
                        itemBO.setQuotationNumHis(hisRow.getQuotationNum());
                        if (hisRow.getTaxUnitPrice() == null) {
                            itemBO.setTaxUnitPriceHis(null);
                        } else {
                            itemBO.setTaxUnitPriceHis(new BigDecimal(hisRow.getTaxUnitPrice()));
                        }
                        itemBO.setTaxRateHis(hisRow.getTaxRate());
                        itemBO.setPromisedDeliveryDateHis(hisRow.getPromisedDeliveryDate());
                        itemBO.setQualityPeriodHis(hisRow.getQualityPeriod());
                        itemBO.setSupplierRemarkHis(hisRow.getSupplierRemark());
                        itemBO.setDeliveryPeriodHis(hisRow.getDeliveryPeriod());
                        itemBO.setBrandNameHis(hisRow.getBrandName());
                        if (itemBO.getSupplierName() == null) continue;
                        itemBO.setSupplierName(hisRow.getSupplierName());
                    }
                }
            }
        }
        return map;
    }

    public Long moneyTransfer(Long money) {
        Long moneyFinal = 0L;
        try {
            BigDecimal moneyDecimal = MoneyUtils.Long2BigDecimal((Long)money);
            moneyFinal = moneyDecimal.longValue();
            return moneyFinal;
        }
        catch (Exception e) {
            log.error("\u94b1\u8f6c\u5316\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            return moneyFinal;
        }
    }
}

