/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.ssc.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.pesapp.ssc.ability.DingdangSscQueryTenderResultNoticeDetailsService;
import com.tydic.pesapp.ssc.ability.bo.DingdangSscQueryTenderResultNoticeDetailsReqBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangSscQueryTenderResultNoticeDetailsRspBO;
import com.tydic.ssc.ability.SscQryNoticeDetailAbilityService;
import com.tydic.ssc.ability.SscQryProjectDetailAbilityService;
import com.tydic.ssc.ability.SscQryProjectTempResultSupplierListAbilityService;
import com.tydic.ssc.ability.bo.SscQryNoticeDetailAbilityReqBO;
import com.tydic.ssc.ability.bo.SscQryNoticeDetailAbilityRspBO;
import com.tydic.ssc.ability.bo.SscQryProjectDetailAbilityReqBO;
import com.tydic.ssc.ability.bo.SscQryProjectDetailAbilityRspBO;
import com.tydic.ssc.ability.bo.SscQryProjectTempResultSupplierListAbilityReqBO;
import com.tydic.ssc.ability.bo.SscQryProjectTempResultSupplierListAbilityRspBO;
import com.tydic.ssc.common.SscProjectTempResultSupplierBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class DingdangSscQueryTenderResultNoticeDetailsServiceImpl
implements DingdangSscQueryTenderResultNoticeDetailsService {
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="SSC_GROUP_TEST")
    private SscQryNoticeDetailAbilityService sscQryNoticeDetailAbilityService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="SSC_GROUP_TEST")
    private SscQryProjectDetailAbilityService sscQryProjectDetailAbilityService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="SSC_GROUP_TEST")
    private SscQryProjectTempResultSupplierListAbilityService sscQryProjectTempResultSupplierListAbilityService;

    public DingdangSscQueryTenderResultNoticeDetailsRspBO queryTenderResultNoticeDetails(DingdangSscQueryTenderResultNoticeDetailsReqBO reqBO) {
        this.validateParams(reqBO);
        SscQryNoticeDetailAbilityReqBO reqBO1 = new SscQryNoticeDetailAbilityReqBO();
        SscQryProjectDetailAbilityReqBO reqBO2 = new SscQryProjectDetailAbilityReqBO();
        SscQryProjectTempResultSupplierListAbilityReqBO reqBO3 = new SscQryProjectTempResultSupplierListAbilityReqBO();
        reqBO1.setNoticeId(reqBO.getNoticeId());
        reqBO1.setProjectId(reqBO.getProjectId());
        reqBO2.setProjectId(reqBO.getProjectId());
        reqBO3.setProjectId(reqBO.getProjectId());
        SscQryNoticeDetailAbilityRspBO sscQryNoticeDetailAbilityRspBO = this.sscQryNoticeDetailAbilityService.qryNoticeDetail(reqBO1);
        SscQryProjectDetailAbilityRspBO sscQryProjectDetailAbilityRspBO = this.sscQryProjectDetailAbilityService.qrySscProjectDetail(reqBO2);
        SscQryProjectTempResultSupplierListAbilityRspBO sscQryProjectTempResultSupplierListAbilityRspBO = this.sscQryProjectTempResultSupplierListAbilityService.qryProjectTempResultSupplierList(reqBO3);
        this.validateNotice(sscQryNoticeDetailAbilityRspBO);
        this.validateProject(sscQryProjectDetailAbilityRspBO);
        this.validateProjectTempResult(sscQryProjectTempResultSupplierListAbilityRspBO);
        DingdangSscQueryTenderResultNoticeDetailsRspBO result = this.getResult(sscQryNoticeDetailAbilityRspBO, sscQryProjectDetailAbilityRspBO, sscQryProjectTempResultSupplierListAbilityRspBO);
        return result;
    }

    public void validateParams(DingdangSscQueryTenderResultNoticeDetailsReqBO reqBO) {
        if (reqBO.getProjectId() == null) {
            throw new ZTBusinessException("\u62db\u6807\u7ed3\u679c\u516c\u544a\u8be6\u60c5\u67e5\u8be2API\u3010projectId\u3011\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getNoticeId() == null) {
            throw new ZTBusinessException("\u62db\u6807\u7ed3\u679c\u516c\u544a\u8be6\u60c5\u67e5\u8be2API\u3010noticeId\u3011\u4e0d\u80fd\u4e3anull");
        }
    }

    private void validateProject(SscQryProjectDetailAbilityRspBO rspBO) {
        if ("0001".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException("\u62db\u6807\u9879\u76ee\u8be6\u60c5\u67e5\u8be2API\u8c03\u7528\u5931\u8d25");
        }
    }

    private void validateNotice(SscQryNoticeDetailAbilityRspBO rspBO) {
        if ("0001".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException("\u516c\u544a\u8be6\u60c5\u67e5\u8be2API\u8c03\u7528\u5931\u8d25");
        }
    }

    private void validateProjectTempResult(SscQryProjectTempResultSupplierListAbilityRspBO rspBO) {
        if ("0001".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException("\u62df\u5b9a\u4e2d\u6807\u4f9b\u5e94\u5546\u5217\u8868\u67e5\u8be2API");
        }
    }

    private DingdangSscQueryTenderResultNoticeDetailsRspBO getResult(SscQryNoticeDetailAbilityRspBO sscQryNoticeDetailAbilityRspBO, SscQryProjectDetailAbilityRspBO sscQryProjectDetailAbilityRspBO, SscQryProjectTempResultSupplierListAbilityRspBO sscQryProjectTempResultSupplierListAbilityRspBO) {
        DingdangSscQueryTenderResultNoticeDetailsRspBO rspBO = new DingdangSscQueryTenderResultNoticeDetailsRspBO();
        if (sscQryProjectDetailAbilityRspBO.getSscProjectBO() != null) {
            rspBO.setProjectName(sscQryProjectDetailAbilityRspBO.getSscProjectBO().getProjectName());
            rspBO.setProjectNo(sscQryProjectDetailAbilityRspBO.getSscProjectBO().getProjectNo());
            rspBO.setTenderModeStr(sscQryProjectDetailAbilityRspBO.getSscProjectBO().getTenderModeStr());
            rspBO.setPurchaseUnitName(sscQryProjectDetailAbilityRspBO.getSscProjectBO().getPurchaseUnitName());
            rspBO.setBidOpenTime(sscQryProjectDetailAbilityRspBO.getSscProjectBO().getBidOpenTime());
        } else {
            rspBO.setProjectName(null);
            rspBO.setProjectNo(null);
            rspBO.setTenderModeStr(null);
            rspBO.setPurchaseUnitName(null);
            rspBO.setBidOpenTime(null);
        }
        if (sscQryNoticeDetailAbilityRspBO.getSscProjectNoticeBO() != null) {
            rspBO.setPublicTime(sscQryNoticeDetailAbilityRspBO.getSscProjectNoticeBO().getPublicTime());
            rspBO.setNoticeTemplateCode(sscQryNoticeDetailAbilityRspBO.getSscProjectNoticeBO().getNoticeTemplateCode());
        } else {
            rspBO.setPublicTime(null);
            rspBO.setNoticeTemplateCode(null);
        }
        List rows = sscQryProjectTempResultSupplierListAbilityRspBO.getRows();
        if (rows == null || rows.size() == 0) {
            ArrayList winSuppliers = new ArrayList();
            BigDecimal winPrice = new BigDecimal(0);
            rspBO.setWinPrice(winPrice);
            rspBO.setWinSuppliers(winSuppliers);
        } else {
            List<String> winSuppliers = this.getWinSuppliers(rows);
            BigDecimal winPrice = this.getWinPrice(rows);
            rspBO.setWinSuppliers(winSuppliers);
            rspBO.setWinPrice(winPrice);
        }
        return rspBO;
    }

    public List<String> getWinSuppliers(List<SscProjectTempResultSupplierBO> rows) {
        ArrayList<String> list = new ArrayList<String>();
        for (SscProjectTempResultSupplierBO row : rows) {
            if (row.getSupplierName() != null) {
                list.add(row.getSupplierName());
                continue;
            }
            list.add(" ");
        }
        return list;
    }

    public BigDecimal getWinPrice(List<SscProjectTempResultSupplierBO> rows) {
        Long result = 0L;
        for (SscProjectTempResultSupplierBO row : rows) {
            if (row.getBidTaxAmount() == null) continue;
            result = result + row.getBidTaxAmount();
        }
        return new BigDecimal(result);
    }
}

