/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.ssc.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.pesapp.ssc.ability.DingdangSscWinningResultExcelService;
import com.tydic.pesapp.ssc.ability.bo.DingdangSscSupplierInfoBO;
import com.tydic.pesapp.ssc.ability.bo.DingdangSscSupplierPriceComparisonItemBO;
import com.tydic.pesapp.ssc.ability.bo.ExcelPubOutputRspBO;
import com.tydic.pesapp.ssc.ability.bo.WinningResultExcelReqBO;
import com.tydic.pesapp.ssc.ability.utils.ExcelFormatUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DingdangSscWinningResultExcelServiceImpl
implements DingdangSscWinningResultExcelService {
    private static final Logger log = LoggerFactory.getLogger(DingdangSscWinningResultExcelServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    private static final String path = "pesapp-common";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;

    private void encapInputReq(WinningResultExcelReqBO winningResultExcelReqBO) {
        int seqCnt = 1;
        if (!CollectionUtils.isEmpty((Collection)winningResultExcelReqBO.getPriceComparisonItemInfoBOList())) {
            for (Object priceComparisonItemInfoBO : winningResultExcelReqBO.getPriceComparisonItemInfoBOList()) {
                BigDecimal tempNum = new BigDecimal(0);
                priceComparisonItemInfoBO.setSeqNo(seqCnt + "");
                for (DingdangSscSupplierPriceComparisonItemBO supplierItemBO : priceComparisonItemInfoBO.getSupplierPriceComparisonItemList()) {
                    log.info("DingdangSscWinningResultExcelService::encapInputReq\u5165\u53c2\u4fe1\u606f::tempNum=" + tempNum);
                    tempNum = tempNum.add(supplierItemBO.getBidNum());
                    BigDecimal supNum = supplierItemBO.getBidNum().setScale(2, 1);
                    supplierItemBO.setBidNum(supNum);
                    supplierItemBO.setQuotationNum(supplierItemBO.getQuotationNum().setScale(2, 1));
                    supplierItemBO.setTaxUnitPrice(supplierItemBO.getTaxUnitPrice().setScale(2, 1));
                    supplierItemBO.setDeliveryPeriodStr(supplierItemBO.getDeliveryPeriod() + "\u5929");
                    supplierItemBO.setQualityPeriodStr(supplierItemBO.getQualityPeriod() + "\u5929");
                    supplierItemBO.setTaxRateStr(supplierItemBO.getTaxRate() + "%");
                }
                BigDecimal tempPurchaseNum = !StringUtils.isEmpty((Object)priceComparisonItemInfoBO.getPurchaseNumber()) ? new BigDecimal(priceComparisonItemInfoBO.getPurchaseNumber()) : new BigDecimal(0);
                log.info("DingdangSscWinningResultExcelService::encapInputReq\u5165\u53c2\u4fe1\u606f::tempPurchaseNum=" + tempPurchaseNum);
                log.info("DingdangSscWinningResultExcelService::encapInputReq\u5165\u53c2\u4fe1\u606f::tempNum=" + tempNum);
                priceComparisonItemInfoBO.setRemainDisNum(tempPurchaseNum.subtract(tempNum).setScale(2, 1).toString());
                String specModelTemp = priceComparisonItemInfoBO.getSpec() + "_" + priceComparisonItemInfoBO.getModel();
                priceComparisonItemInfoBO.setSpecAndModel(specModelTemp);
                priceComparisonItemInfoBO.setPurchaseNumber(tempPurchaseNum.setScale(2, 1).toString());
                ++seqCnt;
            }
        }
        if (winningResultExcelReqBO.getButtomTotalInfoBO() != null && !CollectionUtils.isEmpty((Collection)winningResultExcelReqBO.getSupplierHeaderBOList())) {
            BigDecimal drawupTotalAmount = new BigDecimal(0);
            for (DingdangSscSupplierInfoBO supplierInfoBO : winningResultExcelReqBO.getSupplierHeaderBOList()) {
                String modeDetail = supplierInfoBO.getPayModeShow() + "/" + supplierInfoBO.getTradeModeShow();
                log.info("DingdangSscWinningResultExcelService::modeDetail=" + modeDetail);
                drawupTotalAmount = drawupTotalAmount.add(supplierInfoBO.getTotalQuotationPrice());
                supplierInfoBO.setPayAndTradeModeDetail(modeDetail);
            }
            BigDecimal budgetAmount = winningResultExcelReqBO.getButtomTotalInfoBO().getProjectBudgetAmount().setScale(2, 1);
            winningResultExcelReqBO.getButtomTotalInfoBO().setProjectBudgetAmount(budgetAmount);
            winningResultExcelReqBO.getButtomTotalInfoBO().setDrawupTotalAmount(drawupTotalAmount.setScale(2, 1));
            String modeStr = winningResultExcelReqBO.getButtomTotalInfoBO().getPayModeShow() + "/" + winningResultExcelReqBO.getButtomTotalInfoBO().getTradeModeShow();
            winningResultExcelReqBO.getButtomTotalInfoBO().setPayAndTradeModeStr(modeStr);
        }
    }

    public ExcelPubOutputRspBO createWinningResultComplexExcel(WinningResultExcelReqBO winningResultExcelReqBO) {
        log.info("createWinningResultComplexExcel\u5165\u53c2\u4fe1\u606f::JSON.toJSONString(winningResultExcelReqBO)=" + JSON.toJSONString((Object)winningResultExcelReqBO));
        log.info("createWinningResultComplexExcel\u5165\u53c2\u4fe1\u606f::winningResultExcelReqBO.toString()=" + winningResultExcelReqBO.toString());
        ExcelPubOutputRspBO excelPubOutputRspBO = new ExcelPubOutputRspBO();
        this.encapInputReq(winningResultExcelReqBO);
        log.info("\u5c01\u88c5\u540e\u7684\u5165\u53c2\u4fe1\u606f-encapInputReq::winningResultExcelReqBO.toString()=" + winningResultExcelReqBO.toString());
        try {
            String fileUrl;
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFCellStyle alignStyle = (XSSFCellStyle)ExcelFormatUtil.contentStyle((Workbook)wb);
            XSSFCellStyle headerStyle = (XSSFCellStyle)ExcelFormatUtil.headStyle((Workbook)wb);
            XSSFCellStyle titleStyle = (XSSFCellStyle)ExcelFormatUtil.titleStyle((Workbook)wb, HSSFColor.HSSFColorPredefined.WHITE.getIndex(), (short)10);
            Sheet sheet = wb.createSheet("\u62df\u4e2d\u6807\u7ed3\u679c\u786e\u8ba4(\u6309\u7269\u6599)");
            int rowCount = 0;
            int cellCount = 0;
            String[] headerFronds = new String[]{"\u5e8f\u53f7", "\u7269\u6599\u540d\u79f0", "\u89c4\u683c\u578b\u53f7", "\u6570\u91cf", "\u5907\u6ce8", "\u5269\u4f59\u5206\u914d\u6570", "\u4f9b\u5e94\u5546", "\u62df\u5b9a\u6570\u91cf", "\u53ef\u4f9b\u6570\u91cf", "\u542b\u7a0e\u5355\u4ef7", "\u7a0e\u7387", "\u4ea4\u8d27\u671f", "\u8d28\u4fdd\u671f", "\u54c1\u724c/\u4ea7\u5730", "\u5236\u9020\u5546", "\u5907\u6ce8"};
            for (int i = 0; i < headerFronds.length; ++i) {
                log.info("headerFronds[i]=" + headerFronds[i]);
                boolean createRowFlag = true;
                if (i == 0) {
                    createRowFlag = false;
                }
                ExcelFormatUtil.createRowAndCell(sheet, 0, i, (CellStyle)headerStyle, createRowFlag, false, headerFronds[i]);
                sheet.setColumnWidth(i, headerFronds[i].getBytes().length * 2 * 256);
                log.info("headerFronds[i]::cellCount=" + ++cellCount);
            }
            log.info("cellCount=" + cellCount);
            String[] materialKeys = new String[]{"seqNo", "materialName", "specAndModel", "purchaseNumber", "reqComments", "remainDisNum"};
            String[] suppilerDetailKeys = new String[]{"supplierName", "bidNum", "quotationNum", "taxUnitPrice", "taxRateStr", "deliveryPeriodStr", "qualityPeriodStr", "brandName", "manufacturerName", "supplierRemark"};
            ++rowCount;
            if (!CollectionUtils.isEmpty((Collection)winningResultExcelReqBO.getPriceComparisonItemInfoBOList())) {
                int tempSupItemCnt = 1;
                int materialColNum = materialKeys.length;
                for (Object priceComparisonItemInfoBO : winningResultExcelReqBO.getPriceComparisonItemInfoBOList()) {
                    int supItemCnt = priceComparisonItemInfoBO.getSupplierPriceComparisonItemList().size();
                    log.info("rowCount=" + rowCount);
                    log.info("supItemCnt=" + supItemCnt);
                    Method[] comparisonMethods = priceComparisonItemInfoBO.getClass().getDeclaredMethods();
                    block4: for (int i = 0; i < materialKeys.length; ++i) {
                        boolean createRowFlag = true;
                        if (i == 0) {
                            createRowFlag = false;
                        }
                        log.info("materialKeys[i]=" + materialKeys[i]);
                        for (int j = 0; j < comparisonMethods.length; ++j) {
                            if (!comparisonMethods[j].getName().contains("get") || !("get" + materialKeys[i].substring(0, 1).toUpperCase() + materialKeys[i].substring(1)).equals(comparisonMethods[j].getName())) continue;
                            log.info("comparisonMethods[j].getName()=" + comparisonMethods[j].getName());
                            log.info("i=" + i);
                            log.info("comparisonMethods[j].invoke(priceComparisonItemInfoBO)=" + comparisonMethods[j].invoke(priceComparisonItemInfoBO, new Object[0]));
                            ExcelFormatUtil.createRowAndCell(sheet, rowCount, i, (CellStyle)alignStyle, createRowFlag, false, comparisonMethods[j].invoke(priceComparisonItemInfoBO, new Object[0]));
                            if (supItemCnt <= 1) continue block4;
                            CellRangeAddress regionZt = new CellRangeAddress(rowCount, rowCount + supItemCnt - 1, i, i);
                            sheet.addMergedRegion(regionZt);
                            ExcelFormatUtil.setRegionBorder(BorderStyle.THIN, regionZt, sheet);
                            continue block4;
                        }
                    }
                    log.info("materialColNum=" + materialColNum);
                    log.info("tempSupItemCnt=" + tempSupItemCnt);
                    for (DingdangSscSupplierPriceComparisonItemBO comparisonItemBO : priceComparisonItemInfoBO.getSupplierPriceComparisonItemList()) {
                        Method[] comparisonItemMethods = comparisonItemBO.getClass().getDeclaredMethods();
                        block7: for (int i = 0; i < suppilerDetailKeys.length; ++i) {
                            log.info("suppilerDetailKeys[i]=" + suppilerDetailKeys[i]);
                            for (int j = 0; j < comparisonItemMethods.length; ++j) {
                                if (!comparisonItemMethods[j].getName().contains("get") || !("get" + suppilerDetailKeys[i].substring(0, 1).toUpperCase() + suppilerDetailKeys[i].substring(1)).equals(comparisonItemMethods[j].getName())) continue;
                                log.info("comparisonItemMethods[j].getName()=" + comparisonItemMethods[j].getName());
                                ExcelFormatUtil.createRowAndCell(sheet, tempSupItemCnt, materialColNum + i, (CellStyle)alignStyle, true, false, comparisonItemMethods[j].invoke((Object)comparisonItemBO, new Object[0]));
                                if (!"supplierRemark".equals(suppilerDetailKeys[i])) continue block7;
                                sheet.setColumnWidth(materialColNum + i, (comparisonItemMethods[j].invoke((Object)comparisonItemBO, new Object[0]) + "").getBytes().length * 2 * 256);
                                continue block7;
                            }
                        }
                        ++tempSupItemCnt;
                    }
                    rowCount += supItemCnt;
                }
            }
            if (winningResultExcelReqBO.getButtomTotalInfoBO() != null && !CollectionUtils.isEmpty((Collection)winningResultExcelReqBO.getSupplierHeaderBOList())) {
                ExcelFormatUtil.createRowAndCell(sheet, ++rowCount, 0, (CellStyle)titleStyle, false, false, "\u9884\u7b97\u603b\u91d1\u989d");
                ExcelFormatUtil.createRowAndCell(sheet, rowCount, 1, (CellStyle)alignStyle, true, false, winningResultExcelReqBO.getButtomTotalInfoBO().getProjectBudgetAmount());
                ExcelFormatUtil.createRowAndCell(sheet, rowCount, 2, (CellStyle)titleStyle, true, false, "\u62df\u5b9a\u91d1\u989d\u603b\u8ba1");
                ExcelFormatUtil.createRowAndCell(sheet, rowCount, 3, (CellStyle)alignStyle, true, false, winningResultExcelReqBO.getButtomTotalInfoBO().getDrawupTotalAmount());
                ExcelFormatUtil.createRowAndCell(sheet, rowCount, 4, (CellStyle)titleStyle, true, false, "\u652f\u4ed8/\u4ea4\u6613\u65b9\u5f0f");
                sheet.setColumnWidth(4, "\u652f\u4ed8/\u4ea4\u6613\u65b9\u5f0f".getBytes().length * 2 * 256);
                ExcelFormatUtil.createRowAndCell(sheet, rowCount, 5, (CellStyle)alignStyle, true, false, winningResultExcelReqBO.getButtomTotalInfoBO().getPayAndTradeModeStr());
                int supDetailNum = winningResultExcelReqBO.getSupplierHeaderBOList().size();
                ExcelFormatUtil.createRowAndCell(sheet, ++rowCount, 0, (CellStyle)titleStyle, false, false, "\u4f9b\u5e94\u5546\u5b9a\u6807\u660e\u7ec6");
                CellRangeAddress regionZt = new CellRangeAddress(rowCount, rowCount + supDetailNum - 1, 0, 1);
                sheet.addMergedRegion(regionZt);
                ExcelFormatUtil.setRegionBorder(BorderStyle.THIN, regionZt, sheet);
                int tempCount = 0;
                for (DingdangSscSupplierInfoBO supplierInfoBO : winningResultExcelReqBO.getSupplierHeaderBOList()) {
                    boolean hasRowFlag = true;
                    ExcelFormatUtil.createRowAndCell(sheet, rowCount + tempCount, 2, (CellStyle)alignStyle, hasRowFlag, false, supplierInfoBO.getSupplierName());
                    sheet.setColumnWidth(2, supplierInfoBO.getSupplierName().getBytes().length * 2 * 256);
                    ExcelFormatUtil.createRowAndCell(sheet, rowCount + tempCount, 3, (CellStyle)alignStyle, hasRowFlag, false, supplierInfoBO.getTotalQuotationPrice());
                    ExcelFormatUtil.createRowAndCell(sheet, rowCount + tempCount, 4, (CellStyle)alignStyle, hasRowFlag, false, supplierInfoBO.getPayAndTradeModeDetail());
                    CellRangeAddress regionSup = new CellRangeAddress(rowCount + tempCount, rowCount + tempCount, 4, 5);
                    sheet.addMergedRegion(regionSup);
                    ExcelFormatUtil.setRegionBorder(BorderStyle.THIN, regionSup, sheet);
                    ++tempCount;
                }
            }
            String nowDate = DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMddHHmmss");
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            wb.write((OutputStream)os);
            byte[] data = os.toByteArray();
            os.close();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            String fileName = "WinningResultExcel_" + nowDate + ".xlsx";
            log.info("createWinningResultComplexExcel::fileName=" + fileName);
            String path = this.fileClient.uploadFileByInputStream(path, fileName, (InputStream)inputStream);
            log.info("createWinningResultComplexExcel::path=" + path);
            if ("OSS".equals(this.fileType)) {
                fileUrl = this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                fileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            if (!fileUrl.contains("http:")) {
                fileUrl = "http://" + fileUrl;
            }
            log.info("createWinningResultComplexExcel::\u751f\u6210\u590d\u6742excel\u6587\u4ef6\u5730\u5740::fileUrl=" + fileUrl);
            excelPubOutputRspBO.setExcelUrl(fileUrl);
            log.info("\u5199\u5165\u6210\u529f\uff0c\u8fd0\u884c\u7ed3\u675f\uff01");
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u62df\u4e2d\u6807\u7ed3\u679cexcel\u8868\u683c\u5f02\u5e38\uff1ae=" + e);
            excelPubOutputRspBO.setRespCode("8888");
            excelPubOutputRspBO.setRespDesc("\u751f\u6210\u590d\u5236\u62df\u4e2d\u6807\u7ed3\u679cexcel\u8868\u683c\u5f02\u5e38");
            return excelPubOutputRspBO;
        }
        excelPubOutputRspBO.setRespCode("0000");
        excelPubOutputRspBO.setRespDesc("\u6210\u529f");
        log.info("createWinningResultComplexExcel\u51fa\u53c2\u4fe1\u606f::excelPubOutputRspBO.toString()=" + excelPubOutputRspBO.toString());
        return excelPubOutputRspBO;
    }
}

