/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.ssc.ability.utils;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pesapp.ssc.ability.bo.DingdangSscSupplierInfoBO;
import com.tydic.pesapp.ssc.ability.bo.ExcelMaterialDataBO;
import com.tydic.pesapp.ssc.ability.bo.ExcelPubInputReqBO;
import com.tydic.pesapp.ssc.ability.bo.ExcelPubOutputRspBO;
import com.tydic.pesapp.ssc.ability.bo.ExcelSupplierBiddingDetailBO;
import com.tydic.pesapp.ssc.ability.bo.ExcelSupplierBiddingInfoBO;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelFormatUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelFormatUtil.class);

    public static CellStyle headStyle(Workbook workbook) {
        CellStyle style1 = workbook.createCellStyle();
        style1.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style1.setFillForegroundColor(HSSFColor.HSSFColorPredefined.YELLOW.getIndex());
        style1.setBorderBottom(BorderStyle.THIN);
        style1.setBorderLeft(BorderStyle.THIN);
        style1.setBorderRight(BorderStyle.THIN);
        style1.setBorderTop(BorderStyle.THIN);
        Font font1 = workbook.createFont();
        font1.setBold(true);
        font1.setFontHeightInPoints((short)12);
        style1.setFont(font1);
        style1.setWrapText(true);
        style1.setAlignment(HorizontalAlignment.CENTER);
        style1.setVerticalAlignment(VerticalAlignment.CENTER);
        return style1;
    }

    public static CellStyle contentStyle(Workbook wb) {
        CellStyle style1 = wb.createCellStyle();
        style1.setBorderBottom(BorderStyle.THIN);
        style1.setBorderLeft(BorderStyle.THIN);
        style1.setBorderRight(BorderStyle.THIN);
        style1.setBorderTop(BorderStyle.THIN);
        style1.setWrapText(true);
        style1.setAlignment(HorizontalAlignment.CENTER);
        style1.setVerticalAlignment(VerticalAlignment.CENTER);
        return style1;
    }

    public static CellStyle titleStyle(Workbook workbook, short color, short fontSize) {
        CellStyle style1 = workbook.createCellStyle();
        if (color != HSSFColor.HSSFColorPredefined.WHITE.getIndex()) {
            style1.setFillForegroundColor(color);
        }
        style1.setBorderBottom(BorderStyle.THIN);
        style1.setBorderLeft(BorderStyle.THIN);
        style1.setBorderRight(BorderStyle.THIN);
        style1.setBorderTop(BorderStyle.THIN);
        Font font1 = workbook.createFont();
        font1.setFontHeightInPoints(fontSize);
        font1.setBold(true);
        style1.setFont(font1);
        style1.setWrapText(true);
        style1.setAlignment(HorizontalAlignment.CENTER);
        style1.setVerticalAlignment(VerticalAlignment.CENTER);
        return style1;
    }

    public static void initTitleEX(SXSSFSheet sheet, CellStyle header, String[] title, int[] titleLength) {
        SXSSFRow row0 = sheet.createRow(0);
        row0.setHeight((short)800);
        for (int j = 0; j < title.length; ++j) {
            SXSSFCell cell = row0.createCell(j);
            cell.setCellValue(title[j]);
            cell.setCellStyle(header);
            sheet.setColumnWidth(j, titleLength[j]);
        }
    }

    public static void main(String[] args) {
        ArrayList<ExcelMaterialDataBO> emdBOList = new ArrayList<ExcelMaterialDataBO>();
        ExcelMaterialDataBO emdBO = new ExcelMaterialDataBO();
        emdBO.setMaterialId("mc_001");
        emdBO.setMaterialName("\u7269\u65991");
        emdBO.setSpecModel("mod1");
        emdBO.setMeasureName("\u4e2a");
        emdBO.setPurchaseNumber(new BigDecimal(10).setScale(2, 1));
        emdBO.setUseUnit("\u5355\u4f4d1");
        emdBO.setReqComments("\u5907\u6ce81");
        emdBO.setHistoryUnitPrice(new BigDecimal(121.0).setScale(2, 1));
        emdBOList.add(emdBO);
        emdBO = new ExcelMaterialDataBO();
        emdBO.setMaterialId("mc_002");
        emdBO.setMaterialName("\u7269\u65992");
        emdBO.setSpecModel("mod2");
        emdBO.setMeasureName("\u5f20");
        emdBO.setPurchaseNumber(new BigDecimal(1000).setScale(2, 1));
        emdBO.setUseUnit("\u5355\u4f4d2");
        emdBO.setReqComments("\u5907\u6ce82");
        emdBO.setHistoryUnitPrice(new BigDecimal(0.2).setScale(2, 1));
        emdBOList.add(emdBO);
        emdBO = new ExcelMaterialDataBO();
        emdBO.setMaterialId("mc_003");
        emdBO.setMaterialName("\u7269\u65993");
        emdBO.setSpecModel("mod3");
        emdBO.setMeasureName("\u628a");
        emdBO.setPurchaseNumber(new BigDecimal(50).setScale(2, 1));
        emdBO.setUseUnit("\u5355\u4f4d3");
        emdBO.setReqComments("\u5907\u6ce83");
        emdBO.setHistoryUnitPrice(new BigDecimal(1.2).setScale(2, 1));
        emdBOList.add(emdBO);
        ArrayList<DingdangSscSupplierInfoBO> supplierHeaderBOList = new ArrayList<DingdangSscSupplierInfoBO>();
        DingdangSscSupplierInfoBO supplierHeaderBO = new DingdangSscSupplierInfoBO();
        supplierHeaderBO.setSupplierId(Long.valueOf(Long.parseLong("202103091001")));
        supplierHeaderBO.setSupplierName("\u4f9b\u5e94\u5546A");
        supplierHeaderBOList.add(supplierHeaderBO);
        supplierHeaderBO = new DingdangSscSupplierInfoBO();
        supplierHeaderBO.setSupplierId(Long.valueOf(Long.parseLong("202103091002")));
        supplierHeaderBO.setSupplierName("\u4f9b\u5e94\u5546B");
        supplierHeaderBOList.add(supplierHeaderBO);
        supplierHeaderBO = new DingdangSscSupplierInfoBO();
        supplierHeaderBO.setSupplierId(Long.valueOf(Long.parseLong("202103091003")));
        supplierHeaderBO.setSupplierName("\u4f9b\u5e94\u5546C");
        supplierHeaderBOList.add(supplierHeaderBO);
        supplierHeaderBO = new DingdangSscSupplierInfoBO();
        supplierHeaderBO.setSupplierId(Long.valueOf(Long.parseLong("202103091004")));
        supplierHeaderBO.setSupplierName("\u4f9b\u5e94\u5546D");
        supplierHeaderBOList.add(supplierHeaderBO);
        ArrayList<ExcelSupplierBiddingInfoBO> supplierBiddingInfoBOList = new ArrayList<ExcelSupplierBiddingInfoBO>();
        ArrayList<ExcelSupplierBiddingDetailBO> supplierBiddingDetailBOS = new ArrayList<ExcelSupplierBiddingDetailBO>();
        ExcelSupplierBiddingDetailBO detailBO = new ExcelSupplierBiddingDetailBO();
        detailBO.setMaterialId("mc_001");
        detailBO.setMaterialName("\u7269\u65991");
        detailBO.setBrandId("brand001");
        detailBO.setBrandName("\u54c1\u724c001");
        detailBO.setDeliveryPeriod(Integer.valueOf(14));
        detailBO.setQualityPeriod(Integer.valueOf(12));
        detailBO.setQuotationRound(Integer.valueOf(1));
        detailBO.setSupplierRemark("\u4f9b\u65b9\u5907\u6ce8001");
        detailBO.setTaxUnitPrice(new BigDecimal(10000).setScale(2, 1));
        detailBO.setTaxRate(new BigDecimal(0.15).setScale(2, 1));
        supplierBiddingDetailBOS.add(detailBO);
        detailBO = new ExcelSupplierBiddingDetailBO();
        detailBO.setMaterialId("mc_002");
        detailBO.setMaterialName("\u7269\u65992");
        detailBO.setBrandId("brand002");
        detailBO.setBrandName("\u54c1\u724c002");
        detailBO.setDeliveryPeriod(Integer.valueOf(14));
        detailBO.setQualityPeriod(Integer.valueOf(12));
        detailBO.setQuotationRound(Integer.valueOf(1));
        detailBO.setSupplierRemark("\u4f9b\u65b9\u5907\u6ce8002");
        detailBO.setTaxUnitPrice(new BigDecimal(10000).setScale(2, 1));
        detailBO.setTaxRate(new BigDecimal(0.15).setScale(2, 1));
        supplierBiddingDetailBOS.add(detailBO);
        detailBO = new ExcelSupplierBiddingDetailBO();
        detailBO.setMaterialId("mc_003");
        detailBO.setMaterialName("\u7269\u65993");
        detailBO.setBrandId("brand002");
        detailBO.setBrandName("\u54c1\u724c002");
        detailBO.setDeliveryPeriod(Integer.valueOf(14));
        detailBO.setQualityPeriod(Integer.valueOf(12));
        detailBO.setQuotationRound(Integer.valueOf(1));
        detailBO.setSupplierRemark("\u4f9b\u65b9\u5907\u6ce8003");
        detailBO.setTaxUnitPrice(new BigDecimal(10000).setScale(2, 1));
        detailBO.setTaxRate(new BigDecimal(0.2).setScale(2, 1));
        supplierBiddingDetailBOS.add(detailBO);
        detailBO = new ExcelSupplierBiddingDetailBO();
        detailBO.setMaterialId("mc_004");
        detailBO.setMaterialName("\u7269\u65994");
        detailBO.setBrandId("brand001");
        detailBO.setBrandName("\u54c1\u724c001");
        detailBO.setDeliveryPeriod(Integer.valueOf(14));
        detailBO.setQualityPeriod(Integer.valueOf(12));
        detailBO.setQuotationRound(Integer.valueOf(1));
        detailBO.setSupplierRemark("\u4f9b\u65b9\u5907\u6ce8004");
        detailBO.setTaxUnitPrice(new BigDecimal(10000).setScale(2, 1));
        detailBO.setTaxRate(new BigDecimal(0.2).setScale(2, 1));
        supplierBiddingDetailBOS.add(detailBO);
        detailBO = new ExcelSupplierBiddingDetailBO();
        detailBO.setMaterialId("mc_001");
        detailBO.setMaterialName("\u7269\u65991");
        detailBO.setBrandId("brand001");
        detailBO.setBrandName("\u54c1\u724c001");
        detailBO.setDeliveryPeriod(Integer.valueOf(14));
        detailBO.setQualityPeriod(Integer.valueOf(12));
        detailBO.setQuotationRound(Integer.valueOf(2));
        detailBO.setSupplierRemark("\u4f9b\u65b9\u5907\u6ce8001");
        detailBO.setTaxUnitPrice(new BigDecimal(9850).setScale(2, 1));
        detailBO.setTaxRate(new BigDecimal(0.15).setScale(2, 1));
        supplierBiddingDetailBOS.add(detailBO);
        detailBO = new ExcelSupplierBiddingDetailBO();
        detailBO.setMaterialId("mc_002");
        detailBO.setMaterialName("\u7269\u65992");
        detailBO.setBrandId("brand002");
        detailBO.setBrandName("\u54c1\u724c002");
        detailBO.setDeliveryPeriod(Integer.valueOf(14));
        detailBO.setQualityPeriod(Integer.valueOf(12));
        detailBO.setQuotationRound(Integer.valueOf(2));
        detailBO.setSupplierRemark("\u4f9b\u65b9\u5907\u6ce8002");
        detailBO.setTaxUnitPrice(new BigDecimal(9800).setScale(2, 1));
        detailBO.setTaxRate(new BigDecimal(0.15).setScale(2, 1));
        supplierBiddingDetailBOS.add(detailBO);
        ExcelSupplierBiddingInfoBO supplierBiddingInfoBO = new ExcelSupplierBiddingInfoBO();
        supplierBiddingInfoBO.setSupplierId(Long.valueOf(Long.parseLong("202103091001")));
        supplierBiddingInfoBO.setSupplierName("\u4f9b\u5e94\u5546A");
        supplierBiddingInfoBO.setCurrencyTypeName("\u4eba\u6c11\u5e01");
        supplierBiddingInfoBO.setIsAffordShippingName("\u662f");
        supplierBiddingInfoBO.setPayTypeName("\u73b0\u91d1");
        supplierBiddingInfoBO.setSettleMethodName("\u94f6\u884c\u672c\u7968");
        supplierBiddingInfoBO.setTotalFee(new BigDecimal(40000).setScale(2, 1));
        supplierBiddingInfoBO.setTotalFeeRankings(Integer.valueOf(4));
        supplierBiddingInfoBO.setQuotationRound(Integer.valueOf(1));
        supplierBiddingInfoBO.setDetailBOList(supplierBiddingDetailBOS);
        supplierBiddingInfoBOList.add(supplierBiddingInfoBO);
        supplierBiddingInfoBO = new ExcelSupplierBiddingInfoBO();
        supplierBiddingInfoBO.setSupplierId(Long.valueOf(Long.parseLong("202103091002")));
        supplierBiddingInfoBO.setSupplierName("\u4f9b\u5e94\u5546B");
        supplierBiddingInfoBO.setCurrencyTypeName("\u4eba\u6c11\u5e01");
        supplierBiddingInfoBO.setIsAffordShippingName("\u662f");
        supplierBiddingInfoBO.setPayTypeName("\u94f6\u884c\u5361\u652f\u4ed8");
        supplierBiddingInfoBO.setSettleMethodName("\u6c47\u5151");
        supplierBiddingInfoBO.setTotalFee(new BigDecimal(37800).setScale(2, 1));
        supplierBiddingInfoBO.setTotalFeeRankings(Integer.valueOf(2));
        supplierBiddingInfoBO.setQuotationRound(Integer.valueOf(1));
        supplierBiddingInfoBO.setDetailBOList(supplierBiddingDetailBOS);
        supplierBiddingInfoBOList.add(supplierBiddingInfoBO);
        supplierBiddingInfoBO = new ExcelSupplierBiddingInfoBO();
        supplierBiddingInfoBO.setSupplierId(Long.valueOf(Long.parseLong("202103091003")));
        supplierBiddingInfoBO.setSupplierName("\u4f9b\u5e94\u5546C");
        supplierBiddingInfoBO.setCurrencyTypeName("\u4eba\u6c11\u5e01");
        supplierBiddingInfoBO.setIsAffordShippingName("\u662f");
        supplierBiddingInfoBO.setPayTypeName("\u73b0\u91d1");
        supplierBiddingInfoBO.setSettleMethodName("\u94f6\u884c\u672c\u7968");
        supplierBiddingInfoBO.setTotalFee(new BigDecimal(38000).setScale(2, 1));
        supplierBiddingInfoBO.setTotalFeeRankings(Integer.valueOf(3));
        supplierBiddingInfoBO.setQuotationRound(Integer.valueOf(1));
        supplierBiddingInfoBO.setDetailBOList(supplierBiddingDetailBOS);
        supplierBiddingInfoBOList.add(supplierBiddingInfoBO);
        supplierBiddingInfoBO = new ExcelSupplierBiddingInfoBO();
        supplierBiddingInfoBO.setSupplierId(Long.valueOf(Long.parseLong("202103091004")));
        supplierBiddingInfoBO.setSupplierName("\u4f9b\u5e94\u5546D");
        supplierBiddingInfoBO.setCurrencyTypeName("\u4eba\u6c11\u5e01");
        supplierBiddingInfoBO.setIsAffordShippingName("\u662f");
        supplierBiddingInfoBO.setPayTypeName("\u652f\u7968");
        supplierBiddingInfoBO.setSettleMethodName("\u652f\u7968");
        supplierBiddingInfoBO.setTotalFee(new BigDecimal(37500).setScale(2, 1));
        supplierBiddingInfoBO.setTotalFeeRankings(Integer.valueOf(1));
        supplierBiddingInfoBO.setQuotationRound(Integer.valueOf(1));
        supplierBiddingInfoBO.setDetailBOList(supplierBiddingDetailBOS);
        supplierBiddingInfoBOList.add(supplierBiddingInfoBO);
        supplierBiddingInfoBO = new ExcelSupplierBiddingInfoBO();
        supplierBiddingInfoBO.setSupplierId(Long.valueOf(Long.parseLong("202103091001")));
        supplierBiddingInfoBO.setSupplierName("\u4f9b\u5e94\u5546A");
        supplierBiddingInfoBO.setCurrencyTypeName("\u4eba\u6c11\u5e01");
        supplierBiddingInfoBO.setIsAffordShippingName("\u662f");
        supplierBiddingInfoBO.setPayTypeName("\u73b0\u91d1");
        supplierBiddingInfoBO.setSettleMethodName("\u94f6\u884c\u672c\u7968");
        supplierBiddingInfoBO.setTotalFee(new BigDecimal(39000).setScale(2, 1));
        supplierBiddingInfoBO.setTotalFeeRankings(Integer.valueOf(4));
        supplierBiddingInfoBO.setQuotationRound(Integer.valueOf(2));
        supplierBiddingInfoBO.setDetailBOList(supplierBiddingDetailBOS);
        supplierBiddingInfoBOList.add(supplierBiddingInfoBO);
        supplierBiddingInfoBO = new ExcelSupplierBiddingInfoBO();
        supplierBiddingInfoBO.setSupplierId(Long.valueOf(Long.parseLong("202103091002")));
        supplierBiddingInfoBO.setSupplierName("\u4f9b\u5e94\u5546B");
        supplierBiddingInfoBO.setCurrencyTypeName("\u4eba\u6c11\u5e01");
        supplierBiddingInfoBO.setIsAffordShippingName("\u662f");
        supplierBiddingInfoBO.setPayTypeName("\u94f6\u884c\u5361\u652f\u4ed8");
        supplierBiddingInfoBO.setSettleMethodName("\u6c47\u5151");
        supplierBiddingInfoBO.setTotalFee(new BigDecimal(37000).setScale(2, 1));
        supplierBiddingInfoBO.setTotalFeeRankings(Integer.valueOf(2));
        supplierBiddingInfoBO.setQuotationRound(Integer.valueOf(2));
        supplierBiddingInfoBO.setDetailBOList(supplierBiddingDetailBOS);
        supplierBiddingInfoBOList.add(supplierBiddingInfoBO);
        supplierBiddingInfoBO = new ExcelSupplierBiddingInfoBO();
        supplierBiddingInfoBO.setSupplierId(Long.valueOf(Long.parseLong("202103091003")));
        supplierBiddingInfoBO.setSupplierName("\u4f9b\u5e94\u5546C");
        supplierBiddingInfoBO.setCurrencyTypeName("\u4eba\u6c11\u5e01");
        supplierBiddingInfoBO.setIsAffordShippingName("\u662f");
        supplierBiddingInfoBO.setPayTypeName("\u73b0\u91d1");
        supplierBiddingInfoBO.setSettleMethodName("\u94f6\u884c\u672c\u7968");
        supplierBiddingInfoBO.setTotalFee(new BigDecimal(37600).setScale(2, 1));
        supplierBiddingInfoBO.setTotalFeeRankings(Integer.valueOf(3));
        supplierBiddingInfoBO.setQuotationRound(Integer.valueOf(2));
        supplierBiddingInfoBO.setDetailBOList(supplierBiddingDetailBOS);
        supplierBiddingInfoBOList.add(supplierBiddingInfoBO);
        supplierBiddingInfoBO = new ExcelSupplierBiddingInfoBO();
        supplierBiddingInfoBO.setSupplierId(Long.valueOf(Long.parseLong("202103091004")));
        supplierBiddingInfoBO.setSupplierName("\u4f9b\u5e94\u5546D");
        supplierBiddingInfoBO.setCurrencyTypeName("\u4eba\u6c11\u5e01");
        supplierBiddingInfoBO.setIsAffordShippingName("\u662f");
        supplierBiddingInfoBO.setPayTypeName("\u652f\u7968");
        supplierBiddingInfoBO.setSettleMethodName("\u652f\u7968");
        supplierBiddingInfoBO.setTotalFee(new BigDecimal(37000).setScale(2, 1));
        supplierBiddingInfoBO.setTotalFeeRankings(Integer.valueOf(1));
        supplierBiddingInfoBO.setQuotationRound(Integer.valueOf(2));
        supplierBiddingInfoBO.setDetailBOList(supplierBiddingDetailBOS);
        supplierBiddingInfoBOList.add(supplierBiddingInfoBO);
        supplierBiddingInfoBO = new ExcelSupplierBiddingInfoBO();
        supplierBiddingInfoBO.setSupplierId(Long.valueOf(Long.parseLong("202103091003")));
        supplierBiddingInfoBO.setSupplierName("\u4f9b\u5e94\u5546C");
        supplierBiddingInfoBO.setCurrencyTypeName("\u4eba\u6c11\u5e01");
        supplierBiddingInfoBO.setIsAffordShippingName("\u662f");
        supplierBiddingInfoBO.setPayTypeName("\u73b0\u91d1");
        supplierBiddingInfoBO.setSettleMethodName("\u94f6\u884c\u672c\u7968");
        supplierBiddingInfoBO.setTotalFee(new BigDecimal(36000).setScale(2, 1));
        supplierBiddingInfoBO.setTotalFeeRankings(Integer.valueOf(3));
        supplierBiddingInfoBO.setQuotationRound(Integer.valueOf(3));
        supplierBiddingInfoBO.setDetailBOList(supplierBiddingDetailBOS);
        supplierBiddingInfoBOList.add(supplierBiddingInfoBO);
        supplierBiddingInfoBO = new ExcelSupplierBiddingInfoBO();
        supplierBiddingInfoBO.setSupplierId(Long.valueOf(Long.parseLong("202103091004")));
        supplierBiddingInfoBO.setSupplierName("\u4f9b\u5e94\u5546D");
        supplierBiddingInfoBO.setCurrencyTypeName("\u4eba\u6c11\u5e01");
        supplierBiddingInfoBO.setIsAffordShippingName("\u662f");
        supplierBiddingInfoBO.setPayTypeName("\u652f\u7968");
        supplierBiddingInfoBO.setSettleMethodName("\u652f\u7968");
        supplierBiddingInfoBO.setTotalFee(new BigDecimal(36500).setScale(2, 1));
        supplierBiddingInfoBO.setTotalFeeRankings(Integer.valueOf(1));
        supplierBiddingInfoBO.setQuotationRound(Integer.valueOf(3));
        supplierBiddingInfoBO.setDetailBOList(supplierBiddingDetailBOS);
        supplierBiddingInfoBOList.add(supplierBiddingInfoBO);
        HashMap<String, ExcelSupplierBiddingInfoBO> biddingInfoFirstBOMap = new HashMap<String, ExcelSupplierBiddingInfoBO>();
        HashMap<String, ExcelSupplierBiddingDetailBO> detailFirstBOMap = new HashMap<String, ExcelSupplierBiddingDetailBO>();
        HashMap<String, ExcelSupplierBiddingInfoBO> biddingInfoLastBOMap = new HashMap<String, ExcelSupplierBiddingInfoBO>();
        HashMap<String, ExcelSupplierBiddingDetailBO> detailLastBOMap = new HashMap<String, ExcelSupplierBiddingDetailBO>();
        for (ExcelSupplierBiddingInfoBO supplierInfoBO : supplierBiddingInfoBOList) {
            String mapKey;
            if (supplierInfoBO.getQuotationRound() == 1) {
                biddingInfoFirstBOMap.put(supplierInfoBO.getSupplierId() + "", supplierInfoBO);
                for (ExcelSupplierBiddingDetailBO detailBO1 : supplierInfoBO.getDetailBOList()) {
                    mapKey = supplierInfoBO.getSupplierId() + "_" + detailBO1.getMaterialId();
                    detailFirstBOMap.put(mapKey, detailBO1);
                }
            }
            if (biddingInfoLastBOMap.containsKey(supplierInfoBO.getSupplierId() + "")) {
                if (supplierInfoBO.getQuotationRound() <= ((ExcelSupplierBiddingInfoBO)biddingInfoLastBOMap.get(supplierInfoBO.getSupplierId() + "")).getQuotationRound()) continue;
                biddingInfoLastBOMap.put(supplierInfoBO.getSupplierId() + "", supplierInfoBO);
                for (ExcelSupplierBiddingDetailBO detailBO1 : supplierInfoBO.getDetailBOList()) {
                    mapKey = supplierInfoBO.getSupplierId() + "_" + detailBO1.getMaterialId();
                    if (detailLastBOMap.containsKey(mapKey)) {
                        detailLastBOMap.remove(mapKey);
                    }
                    detailLastBOMap.put(mapKey, detailBO1);
                }
                continue;
            }
            biddingInfoLastBOMap.put(supplierInfoBO.getSupplierId() + "", supplierInfoBO);
            for (ExcelSupplierBiddingDetailBO detailBO1 : supplierInfoBO.getDetailBOList()) {
                mapKey = supplierInfoBO.getSupplierId() + "_" + detailBO1.getMaterialId();
                detailLastBOMap.put(mapKey, detailBO1);
            }
        }
        ExcelPubInputReqBO excelPubInputReqBO = new ExcelPubInputReqBO();
        excelPubInputReqBO.setEmdBOList(emdBOList);
        excelPubInputReqBO.setSupplierHeaderBOList(supplierHeaderBOList);
        excelPubInputReqBO.setBiddingInfoFirstBOMap(biddingInfoFirstBOMap);
        excelPubInputReqBO.setDetailFirstBOMap(detailFirstBOMap);
        excelPubInputReqBO.setBiddingInfoLastBOMap(biddingInfoLastBOMap);
        excelPubInputReqBO.setDetailLastBOMap(detailLastBOMap);
        log.info("excelPubInputReqBO=" + JSONObject.toJSONString((Object)excelPubInputReqBO));
        ExcelFormatUtil.createExcel(excelPubInputReqBO);
    }

    public static ExcelPubOutputRspBO createExcel(ExcelPubInputReqBO excelPubInputReqBO) {
        ExcelPubOutputRspBO excelPubOutputRspBO = new ExcelPubOutputRspBO();
        try {
            Row emdRow;
            int i;
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFCellStyle alignStyle = (XSSFCellStyle)ExcelFormatUtil.contentStyle((Workbook)wb);
            XSSFCellStyle headerStyle = (XSSFCellStyle)ExcelFormatUtil.headStyle((Workbook)wb);
            XSSFCellStyle titleStyle = (XSSFCellStyle)ExcelFormatUtil.titleStyle((Workbook)wb, HSSFColor.HSSFColorPredefined.WHITE.getIndex(), (short)10);
            Sheet sheet = wb.createSheet("\u6bd4\u4ef7\u660e\u7ec6");
            int rowCount = 0;
            int cellCount = 0;
            int materialRowCnt = 1;
            String[] headerFronds = new String[]{"\u7269\u6599\u7f16\u7801", "\u7269\u6599\u540d\u79f0", "\u89c4\u683c\u578b\u53f7", "\u8ba1\u91cf\u5355\u4f4d", "\u6570\u91cf", "\u4f7f\u7528\u5355\u4f4d", "\u9700\u65b9\u5907\u6ce8", "\u5386\u53f2\u4ef7\u683c", "\u62a5\u4ef7\u4fe1\u606f"};
            Row ztRow = sheet.createRow(0);
            log.info("rowCount=" + (rowCount += materialRowCnt));
            for (int i2 = 0; i2 < headerFronds.length; ++i2) {
                Cell ztCell = ztRow.createCell(i2);
                ztCell.setCellValue(headerFronds[i2]);
                CellRangeAddress regionZt = new CellRangeAddress(0, 1, i2, i2);
                sheet.addMergedRegion(regionZt);
                ztCell.setCellStyle((CellStyle)headerStyle);
                sheet.setColumnWidth(i2, headerFronds[i2].getBytes().length * 2 * 256);
                ExcelFormatUtil.setRegionBorder(BorderStyle.THIN, regionZt, sheet);
                ++cellCount;
            }
            log.info("cellCount=" + cellCount);
            int priceRowCnt = 5;
            log.info("excelPubInputReqBO.getEmdBOList()=" + excelPubInputReqBO.getEmdBOList());
            int tempCnt = 0;
            String[] headerMiddles = new String[]{"\u62a5\u4ef7", "\u4ea4\u8d27\u5468\u671f(\u5929)", "\u54c1\u724c", "\u8d28\u4fdd\u671f", "\u4f9b\u65b9\u5907\u6ce8", "\u7a0e\u7387"};
            int tempRowCnt = materialRowCnt;
            for (ExcelMaterialDataBO materialDataBO : excelPubInputReqBO.getEmdBOList()) {
                log.info("emdBOList.size()::tempRowCnt=" + tempRowCnt);
                for (int i3 = 0; i3 < headerMiddles.length; ++i3) {
                    Row everyRow = sheet.createRow(tempRowCnt + 1);
                    Cell ztCell = everyRow.createCell(headerFronds.length - 1);
                    log.info("headerMiddles::tempRowCnt+1=" + (tempRowCnt + 1));
                    log.info("headerMiddles::headerFronds.length-1=" + (headerFronds.length - 1));
                    log.info("headerMiddles::headerMiddles[i]=" + headerMiddles[i3]);
                    ztCell.setCellValue(headerMiddles[i3]);
                    ztCell.setCellStyle((CellStyle)titleStyle);
                    ++tempRowCnt;
                }
                log.info("1111::materialDataBO.toString()=" + materialDataBO.toString());
                log.info("1111::tempCnt=" + tempCnt);
                log.info("1111::rowCount=" + rowCount);
                tempCnt = rowCount + 1;
                log.info("2222::tempCnt=" + tempCnt);
                Row emdRow2 = sheet.getRow(tempCnt);
                materialDataBO.setRowNum(Integer.valueOf(tempCnt));
                Field[] materialFields = materialDataBO.getClass().getDeclaredFields();
                Method[] materialMethods = materialDataBO.getClass().getDeclaredMethods();
                block5: for (int i4 = 0; i4 < materialFields.length; ++i4) {
                    log.info("materialFields[i].getName()=" + materialFields[i4].getName());
                    for (int j = 0; j < materialMethods.length; ++j) {
                        if (!materialMethods[j].getName().contains("get") || "rowNum".equals(materialFields[i4].getName()) || !("get" + materialFields[i4].getName().substring(0, 1).toUpperCase() + materialFields[i4].getName().substring(1)).equals(materialMethods[j].getName())) continue;
                        log.info("materialMethods[j].getName()=" + materialMethods[j].getName());
                        Cell ztCell = emdRow2.createCell(i4);
                        ztCell.setCellValue(materialMethods[j].invoke((Object)materialDataBO, new Object[0]) + "");
                        CellRangeAddress regionZt = new CellRangeAddress(tempCnt, tempCnt + priceRowCnt, i4, i4);
                        sheet.addMergedRegion(regionZt);
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        sheet.setColumnWidth(i4, (materialMethods[j].invoke((Object)materialDataBO, new Object[0]) + "").getBytes().length * 2 * 256);
                        ExcelFormatUtil.setRegionBorder(BorderStyle.THIN, regionZt, sheet);
                        continue block5;
                    }
                }
                rowCount = tempCnt + priceRowCnt;
            }
            HashMap<String, Integer> buttomNumList = new HashMap<String, Integer>();
            String[] headerButtoms = new String[]{"\u603b\u91d1\u989d", "\u603b\u91d1\u989d\u6392\u540d", "\u7ed3\u7b97\u65b9\u5f0f", "\u4ed8\u6b3e\u65b9\u5f0f", "\u8fd0\u6742\u8d39\u7528\u627f\u62c5", "\u5e01\u79cd"};
            String[] headerKeyButtoms = new String[]{"totalFee", "totalFeeRankings", "settleMethodName", "payTypeName", "isAffordShippingName", "currencyTypeName"};
            for (i = 0; i < headerButtoms.length; ++i) {
                tempCnt = rowCount + 1;
                emdRow = sheet.createRow(tempCnt);
                buttomNumList.put(headerKeyButtoms[i], tempCnt);
                Cell ztCell = emdRow.createCell(0);
                ztCell.setCellValue(headerButtoms[i]);
                CellRangeAddress regionZt = new CellRangeAddress(tempCnt, tempCnt, 0, headerFronds.length - 1);
                sheet.addMergedRegion(regionZt);
                ztCell.setCellStyle((CellStyle)titleStyle);
                ExcelFormatUtil.setRegionBorder(BorderStyle.THIN, regionZt, sheet);
                ++rowCount;
            }
            for (i = 0; i < excelPubInputReqBO.getSupplierHeaderBOList().size(); ++i) {
                emdRow = sheet.getRow(0);
                Cell ztCell = emdRow.createCell(cellCount);
                ztCell.setCellValue(((DingdangSscSupplierInfoBO)excelPubInputReqBO.getSupplierHeaderBOList().get(i)).getSupplierName());
                CellRangeAddress regionZt = new CellRangeAddress(0, 0, cellCount, cellCount + 1);
                sheet.addMergedRegion(regionZt);
                ztCell.setCellStyle((CellStyle)headerStyle);
                sheet.setColumnWidth(i, ((DingdangSscSupplierInfoBO)excelPubInputReqBO.getSupplierHeaderBOList().get(i)).getSupplierName().getBytes().length * 2 * 256);
                ExcelFormatUtil.setRegionBorder(BorderStyle.THIN, regionZt, sheet);
                emdRow = sheet.getRow(1);
                Cell singleCell = emdRow.createCell(cellCount);
                singleCell.setCellValue("\u4e00\u6b21\u62a5\u4ef7");
                singleCell.setCellStyle((CellStyle)titleStyle);
                singleCell = emdRow.createCell(cellCount + 1);
                singleCell.setCellValue("\u6700\u7ec8\u62a5\u4ef7");
                singleCell.setCellStyle((CellStyle)titleStyle);
                ((DingdangSscSupplierInfoBO)excelPubInputReqBO.getSupplierHeaderBOList().get(i)).setCellNum(Integer.valueOf(cellCount));
                cellCount += 2;
            }
            for (DingdangSscSupplierInfoBO supplierHeaderBO : excelPubInputReqBO.getSupplierHeaderBOList()) {
                Field[] firstFields = ((ExcelSupplierBiddingInfoBO)excelPubInputReqBO.getBiddingInfoFirstBOMap().get(supplierHeaderBO.getSupplierId() + "")).getClass().getDeclaredFields();
                Method[] firstMethods = ((ExcelSupplierBiddingInfoBO)excelPubInputReqBO.getBiddingInfoFirstBOMap().get(supplierHeaderBO.getSupplierId() + "")).getClass().getDeclaredMethods();
                for (int i5 = 0; i5 < firstFields.length; ++i5) {
                    log.info("firstFields[i].getName()=" + firstFields[i5].getName());
                    if (!buttomNumList.containsKey(firstFields[i5].getName())) continue;
                    log.info("buttomNumList.get(firstFields[i].getName())=" + buttomNumList.get(firstFields[i5].getName()));
                    for (int j = 0; j < firstMethods.length; ++j) {
                        log.info("firstMethods[j].getName()=" + firstMethods[j].getName());
                        if (!firstMethods[j].getName().equals("get" + firstFields[i5].getName().substring(0, 1).toUpperCase() + firstFields[i5].getName().substring(1))) continue;
                        log.info("supplierHeaderBO.getCellNum()=" + supplierHeaderBO.getCellNum());
                        log.info("(buttomNumList.get(firstFields[i].getName()))=" + buttomNumList.get(firstFields[i5].getName()));
                        Row emdRow3 = sheet.getRow(((Integer)buttomNumList.get(firstFields[i5].getName())).intValue());
                        Cell ztCell = emdRow3.createCell(supplierHeaderBO.getCellNum().intValue());
                        ztCell.setCellValue(firstMethods[j].invoke(excelPubInputReqBO.getBiddingInfoFirstBOMap().get(supplierHeaderBO.getSupplierId() + ""), new Object[0]) + "");
                        ztCell.setCellStyle((CellStyle)alignStyle);
                    }
                }
                Field[] lastFields = ((ExcelSupplierBiddingInfoBO)excelPubInputReqBO.getBiddingInfoLastBOMap().get(supplierHeaderBO.getSupplierId() + "")).getClass().getDeclaredFields();
                Method[] lastMethods = ((ExcelSupplierBiddingInfoBO)excelPubInputReqBO.getBiddingInfoLastBOMap().get(supplierHeaderBO.getSupplierId() + "")).getClass().getDeclaredMethods();
                for (int i6 = 0; i6 < lastFields.length; ++i6) {
                    if (!buttomNumList.containsKey(lastFields[i6].getName())) continue;
                    for (int j = 0; j < lastMethods.length; ++j) {
                        if (!lastMethods[j].getName().equals("get" + lastFields[i6].getName().substring(0, 1).toUpperCase() + lastFields[i6].getName().substring(1))) continue;
                        Row emdRow4 = sheet.getRow(((Integer)buttomNumList.get(lastFields[i6].getName())).intValue());
                        Cell ztCell = emdRow4.createCell(supplierHeaderBO.getCellNum() + 1);
                        ztCell.setCellValue(lastMethods[j].invoke(excelPubInputReqBO.getBiddingInfoLastBOMap().get(supplierHeaderBO.getSupplierId() + ""), new Object[0]) + "");
                        ztCell.setCellStyle((CellStyle)alignStyle);
                    }
                }
                for (ExcelMaterialDataBO materialDataBO : excelPubInputReqBO.getEmdBOList()) {
                    Cell ztCell;
                    Row emdRow5;
                    log.info("materialDataBO.getRowNum()=" + materialDataBO.getRowNum());
                    log.info("supplierHeaderBO.getCellNum()=" + supplierHeaderBO.getCellNum());
                    log.info("supplierHeaderBO.getSupplierId()=" + supplierHeaderBO.getSupplierId());
                    log.info("materialDataBO.getMaterialId()=" + materialDataBO.getMaterialId());
                    int tempRowNum = materialDataBO.getRowNum();
                    int tempCellNum = supplierHeaderBO.getCellNum();
                    if (excelPubInputReqBO.getDetailFirstBOMap().containsKey(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())) {
                        emdRow5 = sheet.getRow(tempRowNum);
                        ztCell = emdRow5.createCell(tempCellNum);
                        ztCell.setCellValue(((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailFirstBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getTaxUnitPrice() + "");
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        emdRow5 = sheet.getRow(tempRowNum + 1);
                        ztCell = emdRow5.createCell(tempCellNum);
                        ztCell.setCellValue(((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailFirstBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getDeliveryPeriod() + "");
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        emdRow5 = sheet.getRow(tempRowNum + 2);
                        ztCell = emdRow5.createCell(tempCellNum);
                        ztCell.setCellValue(((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailFirstBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getBrandName() + "");
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        emdRow5 = sheet.getRow(tempRowNum + 3);
                        ztCell = emdRow5.createCell(tempCellNum);
                        ztCell.setCellValue(((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailFirstBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getQualityPeriod() + "");
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        emdRow5 = sheet.getRow(tempRowNum + 4);
                        ztCell = emdRow5.createCell(tempCellNum);
                        ztCell.setCellValue(((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailFirstBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getSupplierRemark() + "");
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        emdRow5 = sheet.getRow(tempRowNum + 5);
                        ztCell = emdRow5.createCell(tempCellNum);
                        ztCell.setCellValue(((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailFirstBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getTaxRate() + "");
                        ztCell.setCellStyle((CellStyle)alignStyle);
                    } else {
                        emdRow5 = sheet.getRow(tempRowNum);
                        ztCell = emdRow5.createCell(tempCellNum);
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        emdRow5 = sheet.getRow(tempRowNum + 1);
                        ztCell = emdRow5.createCell(tempCellNum);
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        emdRow5 = sheet.getRow(tempRowNum + 2);
                        ztCell = emdRow5.createCell(tempCellNum);
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        emdRow5 = sheet.getRow(tempRowNum + 3);
                        ztCell = emdRow5.createCell(tempCellNum);
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        emdRow5 = sheet.getRow(tempRowNum + 4);
                        ztCell = emdRow5.createCell(tempCellNum);
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        emdRow5 = sheet.getRow(tempRowNum + 5);
                        ztCell = emdRow5.createCell(tempCellNum);
                        ztCell.setCellStyle((CellStyle)alignStyle);
                    }
                    if (excelPubInputReqBO.getDetailLastBOMap().containsKey(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())) {
                        emdRow5 = sheet.getRow(tempRowNum);
                        ztCell = emdRow5.createCell(tempCellNum + 1);
                        ztCell.setCellValue(((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailLastBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getTaxUnitPrice() + "");
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        emdRow5 = sheet.getRow(tempRowNum + 1);
                        ztCell = emdRow5.createCell(tempCellNum + 1);
                        ztCell.setCellValue(((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailLastBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getDeliveryPeriod() + "");
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        emdRow5 = sheet.getRow(tempRowNum + 2);
                        ztCell = emdRow5.createCell(tempCellNum + 1);
                        ztCell.setCellValue(((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailLastBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getBrandName() + "");
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        emdRow5 = sheet.getRow(tempRowNum + 3);
                        ztCell = emdRow5.createCell(tempCellNum + 1);
                        ztCell.setCellValue(((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailLastBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getQualityPeriod() + "");
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        emdRow5 = sheet.getRow(tempRowNum + 4);
                        ztCell = emdRow5.createCell(tempCellNum + 1);
                        ztCell.setCellValue(((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailLastBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getSupplierRemark() + "");
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        emdRow5 = sheet.getRow(tempRowNum + 5);
                        ztCell = emdRow5.createCell(tempCellNum + 1);
                        ztCell.setCellValue(((ExcelSupplierBiddingDetailBO)excelPubInputReqBO.getDetailLastBOMap().get(supplierHeaderBO.getSupplierId() + "_" + materialDataBO.getMaterialId())).getTaxRate() + "");
                        ztCell.setCellStyle((CellStyle)alignStyle);
                        continue;
                    }
                    emdRow5 = sheet.getRow(tempRowNum);
                    ztCell = emdRow5.createCell(tempCellNum + 1);
                    ztCell.setCellStyle((CellStyle)alignStyle);
                    emdRow5 = sheet.getRow(tempRowNum + 1);
                    ztCell = emdRow5.createCell(tempCellNum + 1);
                    ztCell.setCellStyle((CellStyle)alignStyle);
                    emdRow5 = sheet.getRow(tempRowNum + 2);
                    ztCell = emdRow5.createCell(tempCellNum + 1);
                    ztCell.setCellStyle((CellStyle)alignStyle);
                    emdRow5 = sheet.getRow(tempRowNum + 3);
                    ztCell = emdRow5.createCell(tempCellNum + 1);
                    ztCell.setCellStyle((CellStyle)alignStyle);
                    emdRow5 = sheet.getRow(tempRowNum + 4);
                    ztCell = emdRow5.createCell(tempCellNum + 1);
                    ztCell.setCellStyle((CellStyle)alignStyle);
                    emdRow5 = sheet.getRow(tempRowNum + 5);
                    ztCell = emdRow5.createCell(tempCellNum + 1);
                    ztCell.setCellStyle((CellStyle)alignStyle);
                }
            }
            FileOutputStream is = new FileOutputStream("E:/AllProjects/dingdang/export/BiddingDetailExcel.xlsx");
            wb.write((OutputStream)is);
            is.close();
            log.info("\u5199\u5165\u6210\u529f\uff0c\u8fd0\u884c\u7ed3\u675f\uff01");
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u590d\u5236excel\u8868\u683c\u5f02\u5e38\uff1ae=" + e);
            excelPubOutputRspBO.setRespCode("8888");
            excelPubOutputRspBO.setRespDesc("\u751f\u6210\u590d\u5236excel\u8868\u683c\u5f02\u5e38");
            return excelPubOutputRspBO;
        }
        excelPubOutputRspBO.setRespCode("0000");
        excelPubOutputRspBO.setRespDesc("\u6210\u529f");
        return excelPubOutputRspBO;
    }

    public static void setRegionBorder(BorderStyle border, CellRangeAddress region, Sheet sheet) {
        RegionUtil.setBorderBottom((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderTop((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
    }

    public static void createRowAndCell(Sheet sheet, int rowNum, int cellNum, CellStyle cellStyle, boolean hasRowFlag, boolean hasCellFlag, Object cellObj) {
        Row row = hasRowFlag ? sheet.getRow(rowNum) : sheet.createRow(rowNum);
        Cell cell = hasCellFlag ? row.getCell(cellNum) : row.createCell(cellNum);
        if (cellObj != null) {
            if (cellObj instanceof Date) {
                cell.setCellValue((Date)cellObj);
            } else if (cellObj instanceof Double) {
                cell.setCellValue(((Double)cellObj).doubleValue());
            } else {
                cell.setCellValue(cellObj + "");
            }
        }
        cell.setCellStyle(cellStyle);
    }

    public static void createMultRowAndCell(Sheet sheet, int rowNum, int cellNum, CellStyle cellStyle, boolean hasRowFlag, boolean hasCellFlag, Object cellObj, int multRowNum, int multCellNum) {
        int m;
        if (multRowNum > 0) {
            for (m = 0; m < multRowNum; ++m) {
                ExcelFormatUtil.createRowAndCell(sheet, rowNum + m, cellNum, cellStyle, hasRowFlag, hasCellFlag, cellObj);
            }
        }
        if (multCellNum > 0) {
            for (m = 0; m < multRowNum; ++m) {
                ExcelFormatUtil.createRowAndCell(sheet, rowNum, cellNum + m, cellStyle, hasRowFlag, hasCellFlag, cellObj);
            }
        }
    }
}

