/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.zone.impl.ability;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.agreement.ability.AgrCreateAgreementChangeApplyAbilityService;
import com.tydic.agreement.ability.AgrModifyAgreementChangeApplyAbilityService;
import com.tydic.agreement.ability.AgrQryAgreementSkuChangeAbilityService;
import com.tydic.agreement.ability.bo.AgrCreateAgreementChangeApplyAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrCreateAgreementChangeApplyAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrModifyAgreementChangeApplyAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrModifyAgreementChangeApplyAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuChangeAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuChangeAbilityRspBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuChangeBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.commodity.ability.api.UccSalesVolumeAbilityService;
import com.tydic.commodity.bo.ability.UccUpdateSaleNumBo;
import com.tydic.commodity.bo.ability.UccUpdateSalesVolumeBO;
import com.tydic.commodity.bo.ability.UccUpdateSalesVolumeReqBO;
import com.tydic.commodity.bo.ability.UccUpdateSalesVolumeRspBO;
import com.tydic.pesapp.zone.ability.PesappZoneSubmitAgrChangeService;
import com.tydic.pesapp.zone.ability.bo.PesappZoneAgreementSkuChangeInfoBO;
import com.tydic.pesapp.zone.ability.bo.PesappZoneSubmitAgrChangeReqBO;
import com.tydic.pesapp.zone.ability.bo.PesappZoneSubmitAgrChangeRspBO;
import com.tydic.uccext.bo.UccBatchGetSkuByAgrDetailsReqBo;
import com.tydic.uccext.bo.UccBatchGetSkuByAgrDetailsRspBo;
import com.tydic.uccext.service.UccBatchGetSkuByAgrDetailsService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PesappZoneSubmitAgrChangeServiceImpl
implements PesappZoneSubmitAgrChangeService {
    private static final Logger log = LoggerFactory.getLogger(PesappZoneSubmitAgrChangeServiceImpl.class);
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="AGR_GROUP_DEV")
    private AgrCreateAgreementChangeApplyAbilityService agrCreateAgreementChangeApplyAbilityService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="AGR_GROUP_DEV")
    private AgrModifyAgreementChangeApplyAbilityService agrModifyAgreementChangeApplyAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UCC_TEST")
    private UccSalesVolumeAbilityService uccSalesVolumeAbilityService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="AGR_GROUP_DEV")
    private AgrQryAgreementSkuChangeAbilityService agrQryAgreementSkuChangeAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UCC_TEST")
    private UccBatchGetSkuByAgrDetailsService uccBatchGetSkuByAgrDetailsService;

    public PesappZoneSubmitAgrChangeRspBO submitAgrChange(PesappZoneSubmitAgrChangeReqBO zoneSubmitAgrChangeReqBO) {
        String jsonStr = JSONObject.toJSONString((Object)zoneSubmitAgrChangeReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
        Map<Long, BigDecimal> skuIdLockNumMap = null;
        if (new Byte("8").equals(zoneSubmitAgrChangeReqBO.getAgrAgreementChangeBO().getChangeType())) {
            skuIdLockNumMap = this.lockSkuNum(zoneSubmitAgrChangeReqBO);
        }
        if (null == zoneSubmitAgrChangeReqBO.getOperType() || 1 == zoneSubmitAgrChangeReqBO.getOperType()) {
            AgrCreateAgreementChangeApplyAbilityReqBO agrCreateAgreementChangeApplyAbilityReqBO = (AgrCreateAgreementChangeApplyAbilityReqBO)JSON.parseObject((String)jsonStr, AgrCreateAgreementChangeApplyAbilityReqBO.class);
            agrCreateAgreementChangeApplyAbilityReqBO.setOperType(AgrCommConstant.AgrSaveOrSubmit.SUBMIT);
            this.changePrecision(agrCreateAgreementChangeApplyAbilityReqBO, zoneSubmitAgrChangeReqBO);
            log.info("\u8c03\u7528\u534f\u8bae\u53d8\u66f4\u7533\u8bf7\u65b0\u589eAPI\u5165\u53c2\u4e3a" + JSON.toJSONString((Object)agrCreateAgreementChangeApplyAbilityReqBO));
            AgrCreateAgreementChangeApplyAbilityRspBO agrCreateAgreementChangeApplyAbilityRspBO = this.agrCreateAgreementChangeApplyAbilityService.createAgreementChangeApply(agrCreateAgreementChangeApplyAbilityReqBO);
            if ("0000".equals(agrCreateAgreementChangeApplyAbilityRspBO.getRespCode())) {
                PesappZoneSubmitAgrChangeRspBO rspBO = new PesappZoneSubmitAgrChangeRspBO();
                rspBO.setChangeId(agrCreateAgreementChangeApplyAbilityRspBO.getChangeId());
                if (!CollectionUtils.isEmpty(skuIdLockNumMap)) {
                    this.unlockSkuNum(skuIdLockNumMap);
                }
                return rspBO;
            }
            throw new ZTBusinessException(agrCreateAgreementChangeApplyAbilityRspBO.getRespDesc());
        }
        AgrModifyAgreementChangeApplyAbilityReqBO agrModifyAgreementChangeApplyAbilityReqBO = (AgrModifyAgreementChangeApplyAbilityReqBO)JSON.parseObject((String)jsonStr, AgrModifyAgreementChangeApplyAbilityReqBO.class);
        agrModifyAgreementChangeApplyAbilityReqBO.setOperType(AgrCommConstant.AgrSaveOrSubmit.SUBMIT);
        log.info("\u8c03\u7528\u534f\u8bae\u53d8\u66f4\u7533\u8bf7\u4fee\u6539API\u5165\u53c2\u4e3a" + JSON.toJSONString((Object)agrModifyAgreementChangeApplyAbilityReqBO));
        AgrModifyAgreementChangeApplyAbilityRspBO grModifyAgreementChangeApplyAbilityRspBO = this.agrModifyAgreementChangeApplyAbilityService.modifyAgreementChangeApply(agrModifyAgreementChangeApplyAbilityReqBO);
        if ("0000".equals(grModifyAgreementChangeApplyAbilityRspBO.getRespCode())) {
            if (!CollectionUtils.isEmpty(skuIdLockNumMap)) {
                this.unlockSkuNum(skuIdLockNumMap);
            }
            return new PesappZoneSubmitAgrChangeRspBO();
        }
        throw new ZTBusinessException(grModifyAgreementChangeApplyAbilityRspBO.getRespDesc());
    }

    private void changePrecision(AgrCreateAgreementChangeApplyAbilityReqBO agrCreateAgreementChangeApplyAbilityReqBO, PesappZoneSubmitAgrChangeReqBO zoneSubmitAgrChangeReqBO) {
        if (agrCreateAgreementChangeApplyAbilityReqBO.getAgrAgreementSkuChangeBOs() != null) {
            for (int i = 0; i < agrCreateAgreementChangeApplyAbilityReqBO.getAgrAgreementSkuChangeBOs().size(); ++i) {
                PesappZoneAgreementSkuChangeInfoBO cnncZoneAgreementSkuChangeInfoBO = (PesappZoneAgreementSkuChangeInfoBO)zoneSubmitAgrChangeReqBO.getAgrAgreementSkuChangeBOs().get(i);
                AgrAgreementSkuChangeBO agrAgreementSkuChangeBO = (AgrAgreementSkuChangeBO)agrCreateAgreementChangeApplyAbilityReqBO.getAgrAgreementSkuChangeBOs().get(i);
                Double markupRate = cnncZoneAgreementSkuChangeInfoBO.getMarkupRate();
                BigDecimal buyPrice = cnncZoneAgreementSkuChangeInfoBO.getBuyPrice();
                BigDecimal buyNumber = cnncZoneAgreementSkuChangeInfoBO.getBuyNumber();
                if (markupRate == null) {
                    markupRate = 0.0;
                }
                BigDecimal addPrice = buyPrice.multiply(new BigDecimal("100")).multiply(new BigDecimal(markupRate));
                BigDecimal salePrice = buyPrice.multiply(new BigDecimal("10000")).add(addPrice);
                agrAgreementSkuChangeBO.setBuyPrice(Long.valueOf(buyPrice.multiply(new BigDecimal("10000")).longValue()));
                agrAgreementSkuChangeBO.setBuyPriceSum(Long.valueOf(buyPrice.multiply(buyNumber).multiply(new BigDecimal("10000")).longValue()));
                agrAgreementSkuChangeBO.setSalePrice(Long.valueOf(salePrice.longValue()));
                agrAgreementSkuChangeBO.setSalePriceSum(Long.valueOf(salePrice.multiply(buyNumber).longValue()));
            }
        }
    }

    private void unlockSkuNum(Map<Long, BigDecimal> skuIdLockNumMap) {
        ArrayList<UccUpdateSaleNumBo> saleNumBos = new ArrayList<UccUpdateSaleNumBo>();
        for (Long skuId : skuIdLockNumMap.keySet()) {
            UccUpdateSaleNumBo uccUpdateSaleNumBo = new UccUpdateSaleNumBo();
            uccUpdateSaleNumBo.setSkuId(skuId);
            uccUpdateSaleNumBo.setSoldNumber(skuIdLockNumMap.get(skuId));
            uccUpdateSaleNumBo.setIncOrDec(Integer.valueOf(1));
            saleNumBos.add(uccUpdateSaleNumBo);
        }
        ArrayList<UccUpdateSalesVolumeBO> uccUpdateSalesVolumeBOS = new ArrayList<UccUpdateSalesVolumeBO>();
        UccUpdateSalesVolumeBO uccUpdateSalesVolumeBO = new UccUpdateSalesVolumeBO();
        uccUpdateSalesVolumeBO.setSaleNumBos(saleNumBos);
        uccUpdateSalesVolumeBOS.add(uccUpdateSalesVolumeBO);
        UccUpdateSalesVolumeReqBO uccUpdateSalesVolumeReqBO = new UccUpdateSalesVolumeReqBO();
        uccUpdateSalesVolumeReqBO.setUccUpdateSalesVolumeBOS(uccUpdateSalesVolumeBOS);
        log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u5e93\u5b58\u64cd\u4f5c\u670d\u52a1\u5165\u53c2\u4e3a" + JSON.toJSONString((Object)uccUpdateSalesVolumeReqBO));
        UccUpdateSalesVolumeRspBO uccUpdateSalesVolumeRspBO = this.uccSalesVolumeAbilityService.updateSalesVolume(uccUpdateSalesVolumeReqBO);
        log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u5e93\u5b58\u64cd\u4f5c\u670d\u52a1\u51fa\u53c2\u4e3a" + JSON.toJSONString((Object)uccUpdateSalesVolumeRspBO));
        if (!"0000".equals(uccUpdateSalesVolumeRspBO.getRespCode())) {
            throw new ZTBusinessException(uccUpdateSalesVolumeRspBO.getRespDesc());
        }
    }

    private Map<Long, BigDecimal> lockSkuNum(PesappZoneSubmitAgrChangeReqBO zoneSubmitAgrChangeReqBO) {
        HashMap<Long, BigDecimal> resultMap = new HashMap<Long, BigDecimal>();
        AgrQryAgreementSkuChangeAbilityReqBO agrQryAgreementSkuChangeAbilityReqBO = new AgrQryAgreementSkuChangeAbilityReqBO();
        agrQryAgreementSkuChangeAbilityReqBO.setAgreementId(zoneSubmitAgrChangeReqBO.getAgreementId());
        agrQryAgreementSkuChangeAbilityReqBO.setChangeCode(zoneSubmitAgrChangeReqBO.getChangeCode());
        agrQryAgreementSkuChangeAbilityReqBO.setPageQueryFlag(Boolean.valueOf(false));
        AgrQryAgreementSkuChangeAbilityRspBO rspBO = this.agrQryAgreementSkuChangeAbilityService.qryAgreementSkuChange(agrQryAgreementSkuChangeAbilityReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException(rspBO.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            HashMap<Long, BigDecimal> agreementSkuIdLockNumMap = new HashMap<Long, BigDecimal>();
            ArrayList<Long> agreementDetailsIds = new ArrayList<Long>();
            for (AgrAgreementSkuChangeBO agrAgreementSkuChangeBO : rspBO.getRows()) {
                BigDecimal lockNum = new BigDecimal(agrAgreementSkuChangeBO.getExtField1()).subtract(new BigDecimal(agrAgreementSkuChangeBO.getExtField2()));
                if (lockNum.compareTo(BigDecimal.ZERO) != -1) continue;
                agreementSkuIdLockNumMap.put(agrAgreementSkuChangeBO.getAgreementSkuId(), lockNum);
                agreementDetailsIds.add(agrAgreementSkuChangeBO.getAgreementSkuId());
            }
            if (agreementDetailsIds.size() > 0) {
                UccBatchGetSkuByAgrDetailsReqBo uccBatchGetSkuByAgrDetailsReqBo = new UccBatchGetSkuByAgrDetailsReqBo();
                uccBatchGetSkuByAgrDetailsReqBo.setAgreementId(zoneSubmitAgrChangeReqBO.getAgreementId());
                uccBatchGetSkuByAgrDetailsReqBo.setAgreementDetailsIds(agreementDetailsIds);
                UccBatchGetSkuByAgrDetailsRspBo uccBatchGetSkuByAgrDetailsRspBo = this.uccBatchGetSkuByAgrDetailsService.batchGetSku(uccBatchGetSkuByAgrDetailsReqBo);
                if (!"0000".equals(uccBatchGetSkuByAgrDetailsRspBo.getRespCode())) {
                    throw new ZTBusinessException(uccBatchGetSkuByAgrDetailsRspBo.getRespDesc());
                }
                Map skuAndAgr = uccBatchGetSkuByAgrDetailsRspBo.getSkuAndAgr();
                if (!CollectionUtils.isEmpty((Map)skuAndAgr)) {
                    ArrayList<UccUpdateSaleNumBo> saleNumBos = new ArrayList<UccUpdateSaleNumBo>();
                    for (Long agreeementSkuId : agreementSkuIdLockNumMap.keySet()) {
                        Long skuId = (Long)skuAndAgr.get(agreeementSkuId);
                        if (null == skuId) continue;
                        UccUpdateSaleNumBo uccUpdateSaleNumBo = new UccUpdateSaleNumBo();
                        uccUpdateSaleNumBo.setSkuId(skuId);
                        uccUpdateSaleNumBo.setSoldNumber((BigDecimal)agreementSkuIdLockNumMap.get(agreeementSkuId));
                        uccUpdateSaleNumBo.setIncOrDec(Integer.valueOf(0));
                        saleNumBos.add(uccUpdateSaleNumBo);
                        resultMap.put(skuId, uccUpdateSaleNumBo.getSoldNumber());
                    }
                    if (saleNumBos.size() > 0) {
                        ArrayList<UccUpdateSalesVolumeBO> uccUpdateSalesVolumeBOS = new ArrayList<UccUpdateSalesVolumeBO>();
                        UccUpdateSalesVolumeBO uccUpdateSalesVolumeBO = new UccUpdateSalesVolumeBO();
                        uccUpdateSalesVolumeBO.setSaleNumBos(saleNumBos);
                        uccUpdateSalesVolumeBOS.add(uccUpdateSalesVolumeBO);
                        UccUpdateSalesVolumeReqBO uccUpdateSalesVolumeReqBO = new UccUpdateSalesVolumeReqBO();
                        uccUpdateSalesVolumeReqBO.setUccUpdateSalesVolumeBOS(uccUpdateSalesVolumeBOS);
                        log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u5e93\u5b58\u64cd\u4f5c\u670d\u52a1\u5165\u53c2\u4e3a" + JSON.toJSONString((Object)uccUpdateSalesVolumeReqBO));
                        UccUpdateSalesVolumeRspBO uccUpdateSalesVolumeRspBO = this.uccSalesVolumeAbilityService.updateSalesVolume(uccUpdateSalesVolumeReqBO);
                        log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u5e93\u5b58\u64cd\u4f5c\u670d\u52a1\u51fa\u53c2\u4e3a" + JSON.toJSONString((Object)uccUpdateSalesVolumeRspBO));
                        if (!"0000".equals(uccUpdateSalesVolumeRspBO.getRespCode())) {
                            throw new ZTBusinessException(uccUpdateSalesVolumeRspBO.getRespDesc());
                        }
                    }
                }
            }
        }
        return resultMap;
    }
}

