/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.zone.aop;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.IPUtils;
import com.tydic.order.pec.ability.UocPebOrderFlowAbilityService;
import com.tydic.order.pec.ability.bo.UocOrderFlowReqBO;
import com.tydic.order.uoc.bo.common.annotation.OrderFlowLog;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.pesapp.zone.ability.bo.PesappZoneReviewOrderObjInfo;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
@Order(value=200)
public class OrderFlowLogAspect {
    private static final Logger log = LoggerFactory.getLogger(OrderFlowLogAspect.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UOC_GROUP_PROD")
    private UocPebOrderFlowAbilityService uocPebOrderFlowAbilityService;

    @Pointcut(value="@annotation(com.tydic.order.uoc.bo.common.annotation.OrderFlowLog)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object result = null;
        try {
            result = point.proceed();
            this.saveOrderFlowLog(point, result);
        }
        catch (ZTBusinessException e) {
            log.error("\u8ba2\u5355\u6d41\u8f6c\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            String msg = e.resolverException();
            throw new ZTBusinessException(msg);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        catch (Throwable e) {
            log.error("\u8ba2\u5355\u6d41\u8f6c\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new Throwable(e);
        }
        return result;
    }

    private void saveOrderFlowLog(ProceedingJoinPoint joinPoint, Object result) {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        String ip = IPUtils.getIp((HttpServletRequest)request);
        log.info("\u672c\u6b21\u64cd\u4f5c\u7684ip\u5730\u5740\u662f\uff1a{}", (Object)ip);
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        OrderFlowLog orderFlowLog = method.getAnnotation(OrderFlowLog.class);
        String description = orderFlowLog.description();
        log.info("\u672c\u6b21\u64cd\u4f5c\u63cf\u8ff0\uff1a{}", (Object)description);
        String operationLink = orderFlowLog.operationLink();
        log.info("\u672c\u6b21\u64cd\u4f5c\u8282\u70b9\uff1a{}", (Object)operationLink);
        UocOrderFlowReqBO recordReqBO = new UocOrderFlowReqBO();
        Object[] args = joinPoint.getArgs();
        JSONObject params = JSON.parseObject((String)JSON.toJSONString((Object)args[0]));
        log.debug("\u5165\u53c2\u7684\u53c2\u6570\uff1a{}", (Object)params);
        String userId = params.getString("userId");
        String userName = params.getString("username");
        String orgName = params.getString("orgName");
        recordReqBO.setDealCompName(params.getString("companyName"));
        recordReqBO.setDealDeptName(orgName);
        JSONArray jsonArray = params.getJSONArray("umcStationsListWebExt");
        String postName = null;
        if (null != jsonArray && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject postJsonObject = jsonArray.getJSONObject(i);
                postName = 0 == i ? postJsonObject.getString("stationName") : postName + "," + postJsonObject.getString("stationName");
            }
            if (1024 < postName.length()) {
                postName = postName.substring(0, 1024);
            }
        } else {
            postName = "-";
        }
        recordReqBO.setDealPostName(postName);
        recordReqBO.setDealOperId(userId);
        recordReqBO.setDealOperName(userName);
        JSONObject response = JSON.parseObject((String)JSON.toJSONString((Object)result));
        log.debug("\u672c\u6b21\u6267\u884c\u7684\u8fd4\u56de\u7ed3\u679c\u662f\uff1a{}", (Object)response);
        recordReqBO.setDealTypeName(operationLink);
        recordReqBO.setDealDesc(description + (response.getString("respDesc") == null ? "" : response.getString("respDesc")));
        recordReqBO.setIpAddress(ip);
        recordReqBO.setDealTime(new Date());
        recordReqBO.setDealReason(description);
        switch (description) {
            case "\u8c03\u4ef7\u590d\u6838": {
                this.dealReviewOrder(operationLink, recordReqBO, params);
                break;
            }
            case "\u4f9b\u5e94\u5546\u53d1\u8d27": {
                recordReqBO.setDealTime(params.getDate("estimatedArrivalTime"));
                this.buildBaseOrderFlowInfo(operationLink, recordReqBO, params);
                break;
            }
            case "\u62d2\u5355": {
                this.buildBaseOrderFlowInfo(operationLink, recordReqBO, params);
                recordReqBO.setDealReason(params.getString("remark"));
                break;
            }
            case "\u53d6\u6d88\u8ba2\u5355": {
                String cancelReason = params.getString("cancelReson");
                recordReqBO.setDealName(operationLink);
                recordReqBO.setDealReason(cancelReason);
                recordReqBO.setOrderId(params.getLong("orderId"));
                recordReqBO.setSaleVoucherId(params.getLong("saleVoucherId"));
                this.buildOrderLog(recordReqBO);
                break;
            }
            default: {
                this.buildBaseOrderFlowInfo(operationLink, recordReqBO, params);
            }
        }
    }

    private void buildBaseOrderFlowInfo(String operationLink, UocOrderFlowReqBO recordReqBO, JSONObject params) {
        recordReqBO.setDealName(operationLink);
        recordReqBO.setOrderId(params.getLong("orderId"));
        recordReqBO.setSaleVoucherId(params.getLong("saleVoucherId"));
        this.buildOrderLog(recordReqBO);
    }

    private void dealReviewOrder(String operationLink, UocOrderFlowReqBO recordReqBO, JSONObject params) {
        String orderInfo = params.getString("orderApprovalList");
        if (StringUtils.isNotBlank((CharSequence)orderInfo)) {
            List reviewOrderInfo = JSON.parseArray((String)orderInfo, PesappZoneReviewOrderObjInfo.class);
            operationLink = "1".equals(params.getString("auditResult")) ? operationLink + "(\u672a\u901a\u8fc7)" : operationLink + "(\u901a\u8fc7)";
            recordReqBO.setDealName(operationLink);
            recordReqBO.setDealReason(params.getString("approvalRemark"));
            reviewOrderInfo.forEach(order -> {
                recordReqBO.setOrderId(order.getOrderId());
                recordReqBO.setSaleVoucherId(order.getSaleVoucherId());
                this.buildOrderLog(recordReqBO);
            });
        } else {
            this.buildOrderLog(recordReqBO);
        }
    }

    private void buildOrderLog(UocOrderFlowReqBO recordReqBO) {
        recordReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        recordReqBO.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.ORDER_OPER_RECORD);
        recordReqBO.setCreateTime(new Date());
        this.uocPebOrderFlowAbilityService.dealAfterSaleRequest(recordReqBO);
        log.debug("\u8bb0\u5f55\u8ba2\u5355\u6d41\u6c34\u4fe1\u606f\u6210\u529f\uff1a{}", (Object)recordReqBO);
    }
}

