/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.zone.impl.ability;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.order.pec.ability.es.order.bo.UocPebChildOrderAbilityBO;
import com.tydic.order.pec.ability.es.order.bo.UocPebOrderItemAbilityBO;
import com.tydic.order.pec.ability.es.order.bo.UocPebUpperOrderAbilityBO;
import com.tydic.order.pec.ability.sale.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.order.pec.bo.sale.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.order.pec.bo.sale.UocSalesSingleDetailsListQueryRspBO;
import com.tydic.pesapp.zone.ability.BmcQueryOperatorOrderReviewListService;
import com.tydic.pesapp.zone.ability.bo.QueryOperatorOrderItemReviewInfo;
import com.tydic.pesapp.zone.ability.bo.QueryOperatorOrderReviewListReqDto;
import com.tydic.pesapp.zone.ability.bo.QueryOperatorOrderReviewListRspDto;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BmcQueryOperatorOrderReviewListServiceImpl
implements BmcQueryOperatorOrderReviewListService {
    private static final Logger log = LoggerFactory.getLogger(BmcQueryOperatorOrderReviewListServiceImpl.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UOC_GROUP_PROD")
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;

    public RspPage<QueryOperatorOrderReviewListRspDto> queryOrderReviewList(QueryOperatorOrderReviewListReqDto reqDto) {
        UocSalesSingleDetailsListQueryReqBO reqBO = new UocSalesSingleDetailsListQueryReqBO();
        RspPage rspDto = new RspPage();
        rspDto.setCode("0000");
        try {
            BeanUtils.copyProperties((Object)reqDto, (Object)reqBO);
            if (reqDto.getSaleState() != null) {
                ArrayList<Integer> saleStateList = new ArrayList<Integer>();
                saleStateList.add(reqDto.getSaleState());
                reqBO.setSaleStateList(saleStateList);
            }
            if (StringUtils.isNotEmpty((String)reqDto.getOrderSource())) {
                ArrayList<String> orderSourceList = new ArrayList<String>();
                orderSourceList.add(reqDto.getOrderSource());
                reqBO.setOrderSourceList(orderSourceList);
            }
            reqBO.setProDeliveryIdList(reqDto.getProDeliveryIdList());
            UocSalesSingleDetailsListQueryRspBO uocRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(reqBO);
            if (uocRspBO != null && "0000".equals(uocRspBO.getRespCode())) {
                rspDto.setPageNo(uocRspBO.getPageNo());
                rspDto.setTotal(uocRspBO.getTotal());
                rspDto.setRecordsTotal(uocRspBO.getRecordsTotal());
                ArrayList<QueryOperatorOrderReviewListRspDto> reviewListRspDtoList = new ArrayList<QueryOperatorOrderReviewListRspDto>();
                if (uocRspBO.getRows() != null && !uocRspBO.getRows().isEmpty()) {
                    List upperList = uocRspBO.getRows();
                    for (UocPebUpperOrderAbilityBO upperBo : upperList) {
                        List childList = upperBo.getChildOrderList();
                        if (childList == null || childList.isEmpty()) continue;
                        for (UocPebChildOrderAbilityBO childBO : childList) {
                            log.error("\u8fd0\u8425\u65b9\u8ba2\u5355\u590d\u6838\u67e5\u8be2UocPebChildOrderAbilityBO:" + childBO);
                            QueryOperatorOrderReviewListRspDto rsp = new QueryOperatorOrderReviewListRspDto();
                            BeanUtils.copyProperties((Object)childBO, (Object)rsp);
                            rsp.setStepId(upperBo.getStepId());
                            List itemList = childBO.getOrderItemList();
                            if (itemList != null && !itemList.isEmpty()) {
                                ArrayList<QueryOperatorOrderItemReviewInfo> itemReviewInfoList = new ArrayList<QueryOperatorOrderItemReviewInfo>();
                                for (UocPebOrderItemAbilityBO itemBO : itemList) {
                                    QueryOperatorOrderItemReviewInfo itemReviewInfo = new QueryOperatorOrderItemReviewInfo();
                                    BeanUtils.copyProperties((Object)itemBO, (Object)itemReviewInfo);
                                    itemReviewInfoList.add(itemReviewInfo);
                                }
                                rsp.setQueryOperatorOrderItemReviewInfoList(itemReviewInfoList);
                            }
                            log.error("\u8fd0\u8425\u65b9\u8ba2\u5355\u590d\u6838\u67e5\u8be2rsp:" + rsp);
                            reviewListRspDtoList.add(rsp);
                        }
                    }
                    rspDto.setRows(reviewListRspDtoList);
                    rspDto.setMessage(uocRspBO.getRespDesc());
                }
            } else {
                rspDto.setCode("0010");
                rspDto.setMessage("\u8c03\u7528\u4e2d\u5fc3\u5c42\u670d\u52a1\u51fa\u9519\uff01");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspDto.setCode("0010");
            rspDto.setMessage("\u8c03\u7528\u4e2d\u5fc3\u5c42\u670d\u52a1\u51fa\u9519\uff01" + e.getMessage());
        }
        return rspDto;
    }
}

