/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dmc.controller;

import com.tydic.dmc.ability.DmcActivityEffectAbilityService;
import com.tydic.dmc.ability.DmcDataAnalysisAbilityService;
import com.tydic.dmc.ability.bo.DmcActivityEffectAbilityReqBO;
import com.tydic.dmc.ability.bo.DmcActivityEffectAbilityRspBO;
import com.tydic.dmc.ability.bo.DmcDataChartAbilityReqBO;
import com.tydic.dmc.ability.bo.DmcDataChartAbilityRspBO;
import com.tydic.dmc.ability.bo.DmcDataOverallAbilityReqBO;
import com.tydic.dmc.ability.bo.DmcDataOverallAbilityRspBO;
import com.tydic.dmc.ability.bo.DmcDataOverviewAbilityReqBO;
import com.tydic.dmc.ability.bo.DmcDataOverviewAbilityRspBO;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dmc/analysis"})
public class DmcDataAnalysisController {
    @Reference(interfaceClass=DmcDataAnalysisAbilityService.class, version="1.0-SNAPSHOT", group="DMC_GROUP_DEV")
    private DmcDataAnalysisAbilityService analysisAbilityService;
    @Reference(interfaceClass=DmcActivityEffectAbilityService.class, version="1.0-SNAPSHOT", group="DMC_GROUP_DEV")
    private DmcActivityEffectAbilityService activityEffectAbilityService;

    @PostMapping(value={"/getDataOverview"})
    public DmcDataOverviewAbilityRspBO getDataOverall(@RequestBody DmcDataOverviewAbilityReqBO reqBO) {
        return this.analysisAbilityService.getDataOverview(reqBO);
    }

    @PostMapping(value={"/getDataOverall"})
    public DmcDataOverallAbilityRspBO getDataOverall(@RequestBody DmcDataOverallAbilityReqBO reqBO) {
        return this.analysisAbilityService.getDataOverall(reqBO);
    }

    @PostMapping(value={"/getChartData"})
    public DmcDataChartAbilityRspBO getChartData(@RequestBody DmcDataChartAbilityReqBO reqBO) {
        return this.analysisAbilityService.getChartData(reqBO);
    }

    @PostMapping(value={"/queryActivityEffect"})
    public DmcActivityEffectAbilityRspBO queryActivityEffect(@RequestBody DmcActivityEffectAbilityReqBO reqBO) {
        return this.activityEffectAbilityService.queryActivityEffect(reqBO);
    }
}

