/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.document.impl.ability;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.document.api.ability.DocInfoTypeListQueryAbilityService;
import com.tydic.document.api.ability.bo.DocInfoTypeListQueryAbilityReqBo;
import com.tydic.document.api.ability.bo.DocInfoTypeListQueryAbilityRspBo;
import com.tydic.document.api.common.bo.DocInfoDocTypeDataBo;
import com.tydic.document.api.common.bo.DocInfoMenuDataBo;
import com.tydic.document.api.constants.DocDictionaryValueConstants;
import com.tydic.document.dao.DocInfoDocTypeMapper;
import com.tydic.document.dao.po.DocInfoDocTypePo;
import com.tydic.document.impl.atom.api.DocDicMapQueryAtomService;
import com.tydic.document.impl.atom.api.DocInfoMenuListQueryAtomService;
import com.tydic.document.impl.atom.api.bo.DocDicMapQueryAtomReqBo;
import com.tydic.document.impl.atom.api.bo.DocDicMapQueryAtomRspBo;
import com.tydic.document.impl.atom.api.bo.DocInfoMenuListQueryAtomReqBo;
import com.tydic.document.impl.atom.api.bo.DocInfoMenuListQueryAtomRspBo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="docInfoTypeListQueryAbilityService")
@HSFProvider(serviceVersion="1.0", serviceGroup="DOCUMENT_GROUP", serviceInterface=DocInfoTypeListQueryAbilityService.class)
public class DocInfoTypeListQueryAbilityServiceImpl
implements DocInfoTypeListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DocInfoTypeListQueryAbilityServiceImpl.class);
    @Autowired
    private DocInfoDocTypeMapper docInfoDocTypeMapper;
    @Autowired
    private DocDicMapQueryAtomService docDicMapQueryAtomService;
    @Autowired
    private DocInfoMenuListQueryAtomService docInfoMenuListQueryAtomService;

    public DocInfoTypeListQueryAbilityRspBo queryDocTypes(DocInfoTypeListQueryAbilityReqBo reqBo) {
        List<DocInfoDocTypePo> docTypePos;
        log.info("=============\u6587\u6863\u7c7b\u522b\u5217\u8868\u67e5\u8be2\u670d\u52a1\u5f00\u59cb===========");
        log.info("\u5165\u53c2\uff1a" + reqBo);
        DocInfoTypeListQueryAbilityRspBo retBo = new DocInfoTypeListQueryAbilityRspBo();
        HashMap<String, List<DocInfoDocTypeDataBo>> docTypeMap = new HashMap<String, List<DocInfoDocTypeDataBo>>(16);
        retBo.setDocTypeMap(docTypeMap);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        DocInfoDocTypePo queryPo = new DocInfoDocTypePo();
        BeanUtils.copyProperties((Object)reqBo, (Object)queryPo);
        if (StringUtils.isEmpty((Object)queryPo.getTypeStatus())) {
            log.info("\u9ed8\u8ba4\u67e5\u8be2\u6709\u6548\u7684\u7c7b\u522b");
            queryPo.setTypeStatus(DocDictionaryValueConstants.DOC_INFO_STATUS_EFFECTIVE);
        }
        if (CollectionUtils.isEmpty(docTypePos = this.docInfoDocTypeMapper.selectByCondition(queryPo))) {
            log.error("\u67e5\u8be2\u6587\u6863\u7c7b\u522b\u5217\u8868\u4e3a\u7a7a");
            retBo.setRespDesc("\u67e5\u8be2\u6587\u6863\u7c7b\u522b\u5217\u8868\u4e3a\u7a7a");
            return retBo;
        }
        this.groupByMenu(docTypePos, docTypeMap);
        log.info("\u51fa\u53c2\uff1a" + retBo);
        log.info("=============\u6587\u6863\u7c7b\u522b\u5217\u8868\u67e5\u8be2\u670d\u52a1\u7ed3\u675f===========");
        return retBo;
    }

    private void groupByMenu(List<DocInfoDocTypePo> docTypePos, Map<String, List<DocInfoDocTypeDataBo>> docTypeMap) {
        Map<String, String> dicMap = this.getDicMap();
        Map<Long, String> menuMap = this.getMenuMap();
        HashMap tempMap = new HashMap(16);
        for (DocInfoDocTypePo docInfoDocTypePo : docTypePos) {
            DocInfoDocTypeDataBo docTypeDataBo = new DocInfoDocTypeDataBo();
            BeanUtils.copyProperties((Object)docInfoDocTypePo, (Object)docTypeDataBo);
            docTypeDataBo.setTypeStatusDesc(dicMap.get(docTypeDataBo.getTypeStatus() + ""));
            Long menuId = docTypeDataBo.getMenuId();
            if (tempMap.containsKey(menuId)) {
                ((List)tempMap.get(menuId)).add(docTypeDataBo);
                continue;
            }
            ArrayList<DocInfoDocTypeDataBo> docTypes = new ArrayList<DocInfoDocTypeDataBo>();
            docTypes.add(docTypeDataBo);
            tempMap.put(menuId, docTypes);
        }
        for (Map.Entry entry : tempMap.entrySet()) {
            String menuName = menuMap.get(entry.getKey());
            if (StringUtils.isEmpty((Object)menuName)) {
                docTypeMap.put(entry.getKey() + "", (List<DocInfoDocTypeDataBo>)entry.getValue());
                continue;
            }
            docTypeMap.put(menuName, (List<DocInfoDocTypeDataBo>)entry.getValue());
        }
    }

    private Map<Long, String> getMenuMap() {
        HashMap<Long, String> menuMap = new HashMap<Long, String>(16);
        DocInfoMenuListQueryAtomRspBo atomRetBo = this.docInfoMenuListQueryAtomService.queryDocMenus(new DocInfoMenuListQueryAtomReqBo());
        if (!CollectionUtils.isEmpty(atomRetBo.getMenus())) {
            for (DocInfoMenuDataBo dataBo : atomRetBo.getMenus()) {
                menuMap.put(dataBo.getMenuId(), dataBo.getMenuName());
            }
        }
        return menuMap;
    }

    private Map<String, String> getDicMap() {
        DocDicMapQueryAtomReqBo atomReqBo = new DocDicMapQueryAtomReqBo();
        atomReqBo.setType("DOC_INFO_STATUS");
        DocDicMapQueryAtomRspBo atomRetBo = this.docDicMapQueryAtomService.queryDicMap(atomReqBo);
        return atomRetBo.getDicMap();
    }
}

