/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.document.utils.es;

import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.document.utils.es.EsDocBaseBo;
import com.tydic.document.utils.es.EsDocDetailContentBo;
import com.tydic.document.utils.es.EsPageRspBo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DocEsUtil {
    private static final Logger log = LoggerFactory.getLogger(DocEsUtil.class);
    private RestHighLevelClient client;

    public DocEsUtil(RestHighLevelClient client) {
        this.client = client;
    }

    public static void main(String[] args) throws Exception {
        RestHighLevelClient client = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost("47.93.182.18", 9200, "http")}));
        DocEsUtil esUtil = new DocEsUtil(client);
        String indexName = "doc_document";
        String indexType = "doc_detail";
        List<EsDocDetailContentBo> esDocDetailContentBos = esUtil.keywordSearch(indexName, indexType, "detailContent", "\u89c4\u8303", EsDocDetailContentBo.class, 0, 2).getData();
        System.out.println(JSON.toJSONString(esDocDetailContentBos));
        esUtil.close();
    }

    public <T> EsPageRspBo<T> keywordSearch(String index, String type, String filed, String keyword, Class<T> clazz, int cPage, int pageSize) throws IOException {
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        searchRequest.types(new String[]{type});
        BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        searchRequest.source(sourceBuilder);
        MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)filed, (Object)keyword);
        boolBuilder.must((QueryBuilder)matchQueryBuilder);
        sourceBuilder.query((QueryBuilder)boolBuilder);
        sourceBuilder.from((cPage - 1) * pageSize);
        sourceBuilder.size(pageSize);
        EsPageRspBo esPageRspBo = new EsPageRspBo();
        ArrayList<Object> tList = new ArrayList<Object>();
        esPageRspBo.setData(tList);
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        Object[] searchHits = hits.getHits();
        int totalRecord = (int)hits.getTotalHits();
        log.info("\u67e5\u8be2\u5230\u7ed3\u679c" + totalRecord + "\u4e2a");
        if (!ArrayUtil.isEmpty((Object[])searchHits)) {
            for (Object hit : searchHits) {
                Map highlightFields = hit.getHighlightFields();
                Object t = JSON.parseObject((String)hit.getSourceAsString(), clazz);
                tList.add(t);
            }
        }
        int totalPageNum = (totalRecord + pageSize - 1) / pageSize;
        esPageRspBo.setTPage(totalPageNum);
        esPageRspBo.setTotal((int)hits.getTotalHits());
        esPageRspBo.setCPage(cPage);
        return esPageRspBo;
    }

    public <T> T getDocument(String index, String type, String _id, Class<T> clazz) throws IOException {
        GetRequest getRequest = new GetRequest(index, type, _id);
        GetResponse getResponse = this.client.get(getRequest, RequestOptions.DEFAULT);
        if (!getResponse.isExists()) {
            throw new IllegalArgumentException("es getDocument failed: id(" + _id + ") is not exists");
        }
        String sourceAsString = getResponse.getSourceAsString();
        return (T)JSON.parseObject((String)sourceAsString, clazz);
    }

    public boolean deleteDocument(String index, String type, String _id) throws IOException {
        DeleteRequest request = new DeleteRequest(index, type, _id);
        DeleteResponse deleteResponse = this.client.delete(request, RequestOptions.DEFAULT);
        System.out.println(JSON.toJSONString((Object)deleteResponse));
        boolean resule = false;
        if (DocWriteResponse.Result.DELETED.equals((Object)deleteResponse.getResult())) {
            log.debug("es delete success(" + _id + "):" + deleteResponse.getResult());
            resule = true;
        } else {
            log.warn("es delete failed(" + _id + "):" + deleteResponse.getResult());
        }
        return resule;
    }

    public void putDocument(String index, String type, EsDocBaseBo obj) throws IOException {
        IndexRequest indexRequest = new IndexRequest(index, type, obj.get_id());
        String jsonString = JSON.toJSONString((Object)obj);
        System.out.println(jsonString);
        indexRequest.source(jsonString, XContentType.JSON);
        IndexResponse response = this.client.index(indexRequest, RequestOptions.DEFAULT);
        System.out.println(response.getResult().name());
    }

    public boolean deleteIndex(String indexName) throws IOException {
        if (!this.indexExists(indexName)) {
            throw new IllegalArgumentException("index(" + indexName + ")  not exists ");
        }
        DeleteIndexRequest request = new DeleteIndexRequest(indexName);
        AcknowledgedResponse deleteIndexResponse = this.client.indices().delete(request, RequestOptions.DEFAULT);
        return deleteIndexResponse.isAcknowledged();
    }

    public boolean indexExists(String indexName) throws IOException {
        GetIndexRequest indexRequest = (GetIndexRequest)new GetIndexRequest().indices(new String[]{indexName});
        boolean exists = this.client.indices().exists(indexRequest, RequestOptions.DEFAULT);
        return exists;
    }

    public boolean createIndex(String indexName) throws IOException {
        if (this.indexExists(indexName)) {
            throw new IllegalArgumentException("index(" + indexName + ")  already exists ");
        }
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        CreateIndexResponse createIndexResponse = null;
        createIndexResponse = this.client.indices().create(request, RequestOptions.DEFAULT);
        System.out.println(JSON.toJSONString((Object)createIndexResponse));
        return createIndexResponse.isAcknowledged();
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("close the es client failed:" + e);
        }
    }

    public static EsDocDetailContentBo genTestBo() {
        EsDocDetailContentBo esBo = new EsDocDetailContentBo();
        esBo.setDetailId(8L);
        esBo.setTypeId(1L);
        esBo.setMenuId(1L);
        esBo.setDetailName("\u89e3\u51b3\u65b9\u6848\u2014\u652f\u4ed8\u89e3\u51b3\u65b9\u6848\u2014\u652f\u4ed8\u8ba2\u5355\u7ba1\u7406");
        esBo.setDetailStatus(1);
        esBo.setDetailDesc("\u89e3\u51b3\u65b9\u6848\u2014\u652f\u4ed8\u89e3\u51b3\u65b9\u6848\u2014\u652f\u4ed8\u8ba2\u5355\u7ba1\u7406");
        esBo.setDocUrl("http://localhost:4000/menutest.html");
        esBo.setCreateTime(new DateTime((Object)new Date()).toString("yyyy-mm-dd HH:mm:ss"));
        esBo.setUpdateTime(new DateTime((Object)new Date()).toString("yyyy-mm-dd HH:mm:ss"));
        esBo.setDetailContent("1. \u54c8\u5e02\u7684\u5408\u6cd5\n1.1. \u83dc\u5355\u5f00\u59cb\n1.1.1. \u5f00\u59cb\u57fa\u5730\u9644\u8fd1\u554a\n\u672c\u6587\u4ecb\u7ecd\u4e86\u5982\u4f55\u4f7f\u7528\u8bbf\u95ee\u63a7\u5236RAM\uff08Resource Access Management\uff09\u5728\u8d26\u53f7\u7ea7\u522b\u4e0a\u63a7\u5236\u5bf9\u4e91\u670d\u52a1\u5668ECS\u8d44\u6e90\u7684\u8bbf\u95ee\uff0c\u5177\u4f53\u901a\u8fc7\u521b\u5efaRAM\u7528\u6237\uff08\u7ec4\uff09\u5e76\u6388\u4e88\u7279\u5b9a\u6743\u9650\u7b56\u7565\u5b9e\u73b0\u3002\n\n1.2. \u80cc\u666f\u4fe1\u606f\n\u8bbf\u95ee\u63a7\u5236RAM\u662f\u963f\u91cc\u4e91\u63d0\u4f9b\u7684\u8d44\u6e90\u8bbf\u95ee\u63a7\u5236\u670d\u52a1\u3002\u66f4\u591a\u8be6\u60c5\uff0c\u8bf7\u53c2\u89c1\u4ec0\u4e48\u662f\u8bbf\u95ee\u63a7\u5236\u3002\u4ee5\u4e0b\u5217\u4e3e\u4e86\u8bbf\u95ee\u63a7\u5236RAM\u7684\u5178\u578b\u573a\u666f\uff1a\n\n\u7528\u6237\uff1a\u5982\u679c\u60a8\u8d2d\u4e70\u4e86\u591a\u53f0\u4e91\u670d\u52a1\u5668ECS\u5b9e\u4f8b\uff0c\u60a8\u7684\u7ec4\u7ec7\u91cc\u6709\u591a\u4e2a\u7528\u6237\uff08\u5982\u5458\u5de5\u3001\u7cfb\u7edf\u6216\u5e94\u7528\u7a0b\u5e8f\uff09\u9700\u8981\u4f7f\u7528\u8fd9\u4e9b\u5b9e\u4f8b\uff0c\u60a8\u53ef\u4ee5\u521b\u5efa\u4e00\u4e2a\u7b56\u7565\u5141\u8bb8\u90e8\u5206\u7528\u6237\u4f7f\u7528\u8fd9\u4e9b\u5b9e\u4f8b\u3002\u907f\u514d\u4e86\u5c06\u540c\u4e00\u4e2aAccessKey\u6cc4\u9732\u7ed9\u591a\u4eba\u7684\u98ce\u9669\u3002\n\n\u7528\u6237\u7ec4\n\n\uff1a\u60a8\u53ef\u4ee5\u521b\u5efa\u591a\u4e2a\u7528\u6237\u7ec4\uff0c\u5e76\u6388\u4e88\u4e0d\u540c\u6743\u9650\u7b56\u7565\uff0c\u8d77\u5230\u6279\u91cf\u7ba1\u7406\u7684\u6548\u679c\u3002\u4f8b\u5982\uff1a\n\n\u4e3a\u4e86\u52a0\u5f3a\u7f51\u7edc\u5b89\u5168\u63a7\u5236\uff0c\u60a8\u53ef\u4ee5\u7ed9\u67d0\u4e2a\u7528\u6237\u7ec4\u6388\u6743\u4e00\u4e2a\u6743\u9650\u7b56\u7565\uff0c\u8be5\u7b56\u7565\u53ef\u4ee5\u89c4\u5b9a\uff1a\u5982\u679c\u7528\u6237\u7684IP\u5730\u5740\u4e0d\u662f\u6765\u81ea\u4f01\u4e1a\u7f51\u7edc\uff0c\u5219\u62d2\u7edd\u6b64\u7c7b\u7528\u6237\u8bf7\u6c42\u8bbf\u95ee\u76f8\u5173ECS\u8d44\u6e90\u3002\n\u60a8\u53ef\u4ee5\u521b\u5efa\u4ee5\u4e0b\u4e24\u4e2a\u7528\u6237\u7ec4\u7ba1\u7406\u4e0d\u540c\u5de5\u4f5c\u804c\u8d23\u7684\u4eba\u5458\uff0c\u5982\u679c\u67d0\u5f00\u53d1\u4eba\u5458\u7684\u5de5\u4f5c\u804c\u8d23\u53d1\u751f\u8f6c\u53d8\uff0c\u6210\u4e3a\u4e00\u540d\u7cfb\u7edf\u7ba1\u7406\u4eba\u5458\uff0c\u60a8\u53ef\u4ee5\u5c06\u5176\u4eceDevelopers\u7528\u6237\u7ec4\u79fb\u5230SysAdmins\u7528\u6237\u7ec4\u3002\nSysAdmins\uff1a\u8be5\u7528\u6237\u7ec4\u9700\u8981\u521b\u5efa\u548c\u7ba1\u7406\u7684\u6743\u9650\u3002\u60a8\u53ef\u4ee5\u7ed9SysAdmins\u7ec4\u6388\u4e88\u4e00\u4e2a\u6743\u9650\u7b56\u7565\uff0c\u8be5\u7b56\u7565\u6388\u4e88\u7528\u6237\u7ec4\u6210\u5458\u6267\u884c\u6240\u6709ECS\u64cd\u4f5c\u7684\u6743\u9650\uff0c\u5305\u62ecECS\u5b9e\u4f8b\u3001\u955c\u50cf\u3001\u5feb\u7167\u548c\u5b89\u5168\u7ec4\u7b49\u3002\nDevelopers\uff1a\u8be5\u7528\u6237\u7ec4\u9700\u8981\u4f7f\u7528\u5b9e\u4f8b\u7684\u6743\u9650\u3002\u60a8\u53ef\u4ee5\u7ed9Developers\u7ec4\u6388\u4e88\u4e00\u4e2a\u6743\u9650\u7b56\u7565\uff0c\u8be5\u7b56\u7565\u6388\u4e88\u7528\u6237\u7ec4\u6210\u5458\u8c03\u7528DescribeInstances\u3001StartInstance\u3001StopInstance\u3001RunInstance\u548cDeleteInstance\u7b49\u6743\u9650\u3002\n1.3. \u6743\u9650\u7b56\u7565\n\u6743\u9650\u7b56\u7565\u5206\u4e3a\u7cfb\u7edf\u7b56\u7565\u548c\u81ea\u5b9a\u4e49\u7b56\u7565\u3002\n\n\u7cfb\u7edf\u7b56\u7565\n\n\uff1a\u963f\u91cc\u4e91\u63d0\u4f9b\u591a\u79cd\u5177\u6709\u4e0d\u540c\u7ba1\u7406\u76ee\u7684\u7684\u9ed8\u8ba4\u6743\u9650\u7b56\u7565\u3002\u4e91\u670d\u52a1\u5668ECS\u7ecf\u5e38\u4f7f\u7528\u7684\u7cfb\u7edf\u7b56\u7565\u6216\u8005RAM\u89d2\u8272\u5305\u542b\u7684\u9ed8\u8ba4\u7b56\u7565\u6709\uff1a\n\nAliyunECSReadOnlyAccess\uff1a\u53ea\u8bfb\u8bbf\u95ee\u4e91\u670d\u52a1\u5668ECS\u7684\u6743\u9650\u3002\nAliyunECSFullAccess\uff1a\u4e91\u670d\u52a1\u5668ECS\u7684\u7ba1\u7406\u5458\u7ea7\u522b\u6743\u9650\u3002\nAliyunECSNetworkInterfaceManagementAccess\uff1a\u7ba1\u7406\u5f39\u6027\u7f51\u5361\u7684\u6743\u9650\u3002\nAliyunECSImageImportDefaultRole\uff1a\u8be5\u89d2\u8272\u5305\u542b\u4e86\u5bfc\u5165\u81ea\u5b9a\u4e49\u955c\u50cf\u65f6\uff0c\u5141\u8bb8ECS\u8bbf\u95eeOSS\u7684\u6388\u6743\u6743\u9650\u3002\nAliyunECSImageExportDefaultRole\uff1a\u8be5\u89d2\u8272\u5305\u542b\u4e86\u5bfc\u51fa\u81ea\u5b9a\u4e49\u955c\u50cf\u65f6\uff0c\u5141\u8bb8ECS\u8bbf\u95eeOSS\u7684\u6388\u6743\u6743\u9650\u3002\nAliyunECSDiskEncryptDefaultRole\uff1a\u8be5\u89d2\u8272\u5305\u542b\u4e86\u52a0\u5bc6\u955c\u50cf\u65f6\uff0c\u5141\u8bb8ECS\u8bbf\u95eeKMS\u7684\u6388\u6743\u6743\u9650\u3002\n\u81ea\u5b9a\u4e49\u7b56\u7565\uff1a\u9700\u8981\u60a8\u7cbe\u51c6\u5730\u8bbe\u8ba1\u6743\u9650\u7b56\u7565\uff0c\u9002\u7528\u4e8e\u719f\u6089\u963f\u91cc\u4e91\u5404\u79cd\u4e91\u670d\u52a1API\u4ee5\u53ca\u5177\u6709\u7cbe\u7ec6\u5316\u63a7\u5236\u9700\u6c42\u7684\u7528\u6237\u3002\u5982\u4e0b\u6587\uff08\u53ef\u9009\uff09\u6b65\u9aa4\u4e8c\uff1a\u521b\u5efa\u81ea\u5b9a\u4e49\u6743\u9650\u7b56\u7565\u6b65\u9aa4\u4e2d\u521b\u5efa\u7684\u81ea\u5b9a\u4e49\u7b56\u7565\u3002\n\n1.4. \u524d\u63d0\u6761\u4ef6\n\u60a8\u5df2\u4f7f\u7528\u4e91\u8d26\u53f7\u767b\u5f55RAM\u63a7\u5236\u53f0\u3002\n\n1.5. \u64cd\u4f5c\u6b65\u9aa4\n\u672c\u6587\u793a\u4f8b\u4f7f\u7528\u4e3b\u8d26\u53f7\u5728RAM\u63a7\u5236\u53f0\u521b\u5efa\u4e00\u4e2aRAM\u7528\u6237\uff0c\u5e76\u6388\u4e88\u81ea\u5b9a\u4e49\u6743\u9650\u6216\u8005\u7cfb\u7edf\u6743\u9650\uff1a\n\n\u6b65\u9aa4\u4e00\uff1a\u521b\u5efaRAM\u7528\u6237\n\uff08\u53ef\u9009\uff09\u6b65\u9aa4\u4e8c\uff1a\u521b\u5efa\u81ea\u5b9a\u4e49\u6743\u9650\u7b56\u7565\n\u6b65\u9aa4\u4e09\uff1a\u6388\u6743RAM\u7528\u6237\n1.6. \u6b65\u9aa4\u4e00\uff1a\u521b\u5efaRAM\u7528\u6237\n\u6309\u4ee5\u4e0b\u6b65\u9aa4\u5728\u8bbf\u95ee\u63a7\u5236RAM\u63a7\u5236\u53f0\u521b\u5efa\u4e00\u4e2aRAM\u7528\u6237\uff1a\n\n\u5728\u5de6\u4fa7\u5bfc\u822a\u680f\u7684\u4eba\u5458\u7ba1\u7406\u83dc\u5355\u4e0b\uff0c\u5355\u51fb\u7528\u6237\u3002\n\n\u5355\u51fb\u65b0\u5efa\u7528\u6237\u3002\n\n\u8bf4\u660e \u5355\u51fb\u6dfb\u52a0\u7528\u6237\uff0c\u53ef\u4e00\u6b21\u6027\u521b\u5efa\u591a\u4e2aRAM\u7528\u6237\u3002\n\n\u8f93\u5165\u767b\u5f55\u540d\u79f0\u548c\u663e\u793a\u540d\u79f0\u3002\n\n\u5728\u8bbf\u95ee\u65b9\u5f0f\u533a\u57df\u4e0b\uff0c\u9009\u62e9\u63a7\u5236\u53f0\u5bc6\u7801\u767b\u5f55\u6216\u7f16\u7a0b\u8bbf\u95ee\u3002\n\n\u63a7\u5236\u53f0\u5bc6\u7801\u767b\u5f55\uff1a\u5b8c\u6210\u5bf9\u767b\u5f55\u5b89\u5168\u7684\u57fa\u672c\u8bbe\u7f6e\uff0c\u5305\u62ec\u81ea\u52a8\u751f\u6210\u6216\u81ea\u5b9a\u4e49\u767b\u5f55\u5bc6\u7801\u3001\u662f\u5426\u8981\u6c42\u4e0b\u6b21\u767b\u5f55\u65f6\u91cd\u7f6e\u5bc6\u7801\u4ee5\u53ca\u662f\u5426\u8981\u6c42\u5f00\u542f\u591a\u56e0\u7d20\u8ba4\u8bc1\u3002\n\u7f16\u7a0b\u8bbf\u95ee\uff1a\u81ea\u52a8\u4e3aRAM\u7528\u6237\u751f\u6210\u8bbf\u95ee\u5bc6\u94a5\uff08AccessKey\uff09\uff0c\u652f\u6301\u901a\u8fc7API\u6216\u5176\u4ed6\u5f00\u53d1\u5de5\u5177\u8bbf\u95ee\u963f\u91cc\u4e91\u3002\n\u8bf4\u660e \u4e3a\u4e86\u4fdd\u969c\u8d26\u53f7\u5b89\u5168\uff0c\u5efa\u8bae\u4ec5\u4e3aRAM\u7528\u6237\u9009\u62e9\u4e00\u79cd\u767b\u5f55\u65b9\u5f0f\uff0c\u907f\u514dRAM\u7528\u6237\u79bb\u5f00\u7ec4\u7ec7\u540e\u4ecd\u53ef\u4ee5\u901a\u8fc7\u8bbf\u95ee\u5bc6\u94a5\u8bbf\u95ee\u963f\u91cc\u4e91\u8d44\u6e90\u3002\n\n\u5355\u51fb\u786e\u8ba4\u3002\n\n\u521b\u5efaRAM\u7528\u6237\n\n1.7. \uff08\u53ef\u9009\uff09\u6b65\u9aa4\u4e8c\uff1a\u521b\u5efa\u81ea\u5b9a\u4e49\u6743\u9650\u7b56\u7565\n\u9664\u4e86\u4f7f\u7528\u963f\u91cc\u4e91\u63d0\u4f9b\u7684\u7cfb\u7edf\u6743\u9650\uff0c\u60a8\u8fd8\u53ef\u4ee5\u6309\u4ee5\u4e0b\u6b65\u9aa4\u5728\u8bbf\u95ee\u63a7\u5236RAM\u63a7\u5236\u53f0\u521b\u5efa\u4e00\u4e2a\u81ea\u5b9a\u4e49\u6743\u9650\u7b56\u7565\uff1a\n\n\u5728\u5de6\u4fa7\u5bfc\u822a\u680f\u7684\u6743\u9650\u7ba1\u7406\u83dc\u5355\u4e0b\uff0c\u5355\u51fb\u6743\u9650\u7b56\u7565\u7ba1\u7406\u3002\n\n\u5355\u51fb\u65b0\u5efa\u6743\u9650\u7b56\u7565\u3002\n\n\u586b\u5199\u7b56\u7565\u540d\u79f0\u548c\u5907\u6ce8\u3002\n\n\u914d\u7f6e\u6a21\u5f0f\u9009\u62e9\u53ef\u89c6\u5316\u914d\u7f6e\u6216\u811a\u672c\u914d\u7f6e\u3002\n\n\u53ef\u89c6\u5316\u914d\u7f6e\uff1a\u5355\u51fb\u6dfb\u52a0\u6388\u6743\u8bed\u53e5\uff0c\u6839\u636e\u754c\u9762\u63d0\u793a\uff0c\u5bf9\u6743\u9650\u6548\u529b\u3001\u64cd\u4f5c\u540d\u79f0\u548c\u8d44\u6e90\u7b49\u8fdb\u884c\u914d\u7f6e\u3002\u53ef\u89c6\u5316\u914d\u7f6e\u521b\u5efa\u81ea\u5b9a\u4e49\u7b56\u7565\n\u811a\u672c\u914d\u7f6e\uff1a\u8bf7\u53c2\u8003\u6743\u9650\u7b56\u7565\u8bed\u6cd5\u548c\u7ed3\u6784\u7f16\u8f91\u7b56\u7565\u5185\u5bb9\u3002\u811a\u672c\u65b9\u5f0f\u81ea\u5b9a\u4e49\u7b56\u7565\n\u9009\u62e9\u811a\u672c\u914d\u7f6e\u65f6\uff0cStatement\u7ed3\u6784\u4e0b\u7684Action\u548cResource\u53c2\u6570\u53d6\u503c\u8bf7\u53c2\u89c1\u9274\u6743\u5217\u8868\uff0c\u5176\u4ed6\u53c2\u6570\u53d6\u503c\u8bf7\u53c2\u89c1 \u300a\u8bbf\u95ee\u63a7\u5236\u6587\u6863\u300b \u6743\u9650\u7b56\u7565\u8bed\u6cd5\u548c\u7ed3\u6784\u3002\n\n\u811a\u672c\u914d\u7f6e\u7b56\u7565\u793a\u4f8b\u4e00\uff1a\u5141\u8bb8RAM\u7528\u6237\u521b\u5efa\u6309\u91cf\u4ed8\u8d39\u5b9e\u4f8b\u3002\n\n{\n    \"Statement\": [\n        {\n            \"Effect\": \"Allow\",\n            \"Action\": [\n                    \"ecs:DescribeImages\", \n                  \"vpc:DescribeVpcs\", \n                  \"vpc:DescribeVSwitches\", \n                  \"ecs:DescribeSecurityGroups\", \n                  \"ecs:DescribeKeyPairs\",\n                  \"ecs:DescribeTags\", \n                  \"ecs:RunInstances\"\n          ],\n            \"Resource\": \"*\"\n        }\n    ],\n    \"Version\": \"1\"\n}\nCopy\n\u811a\u672c\u914d\u7f6e\u7b56\u7565\u793a\u4f8b\u4e8c\uff1a\u5141\u8bb8RAM\u7528\u6237\u521b\u5efa\u5305\u5e74\u5305\u6708\u5b9e\u4f8b\u3002\u5176\u4e2d\n\nbss\n\n\u76f8\u5173API\u4e3b\u8981\u7528\u4e8e\u67e5\u770b\u5e76\u652f\u4ed8\u5305\u5e74\u5305\u6708\u8ba2\u5355\uff0c\u5176\u5bf9\u5e94\u7684\u7cfb\u7edf\u7b56\u7565\u4e3a\n\nAliyunBSSOrderAccess\nCopy\n\u3002\n\n{\n    \"Statement\": [\n        {\n            \"Effect\": \"Allow\",\n            \"Action\": [\n                    \"ecs:DescribeImages\", \n                  \"vpc:DescribeVpcs\", \n                  \"vpc:DescribeVSwitches\", \n                  \"ecs:DescribeSecurityGroups\", \n                  \"ecs:DescribeKeyPairs\",\n                  \"ecs:DescribeTags\", \n                  \"ecs:RunInstances\",\n                  \"bss:DescribeOrderList\",\n                  \"bss:DescribeOrderDetail\",\n                  \"bss:PayOrder\",\n                  \"bss:CancelOrder\"\n          ],\n            \"Resource\": \"*\"\n        }\n    ],\n    \"Version\": \"1\"\n}\nCopy\nsadljfkaj");
        return esBo;
    }

    public static class DocIndex {
        public static final String DOC_INDEX = "doc_document";
        public static final String DOC_TYPE = "doc_detail";
    }
}

