/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.document.impl.ability;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.document.api.ability.DocMaterialsPageQueryAbilityService;
import com.tydic.document.api.ability.bo.DocMaterialsPageQueryAbilityReqBo;
import com.tydic.document.api.common.bo.DocInfoMaterialDataBo;
import com.tydic.document.common.base.bo.DocReqPageBo;
import com.tydic.document.common.base.bo.DocRspPageBo;
import com.tydic.document.dao.DocInfoPicMateriaMapper;
import com.tydic.document.dao.po.DocInfoPicMateriaPo;
import com.tydic.document.impl.atom.api.DocDicMapQueryAtomService;
import com.tydic.document.impl.atom.api.bo.DocDicMapQueryAtomReqBo;
import com.tydic.document.impl.atom.api.bo.DocDicMapQueryAtomRspBo;
import com.tydic.document.utils.DocFileUtil;
import com.tydic.document.utils.DocRspBoUtil;
import com.tydic.document.utils.PageUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="docMaterialsPageQueryAbilityService")
@HSFProvider(serviceVersion="1.0", serviceGroup="DOCUMENT_GROUP", serviceInterface=DocMaterialsPageQueryAbilityService.class)
public class DocMaterialsPageQueryAbilityServiceImpl
implements DocMaterialsPageQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DocMaterialsPageQueryAbilityServiceImpl.class);
    @Autowired
    private DocInfoPicMateriaMapper docInfoPicMateriaMapper;
    @Autowired
    private DocDicMapQueryAtomService docDicMapQueryAtomService;

    public DocRspPageBo<DocInfoMaterialDataBo> queryMaterials(DocMaterialsPageQueryAbilityReqBo reqBo) {
        log.info("====================\u7d20\u6750\u5217\u8868\u67e5\u8be2\u670d\u52a1\u5f00\u59cb====================");
        log.info("\u5165\u53c2\uff1a" + reqBo);
        DocRspPageBo retBo = DocRspBoUtil.genSuccessBo(DocRspPageBo.class);
        retBo.getData().setPageNo(reqBo.getPageNo());
        List rows = retBo.getData().getRows();
        DocInfoPicMateriaPo queryPo = new DocInfoPicMateriaPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)queryPo);
        queryPo.setMateriaUserName(reqBo.getMaterialName());
        PageUtil.startPage((DocReqPageBo)reqBo);
        List<DocInfoPicMateriaPo> materialPos = this.docInfoPicMateriaMapper.selectByCondition(queryPo);
        PageUtil.fillPage(retBo, materialPos);
        Map<String, String> dicMap = this.getDicMap();
        if (CollectionUtils.isEmpty(materialPos)) {
            log.info("\u7d20\u6750\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
            return retBo;
        }
        for (DocInfoPicMateriaPo materialPo : materialPos) {
            DocInfoMaterialDataBo dataBo = new DocInfoMaterialDataBo();
            BeanUtils.copyProperties((Object)materialPo, (Object)dataBo);
            dataBo.setMateriaPath(DocFileUtil.getAbsolutePath(materialPo.getMateriaPath()));
            dataBo.setMateriaStatusDesc(dicMap.get(dataBo.getMateriaStatus() + ""));
            rows.add(dataBo);
        }
        log.info("====================\u7d20\u6750\u5217\u8868\u67e5\u8be2\u670d\u52a1\u7ed3\u675f====================");
        return retBo;
    }

    private Map<String, String> getDicMap() {
        DocDicMapQueryAtomReqBo atomReqBo = new DocDicMapQueryAtomReqBo();
        atomReqBo.setType("DOC_INFO_STATUS");
        DocDicMapQueryAtomRspBo atomRetBo = this.docDicMapQueryAtomService.queryDicMap(atomReqBo);
        return atomRetBo.getDicMap();
    }
}

