/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.document.impl.ability;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.document.api.ability.DocMaterialAddAbilityService;
import com.tydic.document.api.ability.bo.DocMaterialAddAbilityReqBo;
import com.tydic.document.api.ability.bo.DocMaterialAddAbilityRspBo;
import com.tydic.document.api.constants.DocDictionaryValueConstants;
import com.tydic.document.dao.DocInfoDocTypeMenuMapper;
import com.tydic.document.dao.DocInfoPicMateriaMapper;
import com.tydic.document.dao.po.DocInfoPicMateriaPo;
import com.tydic.document.utils.DocFileUtil;
import java.io.InputStream;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="docMaterialAddAbilityService")
@HSFProvider(serviceVersion="1.0", serviceGroup="DOCUMENT_GROUP", serviceInterface=DocMaterialAddAbilityService.class)
public class DocMaterialAddAbilityServiceImpl
implements DocMaterialAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DocMaterialAddAbilityServiceImpl.class);
    @Autowired
    private DocInfoPicMateriaMapper docInfoPicMateriaMapper;
    @Autowired
    private DocInfoDocTypeMenuMapper docInfoDocTypeMenuMapper;

    public DocMaterialAddAbilityRspBo addMaterial(DocMaterialAddAbilityReqBo reqBo) {
        int result;
        log.info("===================\u6587\u6863\u7d20\u6750\u4e0a\u4f20\u670d\u52a1\u5f00\u59cb=====================");
        log.info("\u5165\u53c2\uff1a" + reqBo);
        DocMaterialAddAbilityRspBo retBo = new DocMaterialAddAbilityRspBo();
        DocInfoPicMateriaPo materialPo = new DocInfoPicMateriaPo();
        if (!this.uploadMaterial(reqBo, materialPo)) {
            retBo.setRespCode("4004");
            retBo.setRespDesc("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25------------------");
            return retBo;
        }
        Date nowTime = this.docInfoDocTypeMenuMapper.getDbDate();
        BeanUtils.copyProperties((Object)reqBo, (Object)materialPo);
        materialPo.setMateriaUserName(reqBo.getMaterialUserName());
        materialPo.setCreateTime(nowTime);
        materialPo.setMateriaStatus(DocDictionaryValueConstants.DOC_INFO_STATUS_EFFECTIVE);
        if (StringUtils.isEmpty((Object)materialPo.getMateriaUserName())) {
            log.info("\u7528\u6237\u6ca1\u6709\u6307\u5b9a\u6587\u4ef6\u540d\uff0c\u9ed8\u8ba4\u4f7f\u7528\u6587\u4ef6\u540d\u79f0\u4f5c\u4e3a\u7528\u6237\u6307\u5b9a\u540d\u79f0");
            String materialName = materialPo.getMateriaName();
            materialPo.setMateriaUserName(materialName.substring(0, materialName.lastIndexOf(".")));
        }
        if ((result = this.docInfoPicMateriaMapper.insertSelective(materialPo)) < 1) {
            log.error("\u7d20\u6750\u4fe1\u606f\u6570\u636e\u5165\u5e93\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            retBo.setRespCode("4004");
            retBo.setRespDesc("\u7d20\u6750\u4fe1\u606f\u6570\u636e\u5165\u5e93\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            return retBo;
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        log.info("===================\u6587\u6863\u7d20\u6750\u4e0a\u4f20\u670d\u52a1\u7ed3\u675f=====================");
        return retBo;
    }

    private boolean uploadMaterial(DocMaterialAddAbilityReqBo reqBo, DocInfoPicMateriaPo materialPo) {
        InputStream inputStream;
        MultipartFile file = reqBo.getFile();
        String filename = file.getOriginalFilename();
        assert (filename != null);
        String suffix = filename.substring(filename.lastIndexOf(".") + 1);
        String uploadFileName = DocFileUtil.getRandomName() + "." + suffix;
        try {
            inputStream = file.getInputStream();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u6d41\u53d1\u751f\u5f02\u5e38:" + e);
            return false;
        }
        DocFileUtil.GroupType groupType = DocFileUtil.GroupType.getGroupType(1);
        assert (groupType != null);
        String fileTypePath = groupType.getValue();
        String filePath = DocFileUtil.fileUpload(inputStream, fileTypePath, uploadFileName);
        materialPo.setMateriaPath(filePath);
        materialPo.setMateriaName(filename);
        return true;
    }
}

