/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.document.impl.busi;

import com.tydic.document.api.busi.DocTypeDirectoryQueryBusiService;
import com.tydic.document.api.busi.bo.DocTypeDirectoryQueryBusiReqBo;
import com.tydic.document.api.busi.bo.DocTypeDirectoryQueryBusiRspBo;
import com.tydic.document.api.common.bo.DocTypeDirectoryDataBo;
import com.tydic.document.api.constants.DocConstants;
import com.tydic.document.api.constants.DocDictionaryValueConstants;
import com.tydic.document.dao.DocInfoDocDetailMapper;
import com.tydic.document.dao.DocInfoDocTypeContentMapper;
import com.tydic.document.dao.DocInfoDocTypeMenuMapper;
import com.tydic.document.dao.po.DocInfoDocDetailPo;
import com.tydic.document.dao.po.DocInfoDocTypeContentPo;
import com.tydic.document.dao.po.DocInfoDocTypeMenuPo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="docTypeDirectoryQueryBusiService")
public class DocTypeDirectoryQueryBusiServiceImpl
implements DocTypeDirectoryQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(DocTypeDirectoryQueryBusiServiceImpl.class);
    @Autowired
    private DocInfoDocTypeMenuMapper docInfoDocTypeMenuMapper;
    @Autowired
    private DocInfoDocDetailMapper docInfoDocDetailMapper;
    @Autowired
    private DocInfoDocTypeContentMapper docInfoDocTypeContentMapper;

    public DocTypeDirectoryQueryBusiRspBo queryDirectories(DocTypeDirectoryQueryBusiReqBo reqBo) {
        log.info("\u6587\u6863\u7c7b\u522b\u4e0b\u7684\u83dc\u5355\u67e5\u8be2Busi\u670d\u52a1\uff1a" + reqBo);
        DocTypeDirectoryQueryBusiRspBo retBo = new DocTypeDirectoryQueryBusiRspBo();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        if (StringUtils.isEmpty((Object)reqBo.getDirectoryStatus())) {
            log.info("\u9ed8\u8ba4\u67e5\u8be2\u72b6\u6001\u4e3a\u6709\u6548\u7684\u6570\u636e");
            reqBo.setDirectoryStatus(DocDictionaryValueConstants.DOC_INFO_STATUS_EFFECTIVE);
        }
        if (StringUtils.isEmpty((Object)reqBo.getDirectoryId())) {
            log.info("\u83dc\u5355ID\u4e3a\u7a7a\uff0c\u67e5\u8be2\u8be5\u7c7b\u522b\u4e0b\u7684\u6240\u6709\u9876\u7ea7\u76ee\u5f55");
            this.getAllTopDirectories(reqBo, retBo);
        } else {
            this.getSubDirectories(reqBo, retBo);
        }
        return retBo;
    }

    private void getAllTopDirectories(DocTypeDirectoryQueryBusiReqBo reqBo, DocTypeDirectoryQueryBusiRspBo retBo) {
        DocInfoDocTypeContentPo typeContentPo = this.docInfoDocTypeContentMapper.selectByPrimaryKey(reqBo.getTypeId());
        if (null == typeContentPo) {
            log.error("\u6ca1\u6709\u67e5\u5bfb\u5230\u6587\u6863\u7c7b\u522b\u5185\u5bb9\u8be6\u60c5");
            retBo.setRespCode("2001");
            retBo.setRespDesc("\u6ca1\u6709\u67e5\u5bfb\u5230\u6587\u6863\u7c7b\u522b\u5185\u5bb9\u8be6\u60c5");
            return;
        }
        BeanUtils.copyProperties((Object)typeContentPo, (Object)retBo);
        DocInfoDocTypeMenuPo queryPo = new DocInfoDocTypeMenuPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)queryPo);
        queryPo.setParentId(DocConstants.IS_PARENT_MENU);
        List<DocTypeDirectoryDataBo> directories = this.getDirectories(queryPo);
        retBo.setDirectories(directories);
    }

    private void getSubDirectories(DocTypeDirectoryQueryBusiReqBo reqBo, DocTypeDirectoryQueryBusiRspBo retBo) {
        List<DocInfoDocDetailPo> detailPos;
        ArrayList<DocTypeDirectoryDataBo> directories = new ArrayList<DocTypeDirectoryDataBo>();
        DocInfoDocDetailPo queryPo = new DocInfoDocDetailPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)queryPo);
        queryPo.setMenuId(reqBo.getDirectoryId());
        if (StringUtils.isEmpty((Object)reqBo.getDirectoryStatus())) {
            log.info("\u9ed8\u8ba4\u67e5\u8be2\u6709\u6548\u7684\u6587\u6863\u8be6\u60c5");
            queryPo.setDetailStatus(DocDictionaryValueConstants.DOC_INFO_STATUS_EFFECTIVE);
        }
        if (!CollectionUtils.isEmpty(detailPos = this.docInfoDocDetailMapper.selectByCondition(queryPo))) {
            for (DocInfoDocDetailPo detailPo : detailPos) {
                DocTypeDirectoryDataBo dataBo = new DocTypeDirectoryDataBo();
                BeanUtils.copyProperties((Object)dataBo, (Object)dataBo);
                dataBo.setDirectoryId(detailPo.getDetailId());
                dataBo.setDirectoryName(detailPo.getDetailName());
                dataBo.setIsDirectory(DocConstants.NOT_DIRECTORY);
                dataBo.setDirectoryDesc(detailPo.getDetailDesc());
                dataBo.setDirectoryStatus(detailPo.getDetailStatus());
                directories.add(dataBo);
            }
        } else {
            log.info("\u8be5\u76ee\u5f55\uff08" + reqBo.getDirectoryId() + "\uff09\u4e0b\u6ca1\u6709\u6587\u6863\u8be6\u60c5\u4fe1\u606f");
        }
        DocInfoDocTypeMenuPo queryMenuPo = new DocInfoDocTypeMenuPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)queryMenuPo);
        queryMenuPo.setParentId(reqBo.getDirectoryId());
        List<DocTypeDirectoryDataBo> subdirectories = this.getDirectories(queryMenuPo);
        directories.addAll(subdirectories);
        retBo.setDirectories(directories);
    }

    private List<DocTypeDirectoryDataBo> getDirectories(DocInfoDocTypeMenuPo queryPo) {
        ArrayList<DocTypeDirectoryDataBo> directories = new ArrayList<DocTypeDirectoryDataBo>();
        List<DocInfoDocTypeMenuPo> menuPos = this.docInfoDocTypeMenuMapper.selectByCondition(queryPo);
        if (CollectionUtils.isEmpty(menuPos)) {
            log.info("\u5b50\u76ee\u5f55\u4e3a\u7a7a");
            return directories;
        }
        for (DocInfoDocTypeMenuPo menuPo : menuPos) {
            DocTypeDirectoryDataBo dataBo = new DocTypeDirectoryDataBo();
            BeanUtils.copyProperties((Object)dataBo, (Object)dataBo);
            dataBo.setDirectoryId(menuPo.getMenuId());
            dataBo.setDirectoryName(menuPo.getMenuName());
            dataBo.setIsDirectory(DocConstants.IS_DIRECTORY);
            dataBo.setDirectoryDesc(menuPo.getMenuDesc());
            dataBo.setDirectoryStatus(menuPo.getMenuStatus());
            directories.add(dataBo);
        }
        return directories;
    }
}

