/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrVersionListReqBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrVersionListRspBo;
import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.service.agr.AgrGetAgrVersionService;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrVersionBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrVersionReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrVersionRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrGetAgrVersionService"})
public class AgrGetAgrVersionServiceImpl
implements AgrGetAgrVersionService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;

    @PostMapping(value={"getAgrVersionList"})
    public AgrGetAgrVersionRspBO getAgrVersionList(@RequestBody AgrGetAgrVersionReqBO reqBO) {
        this.validateParam(reqBO);
        AgrGetAgrVersionListReqBo agrGetAgrVersionListReqBo = AgrRu.js(reqBO, AgrGetAgrVersionListReqBo.class);
        AgrGetAgrVersionListRspBo agrGetAgrVersionListRspBo = this.iAgrAgrModel.getAgrVersionList(agrGetAgrVersionListReqBo);
        AgrGetAgrVersionRspBO rspBO = AgrRu.js((Object)agrGetAgrVersionListRspBo, AgrGetAgrVersionRspBO.class);
        this.translation(rspBO);
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void validateParam(AgrGetAgrVersionReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAgrId() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[agrId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void translation(AgrGetAgrVersionRspBO rspBo) {
        List agrAgrVersionList = rspBo.getRows();
        if (CollectionUtil.isNotEmpty((Collection)agrAgrVersionList)) {
            Map<String, Map<String, DicDictionaryBo>> dicMap;
            AgrAgrVersionBo agrAgrVersion = (AgrAgrVersionBo)agrAgrVersionList.get(0);
            ArrayList<String> pCodeList = new ArrayList<String>();
            if (ObjectUtil.isNotNull((Object)agrAgrVersion.getVersionStatus())) {
                pCodeList.add("VERSION_STATUS_PCODE");
            }
            if (ObjectUtil.isNotNull((Object)agrAgrVersion.getChngType())) {
                pCodeList.add("CHANGE_TYPE_PCODE_2");
            }
            if (MapUtil.isNotEmpty(dicMap = this.iAgrDictionaryModel.selectByPCodeListToMap(pCodeList))) {
                for (AgrAgrVersionBo agrVersion : agrAgrVersionList) {
                    agrVersion.setVersionStatusStr(MapUtil.isEmpty(dicMap.get("VERSION_STATUS_PCODE")) ? null : dicMap.get("VERSION_STATUS_PCODE").get(agrVersion.getVersionStatus().toString()).getTitle());
                    agrVersion.setChngTypeStr(MapUtil.isEmpty(dicMap.get("CHANGE_TYPE_PCODE_2")) ? null : dicMap.get("CHANGE_TYPE_PCODE_2").get(agrVersion.getChngType().toString()).getTitle());
                }
            }
        }
    }
}

