/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agrchange;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrChngAccessory;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.service.agrchange.AgrGetAgrChngApplyDetailService;
import com.tydic.dyc.agr.service.agrchange.bo.AgrChngAccessoryBo;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agrchange.AgrGetAgrChngApplyDetailService"})
public class AgrGetAgrChngApplyDetailServiceImpl
implements AgrGetAgrChngApplyDetailService {
    private static final Logger log = LoggerFactory.getLogger(AgrGetAgrChngApplyDetailServiceImpl.class);
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;
    @Autowired
    private IAgrAuditOrderModel iAgrAuditOrderModel;

    @PostMapping(value={"getAgrChngApplyDetail"})
    public AgrGetAgrChngApplyDetailRspBO getAgrChngApplyDetail(@RequestBody AgrGetAgrChngApplyDetailReqBO reqBO) {
        this.validationParam(reqBO);
        AgrChngApplyDo agrChngApplyDo = this.iAgrChngApplyModel.getAgrChngApplyDetail(AgrRu.js(reqBO, AgrAgrChngApplyQryBo.class));
        AgrGetAgrChngApplyDetailRspBO rspBO = this.typeEscape(agrChngApplyDo);
        if (agrChngApplyDo != null && agrChngApplyDo.getChngApplyId() != null) {
            rspBO.setProcInstId(this.qryProInstId(agrChngApplyDo));
            rspBO.setBusiProclnstld(this.qryBusiProInstId(agrChngApplyDo));
        }
        return rspBO;
    }

    private String qryBusiProInstId(AgrChngApplyDo agrChngApplyDo) {
        String procInstId = "";
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        agrProcInstDo.setOrderId(agrChngApplyDo.getAgrId());
        agrProcInstDo.setObjId(agrChngApplyDo.getChngApplyId());
        agrProcInstDo.setObjType(AgrCommConstant.ObjType.CHANGE);
        agrProcInstDo.setOrderBy("id desc LIMIT 1");
        AgrProcInstDo agrProcInstDo1 = this.iAgrProcInstModel.getProcInst(agrProcInstDo);
        if (agrProcInstDo1 != null) {
            procInstId = agrProcInstDo1.getProcInstId();
        }
        return procInstId;
    }

    private String qryProInstId(AgrChngApplyDo agrChngApplyDo) {
        String procInstId = "";
        AgrAuditOrderQryBo agrAuditOrderQryBo = new AgrAuditOrderQryBo();
        agrAuditOrderQryBo.setObjId(agrChngApplyDo.getChngApplyId());
        agrAuditOrderQryBo.setObjType(AgrCommConstant.ObjType.CHANGE);
        agrAuditOrderQryBo.setOrderId(agrChngApplyDo.getAgrId());
        agrAuditOrderQryBo.setOrderBy("id desc");
        AgrAuditOrderDo agrAuditOrderDo = this.iAgrAuditOrderModel.getAuditObj(agrAuditOrderQryBo);
        if (!CollectionUtils.isEmpty(agrAuditOrderDo.getUocApprovalObj())) {
            Long auditOrderId = agrAuditOrderDo.getUocApprovalObj().get(0).getAuditOrderId();
            AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
            agrProcInstDo.setOrderId(agrChngApplyDo.getAgrId());
            agrProcInstDo.setObjId(auditOrderId);
            agrProcInstDo.setObjType(AgrCommConstant.ObjType.APPROVE);
            AgrProcInstDo agrProcInstDo1 = this.iAgrProcInstModel.getProcInst(agrProcInstDo);
            if (agrProcInstDo1 != null) {
                procInstId = agrProcInstDo1.getProcInstId();
            }
        }
        return procInstId;
    }

    private AgrGetAgrChngApplyDetailRspBO typeEscape(AgrChngApplyDo agrChngApplyDo) {
        AgrGetAgrChngApplyDetailRspBO rspBO = AgrRu.js(agrChngApplyDo, AgrGetAgrChngApplyDetailRspBO.class);
        if (agrChngApplyDo.getChngApplyId() != null) {
            rspBO.setChngTypeStr(AgrCommConstant.AgrChngTypeEnum.getValueByCode((Integer)rspBO.getChngType()));
            rspBO.setChngApplyStatusStr(AgrCommConstant.ChngApplyStatusEnum.getNameByValue((Integer)AgrRu.parseInteger(rspBO.getChngApplyStatus())));
            List<AgrChngAccessory> agrChngAccessory = agrChngApplyDo.getAgrChngAccessory();
            rspBO.setAgrChngAccessory(AgrRu.jsl(agrChngAccessory, AgrChngAccessoryBo.class));
        }
        return rspBO;
    }

    private void validationParam(AgrGetAgrChngApplyDetailReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getAgrId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61[\u534f\u8baeID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61[\u534f\u8bae\u53d8\u66f4\u7533\u8bf7ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

