/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agrchange;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryReqPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryRspPageBo;
import com.tydic.dyc.agr.service.agrchange.AgrGetAgrItemChngListService;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrItemChngListReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrItemChngListRspBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrItemChngBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agrchange.AgrGetAgrItemChngListService"})
public class AgrGetAgrItemChngListServiceImpl
implements AgrGetAgrItemChngListService {
    private static final Logger log = LoggerFactory.getLogger(AgrGetAgrItemChngListServiceImpl.class);
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @PostMapping(value={"getAgrItemChngList"})
    public AgrGetAgrItemChngListRspBO getAgrItemChngList(@RequestBody AgrGetAgrItemChngListReqBO reqBO) {
        this.validationParam(reqBO);
        AgrItemChngListQryReqPageBo qryReqPageBo = AgrRu.js(reqBO, AgrItemChngListQryReqPageBo.class);
        AgrItemChngListQryRspPageBo agrItemChngList = this.iAgrChngApplyModel.getAgrItemChngList(qryReqPageBo);
        return this.setRspBoInfo(agrItemChngList);
    }

    private AgrGetAgrItemChngListRspBO setRspBoInfo(AgrItemChngListQryRspPageBo agrItemChngList) {
        AgrGetAgrItemChngListRspBO rspBO = AgrRu.js(agrItemChngList, AgrGetAgrItemChngListRspBO.class);
        List rows = new ArrayList();
        if (!ObjectUtil.isEmpty(agrItemChngList.getRows())) {
            rows = JSONArray.parseArray((String)JSON.toJSONString(agrItemChngList.getRows())).toJavaList(AgrItemChngBo.class);
        }
        rows.forEach(agrItemChngBo -> agrItemChngBo.setItemChngTypeStr(AgrCommConstant.AgrItemChngTypeEnum.getValueByCode((Integer)agrItemChngBo.getItemChngType())));
        rows.forEach(agrItemChngBo -> {
            if (agrItemChngBo.getWhetherOil() != null) {
                agrItemChngBo.setWhetherOilStr(AgrCommConstant.IsOilPcodeEnum.getValueByCode((Integer)agrItemChngBo.getWhetherOil()));
            }
        });
        rspBO.setRows(rows);
        return rspBO;
    }

    private void validationParam(AgrGetAgrItemChngListReqBO reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getChngApplyId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d8\u66f4\u7533\u8bf7ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getAgrId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8baeID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPageNo())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5f53\u524d\u9875]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPageSize())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u67e5\u8be2\u6bcf\u9875\u6761\u6570]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

