/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.repository.impl;

import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuBtnRspBo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuListBo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryRspBo;
import com.tydic.dyc.authority.model.menu.qrybo.SysRoleMenuBtnRspBo;
import com.tydic.dyc.authority.model.menu.sub.SysMenuBtnDo;
import com.tydic.dyc.authority.model.menu.sub.SysMenuDomainSubDo;
import com.tydic.dyc.authority.model.menu.sub.SysRoleMenuBtnDo;
import com.tydic.dyc.authority.repository.SysMenuRepository;
import com.tydic.dyc.authority.repository.dao.SysMenuBtnMapper;
import com.tydic.dyc.authority.repository.dao.SysMenuDomainMapper;
import com.tydic.dyc.authority.repository.dao.SysMenuMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleMenuBtnMapper;
import com.tydic.dyc.authority.repository.po.SysMenuBtnPo;
import com.tydic.dyc.authority.repository.po.SysMenuDomainPo;
import com.tydic.dyc.authority.repository.po.SysMenuPo;
import com.tydic.dyc.authority.repository.po.SysRoleMenuBtnPo;
import com.tydic.dyc.authority.utils.AuthRu;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysMenuRepositoryImpl
implements SysMenuRepository {
    private static final Logger log = LoggerFactory.getLogger(SysMenuRepositoryImpl.class);
    @Autowired
    private SysMenuMapper sysMenuMapper;
    @Autowired
    private SysMenuDomainMapper sysMenuDomainMapper;
    @Autowired
    private SysMenuBtnMapper sysMenuBtnMapper;
    @Autowired
    private SysRoleMenuBtnMapper sysRoleMenuBtnMapper;

    public SysMenuDo createMenuInfo(SysMenuDo reqDo) {
        SysMenuPo sysMenuPo = (SysMenuPo)AuthRu.js((Object)reqDo, SysMenuPo.class);
        SysMenuPo countWherePo = new SysMenuPo();
        if (sysMenuPo.getParentId() != null) {
            countWherePo.setParentId(sysMenuPo.getParentId());
        } else {
            countWherePo.setParentIdNull(0L);
        }
        int menuCount = this.sysMenuMapper.getCheckBy(countWherePo);
        sysMenuPo.setSort(menuCount + 1);
        this.sysMenuMapper.insert(sysMenuPo);
        return reqDo;
    }

    public SysMenuDo modifyMenuInfo(SysMenuDo reqDo) {
        SysMenuPo sysMenuPo = (SysMenuPo)AuthRu.js((Object)reqDo, SysMenuPo.class);
        SysMenuPo wherePo = new SysMenuPo();
        wherePo.setMenuId(reqDo.getMenuId());
        wherePo.setMenuIds(reqDo.getMenuIds());
        this.sysMenuMapper.updateBy(sysMenuPo, wherePo);
        return reqDo;
    }

    public SysMenuQryRspBo getMenuList(SysMenuQryBo qryBo) {
        SysMenuPo sysMenuPo = (SysMenuPo)AuthRu.js((Object)qryBo, SysMenuPo.class);
        sysMenuPo.setOrderBy("deep,sort");
        List<SysMenuPo> listPage = this.sysMenuMapper.getList(sysMenuPo);
        List rspDo = AuthRu.jsl(listPage, SysMenuDo.class);
        SysMenuQryRspBo sysMenuQryRspBo = new SysMenuQryRspBo();
        sysMenuQryRspBo.setRows(rspDo);
        return sysMenuQryRspBo;
    }

    public SysMenuDo getMenuInfoDetails(SysMenuQryBo qryBo) {
        SysMenuPo sysMenuPo = new SysMenuPo();
        sysMenuPo.setMenuId(qryBo.getMenuId());
        sysMenuPo.setParentId(qryBo.getParentId());
        sysMenuPo.setSort(qryBo.getSort());
        sysMenuPo.setMenuCode(qryBo.getMenuCode());
        SysMenuPo modelBy = this.sysMenuMapper.getModelBy(sysMenuPo);
        return (SysMenuDo)AuthRu.js((Object)modelBy, SysMenuDo.class);
    }

    public SysMenuDo getMenuDomainList() {
        SysMenuDomainPo sysMenuDomainPo = new SysMenuDomainPo();
        List<SysMenuDomainPo> list = this.sysMenuDomainMapper.getList(sysMenuDomainPo);
        SysMenuDo sysMenuDo = new SysMenuDo();
        sysMenuDo.setSysMenuDomainSubDos(AuthRu.jsl(list, SysMenuDomainSubDo.class));
        return sysMenuDo;
    }

    public void updateSortBatch(SysMenuListBo sysMenuListBo) {
        List sysMenuPos = AuthRu.jsl((List)sysMenuListBo.getSysMenuDos(), SysMenuPo.class);
        for (SysMenuPo sysMenuPo : sysMenuPos) {
            this.sysMenuMapper.updateById(sysMenuPo);
        }
    }

    public SysMenuBtnRspBo getMenuBtnList(SysMenuQryBo qryBo) {
        SysMenuBtnPo sysMenuBtnPo = new SysMenuBtnPo();
        sysMenuBtnPo.setMenuId(qryBo.getMenuId());
        List<SysMenuBtnPo> list = this.sysMenuBtnMapper.getList(sysMenuBtnPo);
        SysMenuBtnRspBo sysMenuBtnRspBo = new SysMenuBtnRspBo();
        sysMenuBtnRspBo.setRows(AuthRu.jsl(list, SysMenuBtnDo.class));
        return sysMenuBtnRspBo;
    }

    public SysRoleMenuBtnRspBo getRoleMenuBtnList(SysMenuQryBo qryBo) {
        SysRoleMenuBtnPo sysRoleMenuBtnPo = new SysRoleMenuBtnPo();
        sysRoleMenuBtnPo.setRoleId(qryBo.getRoleId());
        sysRoleMenuBtnPo.setMenuId(qryBo.getMenuId());
        List<SysRoleMenuBtnPo> list = this.sysRoleMenuBtnMapper.getList(sysRoleMenuBtnPo);
        SysRoleMenuBtnRspBo sysRoleMenuBtnRspBo = new SysRoleMenuBtnRspBo();
        sysRoleMenuBtnRspBo.setRows(AuthRu.jsl(list, SysRoleMenuBtnDo.class));
        return sysRoleMenuBtnRspBo;
    }

    public SysMenuDo modifyMenuInfoByTreePath(SysMenuDo reqDo) {
        SysMenuPo sysMenuPo = (SysMenuPo)AuthRu.js((Object)reqDo, SysMenuPo.class);
        SysMenuPo wherePo = new SysMenuPo();
        wherePo.setEnableMenuTreePath(reqDo.getEnableMenuTreePath());
        this.sysMenuMapper.updateBy(sysMenuPo, wherePo);
        return reqDo;
    }
}

