/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.pay.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.cfc.ability.api.CfcQryImportTemplateListAbilityService;
import com.tydic.cfc.ability.bo.CfcImportTemplateBO;
import com.tydic.cfc.ability.bo.CfcQryImportTemplateListAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryImportTemplateListAbilityRspBO;
import com.tydic.dyc.fsc.pay.api.DycFscExportBillUploadModelService;
import com.tydic.dyc.fsc.pay.api.DycFscInvoiceForOrderExcelExportService;
import com.tydic.dyc.fsc.pay.bo.CellData;
import com.tydic.dyc.fsc.pay.bo.DycFscExportBillUploadModelReqBO;
import com.tydic.dyc.fsc.pay.bo.DycFscExportBillUploadModelRspBO;
import com.tydic.dyc.fsc.pay.bo.DycFscOrderInvoiceBO;
import com.tydic.dyc.fsc.pay.bo.DycFscOrderitemDetailBO;
import com.tydic.dyc.fsc.pay.bo.DycInvoiceForOrderExcelExportReqBO;
import com.tydic.dyc.fsc.pay.bo.DycInvoiceForOrderExcelExportRspBO;
import com.tydic.fsc.constants.FscConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLDecoder;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.fsc.pay.api.DycFscInvoiceForOrderExcelExportService"})
public class DycFscInvoiceForOrderExcelExportServiceImpl
implements DycFscInvoiceForOrderExcelExportService {
    private static final Logger log = LoggerFactory.getLogger(DycFscInvoiceForOrderExcelExportServiceImpl.class);
    @Autowired
    private CfcQryImportTemplateListAbilityService cfcQryImportTemplateListAbilityService;
    @Autowired
    private DycFscExportBillUploadModelService dycFscExportBillUploadModelService;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "dyc-common/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Value(value="${obs.fileUrl:}")
    private String obsFileUrl;
    @Value(value="${obs.accessUrl:}")
    private String obsAccessUrl;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${upload.uploadTime:3}")
    private Integer uploadTime;
    private static final String REDIS_KEY_PREFIX = "UPLOAD_FILE_PREFIX_";
    private String downloadFile = "/downloadFile/";
    @Value(value="${dyc.file.inst.data.path:dyc/file/instData}")
    private String instDataPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PostMapping(value={"exportExcel"})
    public DycInvoiceForOrderExcelExportRspBO exportExcel(@RequestBody DycInvoiceForOrderExcelExportReqBO reqBO) {
        DycFscExportBillUploadModelReqBO dycFscExportBillUploadModelReqBO = (DycFscExportBillUploadModelReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycFscExportBillUploadModelReqBO.class));
        DycFscExportBillUploadModelRspBO dycFscExportBillUploadModelRspBO = this.dycFscExportBillUploadModelService.exportBillUploadModel(dycFscExportBillUploadModelReqBO);
        CfcQryImportTemplateListAbilityReqBO cfcQryImportTemplateListAbilityReqBO = new CfcQryImportTemplateListAbilityReqBO();
        cfcQryImportTemplateListAbilityReqBO.setImportTemplateNo("DDJSDFPXXSC");
        CfcQryImportTemplateListAbilityRspBO cfcQryImportTemplateListAbilityRspBO = this.cfcQryImportTemplateListAbilityService.qryImportTemplateList(cfcQryImportTemplateListAbilityReqBO);
        String urlLocation = ((CfcImportTemplateBO)cfcQryImportTemplateListAbilityRspBO.getRows().get(0)).getImportTemplateUrl();
        DycInvoiceForOrderExcelExportRspBO rspBO = new DycInvoiceForOrderExcelExportRspBO();
        InputStream is = null;
        HttpURLConnection urlConnection = null;
        ByteArrayOutputStream dstStream = null;
        ByteArrayInputStream inputStream = null;
        try {
            List<CellData> itemDataListRow2;
            List<CellData> orderDataListRow1;
            XSSFSheet sheet;
            log.info("\u8bf7\u6c42\u8bfb {}", (Object)urlLocation);
            if (urlLocation.startsWith("/")) {
                urlLocation = urlLocation.substring(1);
            }
            String s = URLDecoder.decode(urlLocation, "utf-8");
            log.info("\u66ff\u6362\u540e\u7684\u8def\u5f84 {} ", (Object)s);
            is = this.fileClient.downLoadToInputStream(s);
            XSSFWorkbook workbook = new XSSFWorkbook(is);
            if (!Objects.isNull(dycFscExportBillUploadModelRspBO.getDycFscOrderInvoiceBO())) {
                sheet = workbook.getSheetAt(1);
                orderDataListRow1 = this.getCellData(1, 0, 9, workbook);
                itemDataListRow2 = this.getCellData(1, 1, 9, workbook);
                this.insertInvoiceToSheet(0, dycFscExportBillUploadModelRspBO, sheet, orderDataListRow1, itemDataListRow2);
            }
            if (CollectionUtils.isNotEmpty(dycFscExportBillUploadModelRspBO.getFscOrderItemDetailBOS())) {
                sheet = workbook.getSheetAt(2);
                orderDataListRow1 = this.getCellData(2, 0, 19, workbook);
                itemDataListRow2 = this.getCellData(2, 1, 19, workbook);
                this.insertDetailToSheet(0, dycFscExportBillUploadModelRspBO, sheet, orderDataListRow1, itemDataListRow2, reqBO);
            }
            String fileName = "\u7ed3\u7b97-\u5bfc\u51fa\u5f00\u7968\u4e0a\u4f20\u8be6\u60c5\u6a21\u677f.xlsx";
            dstStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)dstStream);
            byte[] bytes = dstStream.toByteArray();
            inputStream = new ByteArrayInputStream(bytes);
            this.upload(inputStream, fileName, rspBO);
            urlConnection.disconnect();
            is.close();
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (dstStream != null) {
                    dstStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rspBO;
    }

    private void upload(InputStream inputStream, String fileName, DycInvoiceForOrderExcelExportRspBO rspBO) {
        String fileUrl;
        String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
        if (!this.instDataPath.endsWith("/")) {
            this.instDataPath = this.instDataPath + "/";
        }
        String path = this.fileClient.uploadFileByInputStream(this.instDataPath + fileDir, fileName, inputStream);
        if ("OSS".equals(this.fileType)) {
            fileUrl = "/" + path;
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else if ("OBS".equals(this.fileType)) {
            fileUrl = "/" + path;
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        rspBO.setName(fileName);
        rspBO.setUrl(fileUrl);
    }

    private void insertInvoiceToSheet(int startRowIndex, DycFscExportBillUploadModelRspBO dycFscExportBillUploadModelRspBO, XSSFSheet sheet, List<CellData> orderDataListRow1, List<CellData> orderDataListRow2) {
        CellData cellData;
        XSSFCell cell;
        int i;
        DycFscOrderInvoiceBO dycFscOrderInvoiceBO = dycFscExportBillUploadModelRspBO.getDycFscOrderInvoiceBO();
        if (Objects.isNull(sheet.getRow(startRowIndex))) {
            sheet.createRow(startRowIndex);
        }
        XSSFRow startRow = sheet.getRow(startRowIndex);
        startRow.setHeight(orderDataListRow1.get(0).getRowHeight());
        for (i = 0; i < orderDataListRow1.size(); ++i) {
            if (Objects.isNull(orderDataListRow1.get(i))) continue;
            if (Objects.isNull(startRow.getCell(i))) {
                startRow.createCell(i);
            }
            cell = startRow.getCell(i);
            cellData = orderDataListRow1.get(i);
            cell.setCellStyle((CellStyle)cellData.getStyle());
            cell.setCellValue(cellData.getData());
            startRow.setHeight(cellData.getRowHeight());
            sheet.setColumnWidth(i, cellData.getColumnWeight());
        }
        if (Objects.isNull(sheet.getRow(++startRowIndex))) {
            sheet.createRow(startRowIndex);
        }
        startRow = sheet.getRow(startRowIndex);
        block12: for (i = 0; i < orderDataListRow2.size(); ++i) {
            if (Objects.isNull(orderDataListRow2.get(i))) continue;
            if (Objects.isNull(startRow.getCell(i))) {
                startRow.createCell(i);
            }
            cell = startRow.getCell(i);
            cellData = orderDataListRow2.get(i);
            cell.setCellStyle((CellStyle)cellData.getStyle());
            cell.setCellValue(cellData.getData());
            startRow.setHeight(cellData.getRowHeight());
            sheet.setColumnWidth(i, cellData.getColumnWeight());
            switch (i) {
                case 0: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getOrderNo());
                    continue block12;
                }
                case 1: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getInvoiceTypeStr());
                    continue block12;
                }
                case 2: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getBuyName());
                    continue block12;
                }
                case 3: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getTaxNo());
                    continue block12;
                }
                case 4: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getAddress());
                    continue block12;
                }
                case 5: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getPhone());
                    continue block12;
                }
                case 6: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getBank());
                    continue block12;
                }
                case 7: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getAccount());
                    continue block12;
                }
                case 8: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getTotalCharge().toString());
                    continue block12;
                }
            }
        }
    }

    private void insertDetailToSheet(int startRowIndex, DycFscExportBillUploadModelRspBO dycFscExportBillUploadModelRspBO, XSSFSheet sheet, List<CellData> orderDataListRow1, List<CellData> orderDataListRow2, DycInvoiceForOrderExcelExportReqBO reqBO) {
        List<DycFscOrderitemDetailBO> fscOrderItemDetailBOS = dycFscExportBillUploadModelRspBO.getFscOrderItemDetailBOS();
        if (Objects.isNull(sheet.getRow(startRowIndex))) {
            sheet.createRow(startRowIndex);
        }
        XSSFRow startRow = sheet.getRow(startRowIndex);
        startRow.setHeight(orderDataListRow1.get(0).getRowHeight());
        for (int i = 0; i < orderDataListRow1.size(); ++i) {
            if (Objects.isNull(orderDataListRow1.get(i))) continue;
            if (Objects.isNull(startRow.getCell(i))) {
                startRow.createCell(i);
            }
            XSSFCell cell = startRow.getCell(i);
            CellData cellData = orderDataListRow1.get(i);
            cell.setCellStyle((CellStyle)cellData.getStyle());
            cell.setCellValue(cellData.getData());
            startRow.setHeight(cellData.getRowHeight());
            sheet.setColumnWidth(i, cellData.getColumnWeight());
        }
        for (DycFscOrderitemDetailBO fscOrderItemDetailBO : fscOrderItemDetailBOS) {
            if (Objects.isNull(sheet.getRow(++startRowIndex))) {
                sheet.createRow(startRowIndex);
            }
            DycFscOrderInvoiceBO fscOrderInvoiceBO = null;
            if (FscConstants.YesOrNoEnum.YES.getCode().equals(reqBO.getIsAutoTest())) {
                fscOrderInvoiceBO = this.generateAutoTestFakeData(dycFscExportBillUploadModelRspBO);
            }
            startRow = sheet.getRow(startRowIndex);
            block23: for (int i = 0; i < orderDataListRow2.size(); ++i) {
                if (Objects.isNull(orderDataListRow2.get(i))) continue;
                if (Objects.isNull(startRow.getCell(i))) {
                    startRow.createCell(i);
                }
                XSSFCell cell = startRow.getCell(i);
                CellData cellData = orderDataListRow2.get(i);
                cell.setCellStyle((CellStyle)cellData.getStyle());
                cell.setCellValue(cellData.getData());
                startRow.setHeight(cellData.getRowHeight());
                sheet.setColumnWidth(i, cellData.getColumnWeight());
                switch (i) {
                    case 0: {
                        cell.setCellValue(fscOrderItemDetailBO.getOrderNo());
                        continue block23;
                    }
                    case 1: {
                        if (!FscConstants.YesOrNoEnum.YES.getCode().equals(reqBO.getIsAutoTest()) || null == fscOrderInvoiceBO) continue block23;
                        cell.setCellValue(fscOrderInvoiceBO.getInvoiceCode());
                        continue block23;
                    }
                    case 2: {
                        if (!FscConstants.YesOrNoEnum.YES.getCode().equals(reqBO.getIsAutoTest()) || null == fscOrderInvoiceBO) continue block23;
                        cell.setCellValue(fscOrderInvoiceBO.getInvoiceNo());
                        continue block23;
                    }
                    case 3: {
                        if (!FscConstants.YesOrNoEnum.YES.getCode().equals(reqBO.getIsAutoTest()) || null == fscOrderInvoiceBO) continue block23;
                        cell.setCellValue(fscOrderInvoiceBO.getVerificationCode());
                        continue block23;
                    }
                    case 4: {
                        if (!FscConstants.YesOrNoEnum.YES.getCode().equals(reqBO.getIsAutoTest()) || null == fscOrderInvoiceBO) continue block23;
                        cell.setCellValue(fscOrderInvoiceBO.getBillDate());
                        continue block23;
                    }
                    case 5: {
                        cell.setCellValue(fscOrderItemDetailBO.getOrderCode());
                        continue block23;
                    }
                    case 6: {
                        cell.setCellValue(fscOrderItemDetailBO.getPurchaserName());
                        continue block23;
                    }
                    case 7: {
                        cell.setCellValue(fscOrderItemDetailBO.getProductId());
                        continue block23;
                    }
                    case 8: {
                        cell.setCellValue(fscOrderItemDetailBO.getSkuNo());
                        continue block23;
                    }
                    case 9: {
                        cell.setCellValue(fscOrderItemDetailBO.getSkuName());
                        continue block23;
                    }
                    case 10: {
                        cell.setCellValue(fscOrderItemDetailBO.getSpecModel());
                        continue block23;
                    }
                    case 11: {
                        cell.setCellValue(fscOrderItemDetailBO.getUnit());
                        continue block23;
                    }
                    case 12: {
                        cell.setCellValue(fscOrderItemDetailBO.getNum().toString());
                        continue block23;
                    }
                    case 13: {
                        cell.setCellValue(fscOrderItemDetailBO.getPrice().toString());
                        continue block23;
                    }
                    case 14: {
                        cell.setCellValue(fscOrderItemDetailBO.getUntaxPrice().toString());
                        continue block23;
                    }
                    case 15: {
                        cell.setCellValue(fscOrderItemDetailBO.getAmt().toString());
                        continue block23;
                    }
                    case 16: {
                        cell.setCellValue(fscOrderItemDetailBO.getUntaxAmt().toString());
                        continue block23;
                    }
                    case 17: {
                        cell.setCellValue(fscOrderItemDetailBO.getTaxAmt().toString());
                        continue block23;
                    }
                    case 18: {
                        cell.setCellValue(fscOrderItemDetailBO.getTaxRate().toString());
                        continue block23;
                    }
                }
            }
        }
    }

    public String generateRandomCode(int length) {
        StringBuilder sb = new StringBuilder(length);
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            int randomNum = random.nextInt(10);
            sb.append(randomNum);
        }
        return sb.toString();
    }

    private DycFscOrderInvoiceBO generateAutoTestFakeData(DycFscExportBillUploadModelRspBO dycFscExportBillUploadModelRspBO) {
        DycFscOrderInvoiceBO dycFscOrderInvoiceBO = dycFscExportBillUploadModelRspBO.getDycFscOrderInvoiceBO();
        dycFscOrderInvoiceBO.setBillDate(DateUtil.format((Date)DateUtil.date(), (String)"yyyy-MM-dd"));
        if (FscConstants.InvoiceCategory.ALL_ELECTRON.equals(dycFscOrderInvoiceBO.getInvoiceCategory())) {
            if ("01".equals(dycFscOrderInvoiceBO.getInvoiceType())) {
                dycFscOrderInvoiceBO.setInvoiceNo(this.generateRandomCode(FscConstants.FscInvoiceVerifyParam.INVOICE_NO_ALL_ELEC_LENGTH));
            }
            if ("00".equals(dycFscOrderInvoiceBO.getInvoiceType())) {
                dycFscOrderInvoiceBO.setInvoiceNo(this.generateRandomCode(FscConstants.FscInvoiceVerifyParam.INVOICE_NO_ALL_ELEC_LENGTH));
            }
        }
        if (FscConstants.InvoiceCategory.PAPER.equals(dycFscOrderInvoiceBO.getInvoiceCategory())) {
            if ("01".equals(dycFscOrderInvoiceBO.getInvoiceType())) {
                dycFscOrderInvoiceBO.setInvoiceNo(this.generateRandomCode(FscConstants.FscInvoiceVerifyParam.INVOICE_NO_LENGTH));
                dycFscOrderInvoiceBO.setInvoiceCode(this.generateRandomCode(FscConstants.FscInvoiceVerifyParam.INVOICE_CODE_PAPER_LENGTH));
            }
            if ("00".equals(dycFscOrderInvoiceBO.getInvoiceType())) {
                dycFscOrderInvoiceBO.setInvoiceNo(this.generateRandomCode(FscConstants.FscInvoiceVerifyParam.INVOICE_NO_LENGTH));
                dycFscOrderInvoiceBO.setInvoiceCode(this.generateRandomCode(FscConstants.FscInvoiceVerifyParam.INVOICE_CODE_PAPER_LENGTH));
            }
        }
        if (FscConstants.InvoiceCategory.ELECTRON.equals(dycFscOrderInvoiceBO.getInvoiceCategory())) {
            if ("01".equals(dycFscOrderInvoiceBO.getInvoiceType())) {
                dycFscOrderInvoiceBO.setInvoiceCode(this.generateRandomCode(FscConstants.FscInvoiceVerifyParam.INVOICE_CODE_ELEC_LENGTH));
                dycFscOrderInvoiceBO.setInvoiceNo(this.generateRandomCode(FscConstants.FscInvoiceVerifyParam.INVOICE_NO_LENGTH));
                dycFscOrderInvoiceBO.setVerificationCode(this.generateRandomCode(FscConstants.FscInvoiceVerifyParam.INVOICE_NO_LENGTH));
            }
            if ("00".equals(dycFscOrderInvoiceBO.getInvoiceType())) {
                dycFscOrderInvoiceBO.setInvoiceCode(this.generateRandomCode(FscConstants.FscInvoiceVerifyParam.INVOICE_CODE_ELEC_LENGTH));
                dycFscOrderInvoiceBO.setInvoiceNo(this.generateRandomCode(FscConstants.FscInvoiceVerifyParam.INVOICE_NO_LENGTH));
            }
        }
        return dycFscOrderInvoiceBO;
    }

    private List<CellData> getCellData(int sheetIndex, int rowIndex, int columnSize, XSSFWorkbook workbook) {
        LinkedList<CellData> cellDataList = new LinkedList<CellData>();
        XSSFSheet sheet = workbook.getSheetAt(sheetIndex);
        for (int i = 0; i < columnSize; ++i) {
            CellData cellData;
            XSSFRow row = sheet.getRow(rowIndex);
            XSSFCell cell = row.getCell(i);
            if (!Objects.isNull(cell)) {
                XSSFCellStyle cellStyle = cell.getCellStyle();
                short rowHeight = row.getHeight();
                int columnWidth = sheet.getColumnWidth(cell.getColumnIndex());
                cell.setCellType(CellType.STRING);
                String cellValue = cell.getStringCellValue();
                cellData = new CellData(rowHeight, columnWidth, cellStyle, cellValue);
            } else {
                cellData = null;
            }
            cellDataList.add(cellData);
        }
        return cellDataList;
    }
}

