/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smcsdk.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.smcsdk.api.SmcsdkOperateStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SmcsdkOperateStockNumServiceImpl
implements SmcsdkOperateStockNumService {
    private static final Logger log = LoggerFactory.getLogger(SmcsdkOperateStockNumServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Resource(name="smcsdkUpdateStockNumProducer")
    private ProxyMessageProducer smcsdkUpdateStockNumProducer;
    @Value(value="${SMCSDK_UPDATE_STOCK_NUM_TAG}")
    private String mqTag;
    @Value(value="${SMCSDK_UPDATE_STOCK_NUM_TOPIC}")
    private String mqTopic;
    private static final Set<String> IN_STOCK_SET = new HashSet<String>();
    private static final Set<String> OUT_STOCK_SET = new HashSet<String>();

    public SmcsdkOperateStockNumRspBO operateStockNum(SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO) {
        SmcsdkOperateStockNumRspBO rspBO = new SmcsdkOperateStockNumRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.validParam(rspBO, smcsdkOperateStockNumReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        String operateType2 = smcsdkOperateStockNumReqBO.getOperateType();
        if (smcsdkOperateStockNumReqBO.getCheckOldObject().booleanValue()) {
            // empty if block
        }
        if (IN_STOCK_SET.contains(operateType2)) {
            this.instock(smcsdkOperateStockNumReqBO);
        } else if (OUT_STOCK_SET.contains(operateType2)) {
            this.outStock(rspBO, smcsdkOperateStockNumReqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                return rspBO;
            }
        }
        this.sendMassage(smcsdkOperateStockNumReqBO);
        return rspBO;
    }

    private void validParam(SmcsdkOperateStockNumRspBO rspBO, SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO) {
        if (StringUtils.isEmpty((Object)smcsdkOperateStockNumReqBO.getOperateType())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u3010operateType\u3011\u4e3a\u7a7a\uff01");
            return;
        }
        if (StringUtils.isEmpty((Object)smcsdkOperateStockNumReqBO.getObjectId())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u3010objectId\u3011\u4e3a\u7a7a\uff01");
            return;
        }
        if (StringUtils.isEmpty((Object)smcsdkOperateStockNumReqBO.getObjectType())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u3010objectType\u3011\u4e3a\u7a7a\uff01");
            return;
        }
        if (CollectionUtils.isEmpty((Collection)smcsdkOperateStockNumReqBO.getSmcsdkStockNumInfoBOs())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u3010smcsdkStockNumInfoBOs\u3011\u4e3a\u7a7a\uff01");
            return;
        }
        for (SmcsdkStockNumInfoBO bo : smcsdkOperateStockNumReqBO.getSmcsdkStockNumInfoBOs()) {
            if (StringUtils.isEmpty((Object)bo.getSkuId())) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u5165\u53c2\u3010skuId\u3011\u4e3a\u7a7a\uff01");
                return;
            }
            if (StringUtils.isEmpty((Object)bo.getStockhouseId())) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u5165\u53c2\u3010stockhouseId\u3011\u4e3a\u7a7a\uff01");
                return;
            }
            if (bo.getOperateNum() != null) continue;
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u3010operateNum\u3011\u4e3a\u7a7a\uff01");
            return;
        }
        if (smcsdkOperateStockNumReqBO.getCheckOldObject().booleanValue()) {
            if (StringUtils.isEmpty((Object)smcsdkOperateStockNumReqBO.getOldObjectType())) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u5165\u53c2\u3010oldObjectType\u3011\u4e3a\u7a7a\uff01");
                return;
            }
            if (StringUtils.isEmpty((Object)smcsdkOperateStockNumReqBO.getOldObjectId())) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u5165\u53c2\u3010oldObjectId\u3011\u4e3a\u7a7a\uff01");
                return;
            }
        }
    }

    private void sendMassage(SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO) {
        smcsdkOperateStockNumReqBO.setUniKey(Long.valueOf(Sequence.getInstance().nextId()));
        log.info("\u53d1\u6d88\u606f\u66f4\u65b0\u5e93\u5b58\u4fe1\u606f\u53c2\u6570\u4e3a:" + JSON.toJSONString((Object)smcsdkOperateStockNumReqBO));
        ProxyMessage proxyMessage = new ProxyMessage(this.mqTopic, this.mqTag, JSON.toJSONString((Object)smcsdkOperateStockNumReqBO));
        ProxySendResult result = this.smcsdkUpdateStockNumProducer.send(proxyMessage);
        log.info("\u53d1\u6d88\u606f\u66f4\u65b0\u5e93\u5b58\u4fe1\u606f\u5b8c\u6210\u7ed3\u679c\u4e3a\uff1a" + JSON.toJSONString((Object)result));
    }

    private void outStock(SmcsdkOperateStockNumRspBO rspBO, SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO) {
        List smcsdkStockNumInfoBOs = smcsdkOperateStockNumReqBO.getSmcsdkStockNumInfoBOs();
        ArrayList<SmcsdkStockNumInfoBO> skuInfoBOList = new ArrayList<SmcsdkStockNumInfoBO>();
        for (SmcsdkStockNumInfoBO bo : smcsdkStockNumInfoBOs) {
            String redisKey = "STOCK_SALE_NUM_" + bo.getStockhouseId();
            Long currenNum = this.cacheClient.incrBy(redisKey + "_" + bo.getSkuId(), -bo.getOperateNum().longValue());
            log.info("\u51fa\u5e93\u66f4\u65b0\u540e\u7684\u53ef\u552e\u6570\u91cf\u4e3a" + currenNum);
            skuInfoBOList.add(bo);
            if (currenNum >= 0L) continue;
            for (SmcsdkStockNumInfoBO smcsdkStockNumInfoBO : skuInfoBOList) {
                this.cacheClient.incrBy(redisKey + "_" + smcsdkStockNumInfoBO.getSkuId(), smcsdkStockNumInfoBO.getOperateNum().longValue());
            }
            rspBO.setRespCode("0002");
            rspBO.setRespDesc("skuId\u3010" + bo.getSkuId() + "\u3011\u5e93\u5b58\u4e0d\u8db3");
            return;
        }
    }

    private void instock(SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO) {
        List smcsdkStockNumInfoBOs = smcsdkOperateStockNumReqBO.getSmcsdkStockNumInfoBOs();
        for (SmcsdkStockNumInfoBO bo : smcsdkStockNumInfoBOs) {
            String redisKey = "STOCK_SALE_NUM_" + bo.getStockhouseId();
            Long count = this.cacheClient.incrBy(redisKey + "_" + bo.getSkuId(), bo.getOperateNum().longValue());
            log.info("\u5165\u5e93\u66f4\u65b0\u540e\u7684\u53ef\u552e\u6570\u91cf\u4e3a" + count);
        }
    }

    private static void initialize() {
        IN_STOCK_SET.add("10");
        IN_STOCK_SET.add("30");
        IN_STOCK_SET.add("11");
        OUT_STOCK_SET.add("20");
        OUT_STOCK_SET.add("40");
    }

    static {
        SmcsdkOperateStockNumServiceImpl.initialize();
    }
}

