/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.approve.impl;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.tydic.dyc.pro.base.core.dictionary.enums.PublicProcInstBusiType;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstHandleDTO;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.approve.api.DycProCommPublicProcTaskInstRepository;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPakageObjDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.service.approve.api.DycProCommCompleteApproveTaskService;
import com.tydic.dyc.pro.dmc.service.approve.bo.DycProCommCompleteApproveTaskReqBO;
import com.tydic.dyc.pro.dmc.service.approve.bo.DycProCommCompleteApproveTaskRspBO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.approve.api.DycProCommCompleteApproveTaskService"})
public class DycProCommCompleteApproveTaskServiceImpl
implements DycProCommCompleteApproveTaskService {
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommPublicProcTaskInstRepository dycProCommPublicProcTaskInstRepository;

    @PostMapping(value={"completeApproveTask"})
    public DycProCommCompleteApproveTaskRspBO completeApproveTask(@RequestBody DycProCommCompleteApproveTaskReqBO reqBO) {
        DycProPublicTaskInstHandleDTO flowTaskInstHandleDto = new DycProPublicTaskInstHandleDTO();
        flowTaskInstHandleDto.setTaskInstId(reqBO.getTaskInstId());
        flowTaskInstHandleDto.setIsFinish(reqBO.getIsFinish());
        flowTaskInstHandleDto.setLinkJudge(reqBO.getLinkJudge());
        this.dycProPublicTaskInstRepository.completeFlowTask(flowTaskInstHandleDto);
        DycProCommAuditPakageObjDTO dycProCommAuditPakageObjDTO = new DycProCommAuditPakageObjDTO();
        dycProCommAuditPakageObjDTO.setAuditPakageId(reqBO.getObjId());
        List skuCountResult = this.dycProCommPublicProcTaskInstRepository.getAuditPakageObjList(dycProCommAuditPakageObjDTO);
        if (!ObjectUtils.isEmpty((Object)skuCountResult)) {
            List<Object> updateSkuList = new ArrayList();
            if (reqBO.getIsFinish().booleanValue()) {
                if ("pass".equals(reqBO.getApproveResult())) {
                    updateSkuList = skuCountResult.stream().map(item -> {
                        DycProCommSkuDTO dycProCommSkuDTO = new DycProCommSkuDTO();
                        dycProCommSkuDTO.setSkuId(item.getSkuId());
                        dycProCommSkuDTO.setApprovalStatus(DycProCommConstants.SkuApprovalStatus.APPROVED);
                        if (PublicProcInstBusiType.AGR_SKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                            dycProCommSkuDTO.setSkuStatus(DycProCommConstants.SkuStatus.ON_SHELVES);
                        } else if (PublicProcInstBusiType.AGR_SKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                            dycProCommSkuDTO.setSkuStatus(DycProCommConstants.SkuStatus.OFF_SHELVES);
                        }
                        return dycProCommSkuDTO;
                    }).collect(Collectors.toList());
                } else if ("reject".equals(reqBO.getApproveResult())) {
                    updateSkuList = skuCountResult.stream().map(item -> {
                        DycProCommSkuDTO dycProCommSkuDTO = new DycProCommSkuDTO();
                        dycProCommSkuDTO.setSkuId(item.getSkuId());
                        dycProCommSkuDTO.setApprovalStatus(DycProCommConstants.SkuApprovalStatus.REJECT);
                        return dycProCommSkuDTO;
                    }).collect(Collectors.toList());
                }
            }
            this.dycProCommSkuRepository.updateSkuInfoBatch(updateSkuList);
        }
        DycProCommCompleteApproveTaskRspBO rspBO = new DycProCommCompleteApproveTaskRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

