/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.skumanage.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuHandleDTO;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommSkuOnShelveService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuOnShelveReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuOnShelveRspBO;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommSkuOnShelveService"})
public class DycProCommSkuOnShelveServiceImpl
implements DycProCommSkuOnShelveService {
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;

    @PostMapping(value={"dealSkuOnShelve"})
    public DycProCommSkuOnShelveRspBO dealSkuOnShelve(@RequestBody DycProCommSkuOnShelveReqBO reqBO) {
        this.val(reqBO);
        DycProCommSkuHandleDTO reqDto = (DycProCommSkuHandleDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycProCommSkuHandleDTO.class);
        reqDto.setUpdateUserId(reqBO.getUserId().toString());
        reqDto.setUpdateUserName(reqBO.getName());
        reqDto.setUserName(reqBO.getUserName());
        reqDto.setUpdateCompanyId(reqBO.getCompanyId());
        reqDto.setUpdateOrgId(reqBO.getOrgId());
        reqDto.setUpdateOrgPath(reqBO.getOrgPath());
        reqDto.setUpdateCompanyName(reqBO.getCompanyName());
        reqDto.setUpdateOrgName(reqBO.getOrgName());
        reqDto.setUpdateTime(new Date());
        if (DycProCommConstants.SkuOnShelveOperFlag.MANDATORY_SHELVES.equals(reqBO.getOperFlag())) {
            this.dycProCommSkuRepository.dealSkuMandatoryShelves(reqDto);
        }
        DycProCommSkuOnShelveRspBO rspBO = new DycProCommSkuOnShelveRspBO();
        if (DycProCommConstants.SkuOnShelveOperFlag.ON_SHELVE.equals(reqBO.getOperFlag())) {
            if (reqBO.getApproveOnShelveSwitch().booleanValue()) {
                Long auditPackageId = Sequence.getInstance().nextId();
                rspBO.setAuditPackageId(auditPackageId);
                reqDto.setAuditPackageId(auditPackageId);
            }
            this.dycProCommSkuRepository.dealSkuOnShelves(reqDto);
        }
        return rspBO;
    }

    private void val(DycProCommSkuOnShelveReqBO reqBO) {
        if (null == reqBO.getOperFlag()) {
            throw new ZTBusinessException("\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIdList())) {
            throw new ZTBusinessException("\u5165\u53c2\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DycProCommConstants.SkuOnShelveOperFlag.MANDATORY_SHELVES.equals(reqBO.getOperFlag()) && StringUtils.isBlank((CharSequence)reqBO.getReason())) {
            throw new ZTBusinessException("\u5f3a\u5236\u4e0a\u67b6\u65f6\u4e0a\u67b6\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

