/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.approve.impl;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordActionTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordOperateResultEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.PublicProcInstBusiType;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstHandleDTO;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.approve.api.DycProCommPublicProcTaskInstRepository;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPakageObjDTO;
import com.tydic.dyc.pro.dmc.repository.operaterecord.api.DycProCommOperateRecordRepository;
import com.tydic.dyc.pro.dmc.repository.operaterecord.dto.DycProCommOperateRecordDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuHandleDTO;
import com.tydic.dyc.pro.dmc.service.approve.api.DycProCommCompleteApproveTaskService;
import com.tydic.dyc.pro.dmc.service.approve.bo.DycProCommCompleteApproveTaskReqBO;
import com.tydic.dyc.pro.dmc.service.approve.bo.DycProCommCompleteApproveTaskRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.approve.api.DycProCommCompleteApproveTaskService"})
public class DycProCommCompleteApproveTaskServiceImpl
implements DycProCommCompleteApproveTaskService {
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommPublicProcTaskInstRepository dycProCommPublicProcTaskInstRepository;
    @Autowired
    private DycProCommOperateRecordRepository dycProCommOperateRecordRepository;

    @PostMapping(value={"completeApproveTask"})
    public DycProCommCompleteApproveTaskRspBO completeApproveTask(@RequestBody DycProCommCompleteApproveTaskReqBO reqBO) {
        DycProPublicTaskInstHandleDTO flowTaskInstHandleDto = new DycProPublicTaskInstHandleDTO();
        BeanUtils.copyProperties((Object)reqBO, (Object)flowTaskInstHandleDto);
        this.dycProPublicTaskInstRepository.completeFlowTask(flowTaskInstHandleDto);
        DycProCommAuditPakageObjDTO dycProCommAuditPakageObjDTO = new DycProCommAuditPakageObjDTO();
        dycProCommAuditPakageObjDTO.setAuditPackageId(reqBO.getObjId());
        List skuCountResult = this.dycProCommPublicProcTaskInstRepository.getAuditPakageObjList(dycProCommAuditPakageObjDTO);
        if (!ObjectUtils.isEmpty((Object)skuCountResult) && reqBO.getIsFinish().booleanValue()) {
            DycProCommSkuHandleDTO dycProCommSkuHandleDTO = new DycProCommSkuHandleDTO();
            ArrayList<String> nullColumnList = new ArrayList<String>();
            dycProCommSkuHandleDTO.setSkuIdList(skuCountResult.stream().map(DycProCommAuditPakageObjDTO::getSkuId).collect(Collectors.toList()));
            if ("pass".equals(reqBO.getDealResult())) {
                if (PublicProcInstBusiType.AGR_SKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                    dycProCommSkuHandleDTO.setSkuStatus(DycProCommConstants.SkuStatus.ON_SHELVES);
                    dycProCommSkuHandleDTO.setOnShelveTime(new Date());
                } else if (PublicProcInstBusiType.AGR_SKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                    dycProCommSkuHandleDTO.setSkuStatus(DycProCommConstants.SkuStatus.OFF_SHELVES);
                    dycProCommSkuHandleDTO.setDownShelveTime(new Date());
                }
                dycProCommSkuHandleDTO.setUpdateUserId(reqBO.getDealUserId());
                dycProCommSkuHandleDTO.setUpdateUserName(reqBO.getDealUserName());
                dycProCommSkuHandleDTO.setUpdateTime(new Date());
                dycProCommSkuHandleDTO.setUpdateOrgId(reqBO.getDealUserOrgId());
                dycProCommSkuHandleDTO.setUpdateOrgName(reqBO.getDealUserOrgName());
                dycProCommSkuHandleDTO.setUpdateOrgPath(reqBO.getDealUserOrgPath());
                dycProCommSkuHandleDTO.setUpdateCompanyId(reqBO.getDealUserCompanyId());
                dycProCommSkuHandleDTO.setUpdateCompanyName(reqBO.getDealUserCompanyName());
                nullColumnList.add("APPROVAL_STATUS");
            } else if ("reject".equals(reqBO.getDealResult())) {
                if (PublicProcInstBusiType.AGR_SKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                    dycProCommSkuHandleDTO.setApprovalStatus(DycProCommConstants.ApprovalStatus.ON_SHELVE_REJECT);
                } else if (PublicProcInstBusiType.AGR_SKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                    dycProCommSkuHandleDTO.setApprovalStatus(DycProCommConstants.ApprovalStatus.OFF_SHELVE_REJECT);
                    dycProCommSkuHandleDTO.setSkuStatus(DycProCommConstants.SkuStatus.ON_SHELVES);
                }
                dycProCommSkuHandleDTO.setUpdateUserId(reqBO.getDealUserId());
                dycProCommSkuHandleDTO.setUpdateUserName(reqBO.getDealUserName());
                dycProCommSkuHandleDTO.setUpdateTime(new Date());
                dycProCommSkuHandleDTO.setUpdateOrgId(reqBO.getDealUserOrgId());
                dycProCommSkuHandleDTO.setUpdateOrgName(reqBO.getDealUserOrgName());
                dycProCommSkuHandleDTO.setUpdateOrgPath(reqBO.getDealUserOrgPath());
                dycProCommSkuHandleDTO.setUpdateCompanyId(reqBO.getDealUserCompanyId());
                dycProCommSkuHandleDTO.setUpdateCompanyName(reqBO.getDealUserCompanyName());
            }
            this.dycProCommSkuRepository.updateSkuInfoNullByIdsAndSyncNoSql(dycProCommSkuHandleDTO, nullColumnList);
            this.insertOperateRecord(skuCountResult, dycProCommSkuHandleDTO, reqBO);
        }
        DycProCommCompleteApproveTaskRspBO rspBO = new DycProCommCompleteApproveTaskRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void insertOperateRecord(List<DycProCommAuditPakageObjDTO> skuCountResult, DycProCommSkuHandleDTO dycProCommSkuHandleDTO, DycProCommCompleteApproveTaskReqBO reqBO) {
        ArrayList<DycProCommOperateRecordDTO> operateRecordPOList = new ArrayList<DycProCommOperateRecordDTO>();
        for (DycProCommAuditPakageObjDTO skuInfoPO : skuCountResult) {
            DycProCommOperateRecordDTO commOperateRecordPO = new DycProCommOperateRecordDTO();
            commOperateRecordPO.setObjId(skuInfoPO.getSkuId());
            commOperateRecordPO.setObjCode(skuInfoPO.getSkuCode());
            commOperateRecordPO.setObjType(DycProCommConstants.OperateRecordObjType.SKU);
            if (PublicProcInstBusiType.AGR_SKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                commOperateRecordPO.setActionType(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordActionTypeEnum.ON_SHELVE.getCode())));
                commOperateRecordPO.setActionName(DmcCommOperateRecordActionTypeEnum.ON_SHELVE.getValue());
            } else if (PublicProcInstBusiType.AGR_SKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                commOperateRecordPO.setActionType(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordActionTypeEnum.DOWN_SHELVE.getCode())));
                commOperateRecordPO.setActionName(DmcCommOperateRecordActionTypeEnum.DOWN_SHELVE.getValue());
            }
            commOperateRecordPO.setOperateTime(dycProCommSkuHandleDTO.getUpdateTime());
            commOperateRecordPO.setOperateUserId(dycProCommSkuHandleDTO.getUpdateUserId());
            commOperateRecordPO.setOperateUserAccount(dycProCommSkuHandleDTO.getUserName());
            commOperateRecordPO.setOperateUserName(dycProCommSkuHandleDTO.getUpdateUserName());
            commOperateRecordPO.setOperateUserType(DycProCommConstants.OperateUserType.USER);
            commOperateRecordPO.setOperateReason(reqBO.getDealRemark());
            if (PublicProcInstBusiType.AGR_SKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                commOperateRecordPO.setOperateResult(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordOperateResultEnum.SUCCESS_ON_SHELVE.getCode())));
                commOperateRecordPO.setOperateResultDesc(DmcCommOperateRecordOperateResultEnum.SUCCESS_ON_SHELVE.getValue());
            } else if (PublicProcInstBusiType.AGR_SKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                commOperateRecordPO.setOperateResult(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordOperateResultEnum.SUCCESS_DOWN_SHELVE.getCode())));
                commOperateRecordPO.setOperateResultDesc(DmcCommOperateRecordOperateResultEnum.SUCCESS_DOWN_SHELVE.getValue());
            }
            operateRecordPOList.add(commOperateRecordPO);
        }
        this.dycProCommOperateRecordRepository.addOperateRecordBatch(operateRecordPOList);
    }
}

