/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.checkrule.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleTypeEnum;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRecordRepository;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckObjCheckRecordDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRecordDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRecordItemDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleInfoQryDTO;
import com.tydic.dyc.pro.dmc.service.checkrule.api.DycProCommPriceCheckService;
import com.tydic.dyc.pro.dmc.service.checkrule.bo.DycProCommPriceCheckReqBO;
import com.tydic.dyc.pro.dmc.service.checkrule.bo.DycProCommPriceCheckRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.checkrule.api.DycProCommPriceCheckService"})
public class DycProCommPriceCheckServiceImpl
implements DycProCommPriceCheckService {
    @Autowired
    private DycProCommCheckRuleInfoRepository dycProCommCheckRuleInfoRepository;
    @Autowired
    private DycProCommCheckRecordRepository dycProCommCheckRecordRepository;

    @PostMapping(value={"dealPriceCheck"})
    public DycProCommPriceCheckRspBO dealPriceCheck(@RequestBody DycProCommPriceCheckReqBO reqBO) {
        DycProCommCheckRuleInfoQryDTO ruleInfoQryDTO = new DycProCommCheckRuleInfoQryDTO();
        ruleInfoQryDTO.setSupplierId(reqBO.getSupplierId());
        ruleInfoQryDTO.setCatalogId(reqBO.getCatalogId());
        ruleInfoQryDTO.setCheckRuleType(Integer.valueOf(Integer.parseInt(DmcCommCheckRuleTypeEnum.PRICE_CHECK.getCode())));
        List checkRuleInfoDTOs = this.dycProCommCheckRuleInfoRepository.querySkuEffectCheckRule(ruleInfoQryDTO);
        if (CollectionUtils.isEmpty((Collection)checkRuleInfoDTOs)) {
            DycProCommCheckObjCheckRecordDTO dycProCommCheckObjCheckRecordDTO = new DycProCommCheckObjCheckRecordDTO();
            dycProCommCheckObjCheckRecordDTO.setCheckObjId(reqBO.getCheckObjId());
            dycProCommCheckObjCheckRecordDTO.setCheckRuleType(Integer.valueOf(Integer.parseInt(DmcCommCheckRuleTypeEnum.PRICE_CHECK.getCode())));
            this.dycProCommCheckRecordRepository.updateObjCheckRecordAndCheckRecord(dycProCommCheckObjCheckRecordDTO);
        } else {
            ArrayList checkRecordDTOList = new ArrayList();
            checkRuleInfoDTOs.forEach(checkRuleInfoDTO -> {
                DycProCommCheckRecordDTO dycProCommCheckRecordDTO = (DycProCommCheckRecordDTO)JSON.parseObject((String)JSON.toJSONString((Object)checkRuleInfoDTO), DycProCommCheckRecordDTO.class);
                dycProCommCheckRecordDTO.setCheckStatus(DycProCommConstants.checkRuleCheckStatus.CHECKIING);
                dycProCommCheckRecordDTO.setCheckObjId(reqBO.getCheckObjId());
                dycProCommCheckRecordDTO.setCheckObjType(reqBO.getCheckObjType());
                dycProCommCheckRecordDTO.setCheckObjName(reqBO.getCheckObjName());
                dycProCommCheckRecordDTO.setCheckResult(null);
                checkRecordDTOList.add(dycProCommCheckRecordDTO);
                ArrayList checkRecordItemDTOs = new ArrayList();
                dycProCommCheckRecordDTO.setCheckRecordItemDTOList(checkRecordItemDTOs);
                checkRuleInfoDTO.getCheckRuleItemInfoDTOList().forEach(dycProCommCheckRuleItemInfoDTO -> {
                    DycProCommCheckRecordItemDTO checkRecordItemDTO = (DycProCommCheckRecordItemDTO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommCheckRuleItemInfoDTO), DycProCommCheckRecordItemDTO.class);
                    checkRecordItemDTOs.add(checkRecordItemDTO);
                });
            });
            DycProCommCheckObjCheckRecordDTO objCheckRecordDTO = this.buildObjCheckRecordDTO(reqBO);
            objCheckRecordDTO.setCheckRuleType(Integer.valueOf(Integer.parseInt(DmcCommCheckRuleTypeEnum.PRICE_CHECK.getCode())));
            objCheckRecordDTO.setCheckSenceCode(reqBO.getCheckSenceCode());
            objCheckRecordDTO.setCheckRecordDTOList(checkRecordDTOList);
            this.dycProCommCheckRecordRepository.addCheckObjCheckRecord(objCheckRecordDTO);
        }
        return new DycProCommPriceCheckRspBO();
    }

    private DycProCommCheckObjCheckRecordDTO buildObjCheckRecordDTO(DycProCommPriceCheckReqBO reqBO) {
        DycProCommCheckObjCheckRecordDTO objCheckRecordDTO = (DycProCommCheckObjCheckRecordDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycProCommCheckObjCheckRecordDTO.class);
        objCheckRecordDTO.setCreateUserId(reqBO.getUserId());
        objCheckRecordDTO.setCreateUserName(reqBO.getName());
        objCheckRecordDTO.setCreateUserAccount(reqBO.getUserName());
        objCheckRecordDTO.setCreateOrgId(reqBO.getOrgId());
        objCheckRecordDTO.setCreateOrgName(reqBO.getOrgName());
        objCheckRecordDTO.setCreateCompanyId(reqBO.getCompanyId());
        objCheckRecordDTO.setCreateCompanyName(reqBO.getCompanyName());
        objCheckRecordDTO.setCreateOrgPath(reqBO.getOrgPath());
        return objCheckRecordDTO;
    }
}

