/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.skumanage.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.dictionary.enums.BooleanFlag;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainTradeMode;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.approve.api.DycProCommPublicProcTaskInstRepository;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPackageInfoDTO;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPakageObjDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoDTO;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommAgrSkuUpdateService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrSkuBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrSkuUpdateReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrSkuUpdateRspBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuPicApiBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommAgrSkuUpdateService"})
public class DycProCommAgrSkuUpdateServiceImpl
implements DycProCommAgrSkuUpdateService {
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommPublicProcTaskInstRepository dycProCommPublicProcTaskInstRepository;

    @PostMapping(value={"updateAgrSku"})
    public DycProCommAgrSkuUpdateRspBO updateAgrSku(@RequestBody DycProCommAgrSkuUpdateReqBO reqBO) {
        this.judge(reqBO);
        this.updateAgrSkuInfo(reqBO);
        DycProCommAgrSkuUpdateRspBO rspBO = new DycProCommAgrSkuUpdateRspBO();
        rspBO.setSkuId(reqBO.getUpdateSkuInfo().getSkuId());
        if (reqBO.getOperType() == 1 && reqBO.getUccApproveOnShelveAgreementSwitch().booleanValue()) {
            Long auditPackageId = Sequence.getInstance().nextId();
            rspBO.setAuditPackageId(auditPackageId);
            this.insertAuditPackage(auditPackageId, reqBO);
        }
        return rspBO;
    }

    private void updateAgrSkuInfo(DycProCommAgrSkuUpdateReqBO reqBO) {
        DycProCommSkuDTO skuDTO = (DycProCommSkuDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getUpdateSkuInfo()), DycProCommSkuDTO.class);
        if (reqBO.getOperType() == 0) {
            skuDTO.setSkuStatus(DycProCommConstants.SkuStatus.DRAFT);
        } else if (reqBO.getOperType() == 1) {
            if (reqBO.getUpdateSkuInfo().getOnShelveWay().equals(DycProCommConstants.SkuOnShelveWay.AUTO_ON_SHELVE)) {
                if (reqBO.getUccApproveOnShelveAgreementSwitch().booleanValue()) {
                    skuDTO.setSkuStatus(DycProCommConstants.SkuStatus.TOBE_ON_SHELVES);
                } else {
                    skuDTO.setSkuStatus(DycProCommConstants.SkuStatus.ON_SHELVES);
                }
            } else {
                skuDTO.setSkuStatus(DycProCommConstants.SkuStatus.TOBE_ON_SHELVES);
            }
        }
        if (reqBO.getUpdateSkuInfo().getTradeMode().equals(Integer.parseInt(DmcAgrMainTradeMode.CH.getCode()))) {
            skuDTO.getPriceInfo().setSalePrice(skuDTO.getPriceInfo().getSupplierPrice());
        }
        DycProCommSkuStockInfoDTO stockInfo = new DycProCommSkuStockInfoDTO();
        stockInfo.setOriginNum(reqBO.getUpdateSkuInfo().getStockInfo().getOriginNum());
        stockInfo.setTotalNum(reqBO.getUpdateSkuInfo().getStockInfo().getOriginNum());
        stockInfo.setUnsaleNum(reqBO.getUpdateSkuInfo().getStockInfo().getOriginNum());
        stockInfo.setSaledNum(BigDecimal.ZERO);
        stockInfo.setSkuName(reqBO.getUpdateSkuInfo().getSkuName());
        stockInfo.setSaleMeasureId(reqBO.getUpdateSkuInfo().getSaleMeasureId());
        stockInfo.setSaleMeasureName(reqBO.getUpdateSkuInfo().getSaleMeasureName());
        stockInfo.setCreateUserId(reqBO.getUserId());
        stockInfo.setCreateUserName(reqBO.getName());
        stockInfo.setCreateUserAccount(reqBO.getUserName());
        stockInfo.setCreateCompanyId(reqBO.getCompanyId());
        stockInfo.setCreateOrgId(reqBO.getOrgId());
        stockInfo.setCreateCompanyName(reqBO.getCompanyName());
        stockInfo.setCreateOrgName(reqBO.getOrgName());
        stockInfo.setCreateTime(new Date(System.currentTimeMillis()));
        skuDTO.setStockInfo(stockInfo);
        skuDTO.setUpdateUserId(reqBO.getUserId());
        skuDTO.setUpdateUserName(reqBO.getName());
        skuDTO.setUpdateCompanyId(reqBO.getCompanyId());
        skuDTO.setUpdateOrgId(reqBO.getOrgId());
        skuDTO.setUpdateOrgPath(reqBO.getOrgPath());
        skuDTO.setUpdateCompanyName(reqBO.getCompanyName());
        skuDTO.setUpdateOrgName(reqBO.getOrgName());
        skuDTO.setUpdateTime(new Date(System.currentTimeMillis()));
        this.dycProCommSkuRepository.updateSkuCompleteInfoAndSyncNosql(skuDTO);
    }

    private void insertAuditPackage(Long auditPackageId, DycProCommAgrSkuUpdateReqBO reqBO) {
        DycProCommAuditPackageInfoDTO dycProCommAuditPackageInfoDTO = new DycProCommAuditPackageInfoDTO();
        dycProCommAuditPackageInfoDTO.setAuditPackageId(auditPackageId);
        ArrayList<Object> auditPackageObjDTOList = new ArrayList<Object>();
        auditPackageObjDTOList.add(JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getUpdateSkuInfo()), DycProCommAuditPakageObjDTO.class));
        for (DycProCommAuditPakageObjDTO dycProCommAuditPakageObjDTO : auditPackageObjDTOList) {
            dycProCommAuditPakageObjDTO.setCreateTime(new Date(System.currentTimeMillis()));
            dycProCommAuditPakageObjDTO.setAuditPackageId(auditPackageId);
            dycProCommAuditPakageObjDTO.setDelTag(DycProCommConstants.DelFlag.NO);
        }
        dycProCommAuditPackageInfoDTO.setAuditPakageObjDTOList(auditPackageObjDTOList);
        this.dycProCommPublicProcTaskInstRepository.addAuditPackageBatch(dycProCommAuditPackageInfoDTO);
    }

    private void judge(DycProCommAgrSkuUpdateReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getOperType())) {
            throw new ZTBusinessException("\u3010\u64cd\u4f5c\u7c7b\u578b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getMiniFlag())) {
            throw new ZTBusinessException("\u3010\u662f\u5426\u6781\u7b80\u6807\u8bc6\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getUccApproveOnShelveAgreementSwitch())) {
            throw new ZTBusinessException("\u3010\u4e0a\u67b6\u5ba1\u6279\u5f00\u5173\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getUpdateSkuInfo())) {
            throw new ZTBusinessException("\u3010sku\u521b\u5efa\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProCommAgrSkuBO updateSkuInfo = reqBO.getUpdateSkuInfo();
        if (ObjectUtils.isEmpty((Object)updateSkuInfo.getOnShelveWay())) {
            throw new ZTBusinessException("\u3010\u4e0a\u67b6\u65b9\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo())) {
            if (!ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getIsAllowReturn()) && DycProCommConstants.IsAllowAfterSale.YES.equals(updateSkuInfo.getSkuAfterSaleInfo().getIsAllowReturn()) && ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getReturnTimeLimit())) {
                throw new ZTBusinessException("\u3010\u9000\u8d27\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getIsAllowReturn()) && DycProCommConstants.IsAllowAfterSale.YES.equals(updateSkuInfo.getSkuAfterSaleInfo().getIsAllowReturn()) && ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getReturnTimeLimit())) {
                throw new ZTBusinessException("\u3010\u9000\u8d27\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getIsAllowChange()) && DycProCommConstants.IsAllowAfterSale.YES.equals(updateSkuInfo.getSkuAfterSaleInfo().getIsAllowChange()) && ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getChangeTimeLimit())) {
                throw new ZTBusinessException("\u3010\u6362\u8d27\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getIsAllowMaintain()) && DycProCommConstants.IsAllowAfterSale.YES.equals(updateSkuInfo.getSkuAfterSaleInfo().getIsAllowMaintain()) && ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getMaintainTimeLimit())) {
                throw new ZTBusinessException("\u3010\u7ef4\u4fee\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)updateSkuInfo.getSkuPicInfoList())) {
            for (DycProCommSkuPicApiBO each : updateSkuInfo.getSkuPicInfoList()) {
                if (ObjectUtils.isEmpty((Object)each.getPicType())) {
                    throw new ZTBusinessException("\u3010\u56fe\u7247\u7c7b\u578b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtils.isEmpty((Object)each.getPicUrl())) {
                    throw new ZTBusinessException("\u3010\u56fe\u7247url\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!ObjectUtils.isEmpty((Object)each.getShowOrder())) continue;
                throw new ZTBusinessException("\u3010\u56fe\u7247\u5c55\u793a\u987a\u5e8f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (reqBO.getMiniFlag().equals(Integer.parseInt(BooleanFlag.YES.getCode()))) {
            // empty if block
        }
    }
}

