/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.skumanage.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainTradeMode;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.managecatalog.api.DycProCommManageCatalogRepository;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommPropertyTemplateInfoDTO;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommPropertyTemplateInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.CommFastCreateSkuInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuAfterSaleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuPicInfoDTO;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoDTO;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommDealFastCreateAgrSkuService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrItemBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrMainBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommDealFastCreateAgrSkuReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommDealFastCreateAgrSkuRspBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommFastCreateSkuInfoApiBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuAfterSaleInfoApiBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommDealFastCreateAgrSkuService"})
public class DycProCommDealFastCreateAgrSkuServiceImpl
implements DycProCommDealFastCreateAgrSkuService {
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommManageCatalogRepository dycProCommManageCatalogRepository;

    @PostMapping(value={"dealFastCreateAgrSku"})
    public DycProCommDealFastCreateAgrSkuRspBO dealFastCreateAgrSku(@RequestBody DycProCommDealFastCreateAgrSkuReqBO reqBO) {
        this.judge(reqBO);
        this.batchcreateAgrSku(reqBO);
        this.dealFastCreateInfo(reqBO);
        return new DycProCommDealFastCreateAgrSkuRspBO();
    }

    private void batchcreateAgrSku(DycProCommDealFastCreateAgrSkuReqBO reqBO) {
        DycProCommAgrMainBO agrInfo = reqBO.getAgrInfo();
        List agrItemList = reqBO.getAgrItemList();
        DycProCommFastCreateSkuInfoApiBO fastCreateSkuInfo = reqBO.getFastCreateSkuInfo();
        ArrayList<DycProCommSkuDTO> skuDTOList = new ArrayList<DycProCommSkuDTO>();
        DycProCommPropertyTemplateInfoQryDTO qryDTO = new DycProCommPropertyTemplateInfoQryDTO();
        qryDTO.setManageCatalogIdList(agrItemList.stream().map(DycProCommAgrItemBO::getManageCatalogId).collect(Collectors.toList()));
        List dycProCommPropertyTemplateInfoDTOS = this.dycProCommManageCatalogRepository.queryPropertyTemplateList(qryDTO);
        if (CollectionUtils.isEmpty((Collection)dycProCommPropertyTemplateInfoDTOS)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u7ba1\u7406\u7c7b\u76ee\u5bf9\u5e94\u7684\u5c5e\u6027\u6a21\u677f");
        }
        Map manageCatalogMap = dycProCommPropertyTemplateInfoDTOS.stream().collect(Collectors.toMap(DycProCommPropertyTemplateInfoDTO::getManageCatalogId, Function.identity()));
        for (DycProCommAgrItemBO agrItem : agrItemList) {
            DycProCommSkuDTO skuDTO = (DycProCommSkuDTO)JSON.parseObject((String)JSON.toJSONString((Object)agrInfo), DycProCommSkuDTO.class);
            if (!manageCatalogMap.containsKey(agrItem.getManageCatalogId())) {
                throw new ZTBusinessException(agrItem.getManageCatalogId() + "\uff0c\u8be5\u7ba1\u7406\u7c7b\u76eeid\u6ca1\u6709\u5bf9\u5e94\u7684\u5c5e\u6027\u6a21\u677f");
            }
            skuDTO.setPropertyTemplateId(((DycProCommPropertyTemplateInfoDTO)manageCatalogMap.get(agrItem.getManageCatalogId())).getPropertyTemplateId());
            skuDTO.setSkuStatus(DycProCommConstants.SkuStatus.DRAFT);
            skuDTO.setSkuSource(DycProCommConstants.SkuSource.AGR_SKU);
            skuDTO.setIsHaveGift(DycProCommConstants.IsHaveGift.NO);
            skuDTO.setDelFlag(DycProCommConstants.DelFlag.NO);
            if (!ObjectUtils.isEmpty((Object)agrItem.getCommodityName())) {
                skuDTO.setSkuName(agrItem.getCommodityName());
            } else if (!ObjectUtils.isEmpty((Object)agrItem.getMaterialName())) {
                skuDTO.setSkuName(agrItem.getMaterialName());
            } else {
                throw new ZTBusinessException("\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            skuDTO.setBrandName(agrItem.getBrandName());
            skuDTO.setMaterialClassifyId(agrItem.getMaterialClassifyId());
            skuDTO.setMaterialClassifyName(agrItem.getMaterialClassifyName());
            skuDTO.setMaterialId(agrItem.getMaterialId());
            skuDTO.setMaterialCode(agrItem.getMaterialCode());
            skuDTO.setMaterialName(agrItem.getMaterialName());
            skuDTO.setSaleMeasureId(agrItem.getMeasureId());
            skuDTO.setSaleMeasureName(agrItem.getMeasureName());
            skuDTO.setSaleMeasureRate(BigDecimal.ONE);
            skuDTO.setSettleMeasureId(agrItem.getMeasureId());
            skuDTO.setSettleMeasureName(agrItem.getMeasureName());
            skuDTO.setMinQuantity(fastCreateSkuInfo.getMinQuantity());
            skuDTO.setRate(agrItem.getTaxRate());
            skuDTO.setOnShelveWay(fastCreateSkuInfo.getOnShelveWay());
            skuDTO.setModel(agrItem.getModel());
            skuDTO.setSpec(agrItem.getSpec());
            if (!ObjectUtils.isEmpty((Object)fastCreateSkuInfo.getPicUrl())) {
                ArrayList<DycProCommSkuPicInfoDTO> skuPicInfoList = new ArrayList<DycProCommSkuPicInfoDTO>();
                DycProCommSkuPicInfoDTO picInfoDTO = new DycProCommSkuPicInfoDTO();
                picInfoDTO.setPicType(DycProCommConstants.PicType.MAIN_IMG);
                picInfoDTO.setPicUrl(fastCreateSkuInfo.getPicUrl());
                picInfoDTO.setShowOrder(Integer.valueOf(1));
                skuPicInfoList.add(picInfoDTO);
                skuDTO.setSkuPicInfoList(skuPicInfoList);
            }
            DycProCommSkuPriceInfoDTO priceInfo = new DycProCommSkuPriceInfoDTO();
            priceInfo.setSupplierPrice(agrItem.getSupplyPrice());
            if (agrInfo.getTradeMode().equals(Integer.parseInt(DmcAgrMainTradeMode.CH.getCode()))) {
                priceInfo.setSalePrice(priceInfo.getSupplierPrice());
            }
            skuDTO.setPriceInfo(priceInfo);
            skuDTO.setSkuAfterSaleInfo((DycProCommSkuAfterSaleInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)fastCreateSkuInfo.getSkuAfterSaleInfo()), DycProCommSkuAfterSaleInfoDTO.class));
            DycProCommSkuStockInfoDTO stockInfo = new DycProCommSkuStockInfoDTO();
            stockInfo.setOriginNum(agrItem.getAgrItemNumber());
            stockInfo.setTotalNum(agrItem.getAgrItemNumber());
            stockInfo.setUnsaleNum(agrItem.getAgrItemNumber());
            stockInfo.setSaledNum(BigDecimal.ZERO);
            stockInfo.setSkuName(skuDTO.getSkuName());
            stockInfo.setSupplierId(agrInfo.getSupplierId());
            stockInfo.setSupplierName(agrInfo.getSupplierName());
            stockInfo.setSaleMeasureId(agrItem.getMeasureId());
            stockInfo.setSaleMeasureName(agrItem.getMeasureName());
            stockInfo.setCreateUserId(reqBO.getUserId());
            stockInfo.setCreateUserName(reqBO.getName());
            stockInfo.setCreateUserAccount(reqBO.getUserName());
            stockInfo.setCreateCompanyId(reqBO.getCompanyId());
            stockInfo.setCreateOrgId(reqBO.getOrgId());
            stockInfo.setCreateCompanyName(reqBO.getCompanyName());
            stockInfo.setCreateOrgName(reqBO.getOrgName());
            stockInfo.setCreateTime(new Date(System.currentTimeMillis()));
            skuDTO.setStockInfo(stockInfo);
            skuDTO.setCreateUserId(reqBO.getUserId());
            skuDTO.setCreateUserName(reqBO.getName());
            skuDTO.setCreateUserAccount(reqBO.getUserName());
            skuDTO.setCreateCompanyId(reqBO.getCompanyId());
            skuDTO.setCreateOrgId(reqBO.getOrgId());
            skuDTO.setCreateOrgPath(reqBO.getOrgPath());
            skuDTO.setCreateCompanyName(reqBO.getCompanyName());
            skuDTO.setCreateOrgName(reqBO.getOrgName());
            skuDTO.setCreateTime(new Date(System.currentTimeMillis()));
            skuDTOList.add(skuDTO);
        }
        List dycProEsIndexMappingSkuBOS = this.dycProCommSkuRepository.addSkuCompleteInfoBatchAndSyncNosql(skuDTOList);
    }

    private void dealFastCreateInfo(DycProCommDealFastCreateAgrSkuReqBO reqBO) {
        Date date = new Date(System.currentTimeMillis());
        String json = JSON.toJSONString((Object)reqBO.getFastCreateSkuInfo());
        CommFastCreateSkuInfoDTO fastCreateSkuInfoDTO = new CommFastCreateSkuInfoDTO();
        fastCreateSkuInfoDTO.setFastCreateSkuJson(json);
        fastCreateSkuInfoDTO.setCreateUserId(reqBO.getUserId());
        fastCreateSkuInfoDTO.setCreateUserName(reqBO.getName());
        fastCreateSkuInfoDTO.setCreateUserAccount(reqBO.getUserName());
        fastCreateSkuInfoDTO.setCreateCompanyId(reqBO.getCompanyId());
        fastCreateSkuInfoDTO.setCreateOrgId(reqBO.getOrgId());
        fastCreateSkuInfoDTO.setCreateCompanyName(reqBO.getCompanyName());
        fastCreateSkuInfoDTO.setCreateOrgName(reqBO.getOrgName());
        fastCreateSkuInfoDTO.setCreateTime(date);
        fastCreateSkuInfoDTO.setUpdateUserId(reqBO.getUserId());
        fastCreateSkuInfoDTO.setUpdateUserName(reqBO.getName());
        fastCreateSkuInfoDTO.setUpdateUserAccount(reqBO.getUserName());
        fastCreateSkuInfoDTO.setUpdateCompanyId(reqBO.getCompanyId());
        fastCreateSkuInfoDTO.setUpdateOrgId(reqBO.getOrgId());
        fastCreateSkuInfoDTO.setUpdateCompanyName(reqBO.getCompanyName());
        fastCreateSkuInfoDTO.setUpdateOrgName(reqBO.getOrgName());
        fastCreateSkuInfoDTO.setUpdateTime(date);
        this.dycProCommSkuRepository.dealFastCreateInfo(fastCreateSkuInfoDTO);
    }

    private void judge(DycProCommDealFastCreateAgrSkuReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrInfo())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getAgrItemList())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u660e\u7ec6\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getFastCreateSkuInfo())) {
            throw new ZTBusinessException("\u3010\u6025\u901f\u94fa\u8d27\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrInfo().getAgrId())) {
            throw new ZTBusinessException("\u3010\u534f\u8baeID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrInfo().getAgrCode())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u7f16\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrInfo().getAgrName())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrInfo().getTradeMode())) {
            throw new ZTBusinessException("\u3010\u4ea4\u6613\u6a21\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrInfo().getSupplierId())) {
            throw new ZTBusinessException("\u3010\u4f9b\u8d27\u5546ID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrInfo().getSupplierName())) {
            throw new ZTBusinessException("\u3010\u4f9b\u8d27\u5546\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getFastCreateSkuInfo().getMinQuantity())) {
            throw new ZTBusinessException("\u3010\u6700\u5c0f\u8d77\u8ba2\u91cf\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getFastCreateSkuInfo().getOnShelveWay())) {
            throw new ZTBusinessException("\u3010\u4e0a\u67b6\u65b9\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getFastCreateSkuInfo().getSkuAfterSaleInfo())) {
            throw new ZTBusinessException("\u3010sku\u552e\u540e\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProCommSkuAfterSaleInfoApiBO skuAfterSaleInfo = reqBO.getFastCreateSkuInfo().getSkuAfterSaleInfo();
        if (ObjectUtils.isEmpty((Object)skuAfterSaleInfo.getIsAllowReturn())) {
            throw new ZTBusinessException("\u3010\u662f\u5426\u652f\u6301\u9000\u8d27\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DycProCommConstants.IsAllowAfterSale.YES.equals(skuAfterSaleInfo.getIsAllowReturn()) && ObjectUtils.isEmpty((Object)skuAfterSaleInfo.getReturnTimeLimit())) {
            throw new ZTBusinessException("\u3010\u9000\u8d27\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)skuAfterSaleInfo.getIsAllowChange())) {
            throw new ZTBusinessException("\u3010\u662f\u5426\u652f\u6301\u6362\u8d27\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DycProCommConstants.IsAllowAfterSale.YES.equals(skuAfterSaleInfo.getIsAllowChange()) && ObjectUtils.isEmpty((Object)skuAfterSaleInfo.getChangeTimeLimit())) {
            throw new ZTBusinessException("\u3010\u6362\u8d27\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)skuAfterSaleInfo.getIsAllowMaintain())) {
            throw new ZTBusinessException("\u3010\u662f\u5426\u652f\u6301\u7ef4\u4fee\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DycProCommConstants.IsAllowAfterSale.YES.equals(skuAfterSaleInfo.getIsAllowMaintain()) && ObjectUtils.isEmpty((Object)skuAfterSaleInfo.getMaintainTimeLimit())) {
            throw new ZTBusinessException("\u3010\u7ef4\u4fee\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycProCommAgrItemBO agrItem : reqBO.getAgrItemList()) {
            if (ObjectUtils.isEmpty((Object)agrItem.getManageCatalogId())) {
                throw new ZTBusinessException("\u3010\u540e\u53f0\u7ba1\u7406\u7c7b\u76eeID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrItem.getBrandName())) {
                throw new ZTBusinessException("\u3010\u54c1\u724c\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrItem.getMeasureId())) {
                throw new ZTBusinessException("\u3010\u8ba1\u91cf\u5355\u4f4dID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrItem.getMeasureName())) {
                throw new ZTBusinessException("\u3010\u8ba1\u91cf\u5355\u4f4d\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrItem.getAgrItemNumber())) {
                throw new ZTBusinessException("\u3010\u6570\u91cf\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrItem.getSupplyPrice())) {
                throw new ZTBusinessException("\u3010\u4f9b\u8d27\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtils.isEmpty((Object)agrItem.getTaxRate())) continue;
            throw new ZTBusinessException("\u3010\u7a0e\u7387\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

