/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.skumanage.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordActionTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordOperateResultEnum;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.approve.api.DycProCommPublicProcTaskInstRepository;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPackageInfoDTO;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPakageObjDTO;
import com.tydic.dyc.pro.dmc.repository.operaterecord.api.DycProCommOperateRecordRepository;
import com.tydic.dyc.pro.dmc.repository.operaterecord.dto.DycProCommOperateRecordDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuHandleDTO;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommSkuOnShelveService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuInfoBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuOnShelveReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuOnShelveRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommSkuOnShelveService"})
public class DycProCommSkuOnShelveServiceImpl
implements DycProCommSkuOnShelveService {
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommOperateRecordRepository dycProCommOperateRecordRepository;
    @Autowired
    private DycProCommPublicProcTaskInstRepository dycProCommPublicProcTaskInstRepository;

    @PostMapping(value={"dealSkuOnShelve"})
    public DycProCommSkuOnShelveRspBO dealSkuOnShelve(@RequestBody DycProCommSkuOnShelveReqBO reqBO) {
        this.val(reqBO);
        List reqSkuIdList = reqBO.getSkuInfoList().stream().map(DycProCommSkuInfoBO::getSkuId).collect(Collectors.toList());
        DycProCommSkuHandleDTO qrySkuHandleDTO = new DycProCommSkuHandleDTO();
        qrySkuHandleDTO.setSkuIdList(reqSkuIdList);
        List commSkuDTOList = this.dycProCommSkuRepository.getSkuMainListByCondition(qrySkuHandleDTO);
        if (CollectionUtils.isEmpty((Collection)commSkuDTOList)) {
            throw new ZTBusinessException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (reqSkuIdList.size() != commSkuDTOList.size()) {
            throw new ZTBusinessException("\u8bf7\u6c42\u6570\u636e\u4e0e\u6570\u636e\u5e93\u67e5\u8be2\u7ed3\u679c\u4e0d\u5339\u914d");
        }
        List<DycProCommSkuDTO> skuInfoList = commSkuDTOList.stream().filter(o -> (DycProCommConstants.SkuStatus.TOBE_ON_SHELVES.equals(o.getSkuStatus()) || DycProCommConstants.SkuStatus.OFF_SHELVES.equals(o.getSkuStatus())) && !DycProCommConstants.ApprovalStatus.ON_SHELVE_IN_APPROVAL.equals(o.getApprovalStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(skuInfoList)) {
            throw new ZTBusinessException("\u6240\u9009\u5546\u54c1\u4e0d\u53ef\u64cd\u4f5c\u4e0a\u67b6");
        }
        DycProCommSkuOnShelveRspBO rspBO = new DycProCommSkuOnShelveRspBO();
        Date now = new Date();
        List skuIds = skuInfoList.stream().map(DycProCommSkuDTO::getSkuId).collect(Collectors.toList());
        DycProCommSkuHandleDTO updateSkuInfoDto = new DycProCommSkuHandleDTO();
        updateSkuInfoDto.setUpdateUserId(reqBO.getUserId());
        updateSkuInfoDto.setUpdateUserName(reqBO.getName());
        updateSkuInfoDto.setUserName(reqBO.getUserName());
        updateSkuInfoDto.setUpdateCompanyId(reqBO.getCompanyId());
        updateSkuInfoDto.setUpdateOrgId(reqBO.getOrgId());
        updateSkuInfoDto.setUpdateOrgPath(reqBO.getOrgPath());
        updateSkuInfoDto.setUpdateCompanyName(reqBO.getCompanyName());
        updateSkuInfoDto.setUpdateOrgName(reqBO.getOrgName());
        updateSkuInfoDto.setUpdateTime(now);
        updateSkuInfoDto.setSkuIdList(skuIds);
        ArrayList<String> nullColumnList = new ArrayList<String>();
        if (!reqBO.getApproveOnShelveSwitch().booleanValue() || DycProCommConstants.SkuOnShelveOperFlag.MANDATORY_SHELVES.equals(reqBO.getOperFlag())) {
            updateSkuInfoDto.setSkuStatus(DycProCommConstants.SkuStatus.ON_SHELVES);
            updateSkuInfoDto.setOnShelveTime(now);
            this.insertOperateRecord(skuInfoList, updateSkuInfoDto, reqBO);
            nullColumnList.add("APPROVAL_STATUS");
        } else {
            updateSkuInfoDto.setApprovalStatus(DycProCommConstants.ApprovalStatus.ON_SHELVE_IN_APPROVAL);
            Long auditPackageId = Sequence.getInstance().nextId();
            rspBO.setAuditPackageId(auditPackageId);
            this.insertAuditPackage(auditPackageId, updateSkuInfoDto, reqBO);
        }
        this.dycProCommSkuRepository.updateSkuInfoNullByIdsAndSyncNoSql(updateSkuInfoDto, nullColumnList);
        return rspBO;
    }

    private void val(DycProCommSkuOnShelveReqBO reqBO) {
        if (null == reqBO.getOperFlag()) {
            throw new ZTBusinessException("\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuInfoList())) {
            throw new ZTBusinessException("\u5165\u53c2\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycProCommSkuInfoBO dycProCommSkuInfoBO : reqBO.getSkuInfoList()) {
            if (null != dycProCommSkuInfoBO.getSkuId()) continue;
            throw new ZTBusinessException("\u5165\u53c2\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DycProCommConstants.SkuOnShelveOperFlag.MANDATORY_SHELVES.equals(reqBO.getOperFlag()) && StringUtils.isBlank((CharSequence)reqBO.getReason())) {
            throw new ZTBusinessException("\u5f3a\u5236\u4e0a\u67b6\u65f6\u4e0a\u67b6\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void insertAuditPackage(Long auditPackageId, DycProCommSkuHandleDTO updateSkuInfoDto, DycProCommSkuOnShelveReqBO reqBO) {
        DycProCommAuditPackageInfoDTO dycProCommAuditPackageInfoDTO = new DycProCommAuditPackageInfoDTO();
        dycProCommAuditPackageInfoDTO.setAuditPackageId(auditPackageId);
        List skuInfoList = reqBO.getSkuInfoList().stream().filter(o -> updateSkuInfoDto.getSkuIdList().contains(o.getSkuId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(skuInfoList)) {
            List auditPackageObjDTOList = JSON.parseArray((String)JSON.toJSONString(skuInfoList), DycProCommAuditPakageObjDTO.class);
            for (DycProCommAuditPakageObjDTO commAuditPackageObjDTO : auditPackageObjDTOList) {
                commAuditPackageObjDTO.setCreateTime(updateSkuInfoDto.getUpdateTime());
                commAuditPackageObjDTO.setAuditPackageId(auditPackageId);
                commAuditPackageObjDTO.setDelTag(DycProCommConstants.DelFlag.NO);
            }
            dycProCommAuditPackageInfoDTO.setAuditPakageObjDTOList(auditPackageObjDTOList);
        }
        this.dycProCommPublicProcTaskInstRepository.addAuditPackageBatch(dycProCommAuditPackageInfoDTO);
    }

    private void insertOperateRecord(List<DycProCommSkuDTO> skuInfoList, DycProCommSkuHandleDTO reqDto, DycProCommSkuOnShelveReqBO reqBO) {
        ArrayList<DycProCommOperateRecordDTO> operateRecordPOList = new ArrayList<DycProCommOperateRecordDTO>();
        for (DycProCommSkuDTO skuInfoPO : skuInfoList) {
            DycProCommOperateRecordDTO commOperateRecordPO = new DycProCommOperateRecordDTO();
            commOperateRecordPO.setObjId(skuInfoPO.getSkuId());
            commOperateRecordPO.setObjCode(skuInfoPO.getSkuCode());
            commOperateRecordPO.setObjType(DycProCommConstants.OperateRecordObjType.SKU);
            commOperateRecordPO.setOperateTime(reqDto.getUpdateTime());
            commOperateRecordPO.setOperateUserId(reqDto.getUpdateUserId());
            commOperateRecordPO.setOperateUserAccount(reqDto.getUserName());
            commOperateRecordPO.setOperateUserName(reqDto.getUpdateUserName());
            commOperateRecordPO.setOperateUserType(DycProCommConstants.OperateUserType.USER);
            commOperateRecordPO.setOperateReason(reqBO.getReason());
            if (DycProCommConstants.SkuOnShelveOperFlag.ON_SHELVE.equals(reqBO.getOperFlag())) {
                commOperateRecordPO.setActionType(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordActionTypeEnum.ON_SHELVE.getCode())));
                commOperateRecordPO.setActionName(DmcCommOperateRecordActionTypeEnum.ON_SHELVE.getValue());
            }
            if (DycProCommConstants.SkuOnShelveOperFlag.MANDATORY_SHELVES.equals(reqBO.getOperFlag())) {
                commOperateRecordPO.setActionType(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordActionTypeEnum.MANDATORY_SHELVE.getCode())));
                commOperateRecordPO.setActionName(DmcCommOperateRecordActionTypeEnum.MANDATORY_SHELVE.getValue());
            }
            commOperateRecordPO.setOperateResult(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordOperateResultEnum.SUCCESS_ON_SHELVE.getCode())));
            commOperateRecordPO.setOperateResultDesc(DmcCommOperateRecordOperateResultEnum.SUCCESS_ON_SHELVE.getValue());
            operateRecordPOList.add(commOperateRecordPO);
        }
        this.dycProCommOperateRecordRepository.addOperateRecordBatch(operateRecordPOList);
    }
}

