/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.skumanage.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuManageCatalogBO;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainTradeMode;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckObjEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckSenceEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordActionTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordOperateResultEnum;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.approve.api.DycProCommPublicProcTaskInstRepository;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPackageInfoDTO;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPakageObjDTO;
import com.tydic.dyc.pro.dmc.repository.bansrecord.api.DycProCommBansRecordRepository;
import com.tydic.dyc.pro.dmc.repository.bansrecord.bo.DycProCommBansRecordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.catalogban.api.DycProCommCatalogBanRepository;
import com.tydic.dyc.pro.dmc.repository.catalogban.dto.DycProCommCatalogBanInfoDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRecordRepository;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommExecCheckRuleDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommImageCheckRuleParamDTO;
import com.tydic.dyc.pro.dmc.repository.managecatalog.api.DycProCommManageCatalogRepository;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommPropertyTemplateInfoDTO;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommPropertyTemplateInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.operaterecord.api.DycProCommOperateRecordRepository;
import com.tydic.dyc.pro.dmc.repository.operaterecord.dto.DycProCommOperateRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.CommFastCreateSkuInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommAgrDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuAfterSaleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDetailsInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuPicInfoDTO;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoDTO;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommDealFastCreateAgrSkuService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrItemBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrMainBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommDealFastCreateAgrSkuReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommDealFastCreateAgrSkuRspBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommFastCreateSkuInfoApiBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuAfterSaleInfoApiBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommDealFastCreateAgrSkuService"})
public class DycProCommDealFastCreateAgrSkuServiceImpl
implements DycProCommDealFastCreateAgrSkuService {
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommManageCatalogRepository dycProCommManageCatalogRepository;
    @Autowired
    private DycProCommPublicProcTaskInstRepository dycProCommPublicProcTaskInstRepository;
    @Autowired
    private DycProCommOperateRecordRepository dycProCommOperateRecordRepository;
    @Autowired
    private DycProCommCheckRecordRepository dycProCommCheckRecordRepository;
    @Autowired
    private DycProCommCatalogBanRepository dycProCommCatalogBanRepository;
    @Autowired
    private DycProCommBansRecordRepository dycProCommBansRecordRepository;
    @Value(value="${is.need.image-text.check}")
    private String isNeedImageTextCheck;
    @Value(value="${is.need.price.check}")
    private String isNeedPriceCheck;

    @PostMapping(value={"dealFastCreateAgrSku"})
    public DycProCommDealFastCreateAgrSkuRspBO dealFastCreateAgrSku(@RequestBody DycProCommDealFastCreateAgrSkuReqBO reqBO) {
        this.judge(reqBO);
        List<DycProEsIndexMappingSkuBO> dycProEsIndexMappingSkuBOS = this.batchCreateAgrSku(reqBO);
        DycProCommDealFastCreateAgrSkuRspBO rspBO = new DycProCommDealFastCreateAgrSkuRspBO();
        if (reqBO.getUccApproveOnShelveAgreementSwitch().booleanValue() && reqBO.getFastCreateSkuInfo().getOnShelveWay().equals(DycProCommConstants.SkuOnShelveWay.AUTO_ON_SHELVE)) {
            Long auditPackageId = Sequence.getInstance().nextId();
            rspBO.setAuditPackageId(auditPackageId);
            this.insertAuditPackage(auditPackageId, dycProEsIndexMappingSkuBOS);
        }
        this.dealFastCreateInfo(reqBO);
        return rspBO;
    }

    private List<DycProEsIndexMappingSkuBO> batchCreateAgrSku(DycProCommDealFastCreateAgrSkuReqBO reqBO) {
        DycProCommAgrMainBO agrInfo = reqBO.getAgrInfo();
        List agrItemList = reqBO.getAgrItemList();
        DycProCommFastCreateSkuInfoApiBO fastCreateSkuInfo = reqBO.getFastCreateSkuInfo();
        ArrayList<DycProCommSkuDTO> skuDTOList = new ArrayList<DycProCommSkuDTO>();
        DycProCommPropertyTemplateInfoQryDTO qryDTO = new DycProCommPropertyTemplateInfoQryDTO();
        qryDTO.setManageCatalogIdList(agrItemList.stream().map(DycProCommAgrItemBO::getManageCatalogId).collect(Collectors.toList()));
        List dycProCommPropertyTemplateInfoDTOS = this.dycProCommManageCatalogRepository.queryPropertyTemplateList(qryDTO);
        if (CollectionUtils.isEmpty((Collection)dycProCommPropertyTemplateInfoDTOS)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u7ba1\u7406\u7c7b\u76ee\u5bf9\u5e94\u7684\u5c5e\u6027\u6a21\u677f");
        }
        Map manageCatalogMap = dycProCommPropertyTemplateInfoDTOS.stream().collect(Collectors.toMap(DycProCommPropertyTemplateInfoDTO::getManageCatalogId, Function.identity()));
        boolean operateRecordFlag = false;
        for (DycProCommAgrItemBO agrItem : agrItemList) {
            DycProCommSkuDTO skuDTO = (DycProCommSkuDTO)JSON.parseObject((String)JSON.toJSONString((Object)agrInfo), DycProCommSkuDTO.class);
            if (!manageCatalogMap.containsKey(agrItem.getManageCatalogId()) || ((DycProCommPropertyTemplateInfoDTO)manageCatalogMap.get(agrItem.getManageCatalogId())).getPropertyTemplateId() == null) {
                throw new ZTBusinessException(agrItem.getManageCatalogId() + "\uff0c\u8be5\u7ba1\u7406\u7c7b\u76eeid\u6ca1\u6709\u5bf9\u5e94\u7684\u5c5e\u6027\u6a21\u677f");
            }
            skuDTO.setPropertyTemplateId(((DycProCommPropertyTemplateInfoDTO)manageCatalogMap.get(agrItem.getManageCatalogId())).getPropertyTemplateId());
            if (reqBO.getFastCreateSkuInfo().getOnShelveWay().equals(DycProCommConstants.SkuOnShelveWay.AUTO_ON_SHELVE)) {
                if (reqBO.getUccApproveOnShelveAgreementSwitch().booleanValue()) {
                    skuDTO.setSkuStatus(DycProCommConstants.SkuStatus.TOBE_ON_SHELVES);
                    skuDTO.setApprovalStatus(DycProCommConstants.ApprovalStatus.ON_SHELVE_IN_APPROVAL);
                } else {
                    operateRecordFlag = true;
                    skuDTO.setSkuStatus(DycProCommConstants.SkuStatus.ON_SHELVES);
                    skuDTO.setOnShelveTime(new Date(System.currentTimeMillis()));
                }
            } else {
                skuDTO.setSkuStatus(DycProCommConstants.SkuStatus.TOBE_ON_SHELVES);
            }
            skuDTO.setSkuSource(DycProCommConstants.SkuSource.AGR_SKU);
            skuDTO.setIsHaveGift(DycProCommConstants.IsHaveGift.NO);
            skuDTO.setDelFlag(DycProCommConstants.DelFlag.NO);
            if (!ObjectUtils.isEmpty((Object)agrItem.getCommodityName())) {
                skuDTO.setSkuName(agrItem.getCommodityName());
            } else if (!ObjectUtils.isEmpty((Object)agrItem.getMaterialName())) {
                skuDTO.setSkuName(agrItem.getMaterialName());
            } else {
                throw new ZTBusinessException("\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            skuDTO.setAgrItemId(agrItem.getAgrItemId());
            skuDTO.setSupplyCycle(agrItem.getSupplyCycle());
            skuDTO.setBrandName(agrItem.getBrandName());
            skuDTO.setMaterialClassifyId(agrItem.getMaterialClassifyId());
            skuDTO.setMaterialClassifyName(agrItem.getMaterialClassifyName());
            skuDTO.setMaterialId(agrItem.getMaterialId());
            skuDTO.setMaterialCode(agrItem.getMaterialCode());
            skuDTO.setMaterialName(agrItem.getMaterialName());
            skuDTO.setSaleMeasureId(agrItem.getMeasureId());
            skuDTO.setSaleMeasureName(agrItem.getMeasureName());
            skuDTO.setSaleMeasureRate(BigDecimal.ONE);
            skuDTO.setSettleMeasureId(agrItem.getMeasureId());
            skuDTO.setSettleMeasureName(agrItem.getMeasureName());
            skuDTO.setMinQuantity(fastCreateSkuInfo.getMinQuantity());
            skuDTO.setRate(agrItem.getTaxRate());
            skuDTO.setOnShelveWay(fastCreateSkuInfo.getOnShelveWay());
            skuDTO.setModel(agrItem.getModel());
            skuDTO.setSpec(agrItem.getSpec());
            DycProCommSkuDetailsInfoDTO skuDetails = new DycProCommSkuDetailsInfoDTO();
            skuDTO.setSkuDetails(skuDetails);
            if (!ObjectUtils.isEmpty((Object)fastCreateSkuInfo.getPicUrl())) {
                ArrayList<DycProCommSkuPicInfoDTO> skuPicInfoList = new ArrayList<DycProCommSkuPicInfoDTO>();
                DycProCommSkuPicInfoDTO picInfoDTO = new DycProCommSkuPicInfoDTO();
                picInfoDTO.setPicType(DycProCommConstants.PicType.MAIN_IMG);
                picInfoDTO.setPicUrl(fastCreateSkuInfo.getPicUrl());
                picInfoDTO.setShowOrder(Integer.valueOf(1));
                skuPicInfoList.add(picInfoDTO);
                skuDTO.setSkuPicInfoList(skuPicInfoList);
            }
            DycProCommSkuPriceInfoDTO priceInfo = new DycProCommSkuPriceInfoDTO();
            priceInfo.setSupplierPrice(agrItem.getSupplyPrice());
            if (agrInfo.getTradeMode().equals(Integer.parseInt(DmcAgrMainTradeMode.CH.getCode()))) {
                priceInfo.setSalePrice(priceInfo.getSupplierPrice());
            } else {
                priceInfo.setSalePrice(priceInfo.getSupplierPrice());
            }
            skuDTO.setPriceInfo(priceInfo);
            skuDTO.setSkuAfterSaleInfo((DycProCommSkuAfterSaleInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)fastCreateSkuInfo.getSkuAfterSaleInfo()), DycProCommSkuAfterSaleInfoDTO.class));
            DycProCommSkuStockInfoDTO stockInfo = new DycProCommSkuStockInfoDTO();
            stockInfo.setOriginNum(agrItem.getAgrItemNumber());
            stockInfo.setTotalNum(agrItem.getAgrItemNumber());
            stockInfo.setUnsaleNum(agrItem.getAgrItemNumber());
            stockInfo.setSaledNum(BigDecimal.ZERO);
            stockInfo.setSkuName(skuDTO.getSkuName());
            stockInfo.setSupplierId(agrInfo.getSupplierId());
            stockInfo.setSupplierName(agrInfo.getSupplierName());
            stockInfo.setSaleMeasureId(agrItem.getMeasureId());
            stockInfo.setSaleMeasureName(agrItem.getMeasureName());
            stockInfo.setCreateUserId(reqBO.getUserId());
            stockInfo.setCreateUserName(reqBO.getName());
            stockInfo.setCreateUserAccount(reqBO.getUserName());
            stockInfo.setCreateCompanyId(reqBO.getCompanyId());
            stockInfo.setCreateOrgId(reqBO.getOrgId());
            stockInfo.setCreateCompanyName(reqBO.getCompanyName());
            stockInfo.setCreateOrgName(reqBO.getOrgName());
            stockInfo.setCreateTime(new Date(System.currentTimeMillis()));
            skuDTO.setStockInfo(stockInfo);
            skuDTO.setSkuAgrInfo((DycProCommAgrDTO)JSON.parseObject((String)JSON.toJSONString((Object)agrInfo), DycProCommAgrDTO.class));
            skuDTO.setCreateUserId(reqBO.getUserId());
            skuDTO.setCreateUserName(reqBO.getName());
            skuDTO.setCreateUserAccount(reqBO.getUserName());
            skuDTO.setCreateCompanyId(reqBO.getCompanyId());
            skuDTO.setCreateOrgId(reqBO.getOrgId());
            skuDTO.setCreateOrgPath(reqBO.getOrgPath());
            skuDTO.setCreateCompanyName(reqBO.getCompanyName());
            skuDTO.setCreateOrgName(reqBO.getOrgName());
            skuDTO.setCreateTime(new Date(System.currentTimeMillis()));
            skuDTOList.add(skuDTO);
        }
        List dycProEsIndexMappingSkuBOS = this.dycProCommSkuRepository.addSkuCompleteInfoBatchAndSyncNosql(skuDTOList);
        if (operateRecordFlag) {
            this.insertOperateRecord(dycProEsIndexMappingSkuBOS, reqBO);
        }
        for (DycProEsIndexMappingSkuBO dycProEsIndexMappingSkuBO : dycProEsIndexMappingSkuBOS) {
            this.pushSkuCheck(dycProEsIndexMappingSkuBO);
            this.dealSkuForbidSale(dycProEsIndexMappingSkuBO);
        }
        return dycProEsIndexMappingSkuBOS;
    }

    private void dealFastCreateInfo(DycProCommDealFastCreateAgrSkuReqBO reqBO) {
        Date date = new Date(System.currentTimeMillis());
        String json = JSON.toJSONString((Object)reqBO.getFastCreateSkuInfo());
        CommFastCreateSkuInfoDTO fastCreateSkuInfoDTO = new CommFastCreateSkuInfoDTO();
        fastCreateSkuInfoDTO.setFastCreateSkuJson(json);
        fastCreateSkuInfoDTO.setCreateUserId(reqBO.getUserId());
        fastCreateSkuInfoDTO.setCreateUserName(reqBO.getName());
        fastCreateSkuInfoDTO.setCreateUserAccount(reqBO.getUserName());
        fastCreateSkuInfoDTO.setCreateCompanyId(reqBO.getCompanyId());
        fastCreateSkuInfoDTO.setCreateOrgId(reqBO.getOrgId());
        fastCreateSkuInfoDTO.setCreateCompanyName(reqBO.getCompanyName());
        fastCreateSkuInfoDTO.setCreateOrgName(reqBO.getOrgName());
        fastCreateSkuInfoDTO.setCreateTime(date);
        fastCreateSkuInfoDTO.setUpdateUserId(reqBO.getUserId());
        fastCreateSkuInfoDTO.setUpdateUserName(reqBO.getName());
        fastCreateSkuInfoDTO.setUpdateUserAccount(reqBO.getUserName());
        fastCreateSkuInfoDTO.setUpdateCompanyId(reqBO.getCompanyId());
        fastCreateSkuInfoDTO.setUpdateOrgId(reqBO.getOrgId());
        fastCreateSkuInfoDTO.setUpdateCompanyName(reqBO.getCompanyName());
        fastCreateSkuInfoDTO.setUpdateOrgName(reqBO.getOrgName());
        fastCreateSkuInfoDTO.setUpdateTime(date);
        this.dycProCommSkuRepository.dealFastCreateInfo(fastCreateSkuInfoDTO);
    }

    private void insertAuditPackage(Long auditPackageId, List<DycProEsIndexMappingSkuBO> dycProEsIndexMappingSkuBOS) {
        DycProCommAuditPackageInfoDTO dycProCommAuditPackageInfoDTO = new DycProCommAuditPackageInfoDTO();
        dycProCommAuditPackageInfoDTO.setAuditPackageId(auditPackageId);
        List auditPackageObjDTOList = JSON.parseArray((String)JSON.toJSONString(dycProEsIndexMappingSkuBOS), DycProCommAuditPakageObjDTO.class);
        for (DycProCommAuditPakageObjDTO commAuditPackageObjDTO : auditPackageObjDTOList) {
            commAuditPackageObjDTO.setCreateTime(new Date(System.currentTimeMillis()));
            commAuditPackageObjDTO.setAuditPackageId(auditPackageId);
            commAuditPackageObjDTO.setDelTag(DycProCommConstants.DelFlag.NO);
        }
        dycProCommAuditPackageInfoDTO.setAuditPakageObjDTOList(auditPackageObjDTOList);
        this.dycProCommPublicProcTaskInstRepository.addAuditPackageBatch(dycProCommAuditPackageInfoDTO);
    }

    private void insertOperateRecord(List<DycProEsIndexMappingSkuBO> dycProEsIndexMappingSkuBOS, DycProCommDealFastCreateAgrSkuReqBO reqBO) {
        ArrayList<DycProCommOperateRecordDTO> operateRecordPOList = new ArrayList<DycProCommOperateRecordDTO>();
        for (DycProEsIndexMappingSkuBO each : dycProEsIndexMappingSkuBOS) {
            DycProCommOperateRecordDTO commOperateRecordPO = new DycProCommOperateRecordDTO();
            commOperateRecordPO.setObjId(each.getSkuId());
            commOperateRecordPO.setObjCode(each.getSkuCode());
            commOperateRecordPO.setObjType(DycProCommConstants.OperateRecordObjType.SKU);
            commOperateRecordPO.setOperateTime(new Date(System.currentTimeMillis()));
            commOperateRecordPO.setOperateUserId(reqBO.getUserId());
            commOperateRecordPO.setOperateUserAccount(reqBO.getUserName());
            commOperateRecordPO.setOperateUserName(reqBO.getName());
            commOperateRecordPO.setOperateUserType(DycProCommConstants.OperateUserType.USER);
            commOperateRecordPO.setOperateReason("\u6025\u901f\u94fa\u8d27\u65f6\u9009\u62e9\u4e86\u7acb\u5373\u4e0a\u67b6\uff0c\u4e14\u4e0d\u9700\u8981\u4e0a\u67b6\u5ba1\u6279");
            commOperateRecordPO.setActionType(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordActionTypeEnum.ON_SHELVE.getCode())));
            commOperateRecordPO.setActionName(DmcCommOperateRecordActionTypeEnum.ON_SHELVE.getValue());
            commOperateRecordPO.setOperateResult(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordOperateResultEnum.SUCCESS_ON_SHELVE.getCode())));
            commOperateRecordPO.setOperateResultDesc(DmcCommOperateRecordOperateResultEnum.SUCCESS_ON_SHELVE.getValue());
            operateRecordPOList.add(commOperateRecordPO);
        }
        this.dycProCommOperateRecordRepository.addOperateRecordBatch(operateRecordPOList);
    }

    private void pushSkuCheck(DycProEsIndexMappingSkuBO dycProEsIndexMappingSkuBO) {
        if ("YES".equals(this.isNeedImageTextCheck)) {
            DycProCommExecCheckRuleDTO checkRuleDto = new DycProCommExecCheckRuleDTO();
            checkRuleDto.setCheckObjId(dycProEsIndexMappingSkuBO.getSkuId());
            checkRuleDto.setCheckObjType(Integer.valueOf(Integer.parseInt(DmcCommCheckObjEnum.AGR_GOODS.getCode())));
            checkRuleDto.setCheckObjCode(dycProEsIndexMappingSkuBO.getSkuCode());
            checkRuleDto.setCheckObjName(dycProEsIndexMappingSkuBO.getSkuName());
            checkRuleDto.setCheckExtObjCode(dycProEsIndexMappingSkuBO.getExtSkuId());
            checkRuleDto.setSupplierId(dycProEsIndexMappingSkuBO.getSupplierId());
            checkRuleDto.setSupplierName(dycProEsIndexMappingSkuBO.getSupplierName());
            List manageCatalogList = dycProEsIndexMappingSkuBO.getManageCatalogList();
            Long manageCatalogId = ((DycProEsIndexMappingSkuManageCatalogBO)manageCatalogList.get(manageCatalogList.size() - 1)).getManageCatalogId();
            checkRuleDto.setCatalogId(manageCatalogId);
            checkRuleDto.setManageCatalogPath(dycProEsIndexMappingSkuBO.getManageCatalogPath());
            checkRuleDto.setManageCatalogPathName(dycProEsIndexMappingSkuBO.getManageCatalogPathName());
            checkRuleDto.setCheckSceneCode(DmcCommCheckSenceEnum.ADD_GOODS.getCode());
            ArrayList<Integer> ruleTypes = new ArrayList<Integer>();
            if ("YES".equals(this.isNeedImageTextCheck)) {
                ruleTypes.add(Integer.parseInt(DmcCommCheckRuleTypeEnum.IMAGE_CHECK.getCode()));
                DycProCommImageCheckRuleParamDTO imageCheckRuleParam = new DycProCommImageCheckRuleParamDTO();
                imageCheckRuleParam.setCheckText(dycProEsIndexMappingSkuBO.getSkuName());
                ArrayList<String> imageUrl = new ArrayList<String>();
                imageUrl.add(dycProEsIndexMappingSkuBO.getMainImageUrl());
                imageCheckRuleParam.setImageUrl(imageUrl);
                checkRuleDto.setImageCheckRuleParam(imageCheckRuleParam);
            }
            checkRuleDto.setCheckRuleTypes(ruleTypes);
            this.dycProCommCheckRecordRepository.execCheckRule(checkRuleDto);
        }
    }

    private void dealSkuForbidSale(DycProEsIndexMappingSkuBO dycProEsIndexMappingSkuBO) {
        Long supplierId;
        ArrayList<DycProCommBansRecordInfoDTO> addBansRecordDtoList = new ArrayList<DycProCommBansRecordInfoDTO>();
        List manageCatalogList = dycProEsIndexMappingSkuBO.getManageCatalogList();
        Long manageCatalogId = ((DycProEsIndexMappingSkuManageCatalogBO)manageCatalogList.get(manageCatalogList.size() - 1)).getManageCatalogId();
        List dycProCommCatalogBanInfoDTOS = this.dycProCommCatalogBanRepository.qryBansInfoByCatalogId(manageCatalogId, supplierId = dycProEsIndexMappingSkuBO.getSupplierId());
        if (!CollectionUtils.isEmpty((Collection)dycProCommCatalogBanInfoDTOS)) {
            for (DycProCommCatalogBanInfoDTO commCatalogBanInfoDto : dycProCommCatalogBanInfoDTOS) {
                DycProCommBansRecordInfoDTO addBansRecordInfoDto = new DycProCommBansRecordInfoDTO();
                addBansRecordInfoDto.setSkuId(dycProEsIndexMappingSkuBO.getSkuId());
                addBansRecordInfoDto.setBansType(DycProCommConstants.BansType.BANS_RULE);
                addBansRecordInfoDto.setBansRuleId(commCatalogBanInfoDto.getBansRuleId());
                addBansRecordInfoDto.setBansReason(commCatalogBanInfoDto.getBansReason());
                addBansRecordInfoDto.setBansStartDate(commCatalogBanInfoDto.getBansStartDate());
                addBansRecordInfoDto.setBansEndDate(commCatalogBanInfoDto.getBansEndDate());
                addBansRecordInfoDto.setCreateTime(new Date());
                addBansRecordDtoList.add(addBansRecordInfoDto);
            }
        }
        if (!CollectionUtils.isEmpty(addBansRecordDtoList)) {
            this.dycProCommBansRecordRepository.addBansRecordBatchAndSyncNosql(addBansRecordDtoList, true);
        }
    }

    private void judge(DycProCommDealFastCreateAgrSkuReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrInfo())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getAgrItemList())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u660e\u7ec6\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getFastCreateSkuInfo())) {
            throw new ZTBusinessException("\u3010\u6025\u901f\u94fa\u8d27\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrInfo().getAgrId())) {
            throw new ZTBusinessException("\u3010\u534f\u8baeID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrInfo().getAgrCode())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u7f16\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrInfo().getAgrName())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrInfo().getTradeMode())) {
            throw new ZTBusinessException("\u3010\u4ea4\u6613\u6a21\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrInfo().getSupplierId())) {
            throw new ZTBusinessException("\u3010\u4f9b\u8d27\u5546ID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrInfo().getSupplierName())) {
            throw new ZTBusinessException("\u3010\u4f9b\u8d27\u5546\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getFastCreateSkuInfo().getMinQuantity())) {
            throw new ZTBusinessException("\u3010\u6700\u5c0f\u8d77\u8ba2\u91cf\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getFastCreateSkuInfo().getOnShelveWay())) {
            throw new ZTBusinessException("\u3010\u4e0a\u67b6\u65b9\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getFastCreateSkuInfo().getSkuAfterSaleInfo())) {
            throw new ZTBusinessException("\u3010sku\u552e\u540e\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProCommSkuAfterSaleInfoApiBO skuAfterSaleInfo = reqBO.getFastCreateSkuInfo().getSkuAfterSaleInfo();
        if (ObjectUtils.isEmpty((Object)skuAfterSaleInfo.getIsAllowReturn())) {
            throw new ZTBusinessException("\u3010\u662f\u5426\u652f\u6301\u9000\u8d27\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DycProCommConstants.IsAllowAfterSale.YES.equals(skuAfterSaleInfo.getIsAllowReturn()) && ObjectUtils.isEmpty((Object)skuAfterSaleInfo.getReturnTimeLimit())) {
            throw new ZTBusinessException("\u3010\u9000\u8d27\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)skuAfterSaleInfo.getIsAllowChange())) {
            throw new ZTBusinessException("\u3010\u662f\u5426\u652f\u6301\u6362\u8d27\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DycProCommConstants.IsAllowAfterSale.YES.equals(skuAfterSaleInfo.getIsAllowChange()) && ObjectUtils.isEmpty((Object)skuAfterSaleInfo.getChangeTimeLimit())) {
            throw new ZTBusinessException("\u3010\u6362\u8d27\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)skuAfterSaleInfo.getIsAllowMaintain())) {
            throw new ZTBusinessException("\u3010\u662f\u5426\u652f\u6301\u7ef4\u4fee\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DycProCommConstants.IsAllowAfterSale.YES.equals(skuAfterSaleInfo.getIsAllowMaintain()) && ObjectUtils.isEmpty((Object)skuAfterSaleInfo.getMaintainTimeLimit())) {
            throw new ZTBusinessException("\u3010\u7ef4\u4fee\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycProCommAgrItemBO agrItem : reqBO.getAgrItemList()) {
            if (ObjectUtils.isEmpty((Object)agrItem.getManageCatalogId())) {
                throw new ZTBusinessException("\u3010\u540e\u53f0\u7ba1\u7406\u7c7b\u76eeID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrItem.getBrandName())) {
                throw new ZTBusinessException("\u3010\u54c1\u724c\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrItem.getMeasureId())) {
                throw new ZTBusinessException("\u3010\u8ba1\u91cf\u5355\u4f4dID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrItem.getMeasureName())) {
                throw new ZTBusinessException("\u3010\u8ba1\u91cf\u5355\u4f4d\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrItem.getAgrItemNumber())) {
                throw new ZTBusinessException("\u3010\u6570\u91cf\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrItem.getSupplyPrice())) {
                throw new ZTBusinessException("\u3010\u4f9b\u8d27\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtils.isEmpty((Object)agrItem.getTaxRate())) continue;
            throw new ZTBusinessException("\u3010\u7a0e\u7387\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

