/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.approve.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingBansRuleBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuBO;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordActionTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordOperateResultEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.PublicProcInstBusiType;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstHandleDTO;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.approve.api.DycProCommPublicProcTaskInstRepository;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPakageObjDTO;
import com.tydic.dyc.pro.dmc.repository.bansrecord.api.DycProCommBansRecordRepository;
import com.tydic.dyc.pro.dmc.repository.bansrecord.bo.DycProCommBansRecordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.bansrecord.bo.DycProCommBansRecordInfoHandleDTO;
import com.tydic.dyc.pro.dmc.repository.bansrecord.bo.DycProCommBansRecordInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.operaterecord.api.DycProCommOperateRecordRepository;
import com.tydic.dyc.pro.dmc.repository.operaterecord.dto.DycProCommOperateRecordDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuHandleDTO;
import com.tydic.dyc.pro.dmc.repository.userTaskProcess.api.DycProCommUserTaskProcessInfoRepository;
import com.tydic.dyc.pro.dmc.repository.userTaskProcess.dto.DycProCommUserTaskProcessInfoDTO;
import com.tydic.dyc.pro.dmc.repository.userTaskProcess.dto.DycProCommUserTaskProcessInfoQryDTO;
import com.tydic.dyc.pro.dmc.service.approve.api.DycProCommCompleteApproveTaskService;
import com.tydic.dyc.pro.dmc.service.approve.bo.DycProCommCompleteApproveTaskReqBO;
import com.tydic.dyc.pro.dmc.service.approve.bo.DycProCommCompleteApproveTaskRspBO;
import com.tydic.dyc.pro.dmc.service.approve.bo.DycProCommSkuMsgFlushedBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.approve.api.DycProCommCompleteApproveTaskService"})
public class DycProCommCompleteApproveTaskServiceImpl
implements DycProCommCompleteApproveTaskService {
    private static final Logger log = LoggerFactory.getLogger(DycProCommCompleteApproveTaskServiceImpl.class);
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommPublicProcTaskInstRepository dycProCommPublicProcTaskInstRepository;
    @Autowired
    private DycProCommOperateRecordRepository dycProCommOperateRecordRepository;
    @Autowired
    private DycProCommBansRecordRepository dycProCommBansRecordRepository;
    @Autowired
    private Environment environment;
    @Autowired
    private DycProCommUserTaskProcessInfoRepository dycProCommUserTaskProcessInfoRepository;
    @Value(value="${comm.user.task.process.topic}")
    private String commUserTaskProcessTopic;
    @Value(value="${comm.user.task.process.tag}")
    private String commUserTaskProcessTag;
    @Value(value="${comm.user.task.process.pid}")
    private String commUserTaskProcessPid;
    @Resource(name="MqDycProCommUserTaskProcessProvider")
    private ProxyMessageProducer dycProCommUserTaskProcessProvider;

    @PostMapping(value={"completeApproveTask"})
    public DycProCommCompleteApproveTaskRspBO completeApproveTask(@RequestBody DycProCommCompleteApproveTaskReqBO reqBO) {
        DycProPublicTaskInstHandleDTO flowTaskInstHandleDto = new DycProPublicTaskInstHandleDTO();
        BeanUtils.copyProperties((Object)reqBO, (Object)flowTaskInstHandleDto);
        this.dycProPublicTaskInstRepository.completeFlowTask(flowTaskInstHandleDto);
        DycProCommAuditPakageObjDTO dycProCommAuditPakageObjDTO = new DycProCommAuditPakageObjDTO();
        dycProCommAuditPakageObjDTO.setAuditPackageId(reqBO.getObjId());
        List skuCountResult = this.dycProCommPublicProcTaskInstRepository.getAuditPakageObjList(dycProCommAuditPakageObjDTO);
        if (!ObjectUtils.isEmpty((Object)skuCountResult) && reqBO.getIsFinish().booleanValue()) {
            Map<Boolean, List<DycProCommSkuDTO>> isDisableSkuMap = this.isDisableSkuCheck(skuCountResult.stream().map(DycProCommAuditPakageObjDTO::getSkuId).collect(Collectors.toList()));
            for (Map.Entry<Boolean, List<DycProCommSkuDTO>> entry : isDisableSkuMap.entrySet()) {
                Boolean isDisable = entry.getKey();
                List<DycProCommSkuDTO> skuList = entry.getValue();
                if (CollectionUtils.isEmpty(skuList)) continue;
                DycProCommSkuHandleDTO dycProCommSkuHandleDTO = new DycProCommSkuHandleDTO();
                ArrayList<String> nullColumnList = new ArrayList<String>();
                dycProCommSkuHandleDTO.setSkuIdList(skuList.stream().map(DycProCommSkuDTO::getSkuId).collect(Collectors.toList()));
                if ("pass".equals(reqBO.getDealResult())) {
                    if (PublicProcInstBusiType.AGR_SKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                        if (isDisable.booleanValue()) {
                            dycProCommSkuHandleDTO.setSkuStatus(DycProCommConstants.SkuStatus.ON_SHELVES);
                        }
                        dycProCommSkuHandleDTO.setOnShelveTime(new Date());
                    } else if (PublicProcInstBusiType.AGR_SKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                        if (isDisable.booleanValue()) {
                            dycProCommSkuHandleDTO.setSkuStatus(DycProCommConstants.SkuStatus.OFF_SHELVES);
                        }
                        dycProCommSkuHandleDTO.setDownShelveTime(new Date());
                        this.relieveSkuBans(dycProCommSkuHandleDTO.getSkuIdList());
                        dycProCommSkuHandleDTO.setSyncNosql(false);
                    } else if (PublicProcInstBusiType.AGR_SKU_EDIT_APPROVE.getCode().equals(reqBO.getBusiType())) {
                        this.relieveSkuBans(dycProCommSkuHandleDTO.getSkuIdList());
                        dycProCommSkuHandleDTO.setSyncNosql(false);
                    }
                    dycProCommSkuHandleDTO.setUpdateUserId(reqBO.getDealUserId());
                    dycProCommSkuHandleDTO.setUpdateUserName(reqBO.getDealUserName());
                    dycProCommSkuHandleDTO.setUpdateTime(new Date());
                    dycProCommSkuHandleDTO.setUpdateOrgId(reqBO.getDealUserOrgId());
                    dycProCommSkuHandleDTO.setUpdateOrgName(reqBO.getDealUserOrgName());
                    dycProCommSkuHandleDTO.setUpdateOrgPath(reqBO.getDealUserOrgPath());
                    dycProCommSkuHandleDTO.setUpdateCompanyId(reqBO.getDealUserCompanyId());
                    dycProCommSkuHandleDTO.setUpdateCompanyName(reqBO.getDealUserCompanyName());
                    nullColumnList.add("APPROVAL_STATUS");
                    if (PublicProcInstBusiType.ESKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                        this.dealSkuMsgFlushed(skuList, reqBO);
                    }
                } else if ("reject".equals(reqBO.getDealResult())) {
                    if (PublicProcInstBusiType.AGR_SKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                        dycProCommSkuHandleDTO.setApprovalStatus(DycProCommConstants.ApprovalStatus.ON_SHELVE_REJECT);
                    } else if (PublicProcInstBusiType.AGR_SKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                        dycProCommSkuHandleDTO.setApprovalStatus(DycProCommConstants.ApprovalStatus.OFF_SHELVE_REJECT);
                        this.relieveSkuBans(dycProCommSkuHandleDTO.getSkuIdList());
                        dycProCommSkuHandleDTO.setSyncNosql(false);
                    } else if (PublicProcInstBusiType.AGR_SKU_EDIT_APPROVE.getCode().equals(reqBO.getBusiType())) {
                        dycProCommSkuHandleDTO.setApprovalStatus(DycProCommConstants.ApprovalStatus.EDIT_REJECT);
                    }
                    dycProCommSkuHandleDTO.setUpdateUserId(reqBO.getDealUserId());
                    dycProCommSkuHandleDTO.setUpdateUserName(reqBO.getDealUserName());
                    dycProCommSkuHandleDTO.setUpdateTime(new Date());
                    dycProCommSkuHandleDTO.setUpdateOrgId(reqBO.getDealUserOrgId());
                    dycProCommSkuHandleDTO.setUpdateOrgName(reqBO.getDealUserOrgName());
                    dycProCommSkuHandleDTO.setUpdateOrgPath(reqBO.getDealUserOrgPath());
                    dycProCommSkuHandleDTO.setUpdateCompanyId(reqBO.getDealUserCompanyId());
                    dycProCommSkuHandleDTO.setUpdateCompanyName(reqBO.getDealUserCompanyName());
                }
                this.dycProCommSkuRepository.updateSkuInfoNullByIdsAndSyncNoSql(dycProCommSkuHandleDTO, nullColumnList);
                if (PublicProcInstBusiType.AGR_SKU_EDIT_APPROVE.getCode().equals(reqBO.getBusiType())) {
                    DycProCommSkuHandleDTO handleDTO = new DycProCommSkuHandleDTO();
                    handleDTO.setDealResult(reqBO.getDealResult());
                    handleDTO.setSkuId(skuList.get(0).getSkuId());
                    this.dycProCommSkuRepository.dealSkuEditAuditApproveAndSyncNoSql(handleDTO, nullColumnList);
                }
                if (!PublicProcInstBusiType.AGR_SKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) && !PublicProcInstBusiType.ESKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) continue;
                this.syncNosqlBatch(dycProCommSkuHandleDTO, nullColumnList);
            }
            this.insertOperateRecord(skuCountResult, reqBO);
        }
        DycProCommCompleteApproveTaskRspBO rspBO = new DycProCommCompleteApproveTaskRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealSkuMsgFlushed(List<DycProCommSkuDTO> skuList, DycProCommCompleteApproveTaskReqBO reqBO) {
        DycProCommUserTaskProcessInfoQryDTO qryUserTaskProcessDto = new DycProCommUserTaskProcessInfoQryDTO();
        ArrayList<Integer> processStatusList = new ArrayList<Integer>();
        processStatusList.add(DycProCommConstants.UserTaskProcessStatus.TODO);
        processStatusList.add(DycProCommConstants.UserTaskProcessStatus.DOING);
        qryUserTaskProcessDto.setProcStatusList(processStatusList);
        List dycProCommUserTaskProcessInfoDTOS = this.dycProCommUserTaskProcessInfoRepository.qryUserTaskProcessList(qryUserTaskProcessDto);
        if (!CollectionUtils.isEmpty((Collection)dycProCommUserTaskProcessInfoDTOS)) {
            if (dycProCommUserTaskProcessInfoDTOS.size() >= 5) {
                throw new ZTBusinessException("\u7b49\u5f85\u5904\u7406\u7684\u4efb\u52a1\u5df2\u67095\u4e2a\uff0c\u8bf7\u7a0d\u540e\u518d\u53d1\u8d77\u5237\u65b0\u4fe1\u606f");
            }
            for (DycProCommUserTaskProcessInfoDTO dycProCommUserTaskProcessInfoDTO : dycProCommUserTaskProcessInfoDTOS) {
                if (!reqBO.getDealUserId().equals(dycProCommUserTaskProcessInfoDTO.getUserId())) continue;
                throw new ZTBusinessException("\u4f60\u4e4b\u524d\u5df2\u63d0\u4ea4\u8fc7\u5237\u65b0\u4fe1\u606f\u7684\u8bf7\u6c42\uff0c\u8bf7\u7b49\u5f85\u5904\u7406\u5b8c\u6210\u540e\u518d\u53d1\u8d77");
            }
        }
        DycProCommUserTaskProcessInfoDTO dycProCommUserTaskProcessInfoDTO = new DycProCommUserTaskProcessInfoDTO();
        dycProCommUserTaskProcessInfoDTO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        dycProCommUserTaskProcessInfoDTO.setUserId(reqBO.getDealUserId());
        dycProCommUserTaskProcessInfoDTO.setProcStatus(DycProCommConstants.UserTaskProcessStatus.TODO);
        dycProCommUserTaskProcessInfoDTO.setTotalNum(Integer.valueOf(skuList.size()));
        this.dycProCommUserTaskProcessInfoRepository.addUserTaskProcess(dycProCommUserTaskProcessInfoDTO);
        ArrayList<DycProCommSkuMsgFlushedBO> pushSkuList = new ArrayList<DycProCommSkuMsgFlushedBO>();
        for (int i = 1; i <= skuList.size(); ++i) {
            DycProCommSkuDTO skuDTO = skuList.get(i - 1);
            DycProCommSkuMsgFlushedBO dycProCommSkuMsgFlushedBO = new DycProCommSkuMsgFlushedBO();
            BeanUtils.copyProperties((Object)skuDTO, (Object)dycProCommSkuMsgFlushedBO);
            dycProCommSkuMsgFlushedBO.setSupplierHsn(this.environment.getProperty("SUPPLIER_ID_" + dycProCommSkuMsgFlushedBO.getSupplierId()));
            pushSkuList.add(dycProCommSkuMsgFlushedBO);
            if (i % 100 != 0 && i != skuList.size()) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)dycProCommUserTaskProcessInfoDTO.getId());
            jsonObject.put("userId", (Object)reqBO.getDealUserId());
            jsonObject.put("skuList", pushSkuList);
            String mqJson = jsonObject.toJSONString();
            log.debug("\u53d1\u9001MQ\u5904\u7406\u6d88\u606f\u53c2\u6570:{}", (Object)mqJson);
            this.dycProCommUserTaskProcessProvider.send(new ProxyMessage(this.commUserTaskProcessTopic, this.commUserTaskProcessTag, mqJson));
            pushSkuList = new ArrayList();
        }
    }

    private Map<Boolean, List<DycProCommSkuDTO>> isDisableSkuCheck(List<Long> skuIdList) {
        HashMap<Boolean, List<DycProCommSkuDTO>> isDisableSkuMap = new HashMap<Boolean, List<DycProCommSkuDTO>>();
        isDisableSkuMap.put(true, new ArrayList());
        isDisableSkuMap.put(false, new ArrayList());
        DycProCommSkuHandleDTO handleDTO = new DycProCommSkuHandleDTO();
        handleDTO.setSkuIdList(skuIdList);
        List skuDTOList = this.dycProCommSkuRepository.getSkuMainListByCondition(handleDTO);
        if (!CollectionUtils.isEmpty((Collection)skuDTOList)) {
            for (DycProCommSkuDTO skuDTO : skuDTOList) {
                if (DycProCommConstants.SkuStatus.DISABLE.equals(skuDTO.getSkuStatus())) {
                    ((List)isDisableSkuMap.get(false)).add(skuDTO);
                    continue;
                }
                ((List)isDisableSkuMap.get(true)).add(skuDTO);
            }
        }
        return isDisableSkuMap;
    }

    private void syncNosqlBatch(DycProCommSkuHandleDTO dycProCommSkuHandleDTO, List<String> nullColumnList) {
        ArrayList<String> nullColumn = new ArrayList<String>(nullColumnList);
        ArrayList<DycProEsIndexMappingSkuBO> dycProEsIndexMappingSkuBOS = new ArrayList<DycProEsIndexMappingSkuBO>();
        Map<Object, Object> skuBansMap = new HashMap();
        DycProCommBansRecordInfoQryDTO dycProCommBansRecordInfoQryDTO = new DycProCommBansRecordInfoQryDTO();
        dycProCommBansRecordInfoQryDTO.setSkuIdList(dycProCommSkuHandleDTO.getSkuIdList());
        dycProCommBansRecordInfoQryDTO.setBansEndDate(new Date());
        List dycProCommBansRecordInfoDTOS = this.dycProCommBansRecordRepository.queryBansRecordList(dycProCommBansRecordInfoQryDTO);
        if (!CollectionUtils.isEmpty((Collection)dycProCommBansRecordInfoDTOS)) {
            skuBansMap = dycProCommBansRecordInfoDTOS.stream().collect(Collectors.groupingBy(DycProCommBansRecordInfoDTO::getSkuId));
        }
        HashMap<Long, ArrayList<String>> nullColumnMap = new HashMap<Long, ArrayList<String>>();
        for (Long skuId : dycProCommSkuHandleDTO.getSkuIdList()) {
            DycProEsIndexMappingSkuBO dycProEsIndexMappingSkuBO = (DycProEsIndexMappingSkuBO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommSkuHandleDTO), DycProEsIndexMappingSkuBO.class);
            if (skuBansMap.containsKey(skuId)) {
                dycProEsIndexMappingSkuBO.setBansRuleList(JSON.parseArray((String)JSON.toJSONString((Object)skuBansMap.get(skuId)), DycProEsIndexMappingBansRuleBO.class));
            } else {
                nullColumn.add("BANS_RULE_LIST");
            }
            nullColumnMap.put(skuId, nullColumn);
            dycProEsIndexMappingSkuBO.setSkuId(skuId);
            dycProEsIndexMappingSkuBOS.add(dycProEsIndexMappingSkuBO);
        }
        this.dycProCommSkuRepository.syncNosqlBatchBySkuId(dycProEsIndexMappingSkuBOS, nullColumnMap);
    }

    private void relieveSkuBans(List<Long> skuIds) {
        DycProCommBansRecordInfoHandleDTO dycProCommBansRecordInfoHandleDTO = new DycProCommBansRecordInfoHandleDTO();
        dycProCommBansRecordInfoHandleDTO.setSyncNosql(false);
        dycProCommBansRecordInfoHandleDTO.setSkuIdList(skuIds);
        dycProCommBansRecordInfoHandleDTO.setBansEndDate(new Date());
        dycProCommBansRecordInfoHandleDTO.setBansType(DycProCommConstants.BansType.DOWN_SHELVE_AUDIT);
        this.dycProCommBansRecordRepository.updateBansRecordBatchAndSyncNosql(dycProCommBansRecordInfoHandleDTO);
    }

    private void insertOperateRecord(List<DycProCommAuditPakageObjDTO> skuCountResult, DycProCommCompleteApproveTaskReqBO reqBO) {
        ArrayList<DycProCommOperateRecordDTO> operateRecordPOList = new ArrayList<DycProCommOperateRecordDTO>();
        for (DycProCommAuditPakageObjDTO skuInfoPO : skuCountResult) {
            DycProCommOperateRecordDTO commOperateRecordPO = new DycProCommOperateRecordDTO();
            commOperateRecordPO.setObjId(skuInfoPO.getSkuId());
            commOperateRecordPO.setObjCode(skuInfoPO.getSkuCode());
            commOperateRecordPO.setObjType(DycProCommConstants.OperateRecordObjType.SKU);
            if (PublicProcInstBusiType.AGR_SKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                commOperateRecordPO.setActionType(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordActionTypeEnum.ON_SHELVE.getCode())));
                commOperateRecordPO.setActionName(DmcCommOperateRecordActionTypeEnum.ON_SHELVE.getValue());
            } else if (PublicProcInstBusiType.AGR_SKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                commOperateRecordPO.setActionType(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordActionTypeEnum.DOWN_SHELVE.getCode())));
                commOperateRecordPO.setActionName(DmcCommOperateRecordActionTypeEnum.DOWN_SHELVE.getValue());
            }
            commOperateRecordPO.setOperateTime(new Date());
            commOperateRecordPO.setOperateUserId(reqBO.getDealUserId());
            commOperateRecordPO.setOperateUserAccount(reqBO.getDealUserName());
            commOperateRecordPO.setOperateUserName(reqBO.getDealUserName());
            commOperateRecordPO.setOperateUserType(DycProCommConstants.OperateUserType.USER);
            commOperateRecordPO.setOperateReason(reqBO.getDealRemark());
            if (PublicProcInstBusiType.AGR_SKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_ON_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                commOperateRecordPO.setOperateResult(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordOperateResultEnum.SUCCESS_ON_SHELVE.getCode())));
                commOperateRecordPO.setOperateResultDesc(DmcCommOperateRecordOperateResultEnum.SUCCESS_ON_SHELVE.getValue());
            } else if (PublicProcInstBusiType.AGR_SKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.ESKU_OFF_SHELVES_APPROVE.getCode().equals(reqBO.getBusiType())) {
                commOperateRecordPO.setOperateResult(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordOperateResultEnum.SUCCESS_DOWN_SHELVE.getCode())));
                commOperateRecordPO.setOperateResultDesc(DmcCommOperateRecordOperateResultEnum.SUCCESS_DOWN_SHELVE.getValue());
            }
            operateRecordPOList.add(commOperateRecordPO);
        }
        this.dycProCommOperateRecordRepository.addOperateRecordBatch(operateRecordPOList);
    }
}

