/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.spu.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuBO;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.approve.api.DycProCommPublicProcTaskInstRepository;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPackageInfoDTO;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPakageObjDTO;
import com.tydic.dyc.pro.dmc.repository.managecatalog.api.DycProCommManageCatalogRepository;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommPropertyTemplateInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommAgrDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuAfterSaleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDetailsInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuPicInfoDTO;
import com.tydic.dyc.pro.dmc.repository.spu.api.DycProCommSpuRepository;
import com.tydic.dyc.pro.dmc.repository.spu.dto.DycProCommSpuInfoDTO;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoDTO;
import com.tydic.dyc.pro.dmc.service.spu.api.DycProCommSubmitSpuEditService;
import com.tydic.dyc.pro.dmc.service.spu.bo.DycProCommSpuSkuInfoApiBO;
import com.tydic.dyc.pro.dmc.service.spu.bo.DycProCommSubmitSpuEditReqBO;
import com.tydic.dyc.pro.dmc.service.spu.bo.DycProCommSubmitSpuEditRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.spu.api.DycProCommSubmitSpuEditService"})
public class DycProCommSubmitSpuEditServiceImpl
implements DycProCommSubmitSpuEditService {
    @Autowired
    private DycProCommSpuRepository dycProCommSpuRepository;
    @Autowired
    private DycProCommManageCatalogRepository dycProCommManageCatalogRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommPublicProcTaskInstRepository dycProCommPublicProcTaskInstRepository;

    @PostMapping(value={"submitSpuEdit"})
    public DycProCommSubmitSpuEditRspBO submitSpuEdit(@RequestBody DycProCommSubmitSpuEditReqBO reqBO) {
        DycProCommSubmitSpuEditRspBO rspBO = new DycProCommSubmitSpuEditRspBO();
        Long propertyTemplateId = null;
        if (null != reqBO.getManageCatalogId()) {
            DycProCommPropertyTemplateInfoDTO queryPropertyTemplateDto = new DycProCommPropertyTemplateInfoDTO();
            queryPropertyTemplateDto.setManageCatalogId(reqBO.getManageCatalogId());
            DycProCommPropertyTemplateInfoDTO queryPropertyTemplateResultDto = this.dycProCommManageCatalogRepository.queryPropertyTemplateOneByCondition(queryPropertyTemplateDto);
            if (null != queryPropertyTemplateResultDto) {
                propertyTemplateId = queryPropertyTemplateResultDto.getPropertyTemplateId();
            } else {
                throw new ZTBusinessException("\u8be5\u7ba1\u7406\u76ee\u5f55\u4e0d\u5b58\u5728\u5c5e\u6027\u6a21\u7248");
            }
        }
        this.updateSpuDetailsInfo(reqBO);
        List<DycProEsIndexMappingSkuBO> dycProEsIndexMappingSkuBOS = this.addSkuInfo(reqBO, propertyTemplateId);
        if (DycProCommConstants.SkuOnShelveWay.AUTO_ON_SHELVE.equals(reqBO.getOnShelveWay())) {
            Long auditPackageId = this.insertAuditPackage(dycProEsIndexMappingSkuBOS);
            rspBO.setAuditPackageId(auditPackageId);
        }
        return rspBO;
    }

    private Long insertAuditPackage(List<DycProEsIndexMappingSkuBO> agrSkuInfoList) {
        Long auditPackageId = Sequence.getInstance().nextId();
        DycProCommAuditPackageInfoDTO dycProCommAuditPackageInfoDTO = new DycProCommAuditPackageInfoDTO();
        dycProCommAuditPackageInfoDTO.setAuditPackageId(auditPackageId);
        List auditPackageObjDTOList = JSONArray.parseArray((String)JSON.toJSONString(agrSkuInfoList)).toJavaList(DycProCommAuditPakageObjDTO.class);
        for (DycProCommAuditPakageObjDTO commAuditPackageObjDTO : auditPackageObjDTOList) {
            commAuditPackageObjDTO.setCreateTime(new Date(System.currentTimeMillis()));
            commAuditPackageObjDTO.setAuditPackageId(auditPackageId);
            commAuditPackageObjDTO.setDelTag(DycProCommConstants.DelFlag.NO);
        }
        dycProCommAuditPackageInfoDTO.setAuditPakageObjDTOList(auditPackageObjDTOList);
        this.dycProCommPublicProcTaskInstRepository.addAuditPackageBatch(dycProCommAuditPackageInfoDTO);
        return auditPackageId;
    }

    private void updateSpuDetailsInfo(DycProCommSubmitSpuEditReqBO reqBO) {
        DycProCommSpuInfoDTO updateSpuInfoDto = (DycProCommSpuInfoDTO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), DycProCommSpuInfoDTO.class);
        this.dycProCommSpuRepository.updateSpuDetailsInfo(updateSpuInfoDto);
    }

    private List<DycProEsIndexMappingSkuBO> addSkuInfo(DycProCommSubmitSpuEditReqBO reqBO, Long propertyTemplateId) {
        ArrayList<DycProCommSkuDTO> skuDTOList = new ArrayList<DycProCommSkuDTO>();
        for (DycProCommSpuSkuInfoApiBO spuSkuInfoBo : reqBO.getSkuList()) {
            DycProCommSkuDTO addSkuDto = new DycProCommSkuDTO();
            BeanUtils.copyProperties((Object)reqBO, (Object)addSkuDto);
            BeanUtils.copyProperties((Object)spuSkuInfoBo, (Object)addSkuDto);
            addSkuDto.setSkuStatus(DycProCommConstants.SkuStatus.TOBE_ON_SHELVES);
            addSkuDto.setSpuId(reqBO.getSpuId());
            addSkuDto.setSkuSource(DycProCommConstants.SkuSource.AGR_SKU);
            addSkuDto.setPropertyTemplateId(propertyTemplateId);
            addSkuDto.setIsHaveGift(DycProCommConstants.IsHaveGift.NO);
            addSkuDto.setCreateUserId(reqBO.getUserId());
            addSkuDto.setCreateUserName(reqBO.getName());
            addSkuDto.setCreateUserAccount(reqBO.getUserName());
            addSkuDto.setCreateCompanyId(reqBO.getCompanyId());
            addSkuDto.setCreateCompanyName(reqBO.getCompanyName());
            addSkuDto.setCreateOrgId(reqBO.getOrgId());
            addSkuDto.setCreateOrgName(reqBO.getOrgName());
            addSkuDto.setCreateOrgPath(reqBO.getOrgPath());
            addSkuDto.setSaleMeasureRate(new BigDecimal(1));
            addSkuDto.setSettleMeasureId(spuSkuInfoBo.getSaleMeasureId());
            addSkuDto.setSettleMeasureName(spuSkuInfoBo.getSaleMeasureName());
            DycProCommAgrDTO skuAgrInfo = new DycProCommAgrDTO();
            BeanUtils.copyProperties((Object)reqBO.getSpuAgrInfo(), (Object)skuAgrInfo);
            addSkuDto.setSkuAgrInfo(skuAgrInfo);
            DycProCommSkuDetailsInfoDTO skuDetails = new DycProCommSkuDetailsInfoDTO();
            skuDetails.setPropertyInstInfo(spuSkuInfoBo.getSkuDetails().getPropertyInstInfo());
            skuDetails.setAfterSaleRemark(reqBO.getSpuDetails().getAfterSaleRemark());
            skuDetails.setPackageRemark(reqBO.getSpuDetails().getPackageRemark());
            skuDetails.setSkuPcDetailUrl(reqBO.getSpuDetails().getSpuPcDetailUrl());
            addSkuDto.setSkuDetails(skuDetails);
            if (null != reqBO.getSpuDetails()) {
                DycProCommSkuAfterSaleInfoDTO addSkuAfterSaleInfoDto = new DycProCommSkuAfterSaleInfoDTO();
                BeanUtils.copyProperties((Object)reqBO.getSpuAfterSaleInfo(), (Object)addSkuAfterSaleInfoDto);
                addSkuDto.setSkuAfterSaleInfo(addSkuAfterSaleInfoDto);
            }
            if (!CollectionUtils.isEmpty((Collection)spuSkuInfoBo.getSkuPicInfoList())) {
                List addSkuPicInfoList = JSONArray.parseArray((String)JSON.toJSONString((Object)spuSkuInfoBo.getSkuPicInfoList())).toJavaList(DycProCommSkuPicInfoDTO.class);
                addSkuDto.setSkuPicInfoList(addSkuPicInfoList);
            }
            if (null != spuSkuInfoBo.getPriceInfo()) {
                DycProCommSkuPriceInfoDTO addSkuPriceInfoDto = new DycProCommSkuPriceInfoDTO();
                addSkuPriceInfoDto.setSupplierPrice(spuSkuInfoBo.getPriceInfo().getSupplierPrice());
                addSkuPriceInfoDto.setMarketPrice(spuSkuInfoBo.getPriceInfo().getMarketPrice());
                addSkuPriceInfoDto.setSalePrice(spuSkuInfoBo.getPriceInfo().getSupplierPrice());
                addSkuPriceInfoDto.setPriority(Integer.valueOf(0));
                addSkuDto.setPriceInfo(addSkuPriceInfoDto);
            }
            if (null != spuSkuInfoBo.getStockInfo()) {
                DycProCommSkuStockInfoDTO addSkuStockInfo = new DycProCommSkuStockInfoDTO();
                addSkuStockInfo.setSkuName(spuSkuInfoBo.getSkuName());
                addSkuStockInfo.setOriginNum(spuSkuInfoBo.getStockInfo().getOriginNum());
                addSkuStockInfo.setTotalNum(spuSkuInfoBo.getStockInfo().getOriginNum());
                addSkuStockInfo.setUnsaleNum(spuSkuInfoBo.getStockInfo().getOriginNum());
                addSkuStockInfo.setSaledNum(new BigDecimal(0));
                addSkuStockInfo.setSupplierId(reqBO.getSupplierId());
                addSkuStockInfo.setSupplierName(reqBO.getSupplierName());
                addSkuStockInfo.setSaleMeasureId(spuSkuInfoBo.getSaleMeasureId());
                addSkuStockInfo.setSaleMeasureName(spuSkuInfoBo.getSaleMeasureName());
                addSkuStockInfo.setCreateUserId(reqBO.getUserId());
                addSkuStockInfo.setCreateUserName(reqBO.getName());
                addSkuStockInfo.setCreateUserAccount(reqBO.getUserName());
                addSkuStockInfo.setCreateCompanyId(reqBO.getCompanyId());
                addSkuStockInfo.setCreateCompanyName(reqBO.getCompanyName());
                addSkuStockInfo.setCreateOrgId(reqBO.getOrgId());
                addSkuStockInfo.setCreateOrgName(reqBO.getOrgName());
                addSkuDto.setStockInfo(addSkuStockInfo);
            }
            skuDTOList.add(addSkuDto);
        }
        List skuEsBoList = this.dycProCommSkuRepository.addSkuCompleteInfoBatchAndSyncNosql(skuDTOList);
        return skuEsBoList;
    }
}

