/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.purchaseAuth.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.dmc.repository.managecatalog.api.DycProCommManageCatalogRepository;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommPropertyTemplateInfoDTO;
import com.tydic.dyc.pro.dmc.repository.purchaseauth.api.DycProCommPurchaseAuthRepository;
import com.tydic.dyc.pro.dmc.repository.purchaseauth.bo.DycProCommPurchaseAuthInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuHandleDTO;
import com.tydic.dyc.pro.dmc.service.pool.bo.DycProCommPurchaseAuthByBuyBO;
import com.tydic.dyc.pro.dmc.service.pool.bo.DycProCommPurchaseAuthByBuyReqBO;
import com.tydic.dyc.pro.dmc.service.pool.bo.DycProCommPurchaseAuthByBuyRspBO;
import com.tydic.dyc.pro.dmc.service.purchaseAuth.api.DycProCommPurchaseAuthByBuyService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.purchaseAuth.api.DycProCommPurchaseAuthByBuyService"})
public class DycProCommPurchaseAuthByBuyServiceImpl
implements DycProCommPurchaseAuthByBuyService {
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommPurchaseAuthRepository dycProCommPurchaseAuthRepository;
    @Autowired
    private DycProCommManageCatalogRepository dycProCommManageCatalogRepository;
    @Value(value="${purchaseAuthType}")
    private Integer purchaseAuthType;

    @PostMapping(value={"qryPurchaseByBuy"})
    public DycProCommPurchaseAuthByBuyRspBO qryPurchaseByBuy(@RequestBody DycProCommPurchaseAuthByBuyReqBO reqBO) {
        DycProCommPurchaseAuthByBuyRspBO rspBO = new DycProCommPurchaseAuthByBuyRspBO();
        if (this.purchaseAuthType != 1) {
            return rspBO;
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getOrgPath())) {
            throw new ZTBusinessException("\u5165\u53c2\u673a\u6784\u6811\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds()) && CollectionUtils.isEmpty((Collection)reqBO.getAgrItemIds())) {
            throw new ZTBusinessException("\u5165\u53c2id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DycProCommSkuHandleDTO skuHandleDTO = new DycProCommSkuHandleDTO();
        skuHandleDTO.setSkuIdList(reqBO.getSkuIds());
        skuHandleDTO.setAgrItemIds(reqBO.getAgrItemIds());
        List skuMainListByCondition = this.dycProCommSkuRepository.getSkuMainListByCondition(skuHandleDTO);
        if (CollectionUtils.isEmpty((Collection)skuMainListByCondition)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5546\u54c1\u6570\u636e");
        }
        Map<Long, List<DycProCommSkuDTO>> skuMap = skuMainListByCondition.stream().collect(Collectors.groupingBy(DycProCommSkuDTO::getSkuId));
        Map<Long, List<DycProCommSkuDTO>> agrItemMap = skuMainListByCondition.stream().filter(a -> a.getAgrItemId() != null).collect(Collectors.groupingBy(DycProCommSkuDTO::getAgrItemId));
        List templateIds = skuMainListByCondition.stream().map(a -> a.getPropertyTemplateId()).collect(Collectors.toList());
        List dycProCommPropertyTemplateInfoDTOS = this.dycProCommManageCatalogRepository.qryManageCatalogByProperTyTemplateId(templateIds);
        if (CollectionUtils.isEmpty((Collection)dycProCommPropertyTemplateInfoDTOS)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7c7b\u76ee\u6570\u636e");
        }
        HashMap<Long, Long> skuCatalogMap = new HashMap<Long, Long>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            for (Long skuId : skuMap.keySet()) {
                for (DycProCommPropertyTemplateInfoDTO dycProCommPropertyTemplateInfoDTO : dycProCommPropertyTemplateInfoDTOS) {
                    if (!dycProCommPropertyTemplateInfoDTO.getPropertyTemplateId().equals(skuMap.get(skuId).get(0).getPropertyTemplateId())) continue;
                    skuCatalogMap.put(skuId, dycProCommPropertyTemplateInfoDTO.getManageCatalogId());
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgrItemIds())) {
            for (Long agrItemId : agrItemMap.keySet()) {
                for (DycProCommPropertyTemplateInfoDTO dycProCommPropertyTemplateInfoDTO : dycProCommPropertyTemplateInfoDTOS) {
                    if (!dycProCommPropertyTemplateInfoDTO.getPropertyTemplateId().equals(agrItemMap.get(agrItemId).get(0).getPropertyTemplateId())) continue;
                    skuCatalogMap.put(agrItemId, dycProCommPropertyTemplateInfoDTO.getManageCatalogId());
                }
            }
        }
        DycProCommPurchaseAuthInfoDTO authInfoDTO = new DycProCommPurchaseAuthInfoDTO();
        authInfoDTO.setOrgPath(reqBO.getOrgPath());
        DycProCommPurchaseAuthInfoDTO infoDTO = this.dycProCommPurchaseAuthRepository.qryPurchaseAuthCatalogAll(authInfoDTO);
        ArrayList<DycProCommPurchaseAuthByBuyBO> rows = new ArrayList<DycProCommPurchaseAuthByBuyBO>();
        if (null != infoDTO && !CollectionUtils.isEmpty((Collection)infoDTO.getCatalogList())) {
            List catalogIds = infoDTO.getCatalogList().stream().distinct().map(a -> a.getCatalogId()).collect(Collectors.toList());
            for (Long skuId : skuCatalogMap.keySet()) {
                if (catalogIds.contains(skuCatalogMap.get(skuId))) continue;
                DycProCommPurchaseAuthByBuyBO buyBO = new DycProCommPurchaseAuthByBuyBO();
                buyBO.setSkuId(skuId);
                buyBO.setBuyFlag(false);
                rows.add(buyBO);
            }
        }
        rspBO.setRows(rows);
        return rspBO;
    }
}

