/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.spu.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuBO;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordActionTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordOperateResultEnum;
import com.tydic.dyc.pro.dmc.constant.DycProCommApiConstant;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.approve.api.DycProCommPublicProcTaskInstRepository;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPackageInfoDTO;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPakageObjDTO;
import com.tydic.dyc.pro.dmc.repository.managecatalog.api.DycProCommManageCatalogRepository;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommPropertyTemplateInfoDTO;
import com.tydic.dyc.pro.dmc.repository.operaterecord.api.DycProCommOperateRecordRepository;
import com.tydic.dyc.pro.dmc.repository.operaterecord.dto.DycProCommOperateRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoHandleDTO;
import com.tydic.dyc.pro.dmc.repository.sensitiveword.api.DycProCommSensitiveWordInfoRepository;
import com.tydic.dyc.pro.dmc.repository.sensitiveword.dto.DycProCommSensitiveWordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommAgrDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuAfterSaleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDetailsInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuPicInfoDTO;
import com.tydic.dyc.pro.dmc.repository.spu.api.DycProCommSpuRepository;
import com.tydic.dyc.pro.dmc.repository.spu.dto.DycProCommSpuInfoDTO;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoDTO;
import com.tydic.dyc.pro.dmc.service.spu.api.DycProCommSubmitSpuEditService;
import com.tydic.dyc.pro.dmc.service.spu.bo.DycProCommSpuSkuInfoApiBO;
import com.tydic.dyc.pro.dmc.service.spu.bo.DycProCommSubmitSpuEditReqBO;
import com.tydic.dyc.pro.dmc.service.spu.bo.DycProCommSubmitSpuEditRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.spu.api.DycProCommSubmitSpuEditService"})
public class DycProCommSubmitSpuEditServiceImpl
implements DycProCommSubmitSpuEditService {
    @Autowired
    private DycProCommSpuRepository dycProCommSpuRepository;
    @Autowired
    private DycProCommManageCatalogRepository dycProCommManageCatalogRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommPublicProcTaskInstRepository dycProCommPublicProcTaskInstRepository;
    @Autowired
    private DycProCommPriceRuleInfoRepository dycProCommPriceRuleInfoRepository;
    @Autowired
    private DycProCommOperateRecordRepository dycProCommOperateRecordRepository;
    @Autowired
    private DycProCommSensitiveWordInfoRepository dycProCommSensitiveWordInfoRepository;

    @PostMapping(value={"submitSpuEdit"})
    public DycProCommSubmitSpuEditRspBO submitSpuEdit(@RequestBody DycProCommSubmitSpuEditReqBO reqBO) {
        DycProCommSubmitSpuEditRspBO rspBO = new DycProCommSubmitSpuEditRspBO();
        Long propertyTemplateId = null;
        if (null != reqBO.getManageCatalogId()) {
            DycProCommPropertyTemplateInfoDTO queryPropertyTemplateDto = new DycProCommPropertyTemplateInfoDTO();
            queryPropertyTemplateDto.setManageCatalogId(reqBO.getManageCatalogId());
            DycProCommPropertyTemplateInfoDTO queryPropertyTemplateResultDto = this.dycProCommManageCatalogRepository.queryPropertyTemplateOneByCondition(queryPropertyTemplateDto);
            if (null != queryPropertyTemplateResultDto) {
                propertyTemplateId = queryPropertyTemplateResultDto.getPropertyTemplateId();
            } else {
                throw new ZTBusinessException("\u8be5\u7ba1\u7406\u76ee\u5f55\u4e0d\u5b58\u5728\u5c5e\u6027\u6a21\u7248");
            }
        }
        this.updateSpuDetailsInfo(reqBO, propertyTemplateId);
        List<DycProEsIndexMappingSkuBO> dycProEsIndexMappingSkuBOS = this.addSkuInfo(reqBO, propertyTemplateId);
        rspBO.setSkuIds(dycProEsIndexMappingSkuBOS.stream().map(DycProEsIndexMappingSkuBO::getSkuId).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty(dycProEsIndexMappingSkuBOS) && DycProCommConstants.ApprovalStatus.ON_SHELVE_IN_APPROVAL.equals(dycProEsIndexMappingSkuBOS.get(0).getApprovalStatus())) {
            Long auditPackageId = this.insertAuditPackage(dycProEsIndexMappingSkuBOS);
            rspBO.setAuditPackageId(auditPackageId);
        }
        return rspBO;
    }

    private void insertOperateRecord(DycProCommSubmitSpuEditReqBO reqBO, List<DycProEsIndexMappingSkuBO> dycProEsIndexMappingSkuBOS) {
        ArrayList<DycProCommOperateRecordDTO> operateRecordPOList = new ArrayList<DycProCommOperateRecordDTO>();
        for (DycProEsIndexMappingSkuBO dycProEsIndexMappingSkuBO : dycProEsIndexMappingSkuBOS) {
            DycProCommOperateRecordDTO commOperateRecordPO = new DycProCommOperateRecordDTO();
            commOperateRecordPO.setObjId(dycProEsIndexMappingSkuBO.getSkuId());
            commOperateRecordPO.setObjCode(dycProEsIndexMappingSkuBO.getSkuCode());
            commOperateRecordPO.setObjType(DycProCommConstants.OperateRecordObjType.SKU);
            commOperateRecordPO.setOperateTime(new Date(System.currentTimeMillis()));
            commOperateRecordPO.setOperateUserId(reqBO.getUserId());
            commOperateRecordPO.setOperateUserAccount(reqBO.getUserName());
            commOperateRecordPO.setOperateUserName(reqBO.getName());
            commOperateRecordPO.setOperateUserType(DycProCommConstants.OperateUserType.USER);
            commOperateRecordPO.setOperateReason("\u521b\u5efa\u5546\u54c1\u65f6\u9009\u62e9\u4e86\u7acb\u5373\u4e0a\u67b6\uff0c\u4e14\u4e0d\u9700\u8981\u4e0a\u67b6\u5ba1\u6279");
            commOperateRecordPO.setActionType(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordActionTypeEnum.ON_SHELVE.getCode())));
            commOperateRecordPO.setActionName(DmcCommOperateRecordActionTypeEnum.ON_SHELVE.getValue());
            commOperateRecordPO.setOperateResult(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordOperateResultEnum.SUCCESS_ON_SHELVE.getCode())));
            commOperateRecordPO.setOperateResultDesc(DmcCommOperateRecordOperateResultEnum.SUCCESS_ON_SHELVE.getValue());
            operateRecordPOList.add(commOperateRecordPO);
        }
        this.dycProCommOperateRecordRepository.addOperateRecordBatch(operateRecordPOList);
    }

    private Long insertAuditPackage(List<DycProEsIndexMappingSkuBO> agrSkuInfoList) {
        Long auditPackageId = Sequence.getInstance().nextId();
        DycProCommAuditPackageInfoDTO dycProCommAuditPackageInfoDTO = new DycProCommAuditPackageInfoDTO();
        dycProCommAuditPackageInfoDTO.setAuditPackageId(auditPackageId);
        List auditPackageObjDTOList = JSONArray.parseArray((String)JSON.toJSONString(agrSkuInfoList)).toJavaList(DycProCommAuditPakageObjDTO.class);
        for (DycProCommAuditPakageObjDTO commAuditPackageObjDTO : auditPackageObjDTOList) {
            commAuditPackageObjDTO.setCreateTime(new Date(System.currentTimeMillis()));
            commAuditPackageObjDTO.setAuditPackageId(auditPackageId);
            commAuditPackageObjDTO.setDelTag(DycProCommConstants.DelFlag.NO);
        }
        dycProCommAuditPackageInfoDTO.setAuditPakageObjDTOList(auditPackageObjDTOList);
        this.dycProCommPublicProcTaskInstRepository.addAuditPackageBatch(dycProCommAuditPackageInfoDTO);
        return auditPackageId;
    }

    private void updateSpuDetailsInfo(DycProCommSubmitSpuEditReqBO reqBO, Long propertyTemplateId) {
        List spuSensitiveWordInfoDTOS = this.dycProCommSensitiveWordInfoRepository.verifySensitiveWord(reqBO.getSpuName());
        if (!CollectionUtils.isEmpty((Collection)spuSensitiveWordInfoDTOS)) {
            StringBuilder sensitiveWords = new StringBuilder();
            for (DycProCommSensitiveWordInfoDTO sensitiveWordDto : spuSensitiveWordInfoDTOS) {
                sensitiveWords.append("[").append(sensitiveWordDto.getSensitiveWordName()).append("],");
            }
            throw new ZTBusinessException("spu\u540d\u79f0\u5b58\u5728\u654f\u611f\u8bcd\uff1a" + sensitiveWords.toString());
        }
        List skuNames = reqBO.getSkuList().stream().map(DycProCommSpuSkuInfoApiBO::getSkuName).collect(Collectors.toList());
        String skuNameStr = String.join((CharSequence)",", skuNames);
        List skusensitiveWordInfoDTOS = this.dycProCommSensitiveWordInfoRepository.verifySensitiveWord(skuNameStr);
        if (!CollectionUtils.isEmpty((Collection)skusensitiveWordInfoDTOS)) {
            StringBuilder sensitiveWords = new StringBuilder();
            for (DycProCommSensitiveWordInfoDTO sensitiveWordDto : skusensitiveWordInfoDTOS) {
                sensitiveWords.append("[").append(sensitiveWordDto.getSensitiveWordName()).append("],");
            }
            throw new ZTBusinessException("sku\u540d\u79f0\u5b58\u5728\u654f\u611f\u8bcd\uff1a" + sensitiveWords.toString());
        }
        DycProCommSpuInfoDTO updateSpuInfoDto = (DycProCommSpuInfoDTO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), DycProCommSpuInfoDTO.class);
        updateSpuInfoDto.setPropertyTemplateId(propertyTemplateId);
        updateSpuInfoDto.setUpdateUserId(reqBO.getUserId());
        updateSpuInfoDto.setUpdateUserName(reqBO.getName());
        updateSpuInfoDto.setUpdateUserAccount(reqBO.getUserName());
        updateSpuInfoDto.setUpdateCompanyId(reqBO.getCompanyId());
        updateSpuInfoDto.setUpdateCompanyName(reqBO.getCompanyName());
        updateSpuInfoDto.setUpdateOrgId(reqBO.getOrgId());
        updateSpuInfoDto.setUpdateOrgName(reqBO.getOrgName());
        updateSpuInfoDto.setUpdateOrgPath(reqBO.getOrgPath());
        this.dycProCommSpuRepository.updateSpuDetailsInfo(updateSpuInfoDto);
    }

    private List<DycProEsIndexMappingSkuBO> addSkuInfo(DycProCommSubmitSpuEditReqBO reqBO, Long propertyTemplateId) {
        ArrayList<DycProCommSkuDTO> skuDTOList = new ArrayList<DycProCommSkuDTO>();
        boolean operateRecordFlag = false;
        for (DycProCommSpuSkuInfoApiBO spuSkuInfoBo : reqBO.getSkuList()) {
            DycProCommSkuDTO addSkuDto = new DycProCommSkuDTO();
            BeanUtils.copyProperties((Object)reqBO, (Object)addSkuDto);
            BeanUtils.copyProperties((Object)spuSkuInfoBo, (Object)addSkuDto);
            addSkuDto.setSkuStatus(DycProCommConstants.SkuStatus.TOBE_ON_SHELVES);
            if (DycProCommConstants.SkuOnShelveWay.MANUAL_ON_SHELVE.equals(reqBO.getOnShelveWay())) {
                addSkuDto.setSkuStatus(DycProCommConstants.SkuStatus.TOBE_ON_SHELVES);
            } else if (DycProCommConstants.SkuOnShelveWay.AUTO_ON_SHELVE.equals(reqBO.getOnShelveWay())) {
                if (reqBO.getUccApproveOnShelveAgreementSwitch().booleanValue()) {
                    addSkuDto.setSkuStatus(DycProCommConstants.SkuStatus.TOBE_ON_SHELVES);
                    addSkuDto.setApprovalStatus(DycProCommConstants.ApprovalStatus.ON_SHELVE_IN_APPROVAL);
                } else {
                    operateRecordFlag = true;
                    addSkuDto.setSkuStatus(DycProCommConstants.SkuStatus.ON_SHELVES);
                    addSkuDto.setOnShelveTime(new Date(System.currentTimeMillis()));
                }
            } else {
                throw new ZTBusinessException("\u672a\u77e5\u7684\u4e0a\u67b6\u65b9\u5f0f");
            }
            addSkuDto.setSpuId(reqBO.getSpuId());
            addSkuDto.setSkuSource(DycProCommConstants.SkuSource.AGR_SKU);
            addSkuDto.setPropertyTemplateId(propertyTemplateId);
            addSkuDto.setIsHaveGift(DycProCommConstants.IsHaveGift.NO);
            addSkuDto.setCreateUserId(reqBO.getUserId());
            addSkuDto.setCreateUserName(reqBO.getName());
            addSkuDto.setCreateUserAccount(reqBO.getUserName());
            addSkuDto.setCreateCompanyId(reqBO.getCompanyId());
            addSkuDto.setCreateCompanyName(reqBO.getCompanyName());
            addSkuDto.setCreateOrgId(reqBO.getOrgId());
            addSkuDto.setCreateOrgName(reqBO.getOrgName());
            addSkuDto.setCreateOrgPath(reqBO.getOrgPath());
            addSkuDto.setSaleMeasureRate(new BigDecimal(1));
            addSkuDto.setSettleMeasureId(spuSkuInfoBo.getSaleMeasureId());
            addSkuDto.setSettleMeasureName(spuSkuInfoBo.getSaleMeasureName());
            DycProCommAgrDTO skuAgrInfo = new DycProCommAgrDTO();
            BeanUtils.copyProperties((Object)reqBO.getSpuAgrInfo(), (Object)skuAgrInfo);
            addSkuDto.setSkuAgrInfo(skuAgrInfo);
            DycProCommSkuDetailsInfoDTO skuDetails = new DycProCommSkuDetailsInfoDTO();
            skuDetails.setPropertyInstInfo(spuSkuInfoBo.getSkuDetails().getPropertyInstInfo());
            skuDetails.setAfterSaleRemark(reqBO.getSpuDetails().getAfterSaleRemark());
            skuDetails.setPackageRemark(reqBO.getSpuDetails().getPackageRemark());
            skuDetails.setSkuPcDetailUrl(reqBO.getSpuDetails().getSpuPcDetailUrl());
            addSkuDto.setSkuDetails(skuDetails);
            if (null != reqBO.getSpuDetails()) {
                DycProCommSkuAfterSaleInfoDTO addSkuAfterSaleInfoDto = new DycProCommSkuAfterSaleInfoDTO();
                BeanUtils.copyProperties((Object)reqBO.getSpuAfterSaleInfo(), (Object)addSkuAfterSaleInfoDto);
                addSkuDto.setSkuAfterSaleInfo(addSkuAfterSaleInfoDto);
            }
            if (!CollectionUtils.isEmpty((Collection)spuSkuInfoBo.getSkuPicInfoList())) {
                List addSkuPicInfoList = JSONArray.parseArray((String)JSON.toJSONString((Object)spuSkuInfoBo.getSkuPicInfoList())).toJavaList(DycProCommSkuPicInfoDTO.class);
                addSkuDto.setSkuPicInfoList(addSkuPicInfoList);
            }
            if (null != spuSkuInfoBo.getPriceInfo()) {
                DycProCommSkuPriceInfoDTO addSkuPriceInfoDto = new DycProCommSkuPriceInfoDTO();
                addSkuPriceInfoDto.setSupplierPrice(spuSkuInfoBo.getPriceInfo().getSupplierPrice());
                addSkuPriceInfoDto.setMarketPrice(spuSkuInfoBo.getPriceInfo().getMarketPrice());
                addSkuPriceInfoDto.setPriority(Integer.valueOf(0));
                if (DycProCommApiConstant.TradeMode.MATCH.equals(reqBO.getTradeMode())) {
                    addSkuPriceInfoDto.setSalePrice(spuSkuInfoBo.getPriceInfo().getSupplierPrice());
                } else {
                    DycProCommSkuPriceInfoHandleDTO handleDTO = new DycProCommSkuPriceInfoHandleDTO();
                    handleDTO.setSupplierPrice(spuSkuInfoBo.getPriceInfo().getSupplierPrice());
                    handleDTO.setMarketPrice(spuSkuInfoBo.getPriceInfo().getMarketPrice());
                    handleDTO.setSupplierId(reqBO.getSupplierId());
                    handleDTO.setAgrId(reqBO.getAgrId());
                    handleDTO.setManageCatalogId(reqBO.getManageCatalogId());
                    handleDTO.setPriceRuleType(DycProCommConstants.PriceRuleType.AGR);
                    DycProCommSkuPriceInfoDTO computeSkuPriceResultDto = this.dycProCommPriceRuleInfoRepository.computeSkuPrice(handleDTO);
                    if (null != computeSkuPriceResultDto) {
                        addSkuPriceInfoDto.setSalePrice(computeSkuPriceResultDto.getSalePrice());
                        addSkuPriceInfoDto.setPriceRuleId(computeSkuPriceResultDto.getPriceRuleId());
                        addSkuPriceInfoDto.setPriceRiseType(computeSkuPriceResultDto.getPriceRiseType());
                        addSkuPriceInfoDto.setPriceRiseRate(computeSkuPriceResultDto.getPriceRiseRate());
                        addSkuPriceInfoDto.setLadderPriceRule(computeSkuPriceResultDto.getLadderPriceRule());
                    }
                }
                addSkuDto.setPriceInfo(addSkuPriceInfoDto);
            }
            if (null != spuSkuInfoBo.getStockInfo()) {
                DycProCommSkuStockInfoDTO addSkuStockInfo = new DycProCommSkuStockInfoDTO();
                addSkuStockInfo.setSkuName(spuSkuInfoBo.getSkuName());
                addSkuStockInfo.setOriginNum(spuSkuInfoBo.getStockInfo().getOriginNum());
                addSkuStockInfo.setTotalNum(spuSkuInfoBo.getStockInfo().getOriginNum());
                addSkuStockInfo.setUnsaleNum(spuSkuInfoBo.getStockInfo().getOriginNum());
                addSkuStockInfo.setSaledNum(new BigDecimal(0));
                addSkuStockInfo.setSupplierId(reqBO.getSupplierId());
                addSkuStockInfo.setSupplierName(reqBO.getSupplierName());
                addSkuStockInfo.setSaleMeasureId(spuSkuInfoBo.getSaleMeasureId());
                addSkuStockInfo.setSaleMeasureName(spuSkuInfoBo.getSaleMeasureName());
                addSkuStockInfo.setCreateUserId(reqBO.getUserId());
                addSkuStockInfo.setCreateUserName(reqBO.getName());
                addSkuStockInfo.setCreateUserAccount(reqBO.getUserName());
                addSkuStockInfo.setCreateCompanyId(reqBO.getCompanyId());
                addSkuStockInfo.setCreateCompanyName(reqBO.getCompanyName());
                addSkuStockInfo.setCreateOrgId(reqBO.getOrgId());
                addSkuStockInfo.setCreateOrgName(reqBO.getOrgName());
                addSkuDto.setStockInfo(addSkuStockInfo);
            }
            skuDTOList.add(addSkuDto);
        }
        List skuEsBoList = this.dycProCommSkuRepository.addSkuCompleteInfoBatchAndSyncNosql(skuDTOList);
        if (operateRecordFlag) {
            this.insertOperateRecord(reqBO, skuEsBoList);
        }
        return skuEsBoList;
    }
}

