/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.shiporder.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderQryDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderAccessoryApiBO;
import com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderConfirmArrivalShipOrderService;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderConfirmArrivalShipOrderReqBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderConfirmArrivalShipOrderRspBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderReturnSkuStockBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderConfirmArrivalShipOrderService"})
public class DycProOrderConfirmArrivalShipOrderServiceImpl
implements DycProOrderConfirmArrivalShipOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderConfirmArrivalShipOrderServiceImpl.class);
    @Autowired
    private DycProOrderShipOrderRepository dycProOrderShipOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;

    @PostMapping(value={"confirmArrivalShipOrder"})
    public DycProOrderConfirmArrivalShipOrderRspBO confirmArrivalShipOrder(@RequestBody DycProOrderConfirmArrivalShipOrderReqBO reqBO) {
        this.verifyParam(reqBO);
        ArrayList<DycProOrderShipOrderQryDTO> updateShipOrderDtoList = new ArrayList<DycProOrderShipOrderQryDTO>();
        for (Long shipOrderId : reqBO.getShipOrderIdList()) {
            DycProOrderShipOrderQryDTO updateShipOrderDto = new DycProOrderShipOrderQryDTO();
            updateShipOrderDto.setShipOrderId(shipOrderId);
            updateShipOrderDto.setReceiverContact(reqBO.getReceiverContact());
            updateShipOrderDto.setReceiverRemark(reqBO.getReceiverRemark());
            updateShipOrderDto.setReceiverUser(reqBO.getReceiverUser());
            updateShipOrderDto.setReceiverTime(new Date());
            updateShipOrderDto.setArriveTime(new Date());
            if (reqBO.getOperType().equals(0)) {
                updateShipOrderDto.setShipOrderState("FH_FH_YDH");
            } else if (reqBO.getOperType().equals(1)) {
                updateShipOrderDto.setShipOrderState("FH_FH_JS");
            } else {
                throw new ZTBusinessException("\u65e0\u6cd5\u8bc6\u522b\u7684\u64cd\u4f5c\u7c7b\u578b");
            }
            updateShipOrderDtoList.add(updateShipOrderDto);
        }
        this.dycProOrderShipOrderRepository.updateShipOrderBatchByIdsAndSyncNosql(updateShipOrderDtoList);
        DycProOrderShipOrderItemQryDTO shipOrderItemQryDto = new DycProOrderShipOrderItemQryDTO();
        shipOrderItemQryDto.setShipOrderIdList(reqBO.getShipOrderIdList());
        List shipOrderItemDtoList = this.dycProOrderShipOrderRepository.queryShipOrderItemByCondition(shipOrderItemQryDto);
        if (!CollectionUtils.isEmpty((Collection)shipOrderItemDtoList)) {
            ArrayList<DycProOrderShipOrderItemDTO> updateShipOrderItemDtoList = new ArrayList<DycProOrderShipOrderItemDTO>();
            for (Object shipOrderItemDto : shipOrderItemDtoList) {
                DycProOrderShipOrderItemDTO updateShipOrderItemDto = new DycProOrderShipOrderItemDTO();
                updateShipOrderItemDto.setShipOrderItemId(shipOrderItemDto.getShipOrderItemId());
                if (reqBO.getOperType().equals(0)) {
                    updateShipOrderItemDto.setArriveCount(shipOrderItemDto.getSendCount());
                }
                if (reqBO.getOperType().equals(1)) {
                    updateShipOrderItemDto.setRefuseCount(shipOrderItemDto.getSendCount());
                }
                updateShipOrderItemDtoList.add(updateShipOrderItemDto);
            }
            this.dycProOrderShipOrderRepository.updateShipOrderItemBatchByIds(updateShipOrderItemDtoList);
            if (!CollectionUtils.isEmpty((Collection)reqBO.getConfirmArrivalAccessoryList())) {
                ArrayList<Object> fileList = new ArrayList<Object>();
                for (Long shipOrderId : reqBO.getShipOrderIdList()) {
                    for (DycProOrderAccessoryApiBO accessoryApiBo : reqBO.getConfirmArrivalAccessoryList()) {
                        DycProOrderOrderAccessoryDTO accessoryDto = new DycProOrderOrderAccessoryDTO();
                        accessoryDto.setAccessoryUrl(accessoryApiBo.getAccessoryUrl());
                        accessoryDto.setAccessoryName(accessoryApiBo.getAccessoryName());
                        accessoryDto.setObjType(DycProOrderApiServiceConstant.AccessoryObjType.CONFIRM_OR_REFUSE_SHIP_ORDER);
                        accessoryDto.setObjId(shipOrderId);
                        accessoryDto.setOrderId(reqBO.getSaleOrderId());
                        fileList.add(accessoryDto);
                    }
                }
                this.dycProOrderOrderRepository.addAllKindsAccessoryBatch(fileList);
            }
            DycProOrderSaleOrderItemQryDTO dycProOrderSaleOrderItemQryDTO = new DycProOrderSaleOrderItemQryDTO();
            dycProOrderSaleOrderItemQryDTO.setSaleOrderId(reqBO.getSaleOrderId());
            List saleOrderItemDTOList = this.dycProOrderSaleOrderRepository.getSaleOrderItemList(dycProOrderSaleOrderItemQryDTO);
            Map saleOrderItemMap = saleOrderItemDTOList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, Function.identity()));
            DycProOrderSaleOrderDTO saleOrderDTO = new DycProOrderSaleOrderDTO();
            HashMap<Long, DycProOrderSaleOrderItemDTO> updateSaleItemMap = new HashMap<Long, DycProOrderSaleOrderItemDTO>();
            for (DycProOrderShipOrderItemDTO shipOrderItemDTO : shipOrderItemDtoList) {
                DycProOrderSaleOrderItemDTO saleOrderItemDTO = (DycProOrderSaleOrderItemDTO)saleOrderItemMap.get(shipOrderItemDTO.getSaleOrderItemId());
                DycProOrderSaleOrderItemDTO updateSaleOrderItemDTO = (DycProOrderSaleOrderItemDTO)updateSaleItemMap.get(shipOrderItemDTO.getSaleOrderItemId());
                if (null == updateSaleOrderItemDTO) {
                    updateSaleOrderItemDTO = new DycProOrderSaleOrderItemDTO();
                    updateSaleOrderItemDTO.setSaleOrderItemId(shipOrderItemDTO.getSaleOrderItemId());
                    updateSaleOrderItemDTO.setRefuseCount(saleOrderItemDTO.getRefuseCount());
                    updateSaleOrderItemDTO.setArriveCount(saleOrderItemDTO.getArriveCount());
                }
                log.debug("saleOrderItemDTO.getRefuseCount():{}", (Object)Optional.ofNullable(saleOrderItemDTO.getRefuseCount()).orElse(BigDecimal.ZERO));
                log.debug("saleOrderItemDTO.getArriveCount():{}", (Object)Optional.ofNullable(saleOrderItemDTO.getArriveCount()).orElse(BigDecimal.ZERO));
                log.debug("shipOrderItemDTO.getSendCount():{}", (Object)shipOrderItemDTO.getSendCount());
                if (reqBO.getOperType().equals(1)) {
                    updateSaleOrderItemDTO.setRefuseCount(Optional.ofNullable(updateSaleOrderItemDTO.getRefuseCount()).orElse(BigDecimal.ZERO).add(shipOrderItemDTO.getSendCount()));
                } else if (reqBO.getOperType().equals(0)) {
                    updateSaleOrderItemDTO.setArriveCount(Optional.ofNullable(updateSaleOrderItemDTO.getArriveCount()).orElse(BigDecimal.ZERO).add(shipOrderItemDTO.getSendCount()));
                }
                updateSaleItemMap.put(updateSaleOrderItemDTO.getSaleOrderItemId(), updateSaleOrderItemDTO);
            }
            saleOrderDTO.setSaleItemList(new ArrayList(updateSaleItemMap.values()));
            this.dycProOrderSaleOrderRepository.updateSaleItemBatch(saleOrderDTO);
            DycProOrderSaleOrderDTO querySaleOrderDto = new DycProOrderSaleOrderDTO();
            querySaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
            DycProOrderSaleOrderDTO saleOrderDto = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(querySaleOrderDto);
            if ("XS_FH_FHWC".equals(saleOrderDto.getSaleOrderState())) {
                DycProOrderSaleOrderDTO updateSaleOrderDto;
                DycProOrderShipOrderQryDTO qryShipOrderDto = new DycProOrderShipOrderQryDTO();
                qryShipOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
                List shipOrderDtoList = this.dycProOrderShipOrderRepository.queryShipOrderByCondition(qryShipOrderDto);
                Object arrivalShipOrderCount = 0;
                Integer refuseShipOrderCount = 0;
                Integer pendingShipOrderCount = 0;
                Iterator inspShipOrderCount = 0;
                for (DycProOrderShipOrderDTO shipOrderDto : shipOrderDtoList) {
                    if ("FH_FH_JS".equals(shipOrderDto.getShipOrderState())) {
                        refuseShipOrderCount = refuseShipOrderCount + 1;
                        continue;
                    }
                    if ("FH_FH_YDH".equals(shipOrderDto.getShipOrderState())) {
                        arrivalShipOrderCount = (Integer)arrivalShipOrderCount + 1;
                        continue;
                    }
                    if ("FH_FH_YS".equals(shipOrderDto.getShipOrderState())) {
                        inspShipOrderCount = (Integer)((Object)inspShipOrderCount) + 1;
                        continue;
                    }
                    pendingShipOrderCount = pendingShipOrderCount + 1;
                }
                if (pendingShipOrderCount > 0) {
                    updateSaleOrderDto = new DycProOrderSaleOrderDTO();
                    updateSaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
                    updateSaleOrderDto.setShiporderList(updateShipOrderDtoList);
                    this.dycProOrderSaleOrderRepository.updateSaleOrderNosqlForIncr(updateSaleOrderDto);
                } else if (((Integer)arrivalShipOrderCount).equals(shipOrderDtoList.size())) {
                    updateSaleOrderDto = new DycProOrderSaleOrderDTO();
                    updateSaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
                    updateSaleOrderDto.setSaleOrderState("XS_DH_DH");
                    updateSaleOrderDto.setShiporderList(updateShipOrderDtoList);
                    this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDto, true);
                } else if (refuseShipOrderCount.equals(shipOrderDtoList.size())) {
                    updateSaleOrderDto = new DycProOrderSaleOrderDTO();
                    updateSaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
                    updateSaleOrderDto.setSaleOrderState("XS_DH_JS");
                    updateSaleOrderDto.setShiporderList(updateShipOrderDtoList);
                    updateSaleOrderDto.setOrderStage(DycProOrderApiServiceConstant.ORDER_STAPE.TRADE_CLOSE);
                    this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDto, true);
                } else if (pendingShipOrderCount.equals(0) && refuseShipOrderCount > 0 && (Integer)arrivalShipOrderCount > 0) {
                    updateSaleOrderDto = new DycProOrderSaleOrderDTO();
                    updateSaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
                    updateSaleOrderDto.setSaleOrderState("XS_DH_BFDH");
                    updateSaleOrderDto.setShiporderList(updateShipOrderDtoList);
                    this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDto, true);
                } else if (pendingShipOrderCount.equals(0) && refuseShipOrderCount.equals(0) && (Integer)arrivalShipOrderCount > 0 && (Integer)((Object)inspShipOrderCount) > 0) {
                    updateSaleOrderDto = new DycProOrderSaleOrderDTO();
                    updateSaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
                    updateSaleOrderDto.setSaleOrderState("XS_DH_DH");
                    updateSaleOrderDto.setShiporderList(updateShipOrderDtoList);
                    this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDto, true);
                } else if (pendingShipOrderCount.equals(0) && ((Integer)arrivalShipOrderCount).equals(0) && refuseShipOrderCount > 0 && (Integer)((Object)inspShipOrderCount) > 0) {
                    updateSaleOrderDto = new DycProOrderSaleOrderDTO();
                    updateSaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
                    updateSaleOrderDto.setSaleOrderState("XS_YS_BFYS");
                    updateSaleOrderDto.setShiporderList(updateShipOrderDtoList);
                    updateSaleOrderDto.setOrderStage(DycProOrderApiServiceConstant.ORDER_STAPE.TRADE_SUCCESS);
                    this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDto, true);
                }
            } else {
                DycProOrderSaleOrderDTO updateSaleOrderDto = new DycProOrderSaleOrderDTO();
                updateSaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
                updateSaleOrderDto.setShiporderList(updateShipOrderDtoList);
                this.dycProOrderSaleOrderRepository.updateSaleOrderNosqlForIncr(updateSaleOrderDto);
            }
            DycProOrderConfirmArrivalShipOrderRspBO rspBO = new DycProOrderConfirmArrivalShipOrderRspBO();
            if (reqBO.getOperType().equals(1)) {
                DycProOrderReturnSkuStockBO returnSkuStockBo;
                ArrayList<Long> saleOrderItemIdList = new ArrayList<Long>();
                for (DycProOrderShipOrderItemDTO shipOrderItemDto : shipOrderItemDtoList) {
                    saleOrderItemIdList.add(shipOrderItemDto.getSaleOrderItemId());
                }
                DycProOrderSaleOrderItemQryDTO querySaleOrderItemDto = new DycProOrderSaleOrderItemQryDTO();
                querySaleOrderItemDto.setSaleOrderItemIdList(saleOrderItemIdList);
                List saleOrderItemDtoList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDto);
                HashMap<Long, DycProOrderReturnSkuStockBO> returnSkuMap = new HashMap<Long, DycProOrderReturnSkuStockBO>();
                for (DycProOrderSaleOrderItemDTO saleOrderItemDto : saleOrderItemDtoList) {
                    if (returnSkuMap.containsKey(saleOrderItemDto.getSaleOrderItemId())) continue;
                    returnSkuStockBo = new DycProOrderReturnSkuStockBO();
                    returnSkuStockBo.setSkuId(Long.valueOf(saleOrderItemDto.getSkuId()));
                    returnSkuStockBo.setSaleOrderItemId(saleOrderItemDto.getSaleOrderItemId());
                    returnSkuMap.put(saleOrderItemDto.getSaleOrderItemId(), returnSkuStockBo);
                }
                for (DycProOrderShipOrderItemDTO shipOrderItemDto : shipOrderItemDtoList) {
                    returnSkuStockBo = (DycProOrderReturnSkuStockBO)returnSkuMap.get(shipOrderItemDto.getSaleOrderItemId());
                    returnSkuStockBo.setDeductAmount(Optional.ofNullable(returnSkuStockBo.getDeductAmount()).orElse(BigDecimal.ZERO).add(shipOrderItemDto.getSendCount()));
                    returnSkuMap.put(shipOrderItemDto.getSaleOrderItemId(), returnSkuStockBo);
                }
                ArrayList returnSkuList = new ArrayList(returnSkuMap.values());
                rspBO.setReturnSkuList(returnSkuList);
                return rspBO;
            }
            return rspBO;
        }
        throw new ZTBusinessException("\u67e5\u8be2\u53d1\u8d27\u5355\u660e\u7ec6\u5931\u8d25");
    }

    private void verifyParam(DycProOrderConfirmArrivalShipOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperType()) {
            throw new ZTBusinessException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getShipOrderIdList())) {
            throw new ZTBusinessException("\u53d1\u8d27\u5355id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

