/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dycpro.saas.order.saleOrder.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.service.order.api.DycProOrderQueryConfEvaluateListApiService;
import com.tydic.dyc.pro.egc.service.order.bo.DycProOrderConfEvaluateApiBO;
import com.tydic.dyc.pro.egc.service.order.bo.DycProOrderQueryConfEvaluateListApiReqBO;
import com.tydic.dyc.pro.egc.service.order.bo.DycProOrderQueryConfEvaluateListApiRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderEvaluateDealService;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderQrySaleOrderListPageApiService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderEvaluateDealReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderEvaluateDealRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderQrySaleOrderListPageApiReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderQrySaleOrderListPageApiRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderSaleInspOrderEsApiBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderSaleOrderEsApiBO;
import com.tydic.dycpro.saas.order.constant.DycProSaasOrderConstant;
import com.tydic.dycpro.saas.order.saleOrder.api.DycProSaasOrderDealAutoEvaService;
import com.tydic.dycpro.saas.order.saleOrder.bo.DycProSaasOrderDealAutoEvaReqBO;
import com.tydic.dycpro.saas.order.saleOrder.bo.DycProSaasOrderDealAutoEvaRspBO;
import com.tydic.uec.ability.UecEvaluateCreateAbilityService;
import com.tydic.uec.ability.UecTemplateDetailQryAbilityService;
import com.tydic.uec.ability.UecTemplateListQryAbilityService;
import com.tydic.uec.ability.bo.UecEvaluateCreateAbilityReqBO;
import com.tydic.uec.ability.bo.UecEvaluateCreateAbilityRspBO;
import com.tydic.uec.ability.bo.UecTemplateDetailQryAbilityReqBO;
import com.tydic.uec.ability.bo.UecTemplateDetailQryAbilityRspBO;
import com.tydic.uec.ability.bo.UecTemplateListQryAbilityReqBO;
import com.tydic.uec.ability.bo.UecTemplateListQryAbilityRspBO;
import com.tydic.uec.common.bo.eva.EvaBaseInfoBO;
import com.tydic.uec.common.bo.eva.EvaObjInfoBO;
import com.tydic.uec.common.bo.eva.EvaStarLevelBO;
import com.tydic.uec.common.bo.mod.ConfItemLevelBO;
import com.tydic.uec.common.bo.mod.ConfStarItemBO;
import com.tydic.uec.common.bo.mod.TemplateBO;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_PRO_GROUP/4.0.0/com.tydic.dycpro.saas.order.saleOrder.api.DycProSaasOrderDealAutoEvaService"})
public class DycProSaasOrderDealAutoEvaServiceImpl
implements DycProSaasOrderDealAutoEvaService {
    private static final Logger log = LoggerFactory.getLogger(DycProSaasOrderDealAutoEvaServiceImpl.class);
    private static final Integer TO_EVA = 0;
    private static final Integer SYSTEM_AUTOMATIC_PRAISE = 1;
    private static final List<String> EVA_ITEM_LIST = Arrays.asList("shop_logis", "shop_desc", "shop_service", "product_eva");
    @Autowired
    private DycProOrderQrySaleOrderListPageApiService dycProOrderQrySaleOrderListPageApiService;
    @Autowired
    private DycProOrderQueryConfEvaluateListApiService dycProOrderQueryConfEvaluateListApiService;
    @Autowired
    private UecTemplateDetailQryAbilityService uecTemplateDetailQryAbilityService;
    @Autowired
    private DycProOrderEvaluateDealService dycProOrderEvaluateDealService;
    @Autowired
    private UecTemplateListQryAbilityService uecTemplateListQryAbilityService;
    @Autowired
    private UecEvaluateCreateAbilityService evaluateCreateAbilityService;

    @Override
    @PostMapping(value={"dealAutoEva"})
    public DycProSaasOrderDealAutoEvaRspBO dealAutoEva(@RequestBody DycProSaasOrderDealAutoEvaReqBO reqBO) {
        Map<String, DycProOrderConfEvaluateApiBO> evaConfigMap;
        DycProOrderQrySaleOrderListPageApiRspBO firstQrySaleOrderList = this.getSaleOrderList(1, 100);
        if (!CollectionUtils.isEmpty((Collection)firstQrySaleOrderList.getRows()) && !(evaConfigMap = this.getEvaConfig()).isEmpty()) {
            UecTemplateDetailQryAbilityRspBO evaTemplate = this.getEvaTemplate();
            List<EvaStarLevelBO> evaStarLevelList = this.setDefaultStarLevel(evaTemplate);
            this.dealEva(evaTemplate, evaStarLevelList, firstQrySaleOrderList.getRows(), evaConfigMap);
            if (firstQrySaleOrderList.getRecordsTotal() > 100) {
                for (int i = 2; i <= firstQrySaleOrderList.getTotal(); ++i) {
                    DycProOrderQrySaleOrderListPageApiRspBO againQrySaleOrderList = this.getSaleOrderList(i, 100);
                    if (CollectionUtils.isEmpty((Collection)againQrySaleOrderList.getRows())) continue;
                    this.dealEva(evaTemplate, evaStarLevelList, againQrySaleOrderList.getRows(), evaConfigMap);
                }
            }
        }
        return new DycProSaasOrderDealAutoEvaRspBO();
    }

    private void dealEva(UecTemplateDetailQryAbilityRspBO evaTemplate, List<EvaStarLevelBO> evaStarLevelList, List<DycProOrderSaleOrderEsApiBO> rows, Map<String, DycProOrderConfEvaluateApiBO> evaConfigMap) {
        for (DycProOrderSaleOrderEsApiBO row : rows) {
            DycProOrderConfEvaluateApiBO evaConfig = this.getPurOrgEvaConfig(evaConfigMap, row.getSaleStakeholder().getPurOrgId());
            if (!SYSTEM_AUTOMATIC_PRAISE.equals(evaConfig.getSystemAutomaticPraise())) continue;
            Long evaluationDeadline = evaConfig.getEvaluationDeadline();
            if (CollectionUtils.isEmpty((Collection)row.getInspOrderList())) continue;
            Date lastInspTime = (Date)row.getInspOrderList().stream().map(DycProOrderSaleInspOrderEsApiBO::getCreateTime).sorted(Comparator.reverseOrder()).collect(Collectors.toList()).get(0);
            log.info("\u9700\u8981\u81ea\u52a8\u597d\u8bc4\u7684\u8ba2\u5355\u53f7\uff1a{},\u6700\u665a\u9a8c\u6536\u65f6\u95f4:{},\u5f53\u524d\u65f6\u95f4\uff1a{},\u8bc4\u4ef7\u622a\u6b62\u65f6\u95f4\uff1a{}", new Object[]{row.getSaleOrderNo(), lastInspTime, new Date(), evaluationDeadline});
            if (System.currentTimeMillis() <= lastInspTime.getTime() + evaluationDeadline) continue;
            log.info("\u9700\u8981\u81ea\u52a8\u597d\u8bc4\u7684\u8ba2\u5355\u53f7\uff1a{}\u9700\u8981\u81ea\u52a8\u8bc4\u4ef7", (Object)row.getSaleOrderNo());
            UecEvaluateCreateAbilityRspBO uecEvaluateCreateAbilityRspBO = this.evaluateCreateAbilityService.createEvaluate(this.setEvaluateCreateInfo(evaTemplate, row, evaStarLevelList));
            if (!"0000".equals(uecEvaluateCreateAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException("\u5904\u7406\u81ea\u52a8\u8bc4\u4ef7|\u5904\u7406\u8bc4\u4ef7|\u8c03\u7528\u8bc4\u4ef7\u521b\u5efa\u5931\u8d25: " + uecEvaluateCreateAbilityRspBO.getRespDesc());
            }
            DycProOrderEvaluateDealReqBO uocEvaluateDealServiceReqBo = new DycProOrderEvaluateDealReqBO();
            uocEvaluateDealServiceReqBo.setOrderId(row.getOrderId());
            uocEvaluateDealServiceReqBo.setSaleOrderId(row.getSaleOrderId());
            uocEvaluateDealServiceReqBo.setUserId(Long.valueOf(1L));
            uocEvaluateDealServiceReqBo.setEvaluateState(DycProSaasOrderConstant.EvaState.EVALUATED_CAN_REVIEWED);
            DycProOrderEvaluateDealRspBO dycProOrderEvaluateDealRspBO = this.dycProOrderEvaluateDealService.dealEvaluate(uocEvaluateDealServiceReqBo);
            if ("0000".equals(dycProOrderEvaluateDealRspBO.getRespCode())) continue;
            throw new ZTBusinessException("\u5904\u7406\u81ea\u52a8\u8bc4\u4ef7|\u5904\u7406\u8bc4\u4ef7|\u8c03\u7528\u5904\u7406\u9500\u552e\u5355\u8bc4\u4ef7\u5931\u8d25: " + dycProOrderEvaluateDealRspBO.getRespDesc());
        }
    }

    private DycProOrderConfEvaluateApiBO getPurOrgEvaConfig(Map<String, DycProOrderConfEvaluateApiBO> evaConfigMap, String purOrgId) {
        if (null == evaConfigMap.get(purOrgId)) {
            return evaConfigMap.get("0");
        }
        return evaConfigMap.get(purOrgId);
    }

    private DycProOrderQrySaleOrderListPageApiRspBO getSaleOrderList(int pageNo, int pageSize) {
        DycProOrderQrySaleOrderListPageApiReqBO qrySaleOrderListPage = new DycProOrderQrySaleOrderListPageApiReqBO();
        qrySaleOrderListPage.setPageNo(Integer.valueOf(pageNo));
        qrySaleOrderListPage.setPageSize(Integer.valueOf(pageSize));
        qrySaleOrderListPage.setEvaluateState(TO_EVA);
        qrySaleOrderListPage.setSaleOrderStateList(Collections.singletonList("XS_YS_YS"));
        DycProOrderQrySaleOrderListPageApiRspBO saleOrderListPage = this.dycProOrderQrySaleOrderListPageApiService.qrySaleOrderListPage(qrySaleOrderListPage);
        if (!"0000".equals(saleOrderListPage.getRespCode())) {
            throw new ZTBusinessException("\u5904\u7406\u81ea\u52a8\u8bc4\u4ef7|\u83b7\u53d6\u9500\u552e\u8ba2\u5355\u5217\u8868\u5931\u8d25: " + saleOrderListPage.getRespDesc());
        }
        return saleOrderListPage;
    }

    private List<EvaStarLevelBO> setDefaultStarLevel(UecTemplateDetailQryAbilityRspBO evaTemplate) {
        return evaTemplate.getBaseFieldList().stream().filter(confBaseFieldBO -> EVA_ITEM_LIST.contains(confBaseFieldBO.getFieldCode())).map(confBaseFieldBO -> {
            ConfStarItemBO confStarItemBO = (ConfStarItemBO)confBaseFieldBO.getStarItemList().get(0);
            EvaStarLevelBO evaStarLevelBO = new EvaStarLevelBO();
            evaStarLevelBO.setItemCode(confStarItemBO.getItemCode());
            evaStarLevelBO.setItemName(confStarItemBO.getItemName());
            for (ConfItemLevelBO confItemLevelBO : confStarItemBO.getItemLevelList()) {
                if (1 != confItemLevelBO.getIsDefault()) continue;
                evaStarLevelBO.setIsDefault(Integer.valueOf(1));
                evaStarLevelBO.setLevelValue(confItemLevelBO.getLevelValue());
            }
            return evaStarLevelBO;
        }).collect(Collectors.toList());
    }

    private UecEvaluateCreateAbilityReqBO setEvaluateCreateInfo(UecTemplateDetailQryAbilityRspBO evaTemplate, DycProOrderSaleOrderEsApiBO row, List<EvaStarLevelBO> evaStarLevelList) {
        TemplateBO templateInfo = evaTemplate.getTemplateInfo();
        EvaBaseInfoBO evaBaseInfoBO = (EvaBaseInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)templateInfo), EvaBaseInfoBO.class);
        evaBaseInfoBO.setBusiSn(row.getSaleOrderNo());
        evaBaseInfoBO.setEvaAct(Integer.valueOf(1));
        List objInfoBOList = row.getSaleItemList().stream().map(saleOrderItemEsApiBO -> {
            EvaObjInfoBO evaObjInfoBO = new EvaObjInfoBO();
            evaObjInfoBO.setEvaContent("\u7cfb\u7edf\u81ea\u52a8\u597d\u8bc4");
            evaObjInfoBO.setObjId(saleOrderItemEsApiBO.getSkuId());
            evaObjInfoBO.setObjName(saleOrderItemEsApiBO.getSkuName());
            evaObjInfoBO.setObjType(Integer.valueOf(1));
            evaObjInfoBO.setStarLevelList(evaStarLevelList);
            return evaObjInfoBO;
        }).collect(Collectors.toList());
        UecEvaluateCreateAbilityReqBO uecEvaluateCreateAbilityReqBO = new UecEvaluateCreateAbilityReqBO();
        uecEvaluateCreateAbilityReqBO.setEvaBaseInfo(evaBaseInfoBO);
        uecEvaluateCreateAbilityReqBO.getEvaBaseInfo().setOrderId(Convert.toStr((Object)row.getOrderId()));
        uecEvaluateCreateAbilityReqBO.setObjInfoList(objInfoBOList);
        uecEvaluateCreateAbilityReqBO.setNeedAudit(Boolean.valueOf(false));
        uecEvaluateCreateAbilityReqBO.setUserId(Long.valueOf(1L));
        uecEvaluateCreateAbilityReqBO.setName("\u7cfb\u7edf\u81ea\u52a8");
        return uecEvaluateCreateAbilityReqBO;
    }

    private UecTemplateDetailQryAbilityRspBO getEvaTemplate() {
        UecTemplateListQryAbilityReqBO uecTemplateListQryAbilityReqBO = new UecTemplateListQryAbilityReqBO();
        uecTemplateListQryAbilityReqBO.setState(Integer.valueOf(1));
        uecTemplateListQryAbilityReqBO.setSysCode("PEB");
        uecTemplateListQryAbilityReqBO.setTypeCode("EVA");
        UecTemplateListQryAbilityRspBO uecTemplateListQryAbilityRspBO = this.uecTemplateListQryAbilityService.qryTemplateList(uecTemplateListQryAbilityReqBO);
        if (!"0000".equals(uecTemplateListQryAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5904\u7406\u81ea\u52a8\u8bc4\u4ef7|\u83b7\u53d6\u8bc4\u4ef7\u6a21\u677f|\u67e5\u8be2\u8bc4\u4ef7\u6a21\u677f\u5217\u8868\u5931\u8d25: " + uecTemplateListQryAbilityRspBO.getRespDesc());
        }
        TemplateBO templateBO = (TemplateBO)uecTemplateListQryAbilityRspBO.getRows().get(0);
        UecTemplateDetailQryAbilityReqBO uecTemplateDetailQryAbilityReqBO = new UecTemplateDetailQryAbilityReqBO();
        uecTemplateDetailQryAbilityReqBO.setModId(templateBO.getModId());
        uecTemplateDetailQryAbilityReqBO.setTypeCode("EVA");
        UecTemplateDetailQryAbilityRspBO uecTemplateDetailQryAbilityRspBO = this.uecTemplateDetailQryAbilityService.qryTemplateDetail(uecTemplateDetailQryAbilityReqBO);
        if (!"0000".equals(uecTemplateDetailQryAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5904\u7406\u81ea\u52a8\u8bc4\u4ef7|\u83b7\u53d6\u8bc4\u4ef7\u6a21\u677f|\u67e5\u8be2\u8bc4\u4ef7\u6a21\u677f\u8be6\u60c5\u5931\u8d25: " + uecTemplateDetailQryAbilityRspBO.getRespDesc());
        }
        return uecTemplateDetailQryAbilityRspBO;
    }

    private Map<String, DycProOrderConfEvaluateApiBO> getEvaConfig() {
        DycProOrderQueryConfEvaluateListApiRspBO dycProOrderQueryConfEvaluateListApiRspBO = this.dycProOrderQueryConfEvaluateListApiService.queryConfEvaluateList(new DycProOrderQueryConfEvaluateListApiReqBO());
        if (!"0000".equals(dycProOrderQueryConfEvaluateListApiRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5904\u7406\u81ea\u52a8\u8bc4\u4ef7|\u83b7\u53d6\u8bc4\u4ef7\u914d\u7f6e\u5931\u8d25: " + dycProOrderQueryConfEvaluateListApiRspBO.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)dycProOrderQueryConfEvaluateListApiRspBO.getConfEvaluateList())) {
            return dycProOrderQueryConfEvaluateListApiRspBO.getConfEvaluateList().stream().collect(Collectors.toMap(DycProOrderConfEvaluateApiBO::getApplicationUnitNo, bo -> bo, (k1, k2) -> k1));
        }
        return new HashMap<String, DycProOrderConfEvaluateApiBO>(1);
    }
}

