/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dycpro.saas.order.saleOrder.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderEvaluateDealService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderEvaluateDealReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderEvaluateDealRspBO;
import com.tydic.dycpro.saas.order.saleOrder.api.DycProSaasOrderSaleOrderEvaluateService;
import com.tydic.dycpro.saas.order.saleOrder.bo.DycProSaasOrderSaleOrderEvaluateReqBO;
import com.tydic.dycpro.saas.order.saleOrder.bo.DycProSaasOrderSaleOrderEvaluateRspBO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import com.tydic.uec.ability.UecAuditOrderCreateAbilityService;
import com.tydic.uec.ability.UecEvaluateCreateAbilityService;
import com.tydic.uec.ability.bo.UecAuditOrderCreateAbilityReqBO;
import com.tydic.uec.ability.bo.UecAuditOrderCreateAbilityRspBO;
import com.tydic.uec.ability.bo.UecEvaluateCreateAbilityReqBO;
import com.tydic.uec.ability.bo.UecEvaluateCreateAbilityRspBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_PRO_GROUP/4.0.0/com.tydic.dycpro.saas.order.saleOrder.api.DycProSaasOrderSaleOrderEvaluateService"})
public class DycProSaasOrderSaleOrderEvaluateServiceImpl
implements DycProSaasOrderSaleOrderEvaluateService {
    private static final Logger log = LoggerFactory.getLogger(DycProSaasOrderSaleOrderEvaluateServiceImpl.class);
    public static final Integer EVALUATE = 1;
    public static final Integer AFTER_EVALUATE = 2;
    public static final Integer EVALUATED_CAN_REVIEWED = 1;
    public static final Integer REVIEWED = 4;
    public static final Integer EVALUATED_CAN_REVIEWED_AUDIT = 6;
    public static final Integer REVIEWED_AUDIT = 7;
    @Value(value="${no.need.audit.key:noNeedAudit}")
    private String noNeedAudit;
    @Autowired
    private UecEvaluateCreateAbilityService evaluateCreateAbilityService;
    @Autowired
    private DycProOrderEvaluateDealService dycProOrderEvaluateDealService;
    @Autowired
    private UecAuditOrderCreateAbilityService uecAuditOrderCreateAbilityService;
    @Value(value="${process.sysCode:DYC}")
    private String SYS_CODE;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;

    @Override
    @PostMapping(value={"saleOrderEvaluate"})
    public DycProSaasOrderSaleOrderEvaluateRspBO saleOrderEvaluate(@RequestBody DycProSaasOrderSaleOrderEvaluateReqBO reqBO) {
        this.verifyParam(reqBO);
        List<Long> evaIds = this.evaluateSaleOrder(reqBO);
        this.synchronousSaleOrderInfo(reqBO);
        if (!reqBO.getCreateEvaProcessKey().equals(this.noNeedAudit)) {
            this.startApproveProcess(reqBO, evaIds);
        }
        return new DycProSaasOrderSaleOrderEvaluateRspBO();
    }

    private void startApproveProcess(DycProSaasOrderSaleOrderEvaluateReqBO reqBO, List<Long> evaIds) {
        for (Long evaId : evaIds) {
            UecAuditOrderCreateAbilityReqBO uecAuditOrderCreateAbilityReqBO = new UecAuditOrderCreateAbilityReqBO();
            uecAuditOrderCreateAbilityReqBO.setOrderId(evaId);
            uecAuditOrderCreateAbilityReqBO.setObjBusiType(Integer.valueOf(1));
            uecAuditOrderCreateAbilityReqBO.setUserId(reqBO.getUserId());
            uecAuditOrderCreateAbilityReqBO.setUsername(reqBO.getName());
            uecAuditOrderCreateAbilityReqBO.setObjId(evaId);
            uecAuditOrderCreateAbilityReqBO.setObjType(Integer.valueOf(1));
            log.info("\u8c03\u7528\u8bc4\u4ef7\u4e2d\u5fc3\u5ba1\u6279\u5355\u521b\u5efa\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)uecAuditOrderCreateAbilityReqBO));
            UecAuditOrderCreateAbilityRspBO uecAuditOrderCreateAbilityRspBO = this.uecAuditOrderCreateAbilityService.dealAuditOrderCreate(uecAuditOrderCreateAbilityReqBO);
            log.info("\u8c03\u7528\u8bc4\u4ef7\u4e2d\u5fc3\u5ba1\u6279\u5355\u521b\u5efa\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)uecAuditOrderCreateAbilityReqBO));
            if (!"0000".equals(uecAuditOrderCreateAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8c03\u7528\u8bc4\u4ef7\u4e2d\u5fc3\u521b\u5efa\u5ba1\u6279\u9519\u8bef\uff1a" + uecAuditOrderCreateAbilityRspBO.getRespDesc());
            }
            HashMap<String, Long> variables = new HashMap<String, Long>();
            variables.put("auditId", uecAuditOrderCreateAbilityRspBO.getAuditOrderId());
            EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = new EacStartProjectAbilityReqBO();
            eacStartProjectAbilityReqBO.setUserId(reqBO.getUserId().toString());
            eacStartProjectAbilityReqBO.setProcDefKey(reqBO.getCreateEvaProcessKey());
            eacStartProjectAbilityReqBO.setSysCode(this.SYS_CODE);
            eacStartProjectAbilityReqBO.setPartitionKey(evaId.toString());
            eacStartProjectAbilityReqBO.setVariables(variables);
            ArrayList<String> strings = new ArrayList<String>();
            strings.add(evaId.toString());
            eacStartProjectAbilityReqBO.setBusinessIdList(strings);
            log.info("\u8ba2\u5355\u4e0b\u5355\u5ba1\u6279\u6d41\u7a0b\u542f\u52a8\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityReqBO));
            EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
            log.info("\u8ba2\u5355\u4e0b\u5355\u5ba1\u6279\u6d41\u7a0b\u542f\u52a8\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityRspBO));
            if ("0000".equals(eacStartProjectAbilityRspBO.getRespCode())) continue;
            throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacStartProjectAbilityRspBO.getRespCode() + "\u3011," + eacStartProjectAbilityRspBO.getRespDesc());
        }
    }

    private void synchronousSaleOrderInfo(DycProSaasOrderSaleOrderEvaluateReqBO reqBO) {
        DycProOrderEvaluateDealReqBO uocEvaluateDealServiceReqBo = (DycProOrderEvaluateDealReqBO)JUtil.js((Object)reqBO, DycProOrderEvaluateDealReqBO.class);
        if (reqBO.getEvaBaseInfo().getEvaAct().equals(EVALUATE)) {
            if (!reqBO.getCreateEvaProcessKey().equals(this.noNeedAudit)) {
                uocEvaluateDealServiceReqBo.setEvaluateState(EVALUATED_CAN_REVIEWED_AUDIT);
            } else {
                uocEvaluateDealServiceReqBo.setEvaluateState(EVALUATED_CAN_REVIEWED);
            }
        } else if (reqBO.getEvaBaseInfo().getEvaAct().equals(AFTER_EVALUATE)) {
            if (!reqBO.getCreateEvaProcessKey().equals(this.noNeedAudit)) {
                uocEvaluateDealServiceReqBo.setEvaluateState(REVIEWED_AUDIT);
            } else {
                uocEvaluateDealServiceReqBo.setEvaluateState(REVIEWED);
            }
        }
        DycProOrderEvaluateDealRspBO uocEvaluateDealServiceRspBo = this.dycProOrderEvaluateDealService.dealEvaluate(uocEvaluateDealServiceReqBo);
        if (!"0000".equals(uocEvaluateDealServiceRspBo.getRespCode())) {
            throw new ZTBusinessException("\u540c\u6b65\u8ba2\u5355\u8bc4\u4ef7\u72b6\u6001\u5931\u8d25\uff1a" + uocEvaluateDealServiceRspBo.getRespDesc());
        }
    }

    private List<Long> evaluateSaleOrder(DycProSaasOrderSaleOrderEvaluateReqBO reqBO) {
        UecEvaluateCreateAbilityReqBO uecEvaluateCreateAbilityReqBO = (UecEvaluateCreateAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UecEvaluateCreateAbilityReqBO.class);
        if (reqBO.getCreateEvaProcessKey().equals(this.noNeedAudit)) {
            uecEvaluateCreateAbilityReqBO.setNeedAudit(Boolean.valueOf(false));
        } else {
            uecEvaluateCreateAbilityReqBO.setNeedAudit(Boolean.valueOf(true));
        }
        UecEvaluateCreateAbilityRspBO uecEvaluateCreateAbilityRspBO = this.evaluateCreateAbilityService.createEvaluate(uecEvaluateCreateAbilityReqBO);
        log.info("\u8c03\u7528\u8bc4\u4ef7\u4e2d\u5fc3\u51fa\u53c2,{}", (Object)JSON.toJSONString((Object)uecEvaluateCreateAbilityRspBO));
        if (!"0000".equals(uecEvaluateCreateAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u8bc4\u4ef7\u4e2d\u5fc3\u5931\u8d25\uff1a" + uecEvaluateCreateAbilityRspBO.getRespDesc());
        }
        return uecEvaluateCreateAbilityRspBO.getEvaIds();
    }

    private void verifyParam(DycProSaasOrderSaleOrderEvaluateReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

