/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dycpro.saas.order.shipOrder.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.pro.base.utils.msgPool.DycProBaseMsgPoolAfterServiceReqBO;
import com.tydic.dyc.pro.base.utils.msgPool.DycProBaseMsgPoolBeforeServiceReqBO;
import com.tydic.dyc.pro.base.utils.msgPool.DycProBaseMsgPoolUtil;
import com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderCreateEsShipOrderService;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderCreateEsShipOrderReqBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderCreateEsShipOrderRspBO;
import com.tydic.dycpro.saas.order.shipOrder.api.DycProSaasOrderDealShipOrderMsgService;
import com.tydic.dycpro.saas.order.shipOrder.bo.DycProSaasOrderDealShipOrderMsgReqBO;
import com.tydic.dycpro.saas.order.shipOrder.bo.DycProSaasOrderDealShipOrderMsgRspBO;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_PRO_GROUP/4.0.0/com.tydic.dycpro.saas.order.shipOrder.api.DycProSaasOrderDealShipOrderMsgService"})
public class DycProSaasOrderDealShipOrderMsgServiceImpl
implements DycProSaasOrderDealShipOrderMsgService {
    private static final Logger log = LoggerFactory.getLogger(DycProSaasOrderDealShipOrderMsgServiceImpl.class);
    @Autowired
    private DycProOrderCreateEsShipOrderService dycProOrderCreateEsShipOrderService;
    @Value(value="${spool.api.before.url:${spool.ability.api.host}/spool/ability/before/do}")
    private String spoolAbilityBeforeServiceUrl;
    @Value(value="${spool.api.after.url:${spool.ability.api.host}/spool/ability/after/do}")
    private String spoolAbilityAfterServiceUrl;
    @Autowired
    private CacheClient cacheClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PostMapping(value={"dealShipOrderMsg"})
    public DycProSaasOrderDealShipOrderMsgRspBO dealShipOrderMsg(@RequestBody DycProSaasOrderDealShipOrderMsgReqBO reqBO) {
        String exceptionStr = null;
        try {
            this.spoolBeforeService(reqBO);
            RLock lock = this.cacheClient.getJedisPool().getLock("order_lock_" + reqBO.getResult().getOrderId());
            log.info("\u83b7\u53d6\u53d1\u8d27\u6d88\u606f\u8ba2\u5355id\u9501:{}", (Object)reqBO.getResult().getOrderId());
            try {
                boolean b = lock.tryLock(10L, 5L, TimeUnit.SECONDS);
                log.info("\u83b7\u53d6\u9501\u7ed3\u679c:{},\u53d1\u8d27\u6d88\u606f\u8ba2\u5355id\u9501:{}", (Object)b, (Object)reqBO.getResult().getOrderId());
                if (b) {
                    this.createShip(reqBO);
                }
            }
            catch (Exception e) {
                log.error("\u53d1\u8d27\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
                throw new ZTBusinessException("\u53d1\u8d27\u6d88\u606f\u5904\u7406\u5f02\u5e38" + e.getMessage());
            }
            finally {
                if (lock != null && lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
                log.info("\u83b7\u53d6\u53d1\u8d27\u6d88\u606f\u8ba2\u5355id\u9501\u91ca\u653e:{}", (Object)reqBO.getResult().getOrderId());
            }
            this.spoolAfterService(reqBO, exceptionStr);
        }
        catch (Exception e) {
            try {
                log.error("\u7535\u5546\u53d1\u8d27\u6d88\u606f\u5904\u7406\u63a5\u53e3\u62a5\u9519\uff1a", (Throwable)e);
                exceptionStr = e.getMessage();
                this.spoolAfterService(reqBO, exceptionStr);
            }
            catch (Throwable throwable) {
                this.spoolAfterService(reqBO, exceptionStr);
                throw throwable;
            }
        }
        return new DycProSaasOrderDealShipOrderMsgRspBO();
    }

    public void createShip(DycProSaasOrderDealShipOrderMsgReqBO reqBO) {
        DycProOrderCreateEsShipOrderReqBO createEsShipOrderReqBO = (DycProOrderCreateEsShipOrderReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycProOrderCreateEsShipOrderReqBO.class);
        DycProOrderCreateEsShipOrderRspBO createEsShipOrderRspBO = this.dycProOrderCreateEsShipOrderService.createEsShipOrder(createEsShipOrderReqBO);
        if (!"0000".equals(createEsShipOrderRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5916\u90e8\u53d1\u8d27\u5355\uff1a" + reqBO.getResult().getPackageId() + "\u521b\u5efa\u53d1\u8d27\u5355\u4fe1\u606f\u5f02\u5e38:" + createEsShipOrderRspBO.getRespDesc());
        }
    }

    private void spoolBeforeService(DycProSaasOrderDealShipOrderMsgReqBO reqBO) {
        DycProBaseMsgPoolBeforeServiceReqBO msgPoolBeforeServiceReqBO = new DycProBaseMsgPoolBeforeServiceReqBO();
        msgPoolBeforeServiceReqBO.setMqMsgId(reqBO.getMqMsgId());
        msgPoolBeforeServiceReqBO.setTraceId(reqBO.getTraceId());
        msgPoolBeforeServiceReqBO.setBusiCenterCode("UOC");
        msgPoolBeforeServiceReqBO.setUrl(this.spoolAbilityBeforeServiceUrl);
        DycProBaseMsgPoolUtil.spoolBeforeService((DycProBaseMsgPoolBeforeServiceReqBO)msgPoolBeforeServiceReqBO);
    }

    private void spoolAfterService(DycProSaasOrderDealShipOrderMsgReqBO reqBO, String exceptionStr) {
        DycProBaseMsgPoolAfterServiceReqBO msgPoolAfterServiceReqBO = new DycProBaseMsgPoolAfterServiceReqBO();
        msgPoolAfterServiceReqBO.setMqMsgId(reqBO.getMqMsgId());
        msgPoolAfterServiceReqBO.setTraceId(reqBO.getTraceId());
        msgPoolAfterServiceReqBO.setException(exceptionStr);
        msgPoolAfterServiceReqBO.setBusiCenterCode("UOC");
        msgPoolAfterServiceReqBO.setUrl(this.spoolAbilityAfterServiceUrl);
        DycProBaseMsgPoolUtil.spoolAfterService((DycProBaseMsgPoolAfterServiceReqBO)msgPoolAfterServiceReqBO);
    }
}

