/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.smc.repository.invoice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.smc.constants.DycProSmcRepositoryConstant;
import com.tydic.dyc.pro.smc.dao.UmcInvoiceInfoMapper;
import com.tydic.dyc.pro.smc.po.UmcInvoiceInfoPO;
import com.tydic.dyc.pro.smc.repository.invoice.api.DycProInvoiceRepository;
import com.tydic.dyc.pro.smc.repository.invoice.dto.DycProUmcInvoiceInfoDTO;
import com.tydic.dyc.pro.smc.repository.invoice.dto.DycProUmcInvoiceInfoQryDTO;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycProInvoiceRepositoryImpl
implements DycProInvoiceRepository {
    @Autowired
    private UmcInvoiceInfoMapper umcInvoiceInfoMapper;

    @Override
    public void addInvoice(DycProUmcInvoiceInfoDTO invoiceDto) {
        UmcInvoiceInfoPO addInvoicePO = new UmcInvoiceInfoPO();
        BeanUtils.copyProperties((Object)invoiceDto, (Object)addInvoicePO);
        addInvoicePO.setInvoiceId(Sequence.getInstance().nextId());
        addInvoicePO.setCreateTime(new Date());
        addInvoicePO.setDelFlag(DycProSmcRepositoryConstant.DelFlag.NO);
        this.umcInvoiceInfoMapper.insert(addInvoicePO);
    }

    @Override
    public DycProUmcInvoiceInfoDTO queryInvoiceByCondition(DycProUmcInvoiceInfoQryDTO qryDto) {
        UmcInvoiceInfoPO umcInvoiceInfoPO = (UmcInvoiceInfoPO)this.umcInvoiceInfoMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(null != qryDto.getInvoiceId(), UmcInvoiceInfoPO::getInvoiceId, (Object)qryDto.getInvoiceId())).notIn(null != qryDto.getInvoiceIdNotIn(), UmcInvoiceInfoPO::getInvoiceId, new Object[]{qryDto.getInvoiceIdNotIn()})).eq(StringUtils.isNotBlank((CharSequence)qryDto.getTitleType()), UmcInvoiceInfoPO::getTitleType, (Object)qryDto.getTitleType())).eq(null != qryDto.getCreateUserId(), UmcInvoiceInfoPO::getCreateUserId, (Object)qryDto.getCreateUserId())).eq(null != qryDto.getCreateCompanyId(), UmcInvoiceInfoPO::getCreateCompanyId, (Object)qryDto.getCreateCompanyId())).eq(StringUtils.isNotBlank((CharSequence)qryDto.getInvoiceTitle()), UmcInvoiceInfoPO::getInvoiceTitle, (Object)qryDto.getInvoiceTitle())).eq(null != qryDto.getInvoiceClass(), UmcInvoiceInfoPO::getInvoiceClass, (Object)qryDto.getInvoiceClass())).eq(null != qryDto.getInvoiceType(), UmcInvoiceInfoPO::getInvoiceType, (Object)qryDto.getInvoiceType())).eq(null != qryDto.getIsDefault(), UmcInvoiceInfoPO::getIsDefault, (Object)qryDto.getIsDefault())).eq(UmcInvoiceInfoPO::getDelFlag, (Object)DycProSmcRepositoryConstant.DelFlag.NO));
        if (null != umcInvoiceInfoPO) {
            DycProUmcInvoiceInfoDTO invoiceInfoDto = new DycProUmcInvoiceInfoDTO();
            BeanUtils.copyProperties((Object)umcInvoiceInfoPO, (Object)invoiceInfoDto);
            return invoiceInfoDto;
        }
        return null;
    }

    @Override
    public RspPage<DycProUmcInvoiceInfoDTO> queryInvoicePageListByCondition(DycProUmcInvoiceInfoQryDTO qryDto) {
        RspPage rspPage = new RspPage();
        Page page = new Page((long)qryDto.getPageNo().intValue(), (long)qryDto.getPageSize().intValue());
        Page result = (Page)this.umcInvoiceInfoMapper.selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(null != qryDto.getCreateUserId(), UmcInvoiceInfoPO::getCreateUserId, (Object)qryDto.getCreateUserId())).eq(null != qryDto.getCreateCompanyId(), UmcInvoiceInfoPO::getCreateCompanyId, (Object)qryDto.getCreateCompanyId())).eq(StringUtils.isNotBlank((CharSequence)qryDto.getTitleType()), UmcInvoiceInfoPO::getTitleType, (Object)qryDto.getTitleType())).eq(null != qryDto.getInvoiceType(), UmcInvoiceInfoPO::getInvoiceType, (Object)qryDto.getInvoiceType())).eq(null != qryDto.getInvoiceClass(), UmcInvoiceInfoPO::getInvoiceClass, (Object)qryDto.getInvoiceClass())).like(StringUtils.isNotBlank((CharSequence)qryDto.getInvoiceTitle()), UmcInvoiceInfoPO::getInvoiceTitle, (Object)qryDto.getInvoiceTitle())).like(StringUtils.isNotBlank((CharSequence)qryDto.getTaxpayerId()), UmcInvoiceInfoPO::getTaxpayerId, (Object)qryDto.getTaxpayerId())).like(StringUtils.isNotBlank((CharSequence)qryDto.getCreateUserName()), UmcInvoiceInfoPO::getCreateUserName, (Object)qryDto.getCreateUserName())).like(StringUtils.isNotBlank((CharSequence)qryDto.getUpdateUserName()), UmcInvoiceInfoPO::getUpdateUserName, (Object)qryDto.getUpdateUserName())).ge(null != qryDto.getCreateStarTime(), UmcInvoiceInfoPO::getCreateTime, (Object)qryDto.getCreateStarTime())).le(null != qryDto.getCreateEndTime(), UmcInvoiceInfoPO::getCreateTime, (Object)qryDto.getCreateEndTime())).ge(null != qryDto.getUpdateStarTime(), UmcInvoiceInfoPO::getUpdateTime, (Object)qryDto.getUpdateStarTime())).le(null != qryDto.getUpdateEndTime(), UmcInvoiceInfoPO::getUpdateTime, (Object)qryDto.getUpdateEndTime())).eq(UmcInvoiceInfoPO::getDelFlag, (Object)DycProSmcRepositoryConstant.DelFlag.NO)).orderByDesc(UmcInvoiceInfoPO::getCreateTime));
        if (CollectionUtils.isNotEmpty((Collection)result.getRecords())) {
            rspPage.setRows(JSONArray.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProUmcInvoiceInfoDTO.class));
        }
        rspPage.setPageNo((int)result.getCurrent());
        rspPage.setTotal((int)result.getPages());
        rspPage.setRecordsTotal((int)result.getTotal());
        return rspPage;
    }

    @Override
    public void updateInvoiceById(DycProUmcInvoiceInfoDTO invoiceDto) {
        UmcInvoiceInfoPO updateInvoiceInfoPO = new UmcInvoiceInfoPO();
        BeanUtils.copyProperties((Object)invoiceDto, (Object)updateInvoiceInfoPO);
        updateInvoiceInfoPO.setUpdateTime(new Date());
        this.umcInvoiceInfoMapper.updateById(updateInvoiceInfoPO);
    }

    @Override
    public void deleteInvoiceById(DycProUmcInvoiceInfoDTO invoiceDto) {
        UmcInvoiceInfoPO updateInvoiceInfoPO = new UmcInvoiceInfoPO();
        updateInvoiceInfoPO.setInvoiceId(invoiceDto.getInvoiceId());
        updateInvoiceInfoPO.setDelFlag(DycProSmcRepositoryConstant.DelFlag.YES);
        this.umcInvoiceInfoMapper.updateById(updateInvoiceInfoPO);
    }
}

