package com.tydic.dyc.agr.service.portion.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description: AgrPortionBO
 * @Author: the_xhl
 * @Date: 2023-11-21
 */
@Data
public class AgrPortionBO implements Serializable {

    private static final long serialVersionUID = -4647765225570601518L;
    /**
     * 份额id
     */
    private Long portionId;
    /**
     * 份额编号
     */
    private String portionCode;

    /**
     * 份额名称
     */
    private String portionName;

    /**
     * 份额状态
     */
    private String portionStatus;

    /**
     * 管控措施 预警 禁止下单
     */
    private String controlType;
    /**
     * 份额维度（1共享份额   2确定份额）
     */
    private Integer portionType;
    /**
     * 份额维度翻译
     */
    private String portionTypeStr;

    /**
     * 关联协议数量
     */
    private Integer relAgrNum;
    /**
     * 单位id集合
     */
    private List<Long> purIdList;
    /**
     * 协议id集合
     */
    private List<Long> agrIdList;
    /**
     * 下单管控方式(份额管控 顺序选取)
     */
    private String orderTube;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建人id
     */
    private Long createOperId;

    /**
     * 创建人名称
     */
    private String createOperName;
    /**
     * 更新人id
     */
    private Long updateOperId;

    /**
     * 更新人名称
     */
    private String updateOperName;

    /**
     * 更新时间
     */
    private Date updateTime;

}
