package com.tydic.dyc.agr.service.agr.bo;

import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.base.core.dictionary.annotation.DictField;
import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 描述：null 
 * 
 * @author auto_gen
 * @date 2023-02-08 12:03
 **/
@Data
public class AgrPayConfigDetailBo implements Serializable {
	private static final long serialVersionUID =  -1218897964736912642L;

	/**
	 * 支付配置id
	 */
	private Long payCfgId;
	/**
	 * 协议ID
	 */
	private Long agrId;
	/**
	 * 支付方
	 */
	@DictField(busiCenter = "UMC_PLUS",pCode = AgrCommConstant.SysDicDictionaryPCode.PAY_OBJ_PCODE)
	private Integer payObj;
	/**
	 * 支付方转义
	 */
	private String payObjStr;
	/**
	 * 支付方式
	 */
	@DictField(busiCenter = "UMC_PLUS",pCode = AgrCommConstant.SysDicDictionaryPCode.PAY_TYPE_PCODE)
	private Integer payType;
	/**
	 * 支付方式转义
	 */
	private String payTypeStr;
	/**
	 * 预付款
	 */
	private BigDecimal prePay;
	/**
	 * 到货款
	 */
	private BigDecimal matPay;
	/**
	 * 进度款
	 */
	private BigDecimal proPay;
	/**
	 * 验收款
	 */
	private BigDecimal verPay;
	/**
	 * 质保金
	 */
	private BigDecimal quaPay;
	/**
	 * 试运行验收款
	 */
	private BigDecimal pilPay;
	/**
	 * 是否指定日期
	 */
	@DictField(busiCenter = "UMC_PLUS",pCode = AgrCommConstant.SysDicDictionaryPCode.ASSIGN_PCODE)
	private String assign;
	/**
	 * 业务节点
	 */
	private Integer busiNode;
	/**
	 * 业务节点转义
	 */
	private String busiNodeStr;
	/**
	 * 结算月
	 */
	private String settlementMonth;
	/**
	 * 结算日
	 */
	private String settlementDate;
	/**
	 * 成交服务费比率
	 */
	private BigDecimal serviceRate;
	/**
	 * 币种
	 */
	private Integer currency;
	/**
	 * 税率
	 */
	private BigDecimal taxRate;
	/**
	 * 排序
	 */
	private String orderBy;
	/**
	 * 是否指定日期转义
	 */
	private String assignStr;

}
