/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrAllocateRecordListRspBO;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrItemCountByCommodityTypeReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrItemCountByCommodityTypeRspPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrVersionListReqBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrVersionListRspBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAllAgrListRspBO;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemCountQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAccessory;
import com.tydic.dyc.agr.model.agr.sub.AgrAdjustCfg;
import com.tydic.dyc.agr.model.agr.sub.AgrAgrVersion;
import com.tydic.dyc.agr.model.agr.sub.AgrAllocateRecord;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.model.agr.sub.AgrCataScope;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.model.agr.sub.AgrMainExt;
import com.tydic.dyc.agr.model.agr.sub.AgrPayConfig;
import com.tydic.dyc.agr.model.agr.sub.AgrRel;
import com.tydic.dyc.agr.repository.AgrAgrRepository;
import com.tydic.dyc.agr.repository.dao.AgrAccessoryMapper;
import com.tydic.dyc.agr.repository.dao.AgrAdjustCfgHisMapper;
import com.tydic.dyc.agr.repository.dao.AgrAdjustCfgMapper;
import com.tydic.dyc.agr.repository.dao.AgrAgrVersionMapper;
import com.tydic.dyc.agr.repository.dao.AgrAllocateRecordMapper;
import com.tydic.dyc.agr.repository.dao.AgrAppScopeHisMapper;
import com.tydic.dyc.agr.repository.dao.AgrAppScopeMapper;
import com.tydic.dyc.agr.repository.dao.AgrCataScopeHisMapper;
import com.tydic.dyc.agr.repository.dao.AgrCataScopeMapper;
import com.tydic.dyc.agr.repository.dao.AgrItemExtHisMapper;
import com.tydic.dyc.agr.repository.dao.AgrItemExtMapper;
import com.tydic.dyc.agr.repository.dao.AgrItemHisMapper;
import com.tydic.dyc.agr.repository.dao.AgrItemLadderPriceHisMapper;
import com.tydic.dyc.agr.repository.dao.AgrItemLadderPriceMapper;
import com.tydic.dyc.agr.repository.dao.AgrItemMapper;
import com.tydic.dyc.agr.repository.dao.AgrItemMapperUns;
import com.tydic.dyc.agr.repository.dao.AgrMainExtHisMapper;
import com.tydic.dyc.agr.repository.dao.AgrMainExtMapper;
import com.tydic.dyc.agr.repository.dao.AgrMainHisMapper;
import com.tydic.dyc.agr.repository.dao.AgrMainMapper;
import com.tydic.dyc.agr.repository.dao.AgrPayConfigHisMapper;
import com.tydic.dyc.agr.repository.dao.AgrPayConfigMapper;
import com.tydic.dyc.agr.repository.dao.AgrRelHisMapper;
import com.tydic.dyc.agr.repository.dao.AgrRelMapper;
import com.tydic.dyc.agr.repository.po.AgrAccessoryPO;
import com.tydic.dyc.agr.repository.po.AgrAdjustCfgHisPO;
import com.tydic.dyc.agr.repository.po.AgrAdjustCfgPO;
import com.tydic.dyc.agr.repository.po.AgrAgrVersionPO;
import com.tydic.dyc.agr.repository.po.AgrAllocateRecordPO;
import com.tydic.dyc.agr.repository.po.AgrAppScopeHisPO;
import com.tydic.dyc.agr.repository.po.AgrAppScopePO;
import com.tydic.dyc.agr.repository.po.AgrCataScopeHisPO;
import com.tydic.dyc.agr.repository.po.AgrCataScopePO;
import com.tydic.dyc.agr.repository.po.AgrItemExtHisPO;
import com.tydic.dyc.agr.repository.po.AgrItemExtPO;
import com.tydic.dyc.agr.repository.po.AgrItemHisPO;
import com.tydic.dyc.agr.repository.po.AgrItemLadderPriceHisPO;
import com.tydic.dyc.agr.repository.po.AgrItemLadderPricePO;
import com.tydic.dyc.agr.repository.po.AgrItemPO;
import com.tydic.dyc.agr.repository.po.AgrMainExtHisPO;
import com.tydic.dyc.agr.repository.po.AgrMainExtPO;
import com.tydic.dyc.agr.repository.po.AgrMainHisPO;
import com.tydic.dyc.agr.repository.po.AgrMainPO;
import com.tydic.dyc.agr.repository.po.AgrPayConfigHisPO;
import com.tydic.dyc.agr.repository.po.AgrPayConfigPO;
import com.tydic.dyc.agr.repository.po.AgrRelHisPO;
import com.tydic.dyc.agr.repository.po.AgrRelPO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrAgrRepositoryImpl
implements AgrAgrRepository {
    private static final Logger log = LoggerFactory.getLogger(AgrAgrRepositoryImpl.class);
    @Autowired
    private AgrMainMapper agrMainMapper;
    @Autowired
    private AgrItemMapper agrItemMapper;
    @Autowired
    private AgrAppScopeMapper agrAppScopeMapper;
    @Autowired
    private AgrPayConfigMapper agrPayConfigMapper;
    @Autowired
    private AgrAdjustCfgMapper agrAdjustCfgMapper;
    @Autowired
    private AgrCataScopeMapper agrCataScopeMapper;
    @Autowired
    private AgrRelMapper agrRelMapper;
    @Autowired
    private AgrMainExtMapper agrMainExtMapper;
    @Autowired
    private AgrAccessoryMapper agrAccessoryMapper;
    @Autowired
    private AgrItemLadderPriceMapper agrItemLadderPriceMapper;
    @Autowired
    private AgrItemExtMapper agrItemExtMapper;
    @Autowired
    private AgrAllocateRecordMapper agrAllocateRecordMapper;
    @Autowired
    private AgrItemMapperUns agrItemMapperUns;
    @Autowired
    private AgrAgrVersionMapper agrAgrVersionMapper;
    @Autowired
    private AgrMainHisMapper agrMainHisMapper;
    @Autowired
    private AgrItemHisMapper agrItemHisMapper;
    @Autowired
    private AgrAppScopeHisMapper agrAppScopeHisMapper;
    @Autowired
    private AgrPayConfigHisMapper agrPayConfigHisMapper;
    @Autowired
    private AgrAdjustCfgHisMapper agrAdjustCfgHisMapper;
    @Autowired
    private AgrCataScopeHisMapper agrCataScopeHisMapper;
    @Autowired
    private AgrRelHisMapper agrRelHisMapper;
    @Autowired
    private AgrMainExtHisMapper agrMainExtHisMapper;
    @Autowired
    private AgrItemLadderPriceHisMapper agrItemLadderPriceHisMapper;
    @Autowired
    private AgrItemExtHisMapper agrItemExtHisMapper;

    public void saveAgrSub(AgrAgrDo agrAgrDo) {
        if (ObjectUtil.isNotEmpty((Object)agrAgrDo.getAgrAppScope())) {
            ArrayList<AgrAppScopePO> agrAppScopePOs = new ArrayList<AgrAppScopePO>();
            agrAgrDo.getAgrAppScope().forEach(agrAppScope -> {
                AgrAppScopePO po = (AgrAppScopePO)AgrRu.js((Object)agrAppScope, AgrAppScopePO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                po.setAppScopeId(IdUtil.nextId());
                po.setScopeType(agrAgrDo.getScopeType());
                agrAppScopePOs.add(po);
            });
            this.agrAppScopeMapper.insertBatch(agrAppScopePOs);
        }
        if (ObjectUtil.isNotEmpty((Object)agrAgrDo.getAgrPayConfig())) {
            ArrayList<AgrPayConfigPO> agrPayConfigPOs = new ArrayList<AgrPayConfigPO>();
            agrAgrDo.getAgrPayConfig().forEach(agrPayConfig -> {
                AgrPayConfigPO po = (AgrPayConfigPO)AgrRu.js((Object)agrPayConfig, AgrPayConfigPO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                po.setPayCfgId(IdUtil.nextId());
                agrPayConfigPOs.add(po);
            });
            this.agrPayConfigMapper.insertBatch(agrPayConfigPOs);
        }
        if (agrAgrDo.getAgrAdjustCfg() != null) {
            AgrAdjustCfgPO agrAdjustCfgPO = (AgrAdjustCfgPO)AgrRu.js((Object)agrAgrDo.getAgrAdjustCfg(), AgrAdjustCfgPO.class);
            agrAdjustCfgPO.setAgrId(agrAgrDo.getAgrId());
            agrAdjustCfgPO.setAdjustCfgId(IdUtil.nextId());
            this.agrAdjustCfgMapper.insert(agrAdjustCfgPO);
        }
        if (ObjectUtil.isNotEmpty((Object)agrAgrDo.getAgrCataScope())) {
            ArrayList<AgrCataScopePO> agrCataScopePOs = new ArrayList<AgrCataScopePO>();
            agrAgrDo.getAgrCataScope().forEach(agrCataScope -> {
                AgrCataScopePO po = (AgrCataScopePO)AgrRu.js((Object)agrCataScope, AgrCataScopePO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                po.setCataScopeId(IdUtil.nextId());
                agrCataScopePOs.add(po);
            });
            this.agrCataScopeMapper.insertBatch(agrCataScopePOs);
        }
        if (((AgrRel)agrAgrDo.getAgrRel().get(0)).getObjId() != null) {
            ArrayList<AgrRelPO> agrRelPOs = new ArrayList<AgrRelPO>();
            agrAgrDo.getAgrRel().forEach(agrRelPO -> {
                AgrRelPO po = (AgrRelPO)AgrRu.js((Object)agrRelPO, AgrRelPO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                po.setRelId(IdUtil.nextId());
                po.setObjNo(agrRelPO.getObjNo());
                po.setObjName(agrRelPO.getObjName());
                po.setObjId(agrRelPO.getObjId());
                po.setObjType(AgrCommConstant.RelObjType.CONTRACT);
                agrRelPOs.add(po);
            });
            this.agrRelMapper.insertBatch(agrRelPOs);
        }
        if (ObjectUtil.isNotEmpty((Object)agrAgrDo.getAgrMainExt())) {
            ArrayList<AgrMainExtPO> agrMainExtPOs = new ArrayList<AgrMainExtPO>();
            agrAgrDo.getAgrMainExt().forEach(agrMainExtPO -> {
                AgrMainExtPO po = (AgrMainExtPO)AgrRu.js((Object)agrMainExtPO, AgrMainExtPO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                po.setMainExtId(IdUtil.nextId());
                agrMainExtPOs.add(po);
            });
            this.agrMainExtMapper.insertBatch(agrMainExtPOs);
        }
        if (ObjectUtil.isNotEmpty((Object)agrAgrDo.getAgrAccessory())) {
            ArrayList<AgrAccessoryPO> agrAccessoryPOs = new ArrayList<AgrAccessoryPO>();
            agrAgrDo.getAgrAccessory().forEach(agrAccessoryPO -> {
                AgrAccessoryPO po = (AgrAccessoryPO)AgrRu.js((Object)agrAccessoryPO, AgrAccessoryPO.class);
                po.setOrderId(agrAgrDo.getAgrId());
                po.setObjId(agrAgrDo.getAgrId());
                po.setId(IdUtil.nextId());
                po.setObjType(AgrCommConstant.FileObjType.AGR);
                agrAccessoryPOs.add(po);
            });
            this.agrAccessoryMapper.insertBatch(agrAccessoryPOs);
        }
    }

    public void updateAgrMain(AgrAgrDo agrAgrDo) {
        AgrMainPO agrMainPOSet = (AgrMainPO)AgrRu.js((Object)agrAgrDo, AgrMainPO.class);
        agrMainPOSet.setUpdateLoginId(agrAgrDo.getUserId());
        agrMainPOSet.setUpdateName(agrAgrDo.getName());
        agrMainPOSet.setUpdateUsername(agrAgrDo.getUsername());
        agrMainPOSet.setUpdateTime(agrAgrDo.getOperTime());
        AgrMainPO agrMainPOWhere = new AgrMainPO();
        agrMainPOWhere.setAgrId(agrAgrDo.getAgrId());
        agrMainPOSet.setCreateLoginId(agrMainPOSet.getAgrOperatorId());
        agrMainPOSet.setCreateUsername(agrMainPOSet.getAgrOperatorUsername());
        agrMainPOSet.setCreateName(agrMainPOSet.getAgrOperatorName());
        this.agrMainMapper.updateBy(agrMainPOSet, agrMainPOWhere);
    }

    public AgrAgrDo getAgrMain(AgrAgrQryBo agrAgrQryBo) {
        AgrMainPO agrMain = new AgrMainPO();
        agrMain.setAgrId(agrAgrQryBo.getAgrId());
        agrMain.setAgrCode(agrAgrQryBo.getAgrCode());
        AgrMainPO agrMainPO = this.agrMainMapper.getModelBy(agrMain);
        return (AgrAgrDo)AgrRu.js((Object)agrMainPO, AgrAgrDo.class);
    }

    public void deleteAgrSub(AgrAgrDo param0) {
        AgrAdjustCfgPO agrAdjustCfgPO = new AgrAdjustCfgPO();
        agrAdjustCfgPO.setAgrId(param0.getAgrId());
        this.agrAdjustCfgMapper.deleteBy(agrAdjustCfgPO);
        AgrPayConfigPO agrPayConfigPODel = new AgrPayConfigPO();
        agrPayConfigPODel.setAgrId(param0.getAgrId());
        this.agrPayConfigMapper.deleteBy(agrPayConfigPODel);
        AgrAppScopePO agrAppScopePODel = new AgrAppScopePO();
        agrAppScopePODel.setAgrId(param0.getAgrId());
        this.agrAppScopeMapper.deleteBy(agrAppScopePODel);
        AgrCataScopePO agrCataScopePODel = new AgrCataScopePO();
        agrCataScopePODel.setAgrId(param0.getAgrId());
        this.agrCataScopeMapper.deleteBy(agrCataScopePODel);
        AgrMainExtPO agrMainExtPODel = new AgrMainExtPO();
        agrMainExtPODel.setAgrId(param0.getAgrId());
        this.agrMainExtMapper.deleteBy(agrMainExtPODel);
        AgrAccessoryPO agrAccessoryPODel = new AgrAccessoryPO();
        agrAccessoryPODel.setObjId(param0.getAgrId());
        this.agrAccessoryMapper.deleteBy(agrAccessoryPODel);
    }

    public AgrAgrDo getAgrDetail(AgrAgrQryBo agrAgrQryBo) {
        AgrMainPO agrMainPO = (AgrMainPO)AgrRu.js((Object)agrAgrQryBo, AgrMainPO.class);
        AgrMainPO modelBy = this.agrMainMapper.getModelBy(agrMainPO);
        if (modelBy == null) {
            AgrMainHisPO agrMainHisPO = (AgrMainHisPO)AgrRu.js((Object)agrAgrQryBo, AgrMainHisPO.class);
            AgrMainHisPO agrMainHisPO1 = this.agrMainHisMapper.getModelBy(agrMainHisPO);
            if (null != agrMainHisPO1) {
                AgrAgrDo agrAgrDo = (AgrAgrDo)AgrRu.js((Object)agrMainHisPO1, AgrAgrDo.class);
                AgrAppScopeHisPO agrappscopehispo = new AgrAppScopeHisPO();
                agrappscopehispo.setAgrId(agrAgrQryBo.getAgrId());
                agrappscopehispo.setAgrMainHisId(agrMainHisPO1.getAgrMainHisId());
                List<AgrAppScopeHisPO> agrAppScopeHisPOS = this.agrAppScopeHisMapper.getList(agrappscopehispo);
                agrAgrDo.setAgrAppScope(AgrRu.jsl(agrAppScopeHisPOS, AgrAppScope.class));
                AgrPayConfigHisPO agrPayConfigHisPO = new AgrPayConfigHisPO();
                agrPayConfigHisPO.setAgrId(agrAgrQryBo.getAgrId());
                agrPayConfigHisPO.setAgrMainHisId(agrMainHisPO1.getAgrMainHisId());
                List<AgrPayConfigHisPO> agrPayConfigHisPOS = this.agrPayConfigHisMapper.getList(agrPayConfigHisPO);
                agrAgrDo.setAgrPayConfig(AgrRu.jsl(agrPayConfigHisPOS, AgrPayConfig.class));
                AgrAdjustCfgHisPO adjustCfgHisPO = new AgrAdjustCfgHisPO();
                adjustCfgHisPO.setAgrId(agrAgrQryBo.getAgrId());
                adjustCfgHisPO.setAgrMainHisId(agrMainHisPO1.getAgrMainHisId());
                AgrAdjustCfgHisPO agrAdjustCfgHisPO = this.agrAdjustCfgHisMapper.getModelBy(adjustCfgHisPO);
                agrAgrDo.setAgrAdjustCfg((AgrAdjustCfg)AgrRu.js((Object)agrAdjustCfgHisPO, AgrAdjustCfg.class));
                AgrCataScopeHisPO agrCataScopeHisPO = new AgrCataScopeHisPO();
                agrCataScopeHisPO.setAgrId(agrAgrQryBo.getAgrId());
                agrCataScopeHisPO.setAgrMainHisId(agrMainHisPO1.getAgrMainHisId());
                List<AgrCataScopeHisPO> agrCataScopeHisPOS = this.agrCataScopeHisMapper.getList(agrCataScopeHisPO);
                agrAgrDo.setAgrCataScope(AgrRu.jsl(agrCataScopeHisPOS, AgrCataScope.class));
                AgrRelHisPO agrRelHisPO = new AgrRelHisPO();
                agrRelHisPO.setAgrId(agrAgrQryBo.getAgrId());
                agrRelHisPO.setAgrMainHisId(agrMainHisPO1.getAgrMainHisId());
                List<AgrRelHisPO> agrRelHisPOS = this.agrRelHisMapper.getList(agrRelHisPO);
                agrAgrDo.setAgrRel(AgrRu.jsl(agrRelHisPOS, AgrRel.class));
                AgrMainExtHisPO agrMainExtHisPO = new AgrMainExtHisPO();
                agrMainExtHisPO.setAgrId(agrAgrQryBo.getAgrId());
                agrMainExtHisPO.setAgrMainHisId(agrMainHisPO1.getAgrMainHisId());
                List<AgrMainExtHisPO> agrMainExtHisPOS = this.agrMainExtHisMapper.getList(agrMainExtHisPO);
                agrAgrDo.setAgrMainExt(AgrRu.jsl(agrMainExtHisPOS, AgrMainExt.class));
                return agrAgrDo;
            }
            return null;
        }
        AgrAgrDo agrAgrDo = (AgrAgrDo)AgrRu.js((Object)modelBy, AgrAgrDo.class);
        AgrAppScopePO agrAppScopePO = new AgrAppScopePO();
        agrAppScopePO.setAgrId(agrAgrQryBo.getAgrId());
        List<AgrAppScopePO> agrAppScopePOS = this.agrAppScopeMapper.getList(agrAppScopePO);
        agrAgrDo.setAgrAppScope(AgrRu.jsl(agrAppScopePOS, AgrAppScope.class));
        AgrPayConfigPO agrPayConfigPO = new AgrPayConfigPO();
        agrPayConfigPO.setAgrId(agrAgrQryBo.getAgrId());
        List<AgrPayConfigPO> agrPayConfigPOS = this.agrPayConfigMapper.getList(agrPayConfigPO);
        agrAgrDo.setAgrPayConfig(AgrRu.jsl(agrPayConfigPOS, AgrPayConfig.class));
        AgrAdjustCfgPO adjustCfgPO = new AgrAdjustCfgPO();
        adjustCfgPO.setAgrId(agrAgrQryBo.getAgrId());
        AgrAdjustCfgPO agrAdjustCfgPO = this.agrAdjustCfgMapper.getModelBy(adjustCfgPO);
        agrAgrDo.setAgrAdjustCfg((AgrAdjustCfg)AgrRu.js((Object)agrAdjustCfgPO, AgrAdjustCfg.class));
        AgrCataScopePO agrCataScopePO = new AgrCataScopePO();
        agrCataScopePO.setAgrId(agrAgrQryBo.getAgrId());
        List<AgrCataScopePO> agrCataScopePOS = this.agrCataScopeMapper.getList(agrCataScopePO);
        agrAgrDo.setAgrCataScope(AgrRu.jsl(agrCataScopePOS, AgrCataScope.class));
        AgrRelPO agrRelPO = new AgrRelPO();
        agrRelPO.setAgrId(agrAgrQryBo.getAgrId());
        List<AgrRelPO> agrRelPOS = this.agrRelMapper.getList(agrRelPO);
        agrAgrDo.setAgrRel(AgrRu.jsl(agrRelPOS, AgrRel.class));
        AgrMainExtPO agrMainExtPO = new AgrMainExtPO();
        agrMainExtPO.setAgrId(agrAgrQryBo.getAgrId());
        List<AgrMainExtPO> agrMainExtPOS = this.agrMainExtMapper.getList(agrMainExtPO);
        agrAgrDo.setAgrMainExt(AgrRu.jsl(agrMainExtPOS, AgrMainExt.class));
        AgrAccessoryPO agrAccessoryPO = new AgrAccessoryPO();
        agrAccessoryPO.setObjId(agrAgrQryBo.getAgrId());
        agrAccessoryPO.setOrderId(agrAgrQryBo.getAgrId());
        agrAccessoryPO.setObjType(AgrCommConstant.AccessoryObjType.AGR_MAIN);
        List<AgrAccessoryPO> agrAccessoryPOS = this.agrAccessoryMapper.getList(agrAccessoryPO);
        agrAgrDo.setAgrAccessory(AgrRu.jsl(agrAccessoryPOS, AgrAccessory.class));
        return agrAgrDo;
    }

    public void saveAgrItem(AgrAgrDo agrAgrDo) {
        if (ObjectUtil.isNotEmpty((Object)agrAgrDo.getAgrItem())) {
            ArrayList<AgrItemPO> agrItemPOs = new ArrayList<AgrItemPO>();
            ArrayList<AgrItemLadderPricePO> agrItemLadderPricePOS = new ArrayList<AgrItemLadderPricePO>();
            ArrayList<AgrItemExtPO> agrItemExtPOS = new ArrayList<AgrItemExtPO>();
            agrAgrDo.getAgrItem().stream().forEach(agrItem -> {
                AgrItemPO agrItemPO = (AgrItemPO)JSON.parseObject((String)JSON.toJSONString((Object)agrItem), AgrItemPO.class);
                agrItemPO.setAgrId(agrAgrDo.getAgrId());
                agrItemPO.setUniqueKey(agrItem.getCommodityTypeId() + "_" + agrItem.getMaterialCode());
                if (agrItemPO.getAgrItemId() == null) {
                    agrItemPO.setAgrItemId(IdUtil.nextId());
                }
                if (agrItemPO.getAgrSkuStatus() == null) {
                    agrItemPO.setAgrSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
                }
                agrItemPOs.add(agrItemPO);
                if (!CollectionUtils.isEmpty((Collection)agrItem.getAgrItemLadderPrice())) {
                    agrItem.getAgrItemLadderPrice().forEach(agrItemLadderPrice -> {
                        AgrItemLadderPricePO agrItemLadderPricePO = (AgrItemLadderPricePO)JSON.parseObject((String)JSON.toJSONString((Object)agrItemLadderPrice), AgrItemLadderPricePO.class);
                        agrItemLadderPricePO.setAgrId(agrAgrDo.getAgrId());
                        agrItemLadderPricePO.setAgrItemId(agrItemPO.getAgrItemId());
                        agrItemLadderPricePO.setItemLadderPriceId(IdUtil.nextId());
                        agrItemLadderPricePOS.add(agrItemLadderPricePO);
                    });
                }
                if (!CollectionUtils.isEmpty((Collection)agrItem.getAgrItemExt())) {
                    agrItem.getAgrItemExt().forEach(agrItemExt -> {
                        AgrItemExtPO agrItemExtPO = (AgrItemExtPO)JSON.parseObject((String)JSON.toJSONString((Object)agrItemExt), AgrItemExtPO.class);
                        agrItemExtPO.setAgrId(agrAgrDo.getAgrId());
                        agrItemExtPO.setAgrItemId(agrItemPO.getAgrItemId());
                        agrItemExtPO.setItemExtId(IdUtil.nextId());
                        agrItemExtPOS.add(agrItemExtPO);
                    });
                }
            });
            this.agrItemMapper.insertBatch(agrItemPOs);
            if (!CollectionUtils.isEmpty(agrItemLadderPricePOS)) {
                this.agrItemLadderPriceMapper.insertBatch(agrItemLadderPricePOS);
            }
            if (!CollectionUtils.isEmpty(agrItemExtPOS)) {
                this.agrItemExtMapper.insertBatch(agrItemExtPOS);
            }
        }
    }

    public void deleteAgrItemByBatch(AgrAgrDo agrAgrDo) {
        AgrItemPO agrItemPODel = new AgrItemPO();
        agrItemPODel.setAgrId(agrAgrDo.getAgrId());
        if (!CollectionUtils.isEmpty((Collection)agrAgrDo.getAgrItem())) {
            agrItemPODel.setAgrItemIds(((AgrItem)agrAgrDo.getAgrItem().get(0)).getAgrItemIds());
            agrItemPODel.setAgrItemId(((AgrItem)agrAgrDo.getAgrItem().get(0)).getAgrItemId());
        }
        this.agrItemMapper.deleteBy(agrItemPODel);
        AgrItemExtPO agrItemExtPODel = new AgrItemExtPO();
        agrItemExtPODel.setAgrId(agrAgrDo.getAgrId());
        if (!CollectionUtils.isEmpty((Collection)agrAgrDo.getAgrItem())) {
            agrItemExtPODel.setAgrItemIds(((AgrItem)agrAgrDo.getAgrItem().get(0)).getAgrItemIds());
            agrItemExtPODel.setAgrItemId(((AgrItem)agrAgrDo.getAgrItem().get(0)).getAgrItemId());
        }
        this.agrItemExtMapper.deleteBy(agrItemExtPODel);
        AgrItemLadderPricePO agrItemLadderPricePODel = new AgrItemLadderPricePO();
        agrItemLadderPricePODel.setAgrId(agrAgrDo.getAgrId());
        if (!CollectionUtils.isEmpty((Collection)agrAgrDo.getAgrItem())) {
            agrItemLadderPricePODel.setAgrItemIds(((AgrItem)agrAgrDo.getAgrItem().get(0)).getAgrItemIds());
            agrItemLadderPricePODel.setAgrItemId(((AgrItem)agrAgrDo.getAgrItem().get(0)).getAgrItemId());
        }
        this.agrItemLadderPriceMapper.deleteBy(agrItemLadderPricePODel);
    }

    public void updateAgrItemByBatch(AgrAgrDo agrAgrDo) {
        if (!CollectionUtils.isEmpty((Collection)agrAgrDo.getAgrItem())) {
            for (AgrItem agrItem : agrAgrDo.getAgrItem()) {
                AgrItemPO agrItemPOWhere = new AgrItemPO();
                agrItemPOWhere.setAgrItemIds(agrItem.getAgrItemIds());
                agrItemPOWhere.setAgrItemId(agrItem.getAgrItemId());
                agrItemPOWhere.setAgrId(agrAgrDo.getAgrId());
                AgrItemPO agrItemPOSet = (AgrItemPO)AgrRu.js((Object)agrItem, AgrItemPO.class);
                agrItemPOSet.setAgrId(null);
                agrItemPOSet.setAgrItemId(null);
                this.agrItemMapper.updateBy(agrItemPOSet, agrItemPOWhere);
            }
        }
    }

    public AgrItemListQryRspPageBo getAgrItemtList(AgrItemListQryReqPageBo reqPageBo) {
        AgrMainPO agrMainPO = new AgrMainPO();
        agrMainPO.setAgrId(reqPageBo.getAgrId());
        agrMainPO.setAgrVersion(reqPageBo.getAgrVersion());
        AgrMainPO modelBy = this.agrMainMapper.getModelBy(agrMainPO);
        if (modelBy == null) {
            AgrMainHisPO agrMainHisPO = new AgrMainHisPO();
            agrMainHisPO.setAgrId(reqPageBo.getAgrId());
            agrMainHisPO.setAgrVersion(reqPageBo.getAgrVersion());
            AgrMainHisPO agrMainHisPO1 = this.agrMainHisMapper.getModelBy(agrMainHisPO);
            if (null == agrMainHisPO1) {
                throw new BaseBusinessException("", "\u534f\u8bae\u6570\u636e\u4e0d\u5b58\u5728");
            }
            Page pg = new Page(reqPageBo.getPageNo().intValue(), reqPageBo.getPageSize().intValue());
            AgrItemListQryRspPageBo agrItemListQryRspPageBo = new AgrItemListQryRspPageBo();
            List<AgrItemPO> listPage = this.agrItemMapperUns.getListHisPage((AgrItemPO)AgrRu.js((Object)reqPageBo, AgrItemPO.class), (Page<AgrItemPO>)pg);
            List agrItems = AgrRu.jsl(listPage, AgrItem.class);
            agrItemListQryRspPageBo.setPageNo(reqPageBo.getPageNo());
            agrItemListQryRspPageBo.setTotal(Integer.valueOf(pg.getTotalPages()));
            agrItemListQryRspPageBo.setRecordsTotal(Integer.valueOf(pg.getTotalCount()));
            agrItemListQryRspPageBo.setRows(agrItems);
            return agrItemListQryRspPageBo;
        }
        Page pg = new Page(reqPageBo.getPageNo().intValue(), reqPageBo.getPageSize().intValue());
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = new AgrItemListQryRspPageBo();
        List<AgrItemPO> listPage = this.agrItemMapperUns.getListPage((AgrItemPO)AgrRu.js((Object)reqPageBo, AgrItemPO.class), (Page<AgrItemPO>)pg);
        List agrItems = AgrRu.jsl(listPage, AgrItem.class);
        agrItemListQryRspPageBo.setPageNo(reqPageBo.getPageNo());
        agrItemListQryRspPageBo.setTotal(Integer.valueOf(pg.getTotalPages()));
        agrItemListQryRspPageBo.setRecordsTotal(Integer.valueOf(pg.getTotalCount()));
        agrItemListQryRspPageBo.setRows(agrItems);
        return agrItemListQryRspPageBo;
    }

    public void saveAgrMain(AgrAgrDo agrAgrDo) {
        AgrMainPO agrMainPO = (AgrMainPO)AgrRu.js((Object)agrAgrDo, AgrMainPO.class);
        agrMainPO.setCreateLoginId(agrAgrDo.getUserId());
        agrMainPO.setCreateName(agrAgrDo.getName());
        agrMainPO.setCreateTime(agrAgrDo.getOperTime());
        agrMainPO.setCreateUsername(agrAgrDo.getUsername());
        agrMainPO.setCreateOrgId(ObjectUtil.isNotEmpty((Object)agrAgrDo.getOrgId()) ? agrAgrDo.getOrgId() : null);
        agrMainPO.setCreateOrgName(agrAgrDo.getOrgName());
        this.agrMainMapper.insert(agrMainPO);
    }

    public void deleteAgrMain(AgrAgrDo param0) {
        AgrMainPO agrMainPO = new AgrMainPO();
        agrMainPO.setAgrId(param0.getAgrId());
        this.agrMainMapper.deleteBy(agrMainPO);
    }

    public AgrGetAllAgrListRspBO getAllAgrList() {
        List<AgrMainPO> list = this.agrMainMapper.getList(new AgrMainPO());
        AgrGetAllAgrListRspBO retBo = new AgrGetAllAgrListRspBO();
        if (ObjectUtil.isNotEmpty(list)) {
            retBo.setRows(AgrRu.jsl(list, AgrAgrDo.class));
        } else {
            retBo.setRows(new ArrayList());
        }
        return retBo;
    }

    public void saveAgrAllocateRecord(AgrAgrDo agrAgrDo) {
        if (ObjectUtil.isNotEmpty((Object)agrAgrDo.getAgrAllocateRecord())) {
            ArrayList<AgrAllocateRecordPO> agrAllocateRecordPOS = new ArrayList<AgrAllocateRecordPO>();
            agrAgrDo.getAgrAllocateRecord().forEach(agrAllocateRecord -> {
                AgrAllocateRecordPO po = (AgrAllocateRecordPO)AgrRu.js((Object)agrAllocateRecord, AgrAllocateRecordPO.class);
                po.setAllocateLogId(IdUtil.nextId());
                po.setAgrId(agrAgrDo.getAgrId());
                po.setOperTime(new Date());
                po.setOperId(agrAgrDo.getUserId());
                po.setOperName(agrAgrDo.getName());
                agrAllocateRecordPOS.add(po);
            });
            this.agrAllocateRecordMapper.insertBatch(agrAllocateRecordPOS);
        }
    }

    public AgrAgrAllocateRecordListRspBO getAgrAllocateRecordList(AgrAgrQryBo agrAgrQryBo) {
        AgrAgrAllocateRecordListRspBO bo = new AgrAgrAllocateRecordListRspBO();
        AgrAllocateRecordPO agrAllocateRecordPO = new AgrAllocateRecordPO();
        agrAllocateRecordPO.setAgrId(agrAgrQryBo.getAgrId());
        List<AgrAllocateRecordPO> list = this.agrAllocateRecordMapper.getList(agrAllocateRecordPO);
        if (!ObjectUtil.isEmpty(list)) {
            bo.setRows(AgrRu.jsl(list, AgrAllocateRecord.class));
        } else {
            bo.setRows(new ArrayList());
        }
        return bo;
    }

    public AgrGetAgrMainListRspQryBo getAgrMainList(AgrAgrQryBo agrAgrQryBo) {
        AgrGetAgrMainListRspQryBo agrGetAgrMainListRspQryBo = new AgrGetAgrMainListRspQryBo();
        List agrIds = agrAgrQryBo.getAgrIds();
        if (ObjectUtil.isNotEmpty((Object)agrIds) && agrIds.size() > 0) {
            AgrMainPO agrMainPO = new AgrMainPO();
            agrMainPO.setAgrIds(agrAgrQryBo.getAgrIds());
            List<AgrMainPO> agrMainPOS = this.agrMainMapper.getList(agrMainPO);
            List rows = AgrRu.jsl(agrMainPOS, AgrAgrDo.class);
            agrGetAgrMainListRspQryBo.setRows(rows);
        } else {
            AgrMainPO agrMainPO = new AgrMainPO();
            agrMainPO.setAgrId(agrAgrQryBo.getAgrId());
            List<AgrMainPO> agrMainPOS = this.agrMainMapper.getList(agrMainPO);
            List rows = AgrRu.jsl(agrMainPOS, AgrAgrDo.class);
            agrGetAgrMainListRspQryBo.setRows(rows);
        }
        return agrGetAgrMainListRspQryBo;
    }

    public AgrGetAgrItemCountByCommodityTypeRspPageBo getAgrItemCountByCommodityType(AgrGetAgrItemCountByCommodityTypeReqPageBo reqPageBo) {
        AgrGetAgrItemCountByCommodityTypeRspPageBo rspPageBo = new AgrGetAgrItemCountByCommodityTypeRspPageBo();
        Page pg = new Page(reqPageBo.getPageNo().intValue(), reqPageBo.getPageSize().intValue());
        List<AgrItemCountQryBo> listPage = this.agrItemMapperUns.getAgrItemCountByCommodityType((AgrItemPO)AgrRu.js((Object)reqPageBo, AgrItemPO.class), (Page<AgrItemCountQryBo>)pg);
        rspPageBo.setPageNo(reqPageBo.getPageNo());
        rspPageBo.setTotal(Integer.valueOf(pg.getTotalPages()));
        rspPageBo.setRecordsTotal(Integer.valueOf(pg.getTotalCount()));
        rspPageBo.setRows(listPage);
        return rspPageBo;
    }

    public void saveAgrVersion(AgrAgrDo agrAgrDo) {
        AgrAgrVersionPO agrAgrVersionPO1 = new AgrAgrVersionPO();
        agrAgrVersionPO1.setAgrId(agrAgrDo.getAgrId());
        agrAgrVersionPO1.setVersionStatus(AgrCommConstant.AgrVersionStatus.TO_VALID);
        this.agrAgrVersionMapper.deleteBy(agrAgrVersionPO1);
        List agrAgrVersionPOS = AgrRu.jsl((List)agrAgrDo.getAgrAgrVersion(), AgrAgrVersionPO.class);
        agrAgrVersionPOS.forEach(agrAgrVersionPO -> agrAgrVersionPO.setAgrVersionId(IdUtil.nextId()));
        this.agrAgrVersionMapper.insertBatch(agrAgrVersionPOS);
    }

    public AgrGetAgrVersionListRspBo getAgrVersionList(AgrGetAgrVersionListReqBo agrGetAgrVersionListReqBo) {
        AgrAgrVersionPO agrAgrVersionPO = (AgrAgrVersionPO)AgrRu.js((Object)agrGetAgrVersionListReqBo, AgrAgrVersionPO.class);
        List<AgrAgrVersionPO> pos = this.agrAgrVersionMapper.getList(agrAgrVersionPO);
        List rows = AgrRu.jsl(pos, AgrAgrVersion.class);
        AgrGetAgrVersionListRspBo rspBo = new AgrGetAgrVersionListRspBo();
        rspBo.setRows(rows);
        return rspBo;
    }

    public void saveAgrHis(AgrAgrDo agrAgrDo) {
        this.dealAgrVersion(agrAgrDo);
        Long mainHisId = this.copyAgrMain(agrAgrDo);
        this.copyAgrAppScope(agrAgrDo, mainHisId);
        this.copyAgrPayConfig(agrAgrDo, mainHisId);
        this.copyAgrAdjustCfg(agrAgrDo, mainHisId);
        this.copyAgrCataScope(agrAgrDo, mainHisId);
        this.copyAgrRel(agrAgrDo, mainHisId);
        this.copyAgrMainExt(agrAgrDo, mainHisId);
        this.copyAgrItem(agrAgrDo, mainHisId);
    }

    private void copyAgrItem(AgrAgrDo agrAgrDo, Long mainHisId) {
        Page pg = new Page(1, 1000);
        AgrItemPO agrItemPO = new AgrItemPO();
        agrItemPO.setAgrId(agrAgrDo.getAgrId());
        List<AgrItemPO> agrItemPOs = this.agrItemMapperUns.getListPage(agrItemPO, (Page<AgrItemPO>)pg);
        if (!CollectionUtils.isEmpty(agrItemPOs)) {
            this.copyAgrItemInfo(agrItemPOs, mainHisId, agrAgrDo.getAgrId());
            if (pg.getTotalPages() > 1) {
                int total = pg.getTotalPages();
                for (int i = 2; i <= total; ++i) {
                    Page pg1 = new Page(i, 1000);
                    List<AgrItemPO> agrItemPOs1 = this.agrItemMapperUns.getListPage(agrItemPO, (Page<AgrItemPO>)pg1);
                    this.copyAgrItemInfo(agrItemPOs1, mainHisId, agrAgrDo.getAgrId());
                }
            }
        }
    }

    private void copyAgrItemInfo(List<AgrItemPO> agrItemPOs, Long mainHisId, Long agrId) {
        if (!CollectionUtils.isEmpty(agrItemPOs)) {
            List agrItemHisPOS = AgrRu.jsl(agrItemPOs, AgrItemHisPO.class);
            HashMap agrItemIdHisIdMap = new HashMap();
            ArrayList<Long> agrItemIds = new ArrayList<Long>();
            agrItemHisPOS.forEach(agrItemHisPO -> {
                agrItemHisPO.setAgrMainHisId(mainHisId);
                agrItemHisPO.setAgrItemHisId(IdUtil.nextId());
                agrItemIdHisIdMap.put(agrItemHisPO.getAgrItemId(), agrItemHisPO.getAgrItemHisId());
                agrItemIds.add(agrItemHisPO.getAgrItemId());
            });
            this.agrItemHisMapper.insertBatch(agrItemHisPOS);
            AgrItemExtPO agrItemExtPO = new AgrItemExtPO();
            agrItemExtPO.setAgrId(agrId);
            agrItemExtPO.setAgrItemIds(agrItemIds);
            List<AgrItemExtPO> agrItemExtPOS = this.agrItemExtMapper.getList(agrItemExtPO);
            List agrItemExtHisPOS = AgrRu.jsl(agrItemExtPOS, AgrItemExtHisPO.class);
            if (!CollectionUtils.isEmpty((Collection)agrItemExtHisPOS)) {
                agrItemExtHisPOS.forEach(agrItemExtHisPO -> {
                    agrItemExtHisPO.setAgrItemHisId((Long)agrItemIdHisIdMap.get(agrItemExtHisPO.getAgrItemId()));
                    agrItemExtHisPO.setItemExtHisId(IdUtil.nextId());
                });
                this.agrItemExtHisMapper.insertBatch(agrItemExtHisPOS);
            }
            AgrItemLadderPricePO agrItemLadderPricePO = new AgrItemLadderPricePO();
            agrItemLadderPricePO.setAgrId(agrId);
            agrItemLadderPricePO.setAgrItemIds(agrItemIds);
            List<AgrItemLadderPricePO> agrItemLadderPricePOS = this.agrItemLadderPriceMapper.getList(agrItemLadderPricePO);
            List agrItemLadderPriceHisPOS = AgrRu.jsl(agrItemLadderPricePOS, AgrItemLadderPriceHisPO.class);
            if (!CollectionUtils.isEmpty((Collection)agrItemLadderPriceHisPOS)) {
                agrItemLadderPriceHisPOS.forEach(agrItemLadderPriceHisPO -> {
                    agrItemLadderPriceHisPO.setAgrItemHisId((Long)agrItemIdHisIdMap.get(agrItemLadderPriceHisPO.getAgrItemId()));
                    agrItemLadderPriceHisPO.setItemLadderPriceHisId(IdUtil.nextId());
                });
                this.agrItemLadderPriceHisMapper.insertBatch(agrItemLadderPriceHisPOS);
            }
        }
    }

    private void copyAgrMainExt(AgrAgrDo agrAgrDo, Long mainHisId) {
        AgrMainExtPO agrMainExtPO = new AgrMainExtPO();
        agrMainExtPO.setAgrId(agrAgrDo.getAgrId());
        List<AgrMainExtPO> agrMainExtPOS = this.agrMainExtMapper.getList(agrMainExtPO);
        List agrMainExtHisPOS = AgrRu.jsl(agrMainExtPOS, AgrMainExtHisPO.class);
        if (!CollectionUtils.isEmpty((Collection)agrMainExtHisPOS)) {
            agrMainExtHisPOS.forEach(agrMainExtHisPO -> {
                agrMainExtHisPO.setAgrMainHisId(mainHisId);
                agrMainExtHisPO.setMainExtHisId(IdUtil.nextId());
            });
            this.agrMainExtHisMapper.insertBatch(agrMainExtHisPOS);
        }
    }

    private void copyAgrRel(AgrAgrDo agrAgrDo, Long mainHisId) {
        AgrRelPO agrRelPO = new AgrRelPO();
        agrRelPO.setAgrId(agrAgrDo.getAgrId());
        List<AgrRelPO> agrRelPOS = this.agrRelMapper.getList(agrRelPO);
        List agrRelHisPOS = AgrRu.jsl(agrRelPOS, AgrRelHisPO.class);
        if (!CollectionUtils.isEmpty((Collection)agrRelHisPOS)) {
            agrRelHisPOS.forEach(agrRelHisPO -> {
                agrRelHisPO.setAgrMainHisId(mainHisId);
                agrRelHisPO.setRelHisId(IdUtil.nextId());
            });
            this.agrRelHisMapper.insertBatch(agrRelHisPOS);
        }
    }

    private void copyAgrCataScope(AgrAgrDo agrAgrDo, Long mainHisId) {
        AgrCataScopePO agrCataScopePO = new AgrCataScopePO();
        agrCataScopePO.setAgrId(agrAgrDo.getAgrId());
        List<AgrCataScopePO> agrCataScopePOS = this.agrCataScopeMapper.getList(agrCataScopePO);
        List agrCataScopeHisPOS = AgrRu.jsl(agrCataScopePOS, AgrCataScopeHisPO.class);
        if (!CollectionUtils.isEmpty((Collection)agrCataScopeHisPOS)) {
            agrCataScopeHisPOS.forEach(agrCataScopeHisPO -> {
                agrCataScopeHisPO.setAgrMainHisId(mainHisId);
                agrCataScopeHisPO.setCataScopeHisId(IdUtil.nextId());
            });
            this.agrCataScopeHisMapper.insertBatch(agrCataScopeHisPOS);
        }
    }

    private void copyAgrAdjustCfg(AgrAgrDo agrAgrDo, Long mainHisId) {
        AgrAdjustCfgPO adjustCfgPO = new AgrAdjustCfgPO();
        adjustCfgPO.setAgrId(agrAgrDo.getAgrId());
        AgrAdjustCfgPO agrAdjustCfgPO = this.agrAdjustCfgMapper.getModelBy(adjustCfgPO);
        AgrAdjustCfgHisPO agrAdjustCfgHisPO = (AgrAdjustCfgHisPO)AgrRu.js((Object)agrAdjustCfgPO, AgrAdjustCfgHisPO.class);
        if (agrAdjustCfgHisPO != null) {
            agrAdjustCfgHisPO.setAgrMainHisId(mainHisId);
            agrAdjustCfgHisPO.setAdjustCfgHisId(IdUtil.nextId());
            this.agrAdjustCfgHisMapper.insert(agrAdjustCfgHisPO);
        }
    }

    private void copyAgrPayConfig(AgrAgrDo agrAgrDo, Long mainHisId) {
        AgrPayConfigPO agrPayConfigPO = new AgrPayConfigPO();
        agrPayConfigPO.setAgrId(agrAgrDo.getAgrId());
        List<AgrPayConfigPO> agrPayConfigPOS = this.agrPayConfigMapper.getList(agrPayConfigPO);
        List agrPayConfigHisPOS = AgrRu.jsl(agrPayConfigPOS, AgrPayConfigHisPO.class);
        if (!CollectionUtils.isEmpty((Collection)agrPayConfigHisPOS)) {
            agrPayConfigHisPOS.forEach(agrPayConfigHisPO -> {
                agrPayConfigHisPO.setAgrMainHisId(mainHisId);
                agrPayConfigHisPO.setPayCfgHisId(IdUtil.nextId());
            });
            this.agrPayConfigHisMapper.insertBatch(agrPayConfigHisPOS);
        }
    }

    private void copyAgrAppScope(AgrAgrDo agrAgrDo, Long mainHisId) {
        AgrAppScopePO agrAppScopePO = new AgrAppScopePO();
        agrAppScopePO.setAgrId(agrAgrDo.getAgrId());
        List<AgrAppScopePO> agrAppScopePOS = this.agrAppScopeMapper.getList(agrAppScopePO);
        List agrAppScopeHisPOS = AgrRu.jsl(agrAppScopePOS, AgrAppScopeHisPO.class);
        if (!CollectionUtils.isEmpty((Collection)agrAppScopeHisPOS)) {
            agrAppScopeHisPOS.forEach(agrAppScopeHisPO -> {
                agrAppScopeHisPO.setAgrMainHisId(mainHisId);
                agrAppScopeHisPO.setAppScopeHisId(IdUtil.nextId());
            });
            this.agrAppScopeHisMapper.insertBatch(agrAppScopeHisPOS);
        }
    }

    private Long copyAgrMain(AgrAgrDo agrAgrDo) {
        AgrMainPO reqPo = new AgrMainPO();
        reqPo.setAgrId(agrAgrDo.getAgrId());
        AgrMainPO modelBy = this.agrMainMapper.getModelBy(reqPo);
        AgrMainHisPO agrMainHisPO = (AgrMainHisPO)AgrRu.js((Object)modelBy, AgrMainHisPO.class);
        agrMainHisPO.setAgrMainHisId(IdUtil.nextId());
        this.agrMainHisMapper.insert(agrMainHisPO);
        return agrMainHisPO.getAgrMainHisId();
    }

    private void dealAgrVersion(AgrAgrDo agrAgrDo) {
        AgrAgrVersionPO agrAgrVersionPO = new AgrAgrVersionPO();
        agrAgrVersionPO.setAgrId(agrAgrDo.getAgrId());
        agrAgrVersionPO.setVersionStatus(AgrCommConstant.AgrVersionStatus.VALID);
        AgrAgrVersionPO pos = this.agrAgrVersionMapper.getModelBy(agrAgrVersionPO);
        AgrAgrVersionPO set = new AgrAgrVersionPO();
        set.setVersionStatus(AgrCommConstant.AgrVersionStatus.INVALID);
        AgrAgrVersionPO where = new AgrAgrVersionPO();
        where.setAgrId(agrAgrDo.getAgrId());
        where.setAgrVersionId(pos.getAgrVersionId());
        this.agrAgrVersionMapper.updateBy(set, where);
        AgrAgrVersionPO set1 = new AgrAgrVersionPO();
        String newVersion = pos.getAgrVersion().substring(0, 1) + (Integer.parseInt(pos.getAgrVersion().substring(1)) + 1);
        set1.setAgrVersion(newVersion);
        set1.setVersionStatus(AgrCommConstant.AgrVersionStatus.VALID);
        AgrAgrVersionPO where1 = new AgrAgrVersionPO();
        where1.setAgrId(agrAgrDo.getAgrId());
        where1.setVersionStatus(AgrCommConstant.AgrVersionStatus.TO_VALID);
        this.agrAgrVersionMapper.updateBy(set1, where1);
        AgrMainPO set2 = new AgrMainPO();
        set2.setAgrVersion(newVersion);
        AgrMainPO where2 = new AgrMainPO();
        where2.setAgrId(agrAgrDo.getAgrId());
        this.agrMainMapper.updateBy(set2, where2);
    }
}

