package com.tydic.dyc.agr.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryReqPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.sub.*;
import com.tydic.dyc.agr.repository.AgrAgrChngRepository;
import com.tydic.dyc.agr.repository.dao.*;
import com.tydic.dyc.agr.repository.po.*;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题:AgrAgrChngRepositoryImpl
 * 说明:TODO
 * 时间:2022/9/7 15:42
 * 作者:代愿愿
 */
@Slf4j
@Service
public class AgrAgrChngRepositoryImpl implements AgrAgrChngRepository {

    @Autowired
    private AgrChngApplyMapper agrChngApplyMapper;
    @Autowired
    private AgrAccessoryMapper agrAccessoryMapper;
    @Autowired
    private AgrMainChngMapper agrMainChngMapper;
    @Autowired
    private AgrAppScopeChngMapper agrAppScopeChngMapper;
    @Autowired
    private AgrAdjustCfgChngMapper agrAdjustCfgChngMapper;
    @Autowired
    private AgrPayConfigChngMapper agrPayConfigChngMapper;
    @Autowired
    private AgrCataScopeChngMapper agrCataScopeChngMapper;
    @Autowired
    private AgrMainExtChngMapper agrMainExtChngMapper;
    @Autowired
    private AgrItemChngMapper agrItemChngMapper;
    @Autowired
    private AgrItemExtChngMapper agrItemExtChngMapper;
    @Autowired
    private AgrItemLadderPriceChngMapper agrItemLadderPriceChngMapper;

    @Override
    public void saveAgrChngApply(AgrChngApplyDo agrChngApplyDo) {
        //新增协议协议变更申请表
        AgrChngApplyPO applyPO = AgrRu.js(agrChngApplyDo, AgrChngApplyPO.class);
        //设置创建人信息(取登录用户信息)
        applyPO.setCreateLoginId(agrChngApplyDo.getUserId());
        applyPO.setChngApplyStatus(AgrCommConstant.ChngApplyStatus.APPLYING);
        applyPO.setCreateName(agrChngApplyDo.getName());
        applyPO.setCreateOrgName(agrChngApplyDo.getOrgName());
        applyPO.setCreateOrgId(agrChngApplyDo.getOrgId());
        applyPO.setCreateUsername(agrChngApplyDo.getUsername());
        applyPO.setCreateTime(new Date());
        applyPO.setUpdateTime(new Date());
        this.agrChngApplyMapper.insert(applyPO);

        //新增附件表
        List<AgrChngAccessory> accessories = agrChngApplyDo.getAgrChngAccessory();
        this.insertAgrChngApply(accessories, agrChngApplyDo);

    }

    @Override
    public void updateAgrChngApply(AgrChngApplyDo agrChngApplyDo) {
        //修改变更申请表
        //where条件
        AgrChngApplyPO where = new AgrChngApplyPO();
        //设置变更申请ID
        where.setChngApplyId(agrChngApplyDo.getChngApplyId());
        //设置协议ID
        where.setAgrId(agrChngApplyDo.getAgrId());
        //set的值
        AgrChngApplyPO set = AgrRu.js(agrChngApplyDo, AgrChngApplyPO.class);
        set.setAgrId(null);
        set.setChngApplyId(null);
        set.setUpdateTime(new Date());
        this.agrChngApplyMapper.updateBy(set, where);

        //删除变更申请ID对象的附件信息
        AgrAccessoryPO accessoryPO = new AgrAccessoryPO();
        //设置分库建ID(取协议ID)
        accessoryPO.setOrderId(agrChngApplyDo.getAgrId());
        //设置对象ID(取协议变更申请Id)
        accessoryPO.setObjId(agrChngApplyDo.getChngApplyId());
        this.agrAccessoryMapper.deleteBy(accessoryPO);

        //新增附件表
        List<AgrChngAccessory> accessories = agrChngApplyDo.getAgrChngAccessory();
        this.insertAgrChngApply(accessories, agrChngApplyDo);
    }


    /**
     * @param accessories    accessories
     * @param agrChngApplyDo agrChngApplyDo
     */
    private void insertAgrChngApply(List<AgrChngAccessory> accessories, AgrChngApplyDo agrChngApplyDo) {
        if (!ObjectUtil.isEmpty(accessories)) {
            //批量插入附件信息
            accessories.forEach(accessory -> {
                AgrAccessoryPO accessoryPO = AgrRu.js(accessory, AgrAccessoryPO.class);
                //设置ID
                accessoryPO.setId(IdUtil.nextId());
                //设置对象ID
                accessoryPO.setOrderId(agrChngApplyDo.getAgrId());
                //设置对象ID
                accessoryPO.setObjId(agrChngApplyDo.getChngApplyId());
                //协议附件类型
                accessoryPO.setObjType(AgrCommConstant.AccessoryObjType.AGR_CHNG_APPLY);
                //设置创建人信息(当前用户信息)
                accessoryPO.setCreateLoginId(agrChngApplyDo.getUserId());
                accessoryPO.setCreateName(agrChngApplyDo.getName());
                accessoryPO.setCreateUsername(agrChngApplyDo.getUsername());
                accessoryPO.setCreateTime(new Date());
                accessoryPO.setUpdateTime(new Date());
                this.agrAccessoryMapper.insert(accessoryPO);
            });
        }
    }


    /**
     * 协议主体变更新增
     *
     * @param agrChngApplyDo
     */
    @Override
    public void saveAgrMainChng(AgrChngApplyDo agrChngApplyDo) {
        //组装入参
        AgrMainChngPO agrMainChngPO = new AgrMainChngPO();
        AgrMainChng agrMainChng = agrChngApplyDo.getAgrMainChng();
        agrMainChngPO = JSON.parseObject(JSON.toJSONString(agrChngApplyDo), AgrMainChngPO.class);
        agrMainChngPO = JSON.parseObject(JSON.toJSONString(agrMainChng), AgrMainChngPO.class);
        //获取协议ID
        Long agrId = agrChngApplyDo.getAgrId();
        //获取变更申请ID
        Long chngApplyId = agrChngApplyDo.getChngApplyId();
        //获取协议变更ID
        Long agrChngId = IdUtil.nextId();
        agrMainChngPO.setAgrId(agrId);
        agrMainChngPO.setAgrChngId(agrChngId);
        agrMainChngPO.setChngApplyId(chngApplyId);
        log.debug("协议主题新增入参:[agrMainChngPO]:{}", agrMainChngPO);
        //新增协议主体
        this.agrMainChngMapper.insert(agrMainChngPO);

        //协议应用范围变更信息
        List<AgrAppScopeChng> agrAppScopeChng = agrChngApplyDo.getAgrAppScopeChng();
        List<AgrAppScopeChngPO> agrAppScopeChngPOS = AgrRu.jsl(agrAppScopeChng, AgrAppScopeChngPO.class);
        if (!CollectionUtils.isEmpty(agrAppScopeChngPOS)) {
            agrAppScopeChngPOS.stream().forEach(agrAppScopeChngPO -> {
                agrAppScopeChngPO.setAppScopeChngId(IdUtil.nextId());
                agrAppScopeChngPO.setAgrChngId(agrChngId);
                agrAppScopeChngPO.setAgrId(agrId);
                agrAppScopeChngPO.setChngApplyId(chngApplyId);
                agrAppScopeChngPO.setCreateTime(new Date());
                agrAppScopeChngPO.setCreateUsername(agrChngApplyDo.getUsername());
                agrAppScopeChngPO.setCreateName(agrChngApplyDo.getName());
                agrAppScopeChngPO.setCreateLoginId(agrChngApplyDo.getUserId());
            });
            //新增协议应用范围变更信息
            this.agrAppScopeChngMapper.insertBatch(agrAppScopeChngPOS);
        }


        //协议调价配置变更信息
        AgrAdjustCfgChng agrAdjustCfgChng = agrChngApplyDo.getAgrAdjustCfgChng();
        if (!ObjectUtil.isEmpty(agrAdjustCfgChng)) {
            AgrAdjustCfgChngPO agrAdjustCfgChngPO = JSON.parseObject(JSON.toJSONString(agrAdjustCfgChng), AgrAdjustCfgChngPO.class);
            agrAdjustCfgChngPO.setAdjustCfgChngId(IdUtil.nextId());
            agrAdjustCfgChngPO.setChngApplyId(chngApplyId);
            agrAdjustCfgChngPO.setAgrId(agrId);
            agrAdjustCfgChngPO.setAgrChngId(agrChngId);
            agrAdjustCfgChngPO.setCreateTime(new Date());
            agrAdjustCfgChngPO.setCreateUsername(agrChngApplyDo.getUsername());
            agrAdjustCfgChngPO.setCreateName(agrChngApplyDo.getName());
            agrAdjustCfgChngPO.setCreateLoginId(agrChngApplyDo.getUserId());
            //新增协议调价配置变更信息
            this.agrAdjustCfgChngMapper.insert(agrAdjustCfgChngPO);
        }

        //协议支付配置变更信息
        List<AgrPayConfigChng> agrPayConfigChng = agrChngApplyDo.getAgrPayConfigChng();
        List<AgrPayConfigChngPO> agrPayConfigChngPOS = AgrRu.jsl(agrPayConfigChng, AgrPayConfigChngPO.class);
        if (!CollectionUtils.isEmpty(agrPayConfigChngPOS)) {
            agrPayConfigChngPOS.stream().forEach(agrPayConfigChngPO -> {
                agrPayConfigChngPO.setPayCfgChngId(IdUtil.nextId());
                agrPayConfigChngPO.setAgrChngId(agrChngId);
                agrPayConfigChngPO.setAgrId(agrId);
                agrPayConfigChngPO.setChngApplyId(chngApplyId);
                agrPayConfigChngPO.setCreateTime(new Date());
                agrPayConfigChngPO.setCreateUsername(agrChngApplyDo.getUsername());
                agrPayConfigChngPO.setCreateName(agrChngApplyDo.getName());
                agrPayConfigChngPO.setCreateLoginId(agrChngApplyDo.getUserId());
            });
            //新增协议支付配置变更信息
            this.agrPayConfigChngMapper.insertBatch(agrPayConfigChngPOS);
        }

        //协议类目范围变更信息
        List<AgrCataScopeChng> agrCataScopeChng = agrChngApplyDo.getAgrCataScopeChng();
        List<AgrCataScopeChngPO> agrCataScopeChngPOS = AgrRu.jsl(agrCataScopeChng, AgrCataScopeChngPO.class);
        if (!CollectionUtils.isEmpty(agrCataScopeChngPOS)) {
            agrCataScopeChngPOS.stream().forEach(agrCataScopeChngPO -> {
                agrCataScopeChngPO.setCataScopeChngId(IdUtil.nextId());
                agrCataScopeChngPO.setAgrChngId(agrChngId);
                agrCataScopeChngPO.setAgrId(agrId);
                agrCataScopeChngPO.setChngApplyId(chngApplyId);
                agrCataScopeChngPO.setCreateTime(new Date());
                agrCataScopeChngPO.setCreateUsername(agrChngApplyDo.getUsername());
                agrCataScopeChngPO.setCreateName(agrChngApplyDo.getName());
                agrCataScopeChngPO.setCreateLoginId(agrChngApplyDo.getUserId());
            });
            //新增协议类目范围变更
            this.agrCataScopeChngMapper.insertBatch(agrCataScopeChngPOS);
        }

        //协议主体拓展变更信息
        List<AgrMainExtChng> agrMainExtChng = agrChngApplyDo.getAgrMainExtChng();
        List<AgrMainExtChngPO> agrMainExtChngPOS = AgrRu.jsl(agrMainExtChng, AgrMainExtChngPO.class);
        if (!CollectionUtils.isEmpty(agrMainExtChngPOS)) {
            agrMainExtChngPOS.stream().forEach(agrMainExtChngPO -> {
                agrMainExtChngPO.setMainExtChngId(IdUtil.nextId());
                agrMainExtChngPO.setAgrChngId(agrChngId);
                agrMainExtChngPO.setAgrId(agrId);
                agrMainExtChngPO.setChngApplyId(chngApplyId);
                agrMainExtChngPO.setCreateTime(new Date());
                agrMainExtChngPO.setCreateUsername(agrChngApplyDo.getUsername());
                agrMainExtChngPO.setCreateName(agrChngApplyDo.getName());
                agrMainExtChngPO.setCreateLoginId(agrChngApplyDo.getUserId());
            });
            //新增协议主体拓展变更信息
            this.agrMainExtChngMapper.insertBatch(agrMainExtChngPOS);
        }
    }

    @Override
    public void deleteAgrMainChng(AgrChngApplyDo agrChngApplyDo) {
        //入参校验
        validateDeleteAgrMainChng(agrChngApplyDo);

        //获取协议id
        Long agrId = agrChngApplyDo.getAgrId();
        //获取协议变更id
        Long chngApplyId = agrChngApplyDo.getChngApplyId();
        //删除协议主体变更
        AgrMainChngPO agrMainChngPO = new AgrMainChngPO();
        //设置变更申请id
        agrMainChngPO.setChngApplyId(chngApplyId);
        agrMainChngPO.setAgrId(agrId);
        agrMainChngMapper.deleteBy(agrMainChngPO);

        //删除协议调价配置变更
        AgrAdjustCfgChngPO agrAdjustCfgChngPO = new AgrAdjustCfgChngPO();
        //设置变更申请id
        agrAdjustCfgChngPO.setChngApplyId(chngApplyId);
        agrAdjustCfgChngPO.setAgrId(agrId);
        agrAdjustCfgChngMapper.deleteBy(agrAdjustCfgChngPO);

        //删除协议支付配置变更
        AgrPayConfigChngPO agrPayConfigChngPO = new AgrPayConfigChngPO();
        //设置变更申请id
        agrPayConfigChngPO.setChngApplyId(chngApplyId);
        agrPayConfigChngPO.setAgrId(agrId);
        agrPayConfigChngMapper.deleteBy(new AgrPayConfigChngPO());

        //删除协议应用范围变更
        AgrAppScopeChngPO agrAppScopeChngPO = new AgrAppScopeChngPO();
        //设置变更申请id
        agrAppScopeChngPO.setChngApplyId(chngApplyId);
        agrAppScopeChngPO.setAgrId(agrId);
        agrAppScopeChngMapper.deleteBy(agrAppScopeChngPO);

        //删除协议类目范围变更
        AgrCataScopeChngPO agrCataScopeChngPO = new AgrCataScopeChngPO();
        //设置变更申请id
        agrCataScopeChngPO.setChngApplyId(chngApplyId);
        agrCataScopeChngPO.setAgrId(agrId);
        agrCataScopeChngMapper.deleteBy(agrCataScopeChngPO);

        //删除协议主体拓展变更
        AgrMainExtChngPO agrMainExtChngPO = new AgrMainExtChngPO();
        //设置变更申请id
        agrMainExtChngPO.setChngApplyId(chngApplyId);
        agrMainExtChngPO.setAgrId(agrId);
        agrMainExtChngMapper.deleteBy(agrMainExtChngPO);

    }

    /**
     * 删除协议变更申请入参检验
     *
     * @param agrChngApplyDo 入参
     */
    private void validateDeleteAgrMainChng(AgrChngApplyDo agrChngApplyDo) {
        if (ObjectUtil.isEmpty(agrChngApplyDo.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        if (ObjectUtil.isEmpty(agrChngApplyDo.getChngApplyId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请ID]不能为空");
        }
    }

    @Override
    public void deleteAgrItemChng(AgrChngApplyDo agrChngApplyDo) {
        // 1 删除协议明细变更条件
        AgrItemChngPO agrItemChngPO = new AgrItemChngPO();
        agrItemChngPO.setAgrId(agrChngApplyDo.getAgrId());
        agrItemChngPO.setChngApplyId(agrChngApplyDo.getChngApplyId());
        // 2 删除明细变更扩展条件
        AgrItemExtChngPO agrItemExtChngPO = new AgrItemExtChngPO();
        agrItemExtChngPO.setAgrId(agrChngApplyDo.getAgrId());
        agrItemExtChngPO.setChngApplyId(agrChngApplyDo.getChngApplyId());
        // 3 删除明细变更阶梯价条件
        AgrItemLadderPriceChngPO agrItemLadderPriceChngPO = new AgrItemLadderPriceChngPO();
        agrItemLadderPriceChngPO.setAgrId(agrChngApplyDo.getAgrId());
        agrItemLadderPriceChngPO.setChngApplyId(agrChngApplyDo.getChngApplyId());
        if (ObjectUtil.isNotEmpty(agrChngApplyDo.getAgrItemChng())) {
            agrItemChngPO.setAgrItemChngIds(agrChngApplyDo.getAgrItemChng().get(0).getAgrItemChngIds());
            agrItemExtChngPO.setAgrItemChngIds(agrChngApplyDo.getAgrItemChng().get(0).getAgrItemChngIds());
            agrItemLadderPriceChngPO.setAgrItemChngIds(agrChngApplyDo.getAgrItemChng().get(0).getAgrItemChngIds());
        }
        // 删除协议明细变更
        this.agrItemChngMapper.deleteBy(agrItemChngPO);
        // 删除明细变更扩展
        this.agrItemExtChngMapper.deleteBy(agrItemExtChngPO);
        // 删除明细变更阶梯价
        this.agrItemLadderPriceChngMapper.deleteBy(agrItemLadderPriceChngPO);

    }

    @Override
    public AgrChngApplyDo getAgrChngApplyDetail(AgrAgrChngApplyQryBo agrAgrChngApplyQryBo) {
        //查询变更申请 设置入参
        AgrChngApplyPO agrChngApplyPO = AgrRu.js(agrAgrChngApplyQryBo, AgrChngApplyPO.class);
        AgrChngApplyPO result = this.agrChngApplyMapper.getModelBy(agrChngApplyPO);
        if(ObjectUtil.isEmpty(result)){
            return new AgrChngApplyDo();
        }
        AgrChngApplyDo agrChngApplyDo = AgrRu.js(result, AgrChngApplyDo.class);

        //查询变更申请附件
        AgrAccessoryPO accessoryPO = new AgrAccessoryPO();
        //分库建ID
        accessoryPO.setOrderId(agrAgrChngApplyQryBo.getAgrId());
        //对象ID
        accessoryPO.setObjId(agrAgrChngApplyQryBo.getChngApplyId());
        //对象类型
        accessoryPO.setObjType(AgrCommConstant.AccessoryObjType.AGR_CHNG_APPLY);
        List<AgrAccessoryPO> accessoryPOS = this.agrAccessoryMapper.getList(accessoryPO);
        List<AgrChngAccessory> accessories = AgrRu.jsl(accessoryPOS, AgrChngAccessory.class);
        agrChngApplyDo.setAgrChngAccessory(accessories);

        return agrChngApplyDo;
    }

    @Override
    public AgrChngApplyDo getAgrMainChngDetail(AgrAgrChngApplyQryBo agrAgrChngApplyQryBo) {
        //定义出参
        AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();

        //组装协议变更主体查询入参
        AgrMainChngPO agrMainChngPO = JSONObject.parseObject(JSONObject.toJSONString(agrAgrChngApplyQryBo), AgrMainChngPO.class);
        //查询协议主体变更信息
        AgrMainChngPO chngMapperModelBy = this.agrMainChngMapper.getModelBy(agrMainChngPO);
        AgrMainChng agrMainChng = JSONObject.parseObject(JSONObject.toJSONString(chngMapperModelBy), AgrMainChng.class);
        //赋值出参
        agrChngApplyDo.setAgrMainChng(agrMainChng);

        //组装协议调价配置查询入参
        AgrAdjustCfgChngPO agrAdjustCfgChngPO = JSONObject.parseObject(JSONObject.toJSONString(agrAgrChngApplyQryBo), AgrAdjustCfgChngPO.class);
        //查询协议调价配置
        AgrAdjustCfgChngPO agrAdjustCfgChngMapperModelBy = this.agrAdjustCfgChngMapper.getModelBy(agrAdjustCfgChngPO);
        AgrAdjustCfgChng agrAdjustCfgChng = JSONObject.parseObject(JSONObject.toJSONString(agrAdjustCfgChngMapperModelBy), AgrAdjustCfgChng.class);
        //赋值出参
        agrChngApplyDo.setAgrAdjustCfgChng(agrAdjustCfgChng);

        //组装协议支付配置查询入参
        AgrPayConfigChngPO agrPayConfigChngPO = JSONObject.parseObject(JSONObject.toJSONString(agrAgrChngApplyQryBo), AgrPayConfigChngPO.class);
        //查询协议支付配置
        List<AgrPayConfigChngPO> agrPayConfigChngPOS = this.agrPayConfigChngMapper.getList(agrPayConfigChngPO);
        List<AgrPayConfigChng> agrPayConfigChngs = AgrRu.jsl(agrPayConfigChngPOS, AgrPayConfigChng.class);
        //赋值出参
        agrChngApplyDo.setAgrPayConfigChng(agrPayConfigChngs);

        //组装协议类目范围变更查询入参
        AgrCataScopeChngPO agrCataScopeChngPO = JSONObject.parseObject(JSONObject.toJSONString(agrAgrChngApplyQryBo), AgrCataScopeChngPO.class);
        //查询协议类目范围变更
        List<AgrCataScopeChngPO> agrCataScopeChngPOS = this.agrCataScopeChngMapper.getList(agrCataScopeChngPO);
        List<AgrCataScopeChng> agrCataScopeChngs = AgrRu.jsl(agrCataScopeChngPOS, AgrCataScopeChng.class);
        //赋值出参
        agrChngApplyDo.setAgrCataScopeChng(agrCataScopeChngs);

        //组装协议主体拓展变更查询入参
        AgrMainExtChngPO agrMainExtChngPO = JSONObject.parseObject(JSONObject.toJSONString(agrAgrChngApplyQryBo), AgrMainExtChngPO.class);
        //查询协议主体拓展变更
        List<AgrMainExtChngPO> agrMainExtChngPOS = this.agrMainExtChngMapper.getList(agrMainExtChngPO);
        List<AgrMainExtChng> agrMainExtChngs = AgrRu.jsl(agrMainExtChngPOS, AgrMainExtChng.class);
        //赋值出参
        agrChngApplyDo.setAgrMainExtChng(agrMainExtChngs);

        //组装协议应用范围变更查询入参
        AgrAppScopeChngPO agrAppScopeChngPO = JSONObject.parseObject(JSONObject.toJSONString(agrAgrChngApplyQryBo), AgrAppScopeChngPO.class);
        //查询协议应用范围变更
        List<AgrAppScopeChngPO> agrAppScopeChngPOS = this.agrAppScopeChngMapper.getList(agrAppScopeChngPO);
        List<AgrAppScopeChng> agrAppScopeChngs = AgrRu.jsl(agrAppScopeChngPOS, AgrAppScopeChng.class);
        //赋值出参
        agrChngApplyDo.setAgrAppScopeChng(agrAppScopeChngs);

        return agrChngApplyDo;
    }

    @Override
    public void saveAgrItemChng(AgrChngApplyDo agrChngApplyDo) {
        //删除协议明细变更表
        AgrItemChngPO agrItemChngPO = new AgrItemChngPO();
        agrItemChngPO.setAgrId(agrChngApplyDo.getAgrId());
        agrItemChngPO.setChngApplyId(agrChngApplyDo.getChngApplyId());
        List<AgrItemChng> agrItemChngs = agrChngApplyDo.getAgrItemChng();
        //判断协议明细id是否存在
        List<Long> agrItemIds = new ArrayList<>();
        agrItemChngs.stream().map(AgrItemChng::getAgrItemId).forEach(agrItemId -> agrItemIds.add(agrItemId));
        //存在协议明细则删除
        if (agrItemIds.size() > 0){
            agrItemChngPO.setAgrItemIds(agrItemIds);
            this.agrItemChngMapper.deleteBy(agrItemChngPO);
        }
        //新增协议明细变更表
        List<AgrItemChngPO> agrItemChngPOs = new ArrayList<>();
        List<AgrItemLadderPriceChngPO> agrItemLadderPriceChngPOs = new ArrayList<>();
        List<AgrItemExtChngPO> agrItemExtChngPOs = new ArrayList<>();
        agrItemChngs.stream().forEach(agrItemChng -> {
            AgrItemChngPO agrItemChngPOAdd = JSONObject.parseObject(JSON.toJSONString(agrItemChng), AgrItemChngPO.class);
            agrItemChngPOAdd.setAgrId(agrChngApplyDo.getAgrId());
            agrItemChngPOAdd.setAgrItemChngId(IdUtil.nextId());
            agrItemChngPOAdd.setChngApplyId(agrChngApplyDo.getChngApplyId());
            //初始化草稿状态
            agrItemChngPOAdd.setAgrSkuStatus(AgrCommConstant.agrSkuStatus.DRAFTS);
            agrItemChngPOs.add(agrItemChngPOAdd);

            //判断协议明细阶梯价变更表信息是否存在
            List<AgrItemLadderPriceChng> agrItemLadderPriceChngs = agrItemChng.getAgrItemLadderPriceChng();
            if (!CollectionUtils.isEmpty(agrItemLadderPriceChngs)) {
                agrItemLadderPriceChngs.forEach(agrItemLadderPriceChng -> {
                    AgrItemLadderPriceChngPO agrItemLadderPriceChngPO = JSONObject.parseObject(JSONObject.toJSONString(agrItemLadderPriceChng), AgrItemLadderPriceChngPO.class);
                    agrItemLadderPriceChngPO.setAgrId(agrChngApplyDo.getAgrId());
                    agrItemLadderPriceChngPO.setAgrItemChngId(agrItemChngPOAdd.getAgrItemChngId());
                    agrItemLadderPriceChngPO.setChngApplyId(agrChngApplyDo.getChngApplyId());
                    agrItemLadderPriceChngPO.setItemLadderPriceChngId(IdUtil.nextId());
                    agrItemLadderPriceChngPOs.add(agrItemLadderPriceChngPO);
                });
            }

            //判断新增协议明细扩展变更表信息是否存在
            List<AgrItemExtChng> agrItemExtChngs = agrItemChng.getAgrItemExtChng();
            if (!CollectionUtils.isEmpty(agrItemExtChngs)) {
                agrItemExtChngs.forEach(agrItemExtChng -> {
                    AgrItemExtChngPO agrItemExtChngPO = JSONObject.parseObject(JSONObject.toJSONString(agrItemExtChng), AgrItemExtChngPO.class);
                    agrItemExtChngPO.setAgrId(agrChngApplyDo.getAgrId());
                    agrItemExtChngPO.setAgrItemChngId(agrItemChngPOAdd.getAgrItemChngId());
                    agrItemExtChngPO.setChngApplyId(agrChngApplyDo.getChngApplyId());
                    agrItemExtChngPO.setItemExtChngId(IdUtil.nextId());
                    agrItemExtChngPOs.add(agrItemExtChngPO);
                });
            }

        });
        //新增协议明细变更表
        if (agrItemChngPOs.size() > 0){
            this.agrItemChngMapper.insertBatch(agrItemChngPOs);
        }
        //新增协议明细阶梯价变更
        if (agrItemLadderPriceChngPOs.size() > 0) {
            this.agrItemLadderPriceChngMapper.insertBatch(agrItemLadderPriceChngPOs);
        }
        //新增协议明细扩展变更
        if (agrItemExtChngPOs.size() > 0){
            this.agrItemExtChngMapper.insertBatch(agrItemExtChngPOs);
        }

    }

    @Override
    public AgrItemChngListQryRspPageBo getAgrItemChngList(AgrItemChngListQryReqPageBo reqBo) {
        Page<AgrItemChngPO> page = new Page<>(reqBo.getPageNo(), reqBo.getPageSize());
        AgrItemChngListQryRspPageBo rspPageBo = new AgrItemChngListQryRspPageBo();
        List<AgrItemChng> rows = null;
        //查询协议明细变更表
        List<AgrItemChngPO> agrItemChngPOS = agrItemChngMapper.getListPage(AgrRu.js(reqBo, AgrItemChngPO.class), page);
        if (!ObjectUtil.isEmpty(agrItemChngPOS)) {
            rows = AgrRu.jsl(agrItemChngPOS, AgrItemChng.class);
            ArrayList<Long> agrItemChngIds = new ArrayList<>();
            for (AgrItemChngPO agrItemChngPO : agrItemChngPOS) {
                //获取明细变更id集合
                agrItemChngIds.add(agrItemChngPO.getAgrItemChngId());
            }
            //查询协议明细阶梯价表
            AgrItemLadderPriceChngPO agrItemLadderPriceChngPO = new AgrItemLadderPriceChngPO();
            agrItemLadderPriceChngPO.setAgrId(reqBo.getAgrId());
            agrItemLadderPriceChngPO.setChngApplyId(reqBo.getChngApplyId());
            agrItemLadderPriceChngPO.setAgrItemChngIds(agrItemChngIds);
            List<AgrItemLadderPriceChngPO> agrItemLadderPriceChngPOS = this.agrItemLadderPriceChngMapper.getList(agrItemLadderPriceChngPO);
            Map<Long, List<AgrItemLadderPriceChngPO>> agrItemLadderPriceChngPOMap =
                    agrItemLadderPriceChngPOS.stream().collect(Collectors.groupingBy(AgrItemLadderPriceChngPO::getAgrItemChngId));

            //查询协议明细扩展变更
            AgrItemExtChngPO agrItemExtChngPO = new AgrItemExtChngPO();
            agrItemExtChngPO.setAgrId(reqBo.getAgrId());
            agrItemExtChngPO.setChngApplyId(reqBo.getChngApplyId());
            agrItemExtChngPO.setAgrItemChngIds(agrItemChngIds);
            List<AgrItemExtChngPO> agrItemExtChngPOS = this.agrItemExtChngMapper.getList(new AgrItemExtChngPO());
            Map<Long, List<AgrItemExtChngPO>> agrItemExtChngPOMap =
                    agrItemExtChngPOS.stream().collect(Collectors.groupingBy(AgrItemExtChngPO::getAgrItemChngId));

            rows.forEach(agrItemLadderPriceChng -> {
                //封装协议明细阶梯价出参
                List<AgrItemLadderPriceChng> agrItemLadderPriceChngs =
                        AgrRu.jsl(agrItemLadderPriceChngPOMap.get(agrItemLadderPriceChng.getAgrItemChngId()), AgrItemLadderPriceChng.class);
                agrItemLadderPriceChng.setAgrItemLadderPriceChng(AgrRu.jsl(agrItemLadderPriceChngs, AgrItemLadderPriceChng.class));

                //封装协议明细阶梯价出参
                List<AgrItemExtChng> agrItemExtChngs =
                        AgrRu.jsl(agrItemExtChngPOMap.get(agrItemLadderPriceChng.getAgrItemChngId()), AgrItemExtChng.class);
                agrItemLadderPriceChng.setAgrItemExtChng(AgrRu.jsl(agrItemExtChngs, AgrItemExtChng.class));

            });
        }
        //封装结果出参
        rspPageBo.setPageNo(reqBo.getPageNo());
        rspPageBo.setRecordsTotal(page.getTotalCount());
        rspPageBo.setTotal(page.getTotalPages());
        rspPageBo.setRows(rows);

        return rspPageBo;
    }

    @Override
    public void updateAgrChngApplyMain(AgrChngApplyDo agrChngApplyDo) {
        AgrChngApplyPO set = new AgrChngApplyPO() ;
        set.setChngApplyStatus(agrChngApplyDo.getChngApplyStatus());
        set.setConfirmName(agrChngApplyDo.getConfirmName());
        set.setConfirmTime(agrChngApplyDo.getConfirmTime());
        AgrChngApplyPO where = new AgrChngApplyPO() ;
        where.setAgrId(agrChngApplyDo.getAgrId());
        where.setChngApplyId(agrChngApplyDo.getChngApplyId());
        this.agrChngApplyMapper.updateBy(set,where);
    }

    @Override
    public void deleteAgrChngApplyMain(AgrChngApplyDo agrChngApplyDo) {
        AgrChngApplyPO agrChngApplyPO = new AgrChngApplyPO();
        agrChngApplyPO.setChngApplyId(agrChngApplyDo.getChngApplyId());
        agrChngApplyPO.setAgrId(agrChngApplyDo.getAgrId());
        this.agrChngApplyMapper.deleteBy(agrChngApplyPO);
    }
}
