/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.tenant;

import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.authority.tenant.bo.AppConfigBO;
import com.ohaotian.authority.tenant.bo.CreateTenantBO;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantReqBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.bo.TenantSearchPageReqBO;
import com.ohaotian.authority.tenant.service.CreateAppFroTenantService;
import com.ohaotian.authority.tenant.service.CreateTenantService;
import com.ohaotian.authority.tenant.service.DeleteTenantByIdService;
import com.ohaotian.authority.tenant.service.SelectAppForTenantService;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.tenant.service.SelectTenantPageService;
import com.ohaotian.authority.tenant.service.StopTenantByTenantIdService;
import com.ohaotian.authority.tenant.service.UpdateTenantByTenantIdService;
import com.ohaotian.authority.user.bo.SelectTenantListByUserIdReqBO;
import com.ohaotian.authority.user.service.SelectTenantListByUserIdService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.db.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant"}, method={RequestMethod.GET, RequestMethod.POST})
public class TenantController {
    private static final Logger logger = LoggerFactory.getLogger(TenantController.class);
    @Autowired
    private CreateTenantService createTenantService;
    @Autowired
    private SelectTenantPageService selectTenantPageService;
    @Autowired
    private DeleteTenantByIdService deleteTenantByIdService;
    @Autowired
    private SelectTenantByIdService selectTenantByIdService;
    @Autowired
    private UpdateTenantByTenantIdService updateTenantByTenantIdService;
    @Autowired
    private CreateAppFroTenantService createAppFroTenantService;
    @Autowired
    private SelectAppForTenantService selectAppForTenantService;
    @Autowired
    private SelectTenantListByUserIdService selectTenantListByUserIdService;
    @Autowired
    private StopTenantByTenantIdService stopTenantByTenantIdService;

    @RequestMapping(value={"/create"})
    @BusiResponseBody
    @BussinessLog(module="\u79df\u6237\u7ba1\u7406", operat="\u65b0\u5efa")
    public Object create(@RequestBody CreateTenantBO createTenantBO) {
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        createTenantBO.setTenantId(Long.valueOf(l));
        this.createTenantService.insertTenant(createTenantBO);
        return null;
    }

    @RequestMapping(value={"/search"})
    @BusiResponseBody
    public Object search(@RequestBody TenantSearchPageReqBO tenantSearchPageReqBO) {
        return this.selectTenantPageService.selectTenantPage(tenantSearchPageReqBO);
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u79df\u6237\u7ba1\u7406", operat="\u5220\u9664")
    public Object delete(@RequestBody TenantIdBO tenantId) {
        try {
            TenantIdBO tenantIdBO = new TenantIdBO();
            tenantIdBO.setTenantId(tenantId.getTenantId());
            TenantRspBO rspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u79df\u6237", (Throwable)e);
        }
        this.deleteTenantByIdService.deleteTenantById(tenantId);
        return null;
    }

    @RequestMapping(value={"/select"})
    @BusiResponseBody
    public Object select(@RequestBody TenantIdBO tenantIdBO) {
        return this.selectTenantByIdService.selectTenantById(tenantIdBO);
    }

    @RequestMapping(value={"/add"})
    @BusiResponseBody
    @BussinessLog(module="\u79df\u6237\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object add(@RequestBody TenantReqBO tenantReqBO) {
        try {
            TenantIdBO tenantIdBO = new TenantIdBO();
            tenantIdBO.setTenantId(tenantReqBO.getTenantId());
            TenantRspBO rspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u79df\u6237", (Throwable)e);
        }
        this.updateTenantByTenantIdService.updateTenantByTenantId(tenantReqBO);
        return null;
    }

    @RequestMapping(value={"/stop"})
    @BusiResponseBody
    @BussinessLog(module="\u79df\u6237\u7ba1\u7406", operat="\u505c\u7528")
    public Object stop(@RequestBody TenantIdBO tenantId) {
        TenantReqBO tenantReqBO = new TenantReqBO();
        tenantReqBO.setTenantId(tenantId.getTenantId());
        tenantReqBO.setStatus(Integer.valueOf(2));
        this.stopTenantByTenantIdService.stopTenantByTenantId(tenantReqBO);
        return null;
    }

    @RequestMapping(value={"/restart"})
    @BusiResponseBody
    @BussinessLog(module="\u79df\u6237\u7ba1\u7406", operat="\u542f\u7528")
    public Object restart(@RequestBody TenantIdBO tenantId) {
        TenantReqBO tenantReqBO = new TenantReqBO();
        tenantReqBO.setTenantId(tenantId.getTenantId());
        tenantReqBO.setStatus(Integer.valueOf(0));
        this.updateTenantByTenantIdService.updateTenantByTenantId(tenantReqBO);
        return null;
    }

    @RequestMapping(value={"/configApp"})
    @BusiResponseBody
    @BussinessLog(module="\u79df\u6237\u7ba1\u7406", operat="\u5b9a\u5236\u5b50\u7cfb\u7edf")
    public Object configApp(@RequestBody AppConfigBO appConfigForTenantReqBO) {
        this.createAppFroTenantService.createAppforTenant(appConfigForTenantReqBO);
        return null;
    }

    @RequestMapping(value={"/selectconfigApp"})
    @BusiResponseBody
    public Object selectconfigApp(@RequestBody TenantIdBO tenantIdBO) {
        return this.selectAppForTenantService.selectAppforTenant(tenantIdBO);
    }

    @RequestMapping(value={"/selectUserTenant"})
    @BusiResponseBody
    public Object selectUserTenant(@RequestParam(value="userId") String userId, @RequestBody SelectTenantListByUserIdReqBO selectTenantListByUserIdReqBO) {
        return this.selectTenantListByUserIdService.selectTenants(selectTenantListByUserIdReqBO);
    }
}

