/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.resource.parse.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.dyc.resource.parse.api.ReStaticResourceAccessService;
import com.tydic.dyc.resource.parse.api.ReStaticResourceParseService;
import com.tydic.dyc.resource.parse.bo.ReStaticResourceAccessReqBO;
import com.tydic.dyc.resource.parse.bo.ReStaticResourceAccessRspBO;
import com.tydic.dyc.resource.parse.bo.ReStaticResourceParseReqBO;
import com.tydic.dyc.resource.parse.bo.ReStaticResourceParseRspBO;
import com.tydic.dyc.resource.parse.bo.ReStaticResourcePathRelBO;
import com.tydic.dyc.resource.parse.dao.ReStaticResourceAccessErrorRecordMapper;
import com.tydic.dyc.resource.parse.dao.ReStaticResourceAccessRecordMapper;
import com.tydic.dyc.resource.parse.po.ReStaticResourceAccessErrorRecordPO;
import com.tydic.dyc.resource.parse.po.ReStaticResourceAccessRecordPO;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ReStaticResourceAccessServiceImpl
implements ReStaticResourceAccessService {
    private static final Logger log = LoggerFactory.getLogger(ReStaticResourceAccessServiceImpl.class);
    @Autowired
    private ReStaticResourceParseService reStaticResourceParseService;
    @Autowired
    private ReStaticResourceAccessRecordMapper reStaticResourceAccessRecordMapper;
    @Autowired
    private ReStaticResourceAccessErrorRecordMapper reStaticResourceAccessErrorRecordMapper;
    @Autowired
    private FileClient fileClient;
    @Value(value="${re.need.parse.type:text,application}")
    private String[] needParseTypes;
    @Value(value="${re.address.mapping:}")
    private String[] addressMap;
    @Value(value="${re.proxy.ip:}")
    private String proxyAddressIp;
    @Value(value="${re.need.proxy:false}")
    private Boolean needProxy;
    @Value(value="${re.ig.need.parse.type:application/pdf}")
    private String[] igNeedParseTypes;
    @Value(value="${re.need.black.proxy:false}")
    private Boolean needBlackProxy;
    @Value(value="${re.task.url.retry.num:0}")
    private Integer taskRetryNum;
    @Value(value="${re.retry.error.type:java.io.IOException}")
    private String[] retryErrorType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public ReStaticResourceAccessRspBO accessStaticResource(ReStaticResourceAccessReqBO reqBO) {
        for (ReStaticResourcePathRelBO reStaticResourcePathRelBO : reqBO.getReStaticResourcePathRelBOList()) {
            InputStream inputStream = null;
            HttpURLConnection urlConnection = null;
            ReStaticResourceAccessRecordPO reStaticResourceAccessRecordPO = new ReStaticResourceAccessRecordPO();
            try {
                reStaticResourceAccessRecordPO.setOutResourceUrl(reStaticResourcePathRelBO.getOldStaticResourceUrl());
                int count = this.reStaticResourceAccessRecordMapper.getCheckBy(reStaticResourceAccessRecordPO);
                if (count > 0) continue;
                String resourceUrl = reStaticResourcePathRelBO.getOldStaticResourceUrl();
                Integer n = 0;
                if (resourceUrl.startsWith("https")) {
                    Integer n2 = 1;
                }
                if (this.needProxy.booleanValue()) {
                    void var9_16;
                    String[] addressMap1;
                    if (resourceUrl.startsWith("http")) {
                        resourceUrl = resourceUrl.substring(resourceUrl.indexOf("//") + 2);
                    } else if (resourceUrl.startsWith("//")) {
                        resourceUrl = resourceUrl.substring(2);
                    } else if (resourceUrl.startsWith("/")) {
                        resourceUrl = resourceUrl.substring(1);
                    }
                    String domain = resourceUrl.substring(0, resourceUrl.indexOf("/"));
                    resourceUrl = resourceUrl.substring(resourceUrl.indexOf("/"));
                    String resourceUrlPrex = "";
                    Boolean exist = false;
                    for (String address : this.addressMap) {
                        addressMap1 = address.split("->");
                        if (!addressMap1[0].equals(domain)) continue;
                        log.info("\u91c7\u7528\u7cbe\u51c6\u5339\u914d\u65b9\u6848" + addressMap1[0] + "->" + addressMap1[1]);
                        resourceUrlPrex = addressMap1[1] + "/" + var9_16 + "/";
                        exist = true;
                        break;
                    }
                    for (String address : this.addressMap) {
                        String domain2;
                        addressMap1 = address.split("->");
                        String domain1 = addressMap1[0].substring(addressMap1[0].indexOf(".") + 1);
                        if (!domain1.equals(domain2 = domain.substring(domain.indexOf(".") + 1))) continue;
                        log.info("\u91c7\u7528\u53bb\u6389\u7b2c\u4e00\u4e2a\u57df\u540d\u5339\u914d\u65b9\u6848" + addressMap1[0] + "->" + addressMap1[1]);
                        resourceUrlPrex = addressMap1[1] + "/" + var9_16 + "/";
                        exist = true;
                        break;
                    }
                    if (!exist.booleanValue() && this.needBlackProxy.booleanValue()) {
                        log.info("\u91c7\u7528\u515c\u5e95\u65b9\u6848\u5339\u914d\u65b9\u6848");
                        resourceUrlPrex = this.proxyAddressIp + "/" + var9_16 + "/";
                        exist = true;
                    }
                    if (!exist.booleanValue()) {
                        log.error("\u57df\u540d\u6620\u5c04\u5173\u7cfb\u4e0d\u5b58\u5728");
                        throw new ZTBusinessException("\u57df\u540d\u6620\u5c04\u5173\u7cfb\u4e0d\u5b58\u5728");
                    }
                    resourceUrl = resourceUrlPrex + domain + resourceUrl;
                }
                if (!resourceUrl.startsWith("http")) {
                    resourceUrl = "http:" + resourceUrl;
                }
                log.info("\u5916\u90e8\u8bbf\u95ee\u5730\u5740\u4e3a\uff1a" + resourceUrl);
                URL url = new URL(resourceUrl);
                Map<String, String> fileInfo = ReStaticResourceAccessServiceImpl.getFileInfo(reStaticResourcePathRelBO.getNewStaticResourceUrl());
                String fileUrl = fileInfo.get("fileUrl");
                String fileName = fileInfo.get("fileName");
                for (int i = 0; i <= this.taskRetryNum; ++i) {
                    try {
                        urlConnection = (HttpURLConnection)url.openConnection();
                        break;
                    }
                    catch (Exception e) {
                        if (this.taskRetryNum.equals(i)) {
                            throw e;
                        }
                        Boolean existFlag = false;
                        for (String errorType : this.retryErrorType) {
                            if (!e.toString().startsWith(errorType)) continue;
                            existFlag = true;
                            break;
                        }
                        if (existFlag.booleanValue()) continue;
                        throw e;
                    }
                }
                String contentType = urlConnection.getContentType();
                inputStream = urlConnection.getInputStream();
                boolean needParse = false;
                log.info("\u6587\u4ef6\u7c7b\u578b" + contentType);
                List<String> igNeedParseTypeList = Arrays.asList(this.igNeedParseTypes);
                for (String needParseType : this.needParseTypes) {
                    String line;
                    if (!contentType.startsWith(needParseType) || igNeedParseTypeList.contains(contentType)) continue;
                    needParse = true;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((line = bufferedReader.readLine()) != null) {
                        stringBuilder.append(line).append(System.lineSeparator());
                    }
                    String inputStreamToString = stringBuilder.toString();
                    if (StringUtils.isEmpty((Object)inputStreamToString)) {
                        log.info("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
                        this.fileClient.uploadFileByInputStream(fileUrl, fileName, inputStream);
                        break;
                    }
                    ReStaticResourceParseReqBO reStaticResourceParseReqBO = new ReStaticResourceParseReqBO();
                    reStaticResourceParseReqBO.setStaticResourceHtml(inputStreamToString);
                    ReStaticResourceParseRspBO reStaticResourceParseRspBO = this.reStaticResourceParseService.parseStaticResource(reStaticResourceParseReqBO);
                    ByteArrayInputStream inputStream1 = new ByteArrayInputStream(reStaticResourceParseRspBO.getNewStaticResourceHtml().getBytes());
                    log.info("\u6587\u4ef6\u5904\u7406\u540e\u4e0a\u4f20");
                    this.fileClient.uploadFileByInputStream(fileUrl, fileName, (InputStream)inputStream1);
                    ((InputStream)inputStream1).close();
                    bufferedReader.close();
                    break;
                }
                if (!needParse) {
                    log.info("\u6587\u4ef6\u672a\u5904\u7406\u76f4\u63a5\u4e0a\u4f20");
                    this.fileClient.uploadFileByInputStream(fileUrl, fileName, inputStream);
                    inputStream.close();
                }
                reStaticResourceAccessRecordPO.setAccessStatus(0);
                reStaticResourceAccessRecordPO.setInnerResourceUrl(reStaticResourcePathRelBO.getNewStaticResourceUrl());
                reStaticResourceAccessRecordPO.setId(Sequence.getInstance().nextId());
                reStaticResourceAccessRecordPO.setCreateTime(new Date());
                this.reStaticResourceAccessRecordMapper.insert(reStaticResourceAccessRecordPO);
                if (reStaticResourcePathRelBO.getRetryNum() != null && reStaticResourcePathRelBO.getRetryNum() <= 0) continue;
                ReStaticResourceAccessErrorRecordPO errorRecordPO = new ReStaticResourceAccessErrorRecordPO();
                errorRecordPO.setOutResourceUrl(reStaticResourcePathRelBO.getOldStaticResourceUrl());
                this.reStaticResourceAccessErrorRecordMapper.deleteBy(errorRecordPO);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                StringBuilder exception = new StringBuilder();
                exception.append(e.getMessage());
                for (StackTraceElement stackTrace : e.getStackTrace()) {
                    exception.append("\n").append(stackTrace.toString());
                }
                ReStaticResourceAccessErrorRecordPO reStaticResourceAccessErrorRecordPO = new ReStaticResourceAccessErrorRecordPO();
                log.error("\u8bbf\u95ee\u9759\u6001\u8d44\u6e90\u5931\u8d25\uff0curl:{}", (Object)reStaticResourcePathRelBO.getOldStaticResourceUrl(), (Object)e);
                if (exception.toString().length() > 512) {
                    reStaticResourceAccessErrorRecordPO.setFailReason(exception.toString().substring(0, 512));
                } else {
                    reStaticResourceAccessErrorRecordPO.setFailReason(exception.toString());
                }
                reStaticResourceAccessErrorRecordPO.setOutResourceUrl(reStaticResourcePathRelBO.getOldStaticResourceUrl());
                reStaticResourceAccessErrorRecordPO.setInnerResourceUrl(reStaticResourcePathRelBO.getNewStaticResourceUrl());
                reStaticResourceAccessErrorRecordPO.setId(Sequence.getInstance().nextId());
                reStaticResourceAccessErrorRecordPO.setCreateTime(new Date());
                if (reStaticResourcePathRelBO.getRetryNum() == null) {
                    reStaticResourceAccessErrorRecordPO.setRetryNum(0);
                } else {
                    reStaticResourceAccessErrorRecordPO.setRetryNum(reStaticResourcePathRelBO.getRetryNum());
                }
                this.reStaticResourceAccessErrorRecordMapper.insert(reStaticResourceAccessErrorRecordPO);
            }
            finally {
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (null == urlConnection) continue;
                urlConnection.disconnect();
            }
        }
        ReStaticResourceAccessRspBO rspBO = new ReStaticResourceAccessRspBO();
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private static Map<String, String> getFileInfo(String url) {
        int startIndex = url.indexOf("/dyc-ext-resource/");
        String fileUrl = url.substring(startIndex + 1);
        int indexOfQuestionMark = fileUrl.indexOf("?");
        if (indexOfQuestionMark != -1) {
            fileUrl = fileUrl.substring(0, indexOfQuestionMark);
        }
        int lastSlashIndex = fileUrl.lastIndexOf(47);
        String fileName = fileUrl.substring(lastSlashIndex + 1);
        fileUrl = fileUrl.substring(0, lastSlashIndex + 1);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("fileName", fileName);
        result.put("fileUrl", fileUrl);
        return result;
    }

    public static void main(String[] args) throws IOException {
        int length;
        String str = "https://hellorfimg.zcool.cn/provider_image/large/2238530855.jpg";
        URL url = new URL(str);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        InputStream inputStream = urlConnection.getInputStream();
        byte[] tmp = new byte[10240];
        OutputStream outputStream = Files.newOutputStream(Paths.get("eee.jpg", new String[0]), new OpenOption[0]);
        while ((length = inputStream.read(tmp)) != -1) {
            outputStream.write(tmp, 0, length);
        }
        outputStream.close();
        inputStream.close();
    }
}

