/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.resource.parse.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.resource.parse.api.ReStaticResourceParseService;
import com.tydic.dyc.resource.parse.bo.ReStaticResourceParseReqBO;
import com.tydic.dyc.resource.parse.bo.ReStaticResourceParseRspBO;
import com.tydic.dyc.resource.parse.bo.ReStaticResourcePathRelBO;
import com.tydic.dyc.resource.parse.dao.ReStaticResourceAccessRecordMapper;
import com.tydic.dyc.resource.parse.po.ReStaticResourceAccessRecordPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ReStaticResourceParseServiceImpl
implements ReStaticResourceParseService {
    private static final Logger log = LoggerFactory.getLogger(ReStaticResourceParseServiceImpl.class);
    @Resource(name="reAccessThirdResourceProvider")
    private ProxyMessageProducer reAccessThirdResourceProvider;
    @Value(value="${RE_ACCESS_THIRD_RESOURCE_TOPIC:RE_ACCESS_THIRD_RESOURCE_TOPIC}")
    private String reAccessThirdResourceTopic;
    @Value(value="${RE_ACCESS_THIRD_RESOURCE_TAG:*}")
    private String reAccessThirdResourceTag;
    @Value(value="${re.domaim.prex:portalServerIpInner}")
    private String portalServerIpInner;
    @Value(value="${re.parse.regex:(http)?s?:?\\/\\/[^:<>\"]+(\\.[^:<>\"]+)+\\/[^:<>\"]+\\.(png!thumbnail|png|jpg|jpeg|webp|svg|woff|ttf|json|css|woff2|eot|css|js|html|htm)(\\??[^:<>\"')]+)?}")
    private String regex;
    @Value(value="${re.thread.exec.time:300}")
    private Integer threadExecTime;
    @Value(value="${re.parse.lables:}")
    private String selectStr;
    @Value(value="${re.parse.attr:}")
    private String[] selectAttr;
    @Autowired
    private ReStaticResourceAccessRecordMapper reStaticResourceAccessRecordMapper;

    @Override
    public ReStaticResourceParseRspBO parseStaticResource(ReStaticResourceParseReqBO reqBO) {
        ReStaticResourceParseRspBO rspBO = new ReStaticResourceParseRspBO();
        ArrayList<ReStaticResourcePathRelBO> reStaticResourcePathRelBOList = new ArrayList<ReStaticResourcePathRelBO>();
        try {
            if (StringUtils.hasText((String)reqBO.getStaticResourceUrl())) {
                String oldUrl = reqBO.getStaticResourceUrl();
                String newUrl = this.parseUrl(oldUrl, reStaticResourcePathRelBOList);
                rspBO.setNewStaticResourceUrl(newUrl);
            }
            if (StringUtils.hasText((String)reqBO.getStaticResourceHtml())) {
                String oldHtml = reqBO.getStaticResourceHtml();
                String newHtml = this.parseHtml(reqBO.getParseFirst(), oldHtml, reStaticResourcePathRelBOList);
                rspBO.setNewStaticResourceHtml(newHtml);
            }
            if (null != reqBO.getStaticResourceUrlList() && reqBO.getStaticResourceUrlList().size() > 0) {
                ArrayList<String> newStaticResourceUrlList = new ArrayList<String>();
                for (String url : reqBO.getStaticResourceUrlList()) {
                    String newUrl = this.parseUrl(url, reStaticResourcePathRelBOList);
                    newStaticResourceUrlList.add(newUrl);
                }
                rspBO.setNewStaticResourceUrlList(newStaticResourceUrlList);
            }
            if (null != reqBO.getStaticResourceHtmlList() && reqBO.getStaticResourceHtmlList().size() > 0) {
                ArrayList<String> newStaticResourceHtmlList = new ArrayList<String>();
                for (String html : reqBO.getStaticResourceHtmlList()) {
                    String newHtml = this.parseHtml(reqBO.getParseFirst(), html, reStaticResourcePathRelBOList);
                    newStaticResourceHtmlList.add(newHtml);
                }
                rspBO.setNewStaticResourceHtmlList(newStaticResourceHtmlList);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            rspBO.setNewStaticResourceUrl(reqBO.getStaticResourceUrl());
            rspBO.setNewStaticResourceHtml(reqBO.getStaticResourceHtml());
            rspBO.setNewStaticResourceUrlList(reqBO.getStaticResourceUrlList());
            rspBO.setNewStaticResourceHtmlList(reqBO.getStaticResourceHtmlList());
            return rspBO;
        }
        if (reStaticResourcePathRelBOList.size() > 0) {
            this.reAccessThirdResourceProvider.send(new ProxyMessage(this.reAccessThirdResourceTopic, this.reAccessThirdResourceTag, JSON.toJSONString(reStaticResourcePathRelBOList)));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("success");
        return rspBO;
    }

    private String parseUrl(String url, List<ReStaticResourcePathRelBO> reStaticResourcePathRelBOList) {
        if (StringUtils.isEmpty((Object)url)) {
            return url;
        }
        if (!url.startsWith("http") && !url.startsWith("//")) {
            return url;
        }
        int startIndex = url.indexOf("//");
        String path = url.substring(startIndex + 2);
        String innerFileUrl = this.portalServerIpInner + "/dyc-ext-resource/" + path;
        innerFileUrl = innerFileUrl.replaceAll("%", "%25");
        ReStaticResourcePathRelBO bo = new ReStaticResourcePathRelBO();
        bo.setOldStaticResourceUrl(url);
        bo.setNewStaticResourceUrl(innerFileUrl);
        reStaticResourcePathRelBOList.add(bo);
        return innerFileUrl;
    }

    private String parseHtml(Boolean first, String html, List<ReStaticResourcePathRelBO> reStaticResourcePathRelBOList) {
        log.info("html\u89e3\u6790\u5f00\u59cb");
        Pattern pattern = Pattern.compile(this.regex);
        CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
            log.info("\u5f02\u6b65\u7ebf\u7a0b\u5f00\u59cb");
            if (first.booleanValue()) {
                log.info("document\u89e3\u6790\u5f00\u59cb");
                Document document = Jsoup.parse((String)html);
                Elements links = document.select(this.selectStr);
                for (Element link : links) {
                    for (String attr : this.selectAttr) {
                        if (!link.hasAttr(attr)) continue;
                        String oldUrl = link.attr(attr);
                        String newUrl = this.parseUrl(oldUrl, reStaticResourcePathRelBOList);
                        link.attr(attr, newUrl);
                    }
                }
                log.info("document\u89e3\u6790\u7ed3\u675f");
                return document.outerHtml();
            }
            log.info("\u6b63\u5219\u89e3\u6790\u5f00\u59cb");
            Matcher matcher = pattern.matcher(html);
            StringBuilder resultBuilder = new StringBuilder(html.length());
            int lastIndex = 0;
            while (matcher.find()) {
                String oldUrl = matcher.group();
                String newUrl = this.parseUrl(oldUrl, reStaticResourcePathRelBOList);
                resultBuilder.append(html, lastIndex, matcher.start());
                resultBuilder.append(newUrl);
                lastIndex = matcher.end();
            }
            resultBuilder.append(html, lastIndex, html.length());
            String result = resultBuilder.toString();
            log.info("\u6b63\u5219\u89e3\u6790\u7ed3\u675f");
            return result;
        });
        try {
            String newHtml = future.get(this.threadExecTime.intValue(), TimeUnit.SECONDS);
            log.info("\u5f02\u6b65\u7ebf\u7a0b\u7ed3\u675f");
            log.info("html\u89e3\u6790\u7ed3\u675f");
            return newHtml;
        }
        catch (InterruptedException | ExecutionException e) {
            ReStaticResourceAccessRecordPO po = new ReStaticResourceAccessRecordPO();
            po.setHtml(("\u5f02\u6b65\u7ebf\u7a0b\u6267\u884c\u5f02\u5e38" + html).getBytes());
            po.setId(Sequence.getInstance().nextId());
            po.setCreateTime(new Date());
            this.reStaticResourceAccessRecordMapper.insertNotParseHtml(po);
            log.info("\u5f02\u6b65\u7ebf\u7a0b\u6267\u884c\u5f02\u5e38\u7ed3\u675f");
            log.error("", (Throwable)e);
        }
        catch (TimeoutException e) {
            ReStaticResourceAccessRecordPO po = new ReStaticResourceAccessRecordPO();
            po.setHtml(("\u5f02\u6b65\u7ebf\u7a0b\u8d85\u65f6\u7ed3\u675f" + html).getBytes());
            po.setId(Sequence.getInstance().nextId());
            this.reStaticResourceAccessRecordMapper.insertNotParseHtml(po);
            log.info("\u5f02\u6b65\u7ebf\u7a0b\u8d85\u65f6\u7ed3\u675f");
            future.cancel(true);
            log.error("", (Throwable)e);
        }
        log.info("html\u89e3\u6790\u7ed3\u675f");
        return html;
    }

    public static void main(String[] args) {
        String url = "http://fasle";
        if (!url.startsWith("http") && !url.startsWith("//")) {
            System.out.println(url);
        }
    }
}

