/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.resource.parse.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.resource.parse.api.ReStaticResourceAccessService;
import com.tydic.dyc.resource.parse.api.ReStaticResourceRetryTimeTaskService;
import com.tydic.dyc.resource.parse.bo.ReStaticResourceAccessReqBO;
import com.tydic.dyc.resource.parse.bo.ReStaticResourcePathRelBO;
import com.tydic.dyc.resource.parse.bo.ReStaticResourceRetryTimeTaskReqBO;
import com.tydic.dyc.resource.parse.bo.ReStaticResourceRetryTimeTaskRspBO;
import com.tydic.dyc.resource.parse.dao.ReStaticResourceAccessErrorRecordMapper;
import com.tydic.dyc.resource.parse.po.ReStaticResourceAccessErrorRecordPO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReStaticResourceRetryTimeTaskServiceImpl
implements ReStaticResourceRetryTimeTaskService {
    @Autowired
    private ReStaticResourceAccessErrorRecordMapper reStaticResourceAccessErrorRecordMapper;
    @Autowired
    private ReStaticResourceAccessService reStaticResourceAccessService;
    @Value(value="${re.task.num:50}")
    private Integer taskNum;
    @Value(value="${re.task.retry.num:5}")
    private Integer taskRetryNum;

    @Override
    public ReStaticResourceRetryTimeTaskRspBO staticResourceRetryTimeTask(ReStaticResourceRetryTimeTaskReqBO reqBO) {
        ReStaticResourceAccessErrorRecordPO reStaticResourceAccessErrorRecordPO = new ReStaticResourceAccessErrorRecordPO();
        reStaticResourceAccessErrorRecordPO.setRetryNum(this.taskRetryNum);
        Page pg = new Page(1, this.taskNum.intValue());
        List<ReStaticResourceAccessErrorRecordPO> posList = this.reStaticResourceAccessErrorRecordMapper.getListPage(reStaticResourceAccessErrorRecordPO, (Page<ReStaticResourceAccessErrorRecordPO>)pg);
        if (!CollectionUtils.isEmpty(posList)) {
            for (ReStaticResourceAccessErrorRecordPO po : posList) {
                ReStaticResourceAccessReqBO reqBO1 = new ReStaticResourceAccessReqBO();
                ArrayList<ReStaticResourcePathRelBO> reStaticResourcePathRelBOList = new ArrayList<ReStaticResourcePathRelBO>();
                ReStaticResourcePathRelBO bo = new ReStaticResourcePathRelBO();
                bo.setOldStaticResourceUrl(po.getOutResourceUrl());
                bo.setNewStaticResourceUrl(po.getInnerResourceUrl());
                bo.setRetryNum(po.getRetryNum() + 1);
                reStaticResourcePathRelBOList.add(bo);
                reqBO1.setReStaticResourcePathRelBOList(reStaticResourcePathRelBOList);
                this.reStaticResourceAccessService.accessStaticResource(reqBO1);
            }
        }
        ReStaticResourceRetryTimeTaskRspBO rspBO = new ReStaticResourceRetryTimeTaskRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("success");
        return rspBO;
    }
}

